#ifndef CCMDMD_H_
#define CCMDMD_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

 Author: Andrew Lowry
*/
/* ccmdmd.h
**
** This file contains machine-dependent macros and declarations for
** the ccmd package.  Use preprocessor conditionals to include the
** correct code, but PLEASE -- try not to nest conditionals!!
**/

/* Data type that can accomodate int and all pointer data in an
** initializer.  This is how the _cmdat field of the FDB is
** declared, to ease declaration of FDB structures.
**/

typedef char * pdat;

/* On Venix, one cannot pass around pointers to static functions
** because of code mapping difficulties.  Therefore, the following is
** used for functions that really should be static, but which need to
** be invoked via pointers in other modules.  Since they will not be
** static in venix implementations, they should be named so as to reduce
** chances of name conflicts.
**/

#ifdef VENIX
#define PASSEDSTATIC
#else
#define PASSEDSTATIC static
#endif

/*
 * On AIX systems, request BSD extensions
 */
#ifdef AIX
#ifndef BSD_INCLUDES
#define BSD_INCLUDES 1
#endif
#ifndef BSD_REMAP_SIGNAL_TO_SIGVEC
#define BSD_REMAP_SIGNAL_TO_SIGVEC 1
#endif
#endif

/*
** cmsetrp macro - invoke at an appropriate
** reparse point, to install a handler into the CSB that will automatically
** revert execution back to this point whenever a reparse is triggered.
**/

#ifdef LATTICE
#define cmsetrp() \
   { setjmp(&cmrpjb); cmcsb._cmrph = cmrpjmp; }
#else
#define cmsetrp() \
   { setjmp(cmrpjb); cmcsb._cmrph = cmrpjmp; }
#endif

/*
** cmseter macro - invoke just prior to issuing a prompt,
** to install a handler into the CSB that will automatically
** revert execution back to this point whenever a parse error
** is encountered.
**/

#ifdef LATTICE
#define cmseter() \
   { setjmp(&cmerjb); cmcsb._cmerh = (int(*) ARGS((int, ...)))cmerjmp; }
#else
#define cmseter() \
   { setjmp(cmerjb); cmcsb._cmerh = (int(*) ARGS((int, ...)))cmerjmp; }
#endif

#ifdef LATTICE
#define cmsetbl() \
   { setjmp(&cmbljb); cmcsb._cmblh = cmbljmp; }
#else
#define cmsetbl() \
   { setjmp(cmbljb); cmcsb._cmblh = cmbljmp; }
#endif
#define cmclrbl() \
   { cmcsb._cmblh = NULL; }

extern jmp_buf cmrpjb;		/* global jump buffer for auto reparse */
extern jmp_buf cmerjb;		/* global jump buffer for auto error */

#if 0
extern jmp_buf cmbljb;		/* global jump buffer for nonblocking io */
#endif

extern int cmrpjmp ARGS((void));/* reparse handler - longjmps via cmrpjb */
extern int cmerjmp ARGS((int ret_, const char *str_, flag_t flags_));
				/* error handler - longjmps via cmerjb */
extern int cmbljmp ARGS((int ret_));	/* error handler - longjmps via cmerjb */

#endif /* CCMDMD_H_ */
