# SPDX-License-Identifier: Apache-2.0
# Copyright 2012-2023 The Meson development team

# Core public classes for linkers.
from __future__ import annotations

import enum
import typing as T

if T.TYPE_CHECKING:
    from ..environment import Environment


@enum.unique
class RSPFileSyntax(enum.Enum):

    """Which RSP file syntax the compiler supports."""

    MSVC = enum.auto()
    GCC = enum.auto()


class ArLikeLinker:
    # POSIX requires supporting the dash, GNU permits omitting it
    std_args = ['-csr']

    def can_linker_accept_rsp(self) -> bool:
        # armar / AIX can't accept arguments using the @rsp syntax
        # in fact, only the 'ar' id can
        return False

    def get_std_link_args(self, env: 'Environment', is_thin: bool) -> T.List[str]:
        return self.std_args

    def get_output_args(self, target: str) -> T.List[str]:
        return [target]

    def rsp_file_syntax(self) -> RSPFileSyntax:
        return RSPFileSyntax.GCC
