/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ParsingUtils;

public class TrackProperties {
    private static Logger log = Logger.getLogger(TrackProperties.class);
    private String trackLine;
    private Track.DisplayMode displayMode;
    private BaseCoord baseCoord = BaseCoord.UNSPECIFIED;
    private String name;
    private String description;
    private String url;
    private int height;
    private int minHeight;
    private boolean gffTags = false;
    private Color color;
    private Color altColor;
    private Color midColor;
    private String genome;
    private int offset;
    private boolean autoScaleFlag = false;
    private float minValue = Float.NaN;
    private float maxValue = Float.NaN;
    private float midValue = Float.NaN;
    private float neutralFromValue = Float.NaN;
    private float neutralToValue = Float.NaN;
    private boolean drawYLine = false;
    private Class rendererClass;
    private WindowFunction windowingFunction;
    private int smoothingWindow;
    private boolean itemRGB = true;
    private boolean useScore = false;
    private int featureVisibilityWindow = -1;
    private boolean logScale;
    private float yLine;
    private boolean sortable = true;
    private boolean alternateExonColor = false;
    private String dataURL;
    private String indexURL;
    private String coverageURL;
    private Map<String, String> attributes;

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public int getFeatureVisibilityWindow() {
        return this.featureVisibilityWindow;
    }

    public void setFeatureVisibilityWindow(int featureVisibilityWindow) {
        this.featureVisibilityWindow = featureVisibilityWindow;
    }

    public boolean isUseScore() {
        return this.useScore;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public boolean isItemRGB() {
        return this.itemRGB;
    }

    public void setItemRGB(boolean itemRGB) {
        this.itemRGB = itemRGB;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getAltColor() {
        return this.altColor;
    }

    public void setAltColor(Color altColor) {
        this.altColor = altColor;
    }

    public boolean isAutoScale() {
        return this.autoScaleFlag || Float.isNaN(this.minValue) || Float.isNaN(this.maxValue);
    }

    public boolean getAutoScale() {
        return this.autoScaleFlag;
    }

    public String getGenome() {
        return this.genome;
    }

    public void setGenome(String genome) {
        this.genome = genome;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public WindowFunction getWindowingFunction() {
        return this.windowingFunction;
    }

    public void setWindowingFunction(WindowFunction windowingFunction) {
        this.windowingFunction = windowingFunction;
    }

    public int getSmoothingWindow() {
        return this.smoothingWindow;
    }

    public void setSmoothingWindow(int smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
    }

    public Class getRendererClass() {
        return this.rendererClass;
    }

    public void setRendererClass(Class rendererClass) {
        this.rendererClass = rendererClass;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScaleFlag = autoScale;
    }

    public float getMidValue() {
        return this.midValue;
    }

    public void setMidValue(float midValue) {
        this.midValue = midValue;
    }

    public Color getMidColor() {
        return this.midColor;
    }

    public void setMidColor(Color midColor) {
        this.midColor = midColor;
    }

    public boolean isDrawYLine() {
        return this.drawYLine;
    }

    public void setDrawYLine(boolean drawYLine) {
        this.drawYLine = drawYLine;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public BaseCoord getBaseCoord() {
        return this.baseCoord;
    }

    public void setBaseCoord(BaseCoord baseCoord) {
        this.baseCoord = baseCoord;
    }

    public float getNeutralFromValue() {
        return this.neutralFromValue;
    }

    public void setNeutralFromValue(float neutralFromValue) {
        this.neutralFromValue = neutralFromValue;
    }

    public float getNeutralToValue() {
        return this.neutralToValue;
    }

    public void setNeutralToValue(float neutralToValue) {
        this.neutralToValue = neutralToValue;
    }

    public float getyLine() {
        return this.yLine;
    }

    public void setyLine(float yLine) {
        this.yLine = yLine;
    }

    public void setGffTags(boolean gffTags) {
        this.gffTags = gffTags;
    }

    public boolean isGffTags() {
        return this.gffTags;
    }

    public boolean isAlternateExonColor() {
        return this.alternateExonColor;
    }

    public void setAlternateExonColor(boolean alternateExonColor) {
        this.alternateExonColor = alternateExonColor;
    }

    public void setDisplayMode(Track.DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public Track.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public String getDataURL() {
        return this.dataURL;
    }

    public String getIndexURL() {
        return this.indexURL;
    }

    public String getCoverageURL() {
        return this.coverageURL;
    }

    public void setDataURL(String dataURL) {
        this.dataURL = dataURL;
    }

    public void setIndexURL(String indexURL) {
        this.indexURL = indexURL;
    }

    public void setCoverageURL(String coverageURL) {
        this.coverageURL = coverageURL;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setMetaData(String value) {
        String[] attStrings;
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        for (String att : attStrings = ParsingUtils.SEMI_COLON_PATTERN.split(value)) {
            String[] kv = ParsingUtils.EQ_PATTERN.split(att, 2);
            if (kv.length == 2) {
                this.attributes.put(kv[0], kv[1]);
                continue;
            }
            log.info((Object)("Skipping meta value: " + value + ".  Missing '=' token?"));
        }
    }

    public static enum BaseCoord {
        ZERO,
        ONE,
        UNSPECIFIED;

    }
}

