require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LDAP_H)) {
    eval 'sub _LDAP_H () {1;}' unless defined(&_LDAP_H);
    require 'lber.ph';
    require 'ldap_features.ph';
    eval 'sub LDAP_VERSION1 () {1;}' unless defined(&LDAP_VERSION1);
    eval 'sub LDAP_VERSION2 () {2;}' unless defined(&LDAP_VERSION2);
    eval 'sub LDAP_VERSION3 () {3;}' unless defined(&LDAP_VERSION3);
    eval 'sub LDAP_VERSION_MIN () { &LDAP_VERSION2;}' unless defined(&LDAP_VERSION_MIN);
    eval 'sub LDAP_VERSION () { &LDAP_VERSION2;}' unless defined(&LDAP_VERSION);
    eval 'sub LDAP_VERSION_MAX () { &LDAP_VERSION3;}' unless defined(&LDAP_VERSION_MAX);
    eval 'sub LDAP_API_VERSION () {3001;}' unless defined(&LDAP_API_VERSION);
    eval 'sub LDAP_VENDOR_NAME () {"OpenLDAP";}' unless defined(&LDAP_VENDOR_NAME);
    eval 'sub LDAP_API_FEATURE_X_OPENLDAP () { &LDAP_VENDOR_VERSION;}' unless defined(&LDAP_API_FEATURE_X_OPENLDAP);
    if(defined( (defined(&LDAP_API_FEATURE_X_OPENLDAP_REENTRANT) ? &LDAP_API_FEATURE_X_OPENLDAP_REENTRANT : undef) ) || ( defined( (defined(&LDAP_THREAD_SAFE) ? &LDAP_THREAD_SAFE : undef) )  && defined( (defined(&LDAP_API_FEATURE_X_OPENLDAP_THREAD_SAFE) ? &LDAP_API_FEATURE_X_OPENLDAP_THREAD_SAFE : undef) ) )) {
	eval 'sub LDAP_API_FEATURE_THREAD_SAFE () {1;}' unless defined(&LDAP_API_FEATURE_THREAD_SAFE);
	eval 'sub LDAP_API_FEATURE_SESSION_THREAD_SAFE () {1;}' unless defined(&LDAP_API_FEATURE_SESSION_THREAD_SAFE);
	eval 'sub LDAP_API_FEATURE_OPERATION_THREAD_SAFE () {1;}' unless defined(&LDAP_API_FEATURE_OPERATION_THREAD_SAFE);
    }
    if(defined( (defined(&LDAP_THREAD_SAFE) ? &LDAP_THREAD_SAFE : undef) )  && defined( (defined(&LDAP_API_FEATURE_X_OPENLDAP_THREAD_SAFE) ? &LDAP_API_FEATURE_X_OPENLDAP_THREAD_SAFE : undef) )) {
    }
    eval 'sub LDAP_PORT () {389;}' unless defined(&LDAP_PORT);
    eval 'sub LDAPS_PORT () {636;}' unless defined(&LDAPS_PORT);
    eval 'sub LDAP_ROOT_DSE () {"";}' unless defined(&LDAP_ROOT_DSE);
    eval 'sub LDAP_NO_ATTRS () {"1.1";}' unless defined(&LDAP_NO_ATTRS);
    eval 'sub LDAP_ALL_USER_ATTRIBUTES () {"*";}' unless defined(&LDAP_ALL_USER_ATTRIBUTES);
    eval 'sub LDAP_ALL_OPERATIONAL_ATTRIBUTES () {"+";}' unless defined(&LDAP_ALL_OPERATIONAL_ATTRIBUTES);
    eval 'sub LDAP_MAXINT () {(2147483647);}' unless defined(&LDAP_MAXINT);
    eval 'sub LDAP_OPT_API_INFO () {0x;}' unless defined(&LDAP_OPT_API_INFO);
    eval 'sub LDAP_OPT_DESC () {0x1;}' unless defined(&LDAP_OPT_DESC);
    eval 'sub LDAP_OPT_DEREF () {0x2;}' unless defined(&LDAP_OPT_DEREF);
    eval 'sub LDAP_OPT_SIZELIMIT () {0x3;}' unless defined(&LDAP_OPT_SIZELIMIT);
    eval 'sub LDAP_OPT_TIMELIMIT () {0x4;}' unless defined(&LDAP_OPT_TIMELIMIT);
    eval 'sub LDAP_OPT_REFERRALS () {0x8;}' unless defined(&LDAP_OPT_REFERRALS);
    eval 'sub LDAP_OPT_RESTART () {0x9;}' unless defined(&LDAP_OPT_RESTART);
    eval 'sub LDAP_OPT_PROTOCOL_VERSION () {0x11;}' unless defined(&LDAP_OPT_PROTOCOL_VERSION);
    eval 'sub LDAP_OPT_SERVER_CONTROLS () {0x12;}' unless defined(&LDAP_OPT_SERVER_CONTROLS);
    eval 'sub LDAP_OPT_CLIENT_CONTROLS () {0x13;}' unless defined(&LDAP_OPT_CLIENT_CONTROLS);
    eval 'sub LDAP_OPT_API_FEATURE_INFO () {0x15;}' unless defined(&LDAP_OPT_API_FEATURE_INFO);
    eval 'sub LDAP_OPT_HOST_NAME () {0x30;}' unless defined(&LDAP_OPT_HOST_NAME);
    eval 'sub LDAP_OPT_RESULT_CODE () {0x31;}' unless defined(&LDAP_OPT_RESULT_CODE);
    eval 'sub LDAP_OPT_ERROR_NUMBER () { &LDAP_OPT_RESULT_CODE;}' unless defined(&LDAP_OPT_ERROR_NUMBER);
    eval 'sub LDAP_OPT_DIAGNOSTIC_MESSAGE () {0x32;}' unless defined(&LDAP_OPT_DIAGNOSTIC_MESSAGE);
    eval 'sub LDAP_OPT_ERROR_STRING () { &LDAP_OPT_DIAGNOSTIC_MESSAGE;}' unless defined(&LDAP_OPT_ERROR_STRING);
    eval 'sub LDAP_OPT_MATCHED_DN () {0x33;}' unless defined(&LDAP_OPT_MATCHED_DN);
    eval 'sub LDAP_OPT_SSPI_FLAGS () {0x92;}' unless defined(&LDAP_OPT_SSPI_FLAGS);
    eval 'sub LDAP_OPT_SIGN () {0x95;}' unless defined(&LDAP_OPT_SIGN);
    eval 'sub LDAP_OPT_ENCRYPT () {0x96;}' unless defined(&LDAP_OPT_ENCRYPT);
    eval 'sub LDAP_OPT_SASL_METHOD () {0x97;}' unless defined(&LDAP_OPT_SASL_METHOD);
    eval 'sub LDAP_OPT_SECURITY_CONTEXT () {0x99;}' unless defined(&LDAP_OPT_SECURITY_CONTEXT);
    eval 'sub LDAP_OPT_API_EXTENSION_BASE () {0x4000;}' unless defined(&LDAP_OPT_API_EXTENSION_BASE);
    eval 'sub LDAP_OPT_DEBUG_LEVEL () {0x5001;}' unless defined(&LDAP_OPT_DEBUG_LEVEL);
    eval 'sub LDAP_OPT_TIMEOUT () {0x5002;}' unless defined(&LDAP_OPT_TIMEOUT);
    eval 'sub LDAP_OPT_REFHOPLIMIT () {0x5003;}' unless defined(&LDAP_OPT_REFHOPLIMIT);
    eval 'sub LDAP_OPT_NETWORK_TIMEOUT () {0x5005;}' unless defined(&LDAP_OPT_NETWORK_TIMEOUT);
    eval 'sub LDAP_OPT_URI () {0x5006;}' unless defined(&LDAP_OPT_URI);
    eval 'sub LDAP_OPT_REFERRAL_URLS () {0x5007;}' unless defined(&LDAP_OPT_REFERRAL_URLS);
    eval 'sub LDAP_OPT_SOCKBUF () {0x5008;}' unless defined(&LDAP_OPT_SOCKBUF);
    eval 'sub LDAP_OPT_DEFBASE () {0x5009;}' unless defined(&LDAP_OPT_DEFBASE);
    eval 'sub LDAP_OPT_CONNECT_ASYNC () {0x5010;}' unless defined(&LDAP_OPT_CONNECT_ASYNC);
    eval 'sub LDAP_OPT_CONNECT_CB () {0x5011;}' unless defined(&LDAP_OPT_CONNECT_CB);
    eval 'sub LDAP_OPT_SESSION_REFCNT () {0x5012;}' unless defined(&LDAP_OPT_SESSION_REFCNT);
    eval 'sub LDAP_OPT_X_TLS () {0x6000;}' unless defined(&LDAP_OPT_X_TLS);
    eval 'sub LDAP_OPT_X_TLS_CTX () {0x6001;}' unless defined(&LDAP_OPT_X_TLS_CTX);
    eval 'sub LDAP_OPT_X_TLS_CACERTFILE () {0x6002;}' unless defined(&LDAP_OPT_X_TLS_CACERTFILE);
    eval 'sub LDAP_OPT_X_TLS_CACERTDIR () {0x6003;}' unless defined(&LDAP_OPT_X_TLS_CACERTDIR);
    eval 'sub LDAP_OPT_X_TLS_CERTFILE () {0x6004;}' unless defined(&LDAP_OPT_X_TLS_CERTFILE);
    eval 'sub LDAP_OPT_X_TLS_KEYFILE () {0x6005;}' unless defined(&LDAP_OPT_X_TLS_KEYFILE);
    eval 'sub LDAP_OPT_X_TLS_REQUIRE_CERT () {0x6006;}' unless defined(&LDAP_OPT_X_TLS_REQUIRE_CERT);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_MIN () {0x6007;}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_MIN);
    eval 'sub LDAP_OPT_X_TLS_CIPHER_SUITE () {0x6008;}' unless defined(&LDAP_OPT_X_TLS_CIPHER_SUITE);
    eval 'sub LDAP_OPT_X_TLS_RANDOM_FILE () {0x6009;}' unless defined(&LDAP_OPT_X_TLS_RANDOM_FILE);
    eval 'sub LDAP_OPT_X_TLS_SSL_CTX () {0x600a;}' unless defined(&LDAP_OPT_X_TLS_SSL_CTX);
    eval 'sub LDAP_OPT_X_TLS_CRLCHECK () {0x600b;}' unless defined(&LDAP_OPT_X_TLS_CRLCHECK);
    eval 'sub LDAP_OPT_X_TLS_CONNECT_CB () {0x600c;}' unless defined(&LDAP_OPT_X_TLS_CONNECT_CB);
    eval 'sub LDAP_OPT_X_TLS_CONNECT_ARG () {0x600d;}' unless defined(&LDAP_OPT_X_TLS_CONNECT_ARG);
    eval 'sub LDAP_OPT_X_TLS_DHFILE () {0x600e;}' unless defined(&LDAP_OPT_X_TLS_DHFILE);
    eval 'sub LDAP_OPT_X_TLS_NEWCTX () {0x600f;}' unless defined(&LDAP_OPT_X_TLS_NEWCTX);
    eval 'sub LDAP_OPT_X_TLS_CRLFILE () {0x6010;}' unless defined(&LDAP_OPT_X_TLS_CRLFILE);
    eval 'sub LDAP_OPT_X_TLS_PACKAGE () {0x6011;}' unless defined(&LDAP_OPT_X_TLS_PACKAGE);
    eval 'sub LDAP_OPT_X_TLS_ECNAME () {0x6012;}' unless defined(&LDAP_OPT_X_TLS_ECNAME);
    eval 'sub LDAP_OPT_X_TLS_NEVER () {0;}' unless defined(&LDAP_OPT_X_TLS_NEVER);
    eval 'sub LDAP_OPT_X_TLS_HARD () {1;}' unless defined(&LDAP_OPT_X_TLS_HARD);
    eval 'sub LDAP_OPT_X_TLS_DEMAND () {2;}' unless defined(&LDAP_OPT_X_TLS_DEMAND);
    eval 'sub LDAP_OPT_X_TLS_ALLOW () {3;}' unless defined(&LDAP_OPT_X_TLS_ALLOW);
    eval 'sub LDAP_OPT_X_TLS_TRY () {4;}' unless defined(&LDAP_OPT_X_TLS_TRY);
    eval 'sub LDAP_OPT_X_TLS_CRL_NONE () {0;}' unless defined(&LDAP_OPT_X_TLS_CRL_NONE);
    eval 'sub LDAP_OPT_X_TLS_CRL_PEER () {1;}' unless defined(&LDAP_OPT_X_TLS_CRL_PEER);
    eval 'sub LDAP_OPT_X_TLS_CRL_ALL () {2;}' unless defined(&LDAP_OPT_X_TLS_CRL_ALL);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL {
        my($maj,$min) = @_;
	    eval q(((($maj) << 8) + ($min)));
    }' unless defined(&LDAP_OPT_X_TLS_PROTOCOL);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_SSL2 () {(2<< 8);}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_SSL2);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_SSL3 () {(3<< 8);}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_SSL3);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_TLS1_0 () {((3<< 8) + 1);}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_TLS1_0);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_TLS1_1 () {((3<< 8) + 2);}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_TLS1_1);
    eval 'sub LDAP_OPT_X_TLS_PROTOCOL_TLS1_2 () {((3<< 8) + 3);}' unless defined(&LDAP_OPT_X_TLS_PROTOCOL_TLS1_2);
    eval 'sub LDAP_OPT_X_SASL_MECH () {0x6100;}' unless defined(&LDAP_OPT_X_SASL_MECH);
    eval 'sub LDAP_OPT_X_SASL_REALM () {0x6101;}' unless defined(&LDAP_OPT_X_SASL_REALM);
    eval 'sub LDAP_OPT_X_SASL_AUTHCID () {0x6102;}' unless defined(&LDAP_OPT_X_SASL_AUTHCID);
    eval 'sub LDAP_OPT_X_SASL_AUTHZID () {0x6103;}' unless defined(&LDAP_OPT_X_SASL_AUTHZID);
    eval 'sub LDAP_OPT_X_SASL_SSF () {0x6104;}' unless defined(&LDAP_OPT_X_SASL_SSF);
    eval 'sub LDAP_OPT_X_SASL_SSF_EXTERNAL () {0x6105;}' unless defined(&LDAP_OPT_X_SASL_SSF_EXTERNAL);
    eval 'sub LDAP_OPT_X_SASL_SECPROPS () {0x6106;}' unless defined(&LDAP_OPT_X_SASL_SECPROPS);
    eval 'sub LDAP_OPT_X_SASL_SSF_MIN () {0x6107;}' unless defined(&LDAP_OPT_X_SASL_SSF_MIN);
    eval 'sub LDAP_OPT_X_SASL_SSF_MAX () {0x6108;}' unless defined(&LDAP_OPT_X_SASL_SSF_MAX);
    eval 'sub LDAP_OPT_X_SASL_MAXBUFSIZE () {0x6109;}' unless defined(&LDAP_OPT_X_SASL_MAXBUFSIZE);
    eval 'sub LDAP_OPT_X_SASL_MECHLIST () {0x610a;}' unless defined(&LDAP_OPT_X_SASL_MECHLIST);
    eval 'sub LDAP_OPT_X_SASL_NOCANON () {0x610b;}' unless defined(&LDAP_OPT_X_SASL_NOCANON);
    eval 'sub LDAP_OPT_X_SASL_USERNAME () {0x610c;}' unless defined(&LDAP_OPT_X_SASL_USERNAME);
    eval 'sub LDAP_OPT_X_SASL_GSS_CREDS () {0x610d;}' unless defined(&LDAP_OPT_X_SASL_GSS_CREDS);
    eval 'sub LDAP_OPT_X_GSSAPI_DO_NOT_FREE_CONTEXT () {0x6200;}' unless defined(&LDAP_OPT_X_GSSAPI_DO_NOT_FREE_CONTEXT);
    eval 'sub LDAP_OPT_X_GSSAPI_ALLOW_REMOTE_PRINCIPAL () {0x6201;}' unless defined(&LDAP_OPT_X_GSSAPI_ALLOW_REMOTE_PRINCIPAL);
    eval 'sub LDAP_OPT_X_KEEPALIVE_IDLE () {0x6300;}' unless defined(&LDAP_OPT_X_KEEPALIVE_IDLE);
    eval 'sub LDAP_OPT_X_KEEPALIVE_PROBES () {0x6301;}' unless defined(&LDAP_OPT_X_KEEPALIVE_PROBES);
    eval 'sub LDAP_OPT_X_KEEPALIVE_INTERVAL () {0x6302;}' unless defined(&LDAP_OPT_X_KEEPALIVE_INTERVAL);
    eval 'sub LDAP_OPT_PRIVATE_EXTENSION_BASE () {0x7000;}' unless defined(&LDAP_OPT_PRIVATE_EXTENSION_BASE);
    eval 'sub LDAP_OPT_SUCCESS () {0;}' unless defined(&LDAP_OPT_SUCCESS);
    eval 'sub LDAP_OPT_ERROR () {(-1);}' unless defined(&LDAP_OPT_ERROR);
    eval 'sub LDAP_OPT_ON () {(( &void *)  &ber_pvt_opt_on);}' unless defined(&LDAP_OPT_ON);
    eval 'sub LDAP_OPT_OFF () {(( &void *) 0);}' unless defined(&LDAP_OPT_OFF);
    eval 'sub LDAP_API_INFO_VERSION () {(1);}' unless defined(&LDAP_API_INFO_VERSION);
    eval 'sub LDAP_FEATURE_INFO_VERSION () {(1);}' unless defined(&LDAP_FEATURE_INFO_VERSION);
    eval 'sub LDAP_CONTROL_MANAGEDSAIT () {"2.16.840.1.113730.3.4.2";}' unless defined(&LDAP_CONTROL_MANAGEDSAIT);
    eval 'sub LDAP_CONTROL_PROXY_AUTHZ () {"2.16.840.1.113730.3.4.18";}' unless defined(&LDAP_CONTROL_PROXY_AUTHZ);
    eval 'sub LDAP_CONTROL_SUBENTRIES () {"1.3.6.1.4.1.4203.1.10.1";}' unless defined(&LDAP_CONTROL_SUBENTRIES);
    eval 'sub LDAP_CONTROL_VALUESRETURNFILTER () {"1.2.826.0.1.3344810.2.3";}' unless defined(&LDAP_CONTROL_VALUESRETURNFILTER);
    eval 'sub LDAP_CONTROL_ASSERT () {"1.3.6.1.1.12";}' unless defined(&LDAP_CONTROL_ASSERT);
    eval 'sub LDAP_CONTROL_PRE_READ () {"1.3.6.1.1.13.1";}' unless defined(&LDAP_CONTROL_PRE_READ);
    eval 'sub LDAP_CONTROL_POST_READ () {"1.3.6.1.1.13.2";}' unless defined(&LDAP_CONTROL_POST_READ);
    eval 'sub LDAP_CONTROL_SORTREQUEST () {"1.2.840.113556.1.4.473";}' unless defined(&LDAP_CONTROL_SORTREQUEST);
    eval 'sub LDAP_CONTROL_SORTRESPONSE () {"1.2.840.113556.1.4.474";}' unless defined(&LDAP_CONTROL_SORTRESPONSE);
    eval 'sub LDAP_CONTROL_PAGEDRESULTS () {"1.2.840.113556.1.4.319";}' unless defined(&LDAP_CONTROL_PAGEDRESULTS);
    eval 'sub LDAP_SYNC_OID () {"1.3.6.1.4.1.4203.1.9.1";}' unless defined(&LDAP_SYNC_OID);
    eval 'sub LDAP_CONTROL_SYNC () { &LDAP_SYNC_OID ".1";}' unless defined(&LDAP_CONTROL_SYNC);
    eval 'sub LDAP_CONTROL_SYNC_STATE () { &LDAP_SYNC_OID ".2";}' unless defined(&LDAP_CONTROL_SYNC_STATE);
    eval 'sub LDAP_CONTROL_SYNC_DONE () { &LDAP_SYNC_OID ".3";}' unless defined(&LDAP_CONTROL_SYNC_DONE);
    eval 'sub LDAP_SYNC_INFO () { &LDAP_SYNC_OID ".4";}' unless defined(&LDAP_SYNC_INFO);
    eval 'sub LDAP_SYNC_NONE () {0x;}' unless defined(&LDAP_SYNC_NONE);
    eval 'sub LDAP_SYNC_REFRESH_ONLY () {0x1;}' unless defined(&LDAP_SYNC_REFRESH_ONLY);
    eval 'sub LDAP_SYNC_RESERVED () {0x2;}' unless defined(&LDAP_SYNC_RESERVED);
    eval 'sub LDAP_SYNC_REFRESH_AND_PERSIST () {0x3;}' unless defined(&LDAP_SYNC_REFRESH_AND_PERSIST);
    eval 'sub LDAP_SYNC_REFRESH_PRESENTS () {0;}' unless defined(&LDAP_SYNC_REFRESH_PRESENTS);
    eval 'sub LDAP_SYNC_REFRESH_DELETES () {1;}' unless defined(&LDAP_SYNC_REFRESH_DELETES);
    eval 'sub LDAP_TAG_SYNC_NEW_COOKIE () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_SYNC_NEW_COOKIE);
    eval 'sub LDAP_TAG_SYNC_REFRESH_DELETE () {(( &ber_tag_t) 0xa1);}' unless defined(&LDAP_TAG_SYNC_REFRESH_DELETE);
    eval 'sub LDAP_TAG_SYNC_REFRESH_PRESENT () {(( &ber_tag_t) 0xa2);}' unless defined(&LDAP_TAG_SYNC_REFRESH_PRESENT);
    eval 'sub LDAP_TAG_SYNC_ID_SET () {(( &ber_tag_t) 0xa3);}' unless defined(&LDAP_TAG_SYNC_ID_SET);
    eval 'sub LDAP_TAG_SYNC_COOKIE () {(( &ber_tag_t) 0x4);}' unless defined(&LDAP_TAG_SYNC_COOKIE);
    eval 'sub LDAP_TAG_REFRESHDELETES () {(( &ber_tag_t) 0x1);}' unless defined(&LDAP_TAG_REFRESHDELETES);
    eval 'sub LDAP_TAG_REFRESHDONE () {(( &ber_tag_t) 0x1);}' unless defined(&LDAP_TAG_REFRESHDONE);
    eval 'sub LDAP_TAG_RELOAD_HINT () {(( &ber_tag_t) 0x1);}' unless defined(&LDAP_TAG_RELOAD_HINT);
    eval 'sub LDAP_SYNC_PRESENT () {0;}' unless defined(&LDAP_SYNC_PRESENT);
    eval 'sub LDAP_SYNC_ADD () {1;}' unless defined(&LDAP_SYNC_ADD);
    eval 'sub LDAP_SYNC_MODIFY () {2;}' unless defined(&LDAP_SYNC_MODIFY);
    eval 'sub LDAP_SYNC_DELETE () {3;}' unless defined(&LDAP_SYNC_DELETE);
    eval 'sub LDAP_SYNC_NEW_COOKIE () {4;}' unless defined(&LDAP_SYNC_NEW_COOKIE);
    eval 'sub LDAP_CONTROL_DONTUSECOPY () {"1.3.6.1.1.22";}' unless defined(&LDAP_CONTROL_DONTUSECOPY);
    eval 'sub LDAP_CONTROL_PASSWORDPOLICYREQUEST () {"1.3.6.1.4.1.42.2.27.8.5.1";}' unless defined(&LDAP_CONTROL_PASSWORDPOLICYREQUEST);
    eval 'sub LDAP_CONTROL_PASSWORDPOLICYRESPONSE () {"1.3.6.1.4.1.42.2.27.8.5.1";}' unless defined(&LDAP_CONTROL_PASSWORDPOLICYRESPONSE);
    eval 'sub LDAP_CONTROL_NOOP () {"1.3.6.1.4.1.4203.666.5.2";}' unless defined(&LDAP_CONTROL_NOOP);
    eval 'sub LDAP_CONTROL_NO_SUBORDINATES () {"1.3.6.1.4.1.4203.666.5.11";}' unless defined(&LDAP_CONTROL_NO_SUBORDINATES);
    eval 'sub LDAP_CONTROL_RELAX () {"1.3.6.1.4.1.4203.666.5.12";}' unless defined(&LDAP_CONTROL_RELAX);
    eval 'sub LDAP_CONTROL_MANAGEDIT () { &LDAP_CONTROL_RELAX;}' unless defined(&LDAP_CONTROL_MANAGEDIT);
    eval 'sub LDAP_CONTROL_SLURP () {"1.3.6.1.4.1.4203.666.5.13";}' unless defined(&LDAP_CONTROL_SLURP);
    eval 'sub LDAP_CONTROL_VALSORT () {"1.3.6.1.4.1.4203.666.5.14";}' unless defined(&LDAP_CONTROL_VALSORT);
    eval 'sub LDAP_CONTROL_X_DEREF () {"1.3.6.1.4.1.4203.666.5.16";}' unless defined(&LDAP_CONTROL_X_DEREF);
    eval 'sub LDAP_CONTROL_X_WHATFAILED () {"1.3.6.1.4.1.4203.666.5.17";}' unless defined(&LDAP_CONTROL_X_WHATFAILED);
    eval 'sub LDAP_CONTROL_X_CHAINING_BEHAVIOR () {"1.3.6.1.4.1.4203.666.11.3";}' unless defined(&LDAP_CONTROL_X_CHAINING_BEHAVIOR);
    eval 'sub LDAP_CHAINING_PREFERRED () {0;}' unless defined(&LDAP_CHAINING_PREFERRED);
    eval 'sub LDAP_CHAINING_REQUIRED () {1;}' unless defined(&LDAP_CHAINING_REQUIRED);
    eval 'sub LDAP_REFERRALS_PREFERRED () {2;}' unless defined(&LDAP_REFERRALS_PREFERRED);
    eval 'sub LDAP_REFERRALS_REQUIRED () {3;}' unless defined(&LDAP_REFERRALS_REQUIRED);
    eval 'sub LDAP_CONTROL_X_INCREMENTAL_VALUES () {"1.2.840.113556.1.4.802";}' unless defined(&LDAP_CONTROL_X_INCREMENTAL_VALUES);
    eval 'sub LDAP_CONTROL_X_DOMAIN_SCOPE () {"1.2.840.113556.1.4.1339";}' unless defined(&LDAP_CONTROL_X_DOMAIN_SCOPE);
    eval 'sub LDAP_CONTROL_X_PERMISSIVE_MODIFY () {"1.2.840.113556.1.4.1413";}' unless defined(&LDAP_CONTROL_X_PERMISSIVE_MODIFY);
    eval 'sub LDAP_CONTROL_X_SEARCH_OPTIONS () {"1.2.840.113556.1.4.1340";}' unless defined(&LDAP_CONTROL_X_SEARCH_OPTIONS);
    eval 'sub LDAP_SEARCH_FLAG_DOMAIN_SCOPE () {1;}' unless defined(&LDAP_SEARCH_FLAG_DOMAIN_SCOPE);
    eval 'sub LDAP_SEARCH_FLAG_PHANTOM_ROOT () {2;}' unless defined(&LDAP_SEARCH_FLAG_PHANTOM_ROOT);
    eval 'sub LDAP_CONTROL_X_TREE_DELETE () {"1.2.840.113556.1.4.805";}' unless defined(&LDAP_CONTROL_X_TREE_DELETE);
    eval 'sub LDAP_CONTROL_X_EXTENDED_DN () {"1.2.840.113556.1.4.529";}' unless defined(&LDAP_CONTROL_X_EXTENDED_DN);
    eval 'sub LDAP_CONTROL_X_SESSION_TRACKING () {"1.3.6.1.4.1.21008.108.63.1";}' unless defined(&LDAP_CONTROL_X_SESSION_TRACKING);
    eval 'sub LDAP_CONTROL_X_SESSION_TRACKING_RADIUS_ACCT_SESSION_ID () { &LDAP_CONTROL_X_SESSION_TRACKING ".1";}' unless defined(&LDAP_CONTROL_X_SESSION_TRACKING_RADIUS_ACCT_SESSION_ID);
    eval 'sub LDAP_CONTROL_X_SESSION_TRACKING_RADIUS_ACCT_MULTI_SESSION_ID () { &LDAP_CONTROL_X_SESSION_TRACKING ".2";}' unless defined(&LDAP_CONTROL_X_SESSION_TRACKING_RADIUS_ACCT_MULTI_SESSION_ID);
    eval 'sub LDAP_CONTROL_X_SESSION_TRACKING_USERNAME () { &LDAP_CONTROL_X_SESSION_TRACKING ".3";}' unless defined(&LDAP_CONTROL_X_SESSION_TRACKING_USERNAME);
    eval 'sub LDAP_CONTROL_DUPENT_REQUEST () {"2.16.840.1.113719.1.27.101.1";}' unless defined(&LDAP_CONTROL_DUPENT_REQUEST);
    eval 'sub LDAP_CONTROL_DUPENT_RESPONSE () {"2.16.840.1.113719.1.27.101.2";}' unless defined(&LDAP_CONTROL_DUPENT_RESPONSE);
    eval 'sub LDAP_CONTROL_DUPENT_ENTRY () {"2.16.840.1.113719.1.27.101.3";}' unless defined(&LDAP_CONTROL_DUPENT_ENTRY);
    eval 'sub LDAP_CONTROL_DUPENT () { &LDAP_CONTROL_DUPENT_REQUEST;}' unless defined(&LDAP_CONTROL_DUPENT);
    eval 'sub LDAP_CONTROL_PERSIST_REQUEST () {"2.16.840.1.113730.3.4.3";}' unless defined(&LDAP_CONTROL_PERSIST_REQUEST);
    eval 'sub LDAP_CONTROL_PERSIST_ENTRY_CHANGE_NOTICE () {"2.16.840.1.113730.3.4.7";}' unless defined(&LDAP_CONTROL_PERSIST_ENTRY_CHANGE_NOTICE);
    eval 'sub LDAP_CONTROL_PERSIST_ENTRY_CHANGE_ADD () {0x1;}' unless defined(&LDAP_CONTROL_PERSIST_ENTRY_CHANGE_ADD);
    eval 'sub LDAP_CONTROL_PERSIST_ENTRY_CHANGE_DELETE () {0x2;}' unless defined(&LDAP_CONTROL_PERSIST_ENTRY_CHANGE_DELETE);
    eval 'sub LDAP_CONTROL_PERSIST_ENTRY_CHANGE_MODIFY () {0x4;}' unless defined(&LDAP_CONTROL_PERSIST_ENTRY_CHANGE_MODIFY);
    eval 'sub LDAP_CONTROL_PERSIST_ENTRY_CHANGE_RENAME () {0x8;}' unless defined(&LDAP_CONTROL_PERSIST_ENTRY_CHANGE_RENAME);
    eval 'sub LDAP_CONTROL_VLVREQUEST () {"2.16.840.1.113730.3.4.9";}' unless defined(&LDAP_CONTROL_VLVREQUEST);
    eval 'sub LDAP_CONTROL_VLVRESPONSE () {"2.16.840.1.113730.3.4.10";}' unless defined(&LDAP_CONTROL_VLVRESPONSE);
    eval 'sub LDAP_NOTICE_OF_DISCONNECTION () {"1.3.6.1.4.1.1466.20036";}' unless defined(&LDAP_NOTICE_OF_DISCONNECTION);
    eval 'sub LDAP_NOTICE_DISCONNECT () { &LDAP_NOTICE_OF_DISCONNECTION;}' unless defined(&LDAP_NOTICE_DISCONNECT);
    eval 'sub LDAP_EXOP_START_TLS () {"1.3.6.1.4.1.1466.20037";}' unless defined(&LDAP_EXOP_START_TLS);
    eval 'sub LDAP_EXOP_MODIFY_PASSWD () {"1.3.6.1.4.1.4203.1.11.1";}' unless defined(&LDAP_EXOP_MODIFY_PASSWD);
    eval 'sub LDAP_TAG_EXOP_MODIFY_PASSWD_ID () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_EXOP_MODIFY_PASSWD_ID);
    eval 'sub LDAP_TAG_EXOP_MODIFY_PASSWD_OLD () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_TAG_EXOP_MODIFY_PASSWD_OLD);
    eval 'sub LDAP_TAG_EXOP_MODIFY_PASSWD_NEW () {(( &ber_tag_t) 0x82);}' unless defined(&LDAP_TAG_EXOP_MODIFY_PASSWD_NEW);
    eval 'sub LDAP_TAG_EXOP_MODIFY_PASSWD_GEN () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_EXOP_MODIFY_PASSWD_GEN);
    eval 'sub LDAP_EXOP_CANCEL () {"1.3.6.1.1.8";}' unless defined(&LDAP_EXOP_CANCEL);
    eval 'sub LDAP_EXOP_X_CANCEL () { &LDAP_EXOP_CANCEL;}' unless defined(&LDAP_EXOP_X_CANCEL);
    eval 'sub LDAP_EXOP_REFRESH () {"1.3.6.1.4.1.1466.101.119.1";}' unless defined(&LDAP_EXOP_REFRESH);
    eval 'sub LDAP_TAG_EXOP_REFRESH_REQ_DN () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_EXOP_REFRESH_REQ_DN);
    eval 'sub LDAP_TAG_EXOP_REFRESH_REQ_TTL () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_TAG_EXOP_REFRESH_REQ_TTL);
    eval 'sub LDAP_TAG_EXOP_REFRESH_RES_TTL () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_TAG_EXOP_REFRESH_RES_TTL);
    eval 'sub LDAP_EXOP_WHO_AM_I () {"1.3.6.1.4.1.4203.1.11.3";}' unless defined(&LDAP_EXOP_WHO_AM_I);
    eval 'sub LDAP_EXOP_X_WHO_AM_I () { &LDAP_EXOP_WHO_AM_I;}' unless defined(&LDAP_EXOP_X_WHO_AM_I);
    eval 'sub LDAP_EXOP_TURN () {"1.3.6.1.1.19";}' unless defined(&LDAP_EXOP_TURN);
    eval 'sub LDAP_EXOP_X_TURN () { &LDAP_EXOP_TURN;}' unless defined(&LDAP_EXOP_X_TURN);
    eval 'sub LDAP_X_DISTPROC_BASE () {"1.3.6.1.4.1.4203.666.11.6";}' unless defined(&LDAP_X_DISTPROC_BASE);
    eval 'sub LDAP_EXOP_X_CHAINEDREQUEST () { &LDAP_X_DISTPROC_BASE ".1";}' unless defined(&LDAP_EXOP_X_CHAINEDREQUEST);
    eval 'sub LDAP_FEATURE_X_CANCHAINOPS () { &LDAP_X_DISTPROC_BASE ".2";}' unless defined(&LDAP_FEATURE_X_CANCHAINOPS);
    eval 'sub LDAP_CONTROL_X_RETURNCONTREF () { &LDAP_X_DISTPROC_BASE ".3";}' unless defined(&LDAP_CONTROL_X_RETURNCONTREF);
    eval 'sub LDAP_URLEXT_X_LOCALREFOID () { &LDAP_X_DISTPROC_BASE ".4";}' unless defined(&LDAP_URLEXT_X_LOCALREFOID);
    eval 'sub LDAP_URLEXT_X_REFTYPEOID () { &LDAP_X_DISTPROC_BASE ".5";}' unless defined(&LDAP_URLEXT_X_REFTYPEOID);
    eval 'sub LDAP_URLEXT_X_SEARCHEDSUBTREEOID () { &LDAP_X_DISTPROC_BASE ".6";}' unless defined(&LDAP_URLEXT_X_SEARCHEDSUBTREEOID);
    eval 'sub LDAP_URLEXT_X_FAILEDNAMEOID () { &LDAP_X_DISTPROC_BASE ".7";}' unless defined(&LDAP_URLEXT_X_FAILEDNAMEOID);
    eval 'sub LDAP_URLEXT_X_LOCALREF () {"x-localReference";}' unless defined(&LDAP_URLEXT_X_LOCALREF);
    eval 'sub LDAP_URLEXT_X_REFTYPE () {"x-referenceType";}' unless defined(&LDAP_URLEXT_X_REFTYPE);
    eval 'sub LDAP_URLEXT_X_SEARCHEDSUBTREE () {"x-searchedSubtree";}' unless defined(&LDAP_URLEXT_X_SEARCHEDSUBTREE);
    eval 'sub LDAP_URLEXT_X_FAILEDNAME () {"x-failedName";}' unless defined(&LDAP_URLEXT_X_FAILEDNAME);
    if(defined(&LDAP_DEVEL)) {
	eval 'sub LDAP_X_TXN () {"1.3.6.1.4.1.4203.666.11.7";}' unless defined(&LDAP_X_TXN);
	eval 'sub LDAP_EXOP_X_TXN_START () { &LDAP_X_TXN ".1";}' unless defined(&LDAP_EXOP_X_TXN_START);
	eval 'sub LDAP_CONTROL_X_TXN_SPEC () { &LDAP_X_TXN ".2";}' unless defined(&LDAP_CONTROL_X_TXN_SPEC);
	eval 'sub LDAP_EXOP_X_TXN_END () { &LDAP_X_TXN ".3";}' unless defined(&LDAP_EXOP_X_TXN_END);
	eval 'sub LDAP_EXOP_X_TXN_ABORTED_NOTICE () { &LDAP_X_TXN ".4";}' unless defined(&LDAP_EXOP_X_TXN_ABORTED_NOTICE);
    }
    eval 'sub LDAP_FEATURE_ALL_OP_ATTRS () {"1.3.6.1.4.1.4203.1.5.1";}' unless defined(&LDAP_FEATURE_ALL_OP_ATTRS);
    eval 'sub LDAP_FEATURE_OBJECTCLASS_ATTRS () {"1.3.6.1.4.1.4203.1.5.2";}' unless defined(&LDAP_FEATURE_OBJECTCLASS_ATTRS);
    eval 'sub LDAP_FEATURE_ABSOLUTE_FILTERS () {"1.3.6.1.4.1.4203.1.5.3";}' unless defined(&LDAP_FEATURE_ABSOLUTE_FILTERS);
    eval 'sub LDAP_FEATURE_LANGUAGE_TAG_OPTIONS () {"1.3.6.1.4.1.4203.1.5.4";}' unless defined(&LDAP_FEATURE_LANGUAGE_TAG_OPTIONS);
    eval 'sub LDAP_FEATURE_LANGUAGE_RANGE_OPTIONS () {"1.3.6.1.4.1.4203.1.5.5";}' unless defined(&LDAP_FEATURE_LANGUAGE_RANGE_OPTIONS);
    eval 'sub LDAP_FEATURE_MODIFY_INCREMENT () {"1.3.6.1.1.14";}' unless defined(&LDAP_FEATURE_MODIFY_INCREMENT);
    eval 'sub LDAP_FEATURE_SUBORDINATE_SCOPE () {"1.3.6.1.4.1.4203.666.8.1";}' unless defined(&LDAP_FEATURE_SUBORDINATE_SCOPE);
    eval 'sub LDAP_FEATURE_CHILDREN_SCOPE () { &LDAP_FEATURE_SUBORDINATE_SCOPE;}' unless defined(&LDAP_FEATURE_CHILDREN_SCOPE);
    eval 'sub LDAP_TAG_MESSAGE () {(( &ber_tag_t) 0x30);}' unless defined(&LDAP_TAG_MESSAGE);
    eval 'sub LDAP_TAG_MSGID () {(( &ber_tag_t) 0x2);}' unless defined(&LDAP_TAG_MSGID);
    eval 'sub LDAP_TAG_LDAPDN () {(( &ber_tag_t) 0x4);}' unless defined(&LDAP_TAG_LDAPDN);
    eval 'sub LDAP_TAG_LDAPCRED () {(( &ber_tag_t) 0x4);}' unless defined(&LDAP_TAG_LDAPCRED);
    eval 'sub LDAP_TAG_CONTROLS () {(( &ber_tag_t) 0xa0);}' unless defined(&LDAP_TAG_CONTROLS);
    eval 'sub LDAP_TAG_REFERRAL () {(( &ber_tag_t) 0xa3);}' unless defined(&LDAP_TAG_REFERRAL);
    eval 'sub LDAP_TAG_NEWSUPERIOR () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_NEWSUPERIOR);
    eval 'sub LDAP_TAG_EXOP_REQ_OID () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_EXOP_REQ_OID);
    eval 'sub LDAP_TAG_EXOP_REQ_VALUE () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_TAG_EXOP_REQ_VALUE);
    eval 'sub LDAP_TAG_EXOP_RES_OID () {(( &ber_tag_t) 0x8a);}' unless defined(&LDAP_TAG_EXOP_RES_OID);
    eval 'sub LDAP_TAG_EXOP_RES_VALUE () {(( &ber_tag_t) 0x8b);}' unless defined(&LDAP_TAG_EXOP_RES_VALUE);
    eval 'sub LDAP_TAG_IM_RES_OID () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_TAG_IM_RES_OID);
    eval 'sub LDAP_TAG_IM_RES_VALUE () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_TAG_IM_RES_VALUE);
    eval 'sub LDAP_TAG_SASL_RES_CREDS () {(( &ber_tag_t) 0x87);}' unless defined(&LDAP_TAG_SASL_RES_CREDS);
    eval 'sub LDAP_REQ_BIND () {(( &ber_tag_t) 0x60);}' unless defined(&LDAP_REQ_BIND);
    eval 'sub LDAP_REQ_UNBIND () {(( &ber_tag_t) 0x42);}' unless defined(&LDAP_REQ_UNBIND);
    eval 'sub LDAP_REQ_SEARCH () {(( &ber_tag_t) 0x63);}' unless defined(&LDAP_REQ_SEARCH);
    eval 'sub LDAP_REQ_MODIFY () {(( &ber_tag_t) 0x66);}' unless defined(&LDAP_REQ_MODIFY);
    eval 'sub LDAP_REQ_ADD () {(( &ber_tag_t) 0x68);}' unless defined(&LDAP_REQ_ADD);
    eval 'sub LDAP_REQ_DELETE () {(( &ber_tag_t) 0x4a);}' unless defined(&LDAP_REQ_DELETE);
    eval 'sub LDAP_REQ_MODDN () {(( &ber_tag_t) 0x6c);}' unless defined(&LDAP_REQ_MODDN);
    eval 'sub LDAP_REQ_MODRDN () { &LDAP_REQ_MODDN;}' unless defined(&LDAP_REQ_MODRDN);
    eval 'sub LDAP_REQ_RENAME () { &LDAP_REQ_MODDN;}' unless defined(&LDAP_REQ_RENAME);
    eval 'sub LDAP_REQ_COMPARE () {(( &ber_tag_t) 0x6e);}' unless defined(&LDAP_REQ_COMPARE);
    eval 'sub LDAP_REQ_ABANDON () {(( &ber_tag_t) 0x50);}' unless defined(&LDAP_REQ_ABANDON);
    eval 'sub LDAP_REQ_EXTENDED () {(( &ber_tag_t) 0x77);}' unless defined(&LDAP_REQ_EXTENDED);
    eval 'sub LDAP_RES_BIND () {(( &ber_tag_t) 0x61);}' unless defined(&LDAP_RES_BIND);
    eval 'sub LDAP_RES_SEARCH_ENTRY () {(( &ber_tag_t) 0x64);}' unless defined(&LDAP_RES_SEARCH_ENTRY);
    eval 'sub LDAP_RES_SEARCH_REFERENCE () {(( &ber_tag_t) 0x73);}' unless defined(&LDAP_RES_SEARCH_REFERENCE);
    eval 'sub LDAP_RES_SEARCH_RESULT () {(( &ber_tag_t) 0x65);}' unless defined(&LDAP_RES_SEARCH_RESULT);
    eval 'sub LDAP_RES_MODIFY () {(( &ber_tag_t) 0x67);}' unless defined(&LDAP_RES_MODIFY);
    eval 'sub LDAP_RES_ADD () {(( &ber_tag_t) 0x69);}' unless defined(&LDAP_RES_ADD);
    eval 'sub LDAP_RES_DELETE () {(( &ber_tag_t) 0x6b);}' unless defined(&LDAP_RES_DELETE);
    eval 'sub LDAP_RES_MODDN () {(( &ber_tag_t) 0x6d);}' unless defined(&LDAP_RES_MODDN);
    eval 'sub LDAP_RES_MODRDN () { &LDAP_RES_MODDN;}' unless defined(&LDAP_RES_MODRDN);
    eval 'sub LDAP_RES_RENAME () { &LDAP_RES_MODDN;}' unless defined(&LDAP_RES_RENAME);
    eval 'sub LDAP_RES_COMPARE () {(( &ber_tag_t) 0x6f);}' unless defined(&LDAP_RES_COMPARE);
    eval 'sub LDAP_RES_EXTENDED () {(( &ber_tag_t) 0x78);}' unless defined(&LDAP_RES_EXTENDED);
    eval 'sub LDAP_RES_INTERMEDIATE () {(( &ber_tag_t) 0x79);}' unless defined(&LDAP_RES_INTERMEDIATE);
    eval 'sub LDAP_RES_ANY () {(-1);}' unless defined(&LDAP_RES_ANY);
    eval 'sub LDAP_RES_UNSOLICITED () {(0);}' unless defined(&LDAP_RES_UNSOLICITED);
    eval 'sub LDAP_SASL_SIMPLE () {(0);}' unless defined(&LDAP_SASL_SIMPLE);
    eval 'sub LDAP_SASL_NULL () {("");}' unless defined(&LDAP_SASL_NULL);
    eval 'sub LDAP_AUTH_NONE () {(( &ber_tag_t) 0x);}' unless defined(&LDAP_AUTH_NONE);
    eval 'sub LDAP_AUTH_SIMPLE () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_AUTH_SIMPLE);
    eval 'sub LDAP_AUTH_SASL () {(( &ber_tag_t) 0xa3);}' unless defined(&LDAP_AUTH_SASL);
    eval 'sub LDAP_AUTH_KRBV4 () {(( &ber_tag_t) 0xff);}' unless defined(&LDAP_AUTH_KRBV4);
    eval 'sub LDAP_AUTH_KRBV41 () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_AUTH_KRBV41);
    eval 'sub LDAP_AUTH_KRBV42 () {(( &ber_tag_t) 0x82);}' unless defined(&LDAP_AUTH_KRBV42);
    eval 'sub LDAP_AUTH_NEGOTIATE () {(( &ber_tag_t) 0x4ff);}' unless defined(&LDAP_AUTH_NEGOTIATE);
    eval 'sub LDAP_FILTER_AND () {(( &ber_tag_t) 0xa0);}' unless defined(&LDAP_FILTER_AND);
    eval 'sub LDAP_FILTER_OR () {(( &ber_tag_t) 0xa1);}' unless defined(&LDAP_FILTER_OR);
    eval 'sub LDAP_FILTER_NOT () {(( &ber_tag_t) 0xa2);}' unless defined(&LDAP_FILTER_NOT);
    eval 'sub LDAP_FILTER_EQUALITY () {(( &ber_tag_t) 0xa3);}' unless defined(&LDAP_FILTER_EQUALITY);
    eval 'sub LDAP_FILTER_SUBSTRINGS () {(( &ber_tag_t) 0xa4);}' unless defined(&LDAP_FILTER_SUBSTRINGS);
    eval 'sub LDAP_FILTER_GE () {(( &ber_tag_t) 0xa5);}' unless defined(&LDAP_FILTER_GE);
    eval 'sub LDAP_FILTER_LE () {(( &ber_tag_t) 0xa6);}' unless defined(&LDAP_FILTER_LE);
    eval 'sub LDAP_FILTER_PRESENT () {(( &ber_tag_t) 0x87);}' unless defined(&LDAP_FILTER_PRESENT);
    eval 'sub LDAP_FILTER_APPROX () {(( &ber_tag_t) 0xa8);}' unless defined(&LDAP_FILTER_APPROX);
    eval 'sub LDAP_FILTER_EXT () {(( &ber_tag_t) 0xa9);}' unless defined(&LDAP_FILTER_EXT);
    eval 'sub LDAP_FILTER_EXT_OID () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_FILTER_EXT_OID);
    eval 'sub LDAP_FILTER_EXT_TYPE () {(( &ber_tag_t) 0x82);}' unless defined(&LDAP_FILTER_EXT_TYPE);
    eval 'sub LDAP_FILTER_EXT_VALUE () {(( &ber_tag_t) 0x83);}' unless defined(&LDAP_FILTER_EXT_VALUE);
    eval 'sub LDAP_FILTER_EXT_DNATTRS () {(( &ber_tag_t) 0x84);}' unless defined(&LDAP_FILTER_EXT_DNATTRS);
    eval 'sub LDAP_SUBSTRING_INITIAL () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_SUBSTRING_INITIAL);
    eval 'sub LDAP_SUBSTRING_ANY () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_SUBSTRING_ANY);
    eval 'sub LDAP_SUBSTRING_FINAL () {(( &ber_tag_t) 0x82);}' unless defined(&LDAP_SUBSTRING_FINAL);
    eval 'sub LDAP_SCOPE_BASE () {(( &ber_int_t) 0x);}' unless defined(&LDAP_SCOPE_BASE);
    eval 'sub LDAP_SCOPE_BASEOBJECT () { &LDAP_SCOPE_BASE;}' unless defined(&LDAP_SCOPE_BASEOBJECT);
    eval 'sub LDAP_SCOPE_ONELEVEL () {(( &ber_int_t) 0x1);}' unless defined(&LDAP_SCOPE_ONELEVEL);
    eval 'sub LDAP_SCOPE_ONE () { &LDAP_SCOPE_ONELEVEL;}' unless defined(&LDAP_SCOPE_ONE);
    eval 'sub LDAP_SCOPE_SUBTREE () {(( &ber_int_t) 0x2);}' unless defined(&LDAP_SCOPE_SUBTREE);
    eval 'sub LDAP_SCOPE_SUB () { &LDAP_SCOPE_SUBTREE;}' unless defined(&LDAP_SCOPE_SUB);
    eval 'sub LDAP_SCOPE_SUBORDINATE () {(( &ber_int_t) 0x3);}' unless defined(&LDAP_SCOPE_SUBORDINATE);
    eval 'sub LDAP_SCOPE_CHILDREN () { &LDAP_SCOPE_SUBORDINATE;}' unless defined(&LDAP_SCOPE_CHILDREN);
    eval 'sub LDAP_SCOPE_DEFAULT () {(( &ber_int_t) -1);}' unless defined(&LDAP_SCOPE_DEFAULT);
    eval 'sub LDAP_SUBSTRING_INITIAL () {(( &ber_tag_t) 0x80);}' unless defined(&LDAP_SUBSTRING_INITIAL);
    eval 'sub LDAP_SUBSTRING_ANY () {(( &ber_tag_t) 0x81);}' unless defined(&LDAP_SUBSTRING_ANY);
    eval 'sub LDAP_SUBSTRING_FINAL () {(( &ber_tag_t) 0x82);}' unless defined(&LDAP_SUBSTRING_FINAL);
    eval 'sub LDAP_SUCCESS () {0x;}' unless defined(&LDAP_SUCCESS);
    eval 'sub LDAP_RANGE {
        my($n,$x,$y) = @_;
	    eval q(((($x) <= ($n))  && (($n) <= ($y))));
    }' unless defined(&LDAP_RANGE);
    eval 'sub LDAP_OPERATIONS_ERROR () {0x1;}' unless defined(&LDAP_OPERATIONS_ERROR);
    eval 'sub LDAP_PROTOCOL_ERROR () {0x2;}' unless defined(&LDAP_PROTOCOL_ERROR);
    eval 'sub LDAP_TIMELIMIT_EXCEEDED () {0x3;}' unless defined(&LDAP_TIMELIMIT_EXCEEDED);
    eval 'sub LDAP_SIZELIMIT_EXCEEDED () {0x4;}' unless defined(&LDAP_SIZELIMIT_EXCEEDED);
    eval 'sub LDAP_COMPARE_FALSE () {0x5;}' unless defined(&LDAP_COMPARE_FALSE);
    eval 'sub LDAP_COMPARE_TRUE () {0x6;}' unless defined(&LDAP_COMPARE_TRUE);
    eval 'sub LDAP_AUTH_METHOD_NOT_SUPPORTED () {0x7;}' unless defined(&LDAP_AUTH_METHOD_NOT_SUPPORTED);
    eval 'sub LDAP_STRONG_AUTH_NOT_SUPPORTED () { &LDAP_AUTH_METHOD_NOT_SUPPORTED;}' unless defined(&LDAP_STRONG_AUTH_NOT_SUPPORTED);
    eval 'sub LDAP_STRONG_AUTH_REQUIRED () {0x8;}' unless defined(&LDAP_STRONG_AUTH_REQUIRED);
    eval 'sub LDAP_STRONGER_AUTH_REQUIRED () { &LDAP_STRONG_AUTH_REQUIRED;}' unless defined(&LDAP_STRONGER_AUTH_REQUIRED);
    eval 'sub LDAP_PARTIAL_RESULTS () {0x9;}' unless defined(&LDAP_PARTIAL_RESULTS);
    eval 'sub LDAP_REFERRAL () {0xa;}' unless defined(&LDAP_REFERRAL);
    eval 'sub LDAP_ADMINLIMIT_EXCEEDED () {0xb;}' unless defined(&LDAP_ADMINLIMIT_EXCEEDED);
    eval 'sub LDAP_UNAVAILABLE_CRITICAL_EXTENSION () {0xc;}' unless defined(&LDAP_UNAVAILABLE_CRITICAL_EXTENSION);
    eval 'sub LDAP_CONFIDENTIALITY_REQUIRED () {0xd;}' unless defined(&LDAP_CONFIDENTIALITY_REQUIRED);
    eval 'sub LDAP_SASL_BIND_IN_PROGRESS () {0xe;}' unless defined(&LDAP_SASL_BIND_IN_PROGRESS);
    eval 'sub LDAP_ATTR_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x10,0x15));
    }' unless defined(&LDAP_ATTR_ERROR);
    eval 'sub LDAP_NO_SUCH_ATTRIBUTE () {0x10;}' unless defined(&LDAP_NO_SUCH_ATTRIBUTE);
    eval 'sub LDAP_UNDEFINED_TYPE () {0x11;}' unless defined(&LDAP_UNDEFINED_TYPE);
    eval 'sub LDAP_INAPPROPRIATE_MATCHING () {0x12;}' unless defined(&LDAP_INAPPROPRIATE_MATCHING);
    eval 'sub LDAP_CONSTRAINT_VIOLATION () {0x13;}' unless defined(&LDAP_CONSTRAINT_VIOLATION);
    eval 'sub LDAP_TYPE_OR_VALUE_EXISTS () {0x14;}' unless defined(&LDAP_TYPE_OR_VALUE_EXISTS);
    eval 'sub LDAP_INVALID_SYNTAX () {0x15;}' unless defined(&LDAP_INVALID_SYNTAX);
    eval 'sub LDAP_NAME_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x20,0x24));
    }' unless defined(&LDAP_NAME_ERROR);
    eval 'sub LDAP_NO_SUCH_OBJECT () {0x20;}' unless defined(&LDAP_NO_SUCH_OBJECT);
    eval 'sub LDAP_ALIAS_PROBLEM () {0x21;}' unless defined(&LDAP_ALIAS_PROBLEM);
    eval 'sub LDAP_INVALID_DN_SYNTAX () {0x22;}' unless defined(&LDAP_INVALID_DN_SYNTAX);
    eval 'sub LDAP_IS_LEAF () {0x23;}' unless defined(&LDAP_IS_LEAF);
    eval 'sub LDAP_ALIAS_DEREF_PROBLEM () {0x24;}' unless defined(&LDAP_ALIAS_DEREF_PROBLEM);
    eval 'sub LDAP_SECURITY_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x2f,0x32));
    }' unless defined(&LDAP_SECURITY_ERROR);
    eval 'sub LDAP_X_PROXY_AUTHZ_FAILURE () {0x2f;}' unless defined(&LDAP_X_PROXY_AUTHZ_FAILURE);
    eval 'sub LDAP_INAPPROPRIATE_AUTH () {0x30;}' unless defined(&LDAP_INAPPROPRIATE_AUTH);
    eval 'sub LDAP_INVALID_CREDENTIALS () {0x31;}' unless defined(&LDAP_INVALID_CREDENTIALS);
    eval 'sub LDAP_INSUFFICIENT_ACCESS () {0x32;}' unless defined(&LDAP_INSUFFICIENT_ACCESS);
    eval 'sub LDAP_SERVICE_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x33,0x36));
    }' unless defined(&LDAP_SERVICE_ERROR);
    eval 'sub LDAP_BUSY () {0x33;}' unless defined(&LDAP_BUSY);
    eval 'sub LDAP_UNAVAILABLE () {0x34;}' unless defined(&LDAP_UNAVAILABLE);
    eval 'sub LDAP_UNWILLING_TO_PERFORM () {0x35;}' unless defined(&LDAP_UNWILLING_TO_PERFORM);
    eval 'sub LDAP_LOOP_DETECT () {0x36;}' unless defined(&LDAP_LOOP_DETECT);
    eval 'sub LDAP_UPDATE_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x40,0x47));
    }' unless defined(&LDAP_UPDATE_ERROR);
    eval 'sub LDAP_NAMING_VIOLATION () {0x40;}' unless defined(&LDAP_NAMING_VIOLATION);
    eval 'sub LDAP_OBJECT_CLASS_VIOLATION () {0x41;}' unless defined(&LDAP_OBJECT_CLASS_VIOLATION);
    eval 'sub LDAP_NOT_ALLOWED_ON_NONLEAF () {0x42;}' unless defined(&LDAP_NOT_ALLOWED_ON_NONLEAF);
    eval 'sub LDAP_NOT_ALLOWED_ON_RDN () {0x43;}' unless defined(&LDAP_NOT_ALLOWED_ON_RDN);
    eval 'sub LDAP_ALREADY_EXISTS () {0x44;}' unless defined(&LDAP_ALREADY_EXISTS);
    eval 'sub LDAP_NO_OBJECT_CLASS_MODS () {0x45;}' unless defined(&LDAP_NO_OBJECT_CLASS_MODS);
    eval 'sub LDAP_RESULTS_TOO_LARGE () {0x46;}' unless defined(&LDAP_RESULTS_TOO_LARGE);
    eval 'sub LDAP_AFFECTS_MULTIPLE_DSAS () {0x47;}' unless defined(&LDAP_AFFECTS_MULTIPLE_DSAS);
    eval 'sub LDAP_VLV_ERROR () {0x4c;}' unless defined(&LDAP_VLV_ERROR);
    eval 'sub LDAP_OTHER () {0x50;}' unless defined(&LDAP_OTHER);
    eval 'sub LDAP_CUP_RESOURCES_EXHAUSTED () {0x71;}' unless defined(&LDAP_CUP_RESOURCES_EXHAUSTED);
    eval 'sub LDAP_CUP_SECURITY_VIOLATION () {0x72;}' unless defined(&LDAP_CUP_SECURITY_VIOLATION);
    eval 'sub LDAP_CUP_INVALID_DATA () {0x73;}' unless defined(&LDAP_CUP_INVALID_DATA);
    eval 'sub LDAP_CUP_UNSUPPORTED_SCHEME () {0x74;}' unless defined(&LDAP_CUP_UNSUPPORTED_SCHEME);
    eval 'sub LDAP_CUP_RELOAD_REQUIRED () {0x75;}' unless defined(&LDAP_CUP_RELOAD_REQUIRED);
    eval 'sub LDAP_CANCELLED () {0x76;}' unless defined(&LDAP_CANCELLED);
    eval 'sub LDAP_NO_SUCH_OPERATION () {0x77;}' unless defined(&LDAP_NO_SUCH_OPERATION);
    eval 'sub LDAP_TOO_LATE () {0x78;}' unless defined(&LDAP_TOO_LATE);
    eval 'sub LDAP_CANNOT_CANCEL () {0x79;}' unless defined(&LDAP_CANNOT_CANCEL);
    eval 'sub LDAP_ASSERTION_FAILED () {0x7a;}' unless defined(&LDAP_ASSERTION_FAILED);
    eval 'sub LDAP_PROXIED_AUTHORIZATION_DENIED () {0x7b;}' unless defined(&LDAP_PROXIED_AUTHORIZATION_DENIED);
    eval 'sub LDAP_E_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x1000,0x3fff));
    }' unless defined(&LDAP_E_ERROR);
    eval 'sub LDAP_SYNC_REFRESH_REQUIRED () {0x1000;}' unless defined(&LDAP_SYNC_REFRESH_REQUIRED);
    eval 'sub LDAP_X_ERROR {
        my($n) = @_;
	    eval q( &LDAP_RANGE(($n),0x4000,0xffff));
    }' unless defined(&LDAP_X_ERROR);
    eval 'sub LDAP_X_SYNC_REFRESH_REQUIRED () {0x4100;}' unless defined(&LDAP_X_SYNC_REFRESH_REQUIRED);
    eval 'sub LDAP_X_ASSERTION_FAILED () {0x410f;}' unless defined(&LDAP_X_ASSERTION_FAILED);
    eval 'sub LDAP_X_NO_OPERATION () {0x410e;}' unless defined(&LDAP_X_NO_OPERATION);
    if(defined(&LDAP_CONTROL_X_CHAINING_BEHAVIOR)) {
	eval 'sub LDAP_X_NO_REFERRALS_FOUND () {0x4110;}' unless defined(&LDAP_X_NO_REFERRALS_FOUND);
	eval 'sub LDAP_X_CANNOT_CHAIN () {0x4111;}' unless defined(&LDAP_X_CANNOT_CHAIN);
    }
    if(defined(&LDAP_X_DISTPROC_BASE)) {
	eval 'sub LDAP_X_INVALIDREFERENCE () {0x4112;}' unless defined(&LDAP_X_INVALIDREFERENCE);
    }
    if(defined(&LDAP_X_TXN)) {
	eval 'sub LDAP_X_TXN_SPECIFY_OKAY () {0x4120;}' unless defined(&LDAP_X_TXN_SPECIFY_OKAY);
	eval 'sub LDAP_X_TXN_ID_INVALID () {0x4121;}' unless defined(&LDAP_X_TXN_ID_INVALID);
    }
    eval 'sub LDAP_API_ERROR {
        my($n) = @_;
	    eval q((($n)<0));
    }' unless defined(&LDAP_API_ERROR);
    eval 'sub LDAP_API_RESULT {
        my($n) = @_;
	    eval q((($n)<=0));
    }' unless defined(&LDAP_API_RESULT);
    eval 'sub LDAP_SERVER_DOWN () {(-1);}' unless defined(&LDAP_SERVER_DOWN);
    eval 'sub LDAP_LOCAL_ERROR () {(-2);}' unless defined(&LDAP_LOCAL_ERROR);
    eval 'sub LDAP_ENCODING_ERROR () {(-3);}' unless defined(&LDAP_ENCODING_ERROR);
    eval 'sub LDAP_DECODING_ERROR () {(-4);}' unless defined(&LDAP_DECODING_ERROR);
    eval 'sub LDAP_TIMEOUT () {(-5);}' unless defined(&LDAP_TIMEOUT);
    eval 'sub LDAP_AUTH_UNKNOWN () {(-6);}' unless defined(&LDAP_AUTH_UNKNOWN);
    eval 'sub LDAP_FILTER_ERROR () {(-7);}' unless defined(&LDAP_FILTER_ERROR);
    eval 'sub LDAP_USER_CANCELLED () {(-8);}' unless defined(&LDAP_USER_CANCELLED);
    eval 'sub LDAP_PARAM_ERROR () {(-9);}' unless defined(&LDAP_PARAM_ERROR);
    eval 'sub LDAP_NO_MEMORY () {(-10);}' unless defined(&LDAP_NO_MEMORY);
    eval 'sub LDAP_CONNECT_ERROR () {(-11);}' unless defined(&LDAP_CONNECT_ERROR);
    eval 'sub LDAP_NOT_SUPPORTED () {(-12);}' unless defined(&LDAP_NOT_SUPPORTED);
    eval 'sub LDAP_CONTROL_NOT_FOUND () {(-13);}' unless defined(&LDAP_CONTROL_NOT_FOUND);
    eval 'sub LDAP_NO_RESULTS_RETURNED () {(-14);}' unless defined(&LDAP_NO_RESULTS_RETURNED);
    eval 'sub LDAP_MORE_RESULTS_TO_RETURN () {(-15);}' unless defined(&LDAP_MORE_RESULTS_TO_RETURN);
    eval 'sub LDAP_CLIENT_LOOP () {(-16);}' unless defined(&LDAP_CLIENT_LOOP);
    eval 'sub LDAP_REFERRAL_LIMIT_EXCEEDED () {(-17);}' unless defined(&LDAP_REFERRAL_LIMIT_EXCEEDED);
    eval 'sub LDAP_X_CONNECTING () {(-18);}' unless defined(&LDAP_X_CONNECTING);
    eval 'sub LDAP_MOD_OP () {(0x7);}' unless defined(&LDAP_MOD_OP);
    eval 'sub LDAP_MOD_ADD () {(0x);}' unless defined(&LDAP_MOD_ADD);
    eval 'sub LDAP_MOD_DELETE () {(0x1);}' unless defined(&LDAP_MOD_DELETE);
    eval 'sub LDAP_MOD_REPLACE () {(0x2);}' unless defined(&LDAP_MOD_REPLACE);
    eval 'sub LDAP_MOD_INCREMENT () {(0x3);}' unless defined(&LDAP_MOD_INCREMENT);
    eval 'sub LDAP_MOD_BVALUES () {(0x80);}' unless defined(&LDAP_MOD_BVALUES);
    eval 'sub mod_values () { ($mod_vals->{modv_strvals});}' unless defined(&mod_values);
    eval 'sub mod_bvalues () { ($mod_vals->{modv_bvals});}' unless defined(&mod_bvalues);
    eval 'sub LDAP_DEREF_NEVER () {0x;}' unless defined(&LDAP_DEREF_NEVER);
    eval 'sub LDAP_DEREF_SEARCHING () {0x1;}' unless defined(&LDAP_DEREF_SEARCHING);
    eval 'sub LDAP_DEREF_FINDING () {0x2;}' unless defined(&LDAP_DEREF_FINDING);
    eval 'sub LDAP_DEREF_ALWAYS () {0x3;}' unless defined(&LDAP_DEREF_ALWAYS);
    eval 'sub LDAP_NO_LIMIT () {0;}' unless defined(&LDAP_NO_LIMIT);
    eval 'sub LDAP_MSG_ONE () {0x;}' unless defined(&LDAP_MSG_ONE);
    eval 'sub LDAP_MSG_ALL () {0x1;}' unless defined(&LDAP_MSG_ALL);
    eval 'sub LDAP_MSG_RECEIVED () {0x2;}' unless defined(&LDAP_MSG_RECEIVED);
    eval 'sub LDAP_URL_SUCCESS () {0x;}' unless defined(&LDAP_URL_SUCCESS);
    eval 'sub LDAP_URL_ERR_MEM () {0x1;}' unless defined(&LDAP_URL_ERR_MEM);
    eval 'sub LDAP_URL_ERR_PARAM () {0x2;}' unless defined(&LDAP_URL_ERR_PARAM);
    eval 'sub LDAP_URL_ERR_BADSCHEME () {0x3;}' unless defined(&LDAP_URL_ERR_BADSCHEME);
    eval 'sub LDAP_URL_ERR_BADENCLOSURE () {0x4;}' unless defined(&LDAP_URL_ERR_BADENCLOSURE);
    eval 'sub LDAP_URL_ERR_BADURL () {0x5;}' unless defined(&LDAP_URL_ERR_BADURL);
    eval 'sub LDAP_URL_ERR_BADHOST () {0x6;}' unless defined(&LDAP_URL_ERR_BADHOST);
    eval 'sub LDAP_URL_ERR_BADATTRS () {0x7;}' unless defined(&LDAP_URL_ERR_BADATTRS);
    eval 'sub LDAP_URL_ERR_BADSCOPE () {0x8;}' unless defined(&LDAP_URL_ERR_BADSCOPE);
    eval 'sub LDAP_URL_ERR_BADFILTER () {0x9;}' unless defined(&LDAP_URL_ERR_BADFILTER);
    eval 'sub LDAP_URL_ERR_BADEXTS () {0xa;}' unless defined(&LDAP_URL_ERR_BADEXTS);
    eval("sub LDAP_SYNC_CAPI_NONE () { -1; }") unless defined(&LDAP_SYNC_CAPI_NONE);
    eval("sub LDAP_SYNC_CAPI_PHASE_FLAG () { 0x10U; }") unless defined(&LDAP_SYNC_CAPI_PHASE_FLAG);
    eval("sub LDAP_SYNC_CAPI_IDSET_FLAG () { 0x20U; }") unless defined(&LDAP_SYNC_CAPI_IDSET_FLAG);
    eval("sub LDAP_SYNC_CAPI_DONE_FLAG () { 0x40U; }") unless defined(&LDAP_SYNC_CAPI_DONE_FLAG);
    eval("sub LDAP_SYNC_CAPI_PRESENT () { LDAP_SYNC_PRESENT; }") unless defined(&LDAP_SYNC_CAPI_PRESENT);
    eval("sub LDAP_SYNC_CAPI_ADD () { LDAP_SYNC_ADD; }") unless defined(&LDAP_SYNC_CAPI_ADD);
    eval("sub LDAP_SYNC_CAPI_MODIFY () { LDAP_SYNC_MODIFY; }") unless defined(&LDAP_SYNC_CAPI_MODIFY);
    eval("sub LDAP_SYNC_CAPI_DELETE () { LDAP_SYNC_DELETE; }") unless defined(&LDAP_SYNC_CAPI_DELETE);
    eval("sub LDAP_SYNC_CAPI_PRESENTS () { (LDAP_SYNC_CAPI_PHASE_FLAG|LDAP_SYNC_CAPI_PRESENT); }") unless defined(&LDAP_SYNC_CAPI_PRESENTS);
    eval("sub LDAP_SYNC_CAPI_DELETES () { (LDAP_SYNC_CAPI_PHASE_FLAG|LDAP_SYNC_CAPI_DELETE); }") unless defined(&LDAP_SYNC_CAPI_DELETES);
    eval("sub LDAP_SYNC_CAPI_PRESENTS_IDSET () { (LDAP_SYNC_CAPI_PRESENTS|LDAP_SYNC_CAPI_IDSET_FLAG); }") unless defined(&LDAP_SYNC_CAPI_PRESENTS_IDSET);
    eval("sub LDAP_SYNC_CAPI_DELETES_IDSET () { (LDAP_SYNC_CAPI_DELETES|LDAP_SYNC_CAPI_IDSET_FLAG); }") unless defined(&LDAP_SYNC_CAPI_DELETES_IDSET);
    eval("sub LDAP_SYNC_CAPI_DONE () { (LDAP_SYNC_CAPI_DONE_FLAG|LDAP_SYNC_CAPI_PRESENTS); }") unless defined(&LDAP_SYNC_CAPI_DONE);
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef) ) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef) ) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    eval 'sub LDAP_SASL_AUTOMATIC () {0;}' unless defined(&LDAP_SASL_AUTOMATIC);
    eval 'sub LDAP_SASL_INTERACTIVE () {1;}' unless defined(&LDAP_SASL_INTERACTIVE);
    eval 'sub LDAP_SASL_QUIET () {2;}' unless defined(&LDAP_SASL_QUIET);
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    eval 'sub LDAP_AVA_NULL () {0x;}' unless defined(&LDAP_AVA_NULL);
    eval 'sub LDAP_AVA_STRING () {0x1;}' unless defined(&LDAP_AVA_STRING);
    eval 'sub LDAP_AVA_BINARY () {0x2;}' unless defined(&LDAP_AVA_BINARY);
    eval 'sub LDAP_AVA_NONPRINTABLE () {0x4;}' unless defined(&LDAP_AVA_NONPRINTABLE);
    eval 'sub LDAP_AVA_FREE_ATTR () {0x10;}' unless defined(&LDAP_AVA_FREE_ATTR);
    eval 'sub LDAP_AVA_FREE_VALUE () {0x20;}' unless defined(&LDAP_AVA_FREE_VALUE);
    eval 'sub LDAP_DN_FORMAT_LDAP () {0x;}' unless defined(&LDAP_DN_FORMAT_LDAP);
    eval 'sub LDAP_DN_FORMAT_LDAPV3 () {0x10;}' unless defined(&LDAP_DN_FORMAT_LDAPV3);
    eval 'sub LDAP_DN_FORMAT_LDAPV2 () {0x20;}' unless defined(&LDAP_DN_FORMAT_LDAPV2);
    eval 'sub LDAP_DN_FORMAT_DCE () {0x30;}' unless defined(&LDAP_DN_FORMAT_DCE);
    eval 'sub LDAP_DN_FORMAT_UFN () {0x40;}' unless defined(&LDAP_DN_FORMAT_UFN);
    eval 'sub LDAP_DN_FORMAT_AD_CANONICAL () {0x50;}' unless defined(&LDAP_DN_FORMAT_AD_CANONICAL);
    eval 'sub LDAP_DN_FORMAT_LBER () {0xf0;}' unless defined(&LDAP_DN_FORMAT_LBER);
    eval 'sub LDAP_DN_FORMAT_MASK () {0xf0;}' unless defined(&LDAP_DN_FORMAT_MASK);
    eval 'sub LDAP_DN_PRETTY () {0x100;}' unless defined(&LDAP_DN_PRETTY);
    eval 'sub LDAP_DN_SKIP () {0x200;}' unless defined(&LDAP_DN_SKIP);
    eval 'sub LDAP_DN_P_NOLEADTRAILSPACES () {0x1000;}' unless defined(&LDAP_DN_P_NOLEADTRAILSPACES);
    eval 'sub LDAP_DN_P_NOSPACEAFTERRDN () {0x2000;}' unless defined(&LDAP_DN_P_NOSPACEAFTERRDN);
    eval 'sub LDAP_DN_PEDANTIC () {0xf000;}' unless defined(&LDAP_DN_PEDANTIC);
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    if(defined(&LDAP_CONNECTIONLESS)) {
    }
    eval 'sub LDAP_API_FEATURE_CANCEL () {1000;}' unless defined(&LDAP_API_FEATURE_CANCEL);
    eval 'sub LDAP_API_FEATURE_TURN () {1000;}' unless defined(&LDAP_API_FEATURE_TURN);
    eval 'sub LDAP_API_FEATURE_PAGED_RESULTS () {2000;}' unless defined(&LDAP_API_FEATURE_PAGED_RESULTS);
    if((defined(&LDAP_DEPRECATED) ? &LDAP_DEPRECATED : undef)) {
    }
    eval 'sub LDAP_API_FEATURE_SERVER_SIDE_SORT () {2000;}' unless defined(&LDAP_API_FEATURE_SERVER_SIDE_SORT);
    eval 'sub LDAP_API_FEATURE_VIRTUAL_LIST_VIEW () {2000;}' unless defined(&LDAP_API_FEATURE_VIRTUAL_LIST_VIEW);
    eval 'sub LDAP_API_FEATURE_WHOAMI () {1000;}' unless defined(&LDAP_API_FEATURE_WHOAMI);
    eval 'sub LDAP_API_FEATURE_PASSWD_MODIFY () {1000;}' unless defined(&LDAP_API_FEATURE_PASSWD_MODIFY);
    if(defined(&LDAP_CONTROL_PASSWORDPOLICYREQUEST)) {
	eval 'sub LDAP_API_FEATURE_PASSWORD_POLICY () {1000;}' unless defined(&LDAP_API_FEATURE_PASSWORD_POLICY);
	eval("sub PP_passwordExpired () { 0; }") unless defined(&PP_passwordExpired);
	eval("sub PP_accountLocked () { 1; }") unless defined(&PP_accountLocked);
	eval("sub PP_changeAfterReset () { 2; }") unless defined(&PP_changeAfterReset);
	eval("sub PP_passwordModNotAllowed () { 3; }") unless defined(&PP_passwordModNotAllowed);
	eval("sub PP_mustSupplyOldPassword () { 4; }") unless defined(&PP_mustSupplyOldPassword);
	eval("sub PP_insufficientPasswordQuality () { 5; }") unless defined(&PP_insufficientPasswordQuality);
	eval("sub PP_passwordTooShort () { 6; }") unless defined(&PP_passwordTooShort);
	eval("sub PP_passwordTooYoung () { 7; }") unless defined(&PP_passwordTooYoung);
	eval("sub PP_passwordInHistory () { 8; }") unless defined(&PP_passwordInHistory);
	eval("sub PP_noError () { 65535; }") unless defined(&PP_noError);
    }
    eval 'sub LDAP_API_FEATURE_REFRESH () {1000;}' unless defined(&LDAP_API_FEATURE_REFRESH);
    if(defined(&LDAP_X_TXN)) {
    }
    if(defined(&LDAP_CONTROL_X_SESSION_TRACKING)) {
    }
}
1;
