/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.util.StringUtils;
import java.util.Iterator;
import java.util.List;

public class SimpleJSAP
extends JSAP {
    private int screenWidth = 80;
    private String explanation;
    private boolean messagePrinted;
    private final String name;

    public SimpleJSAP(String name, String explanation, Parameter[] parameter) throws JSAPException {
        this.name = name;
        this.explanation = explanation;
        Switch help = new Switch("help", '\u0000', "help");
        help.setHelp("Prints this help message.");
        this.registerParameter(help);
        if (parameter != null) {
            for (int i = 0; i < parameter.length; ++i) {
                this.registerParameter(parameter[i]);
            }
        }
    }

    public SimpleJSAP(String name, String explanation) throws JSAPException {
        this(name, explanation, null);
    }

    public SimpleJSAP(String name) throws JSAPException {
        this(name, null);
    }

    @Override
    public JSAPResult parse(String arg) {
        JSAPResult jsapResult = super.parse(arg);
        this.messagePrinted = this.printMessageIfUnsuccessfulOrHelpRequired(jsapResult);
        return jsapResult;
    }

    @Override
    public JSAPResult parse(String[] arg) {
        JSAPResult jsapResult = super.parse(arg);
        this.messagePrinted = this.printMessageIfUnsuccessfulOrHelpRequired(jsapResult);
        return jsapResult;
    }

    private boolean printMessageIfUnsuccessfulOrHelpRequired(JSAPResult jsapResult) {
        if (!jsapResult.success() || jsapResult.getBoolean("help")) {
            if (!jsapResult.getBoolean("help")) {
                Iterator err = jsapResult.getErrorMessageIterator();
                while (err.hasNext()) {
                    System.err.println("Error: " + err.next());
                }
                return true;
            }
            System.err.println();
            System.err.println("Usage:");
            List l = StringUtils.wrapToList(this.name + " " + this.getUsage(), this.screenWidth);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                System.err.println("  " + i.next().toString());
            }
            if (this.explanation != null) {
                System.err.println();
                l = StringUtils.wrapToList(this.explanation, this.screenWidth);
                i = l.iterator();
                while (i.hasNext()) {
                    System.err.println(i.next());
                }
            }
            System.err.println();
            System.err.println();
            System.err.println(this.getHelp(this.screenWidth));
            return true;
        }
        return false;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public SimpleJSAP setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
        return this;
    }

    public boolean messagePrinted() {
        return this.messagePrinted;
    }
}

