/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.samtools.Defaults;

public class IOUtil {
    @Deprecated
    public static final int STANDARD_BUFFER_SIZE = Defaults.BUFFER_SIZE;
    public static final long ONE_GB = 0x40000000L;
    public static final long TWO_GBS = 0x80000000L;
    public static final long FIVE_GBS = 0x140000000L;

    public static BufferedInputStream toBufferedStream(InputStream stream) {
        if (stream instanceof BufferedInputStream) {
            return (BufferedInputStream)stream;
        }
        return new BufferedInputStream(stream, STANDARD_BUFFER_SIZE);
    }

    public static void deleteFiles(File ... files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static void deleteFiles(Iterable<File> files) {
        for (File f : files) {
            if (f.delete()) continue;
            System.err.println("Could not delete file " + f);
        }
    }

    public static boolean isRegularPath(File file) {
        return !file.exists() || file.isFile();
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs, long minBytesFree) throws IOException {
        File f = null;
        for (int i = 0; i < tmpDirs.length; ++i) {
            if (tmpDirs[i].getUsableSpace() <= minBytesFree && i != tmpDirs.length - 1) continue;
            f = File.createTempFile(prefix, suffix, tmpDirs[i]);
            f.deleteOnExit();
            break;
        }
        return f;
    }

    public static File newTempFile(String prefix, String suffix, File[] tmpDirs) throws IOException {
        return IOUtil.newTempFile(prefix, suffix, tmpDirs, 0x140000000L);
    }

    public static File getDefaultTmpDir() {
        String user = System.getProperty("user.name");
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith("/" + user)) {
            return new File(tmp);
        }
        return new File(tmp, user);
    }
}

