#############################################################################
##
#W  oprtglat.gd                GAP library                   Alexander Hulpke
##
#H  @(#)$Id: oprtglat.gd,v 4.6 2002/04/15 10:05:06 sal Exp $ 
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains declarations for orbits on subgroups
##
Revision.oprtglat_gd:=
  "@(#)$Id: oprtglat.gd,v 4.6 2002/04/15 10:05:06 sal Exp $";

#############################################################################
##
#O  SubgroupsOrbitsAndNormalizers(G,O,all)   orbits of G on subgroups
##  O is either a list on which G acts or a record containing a component
##  `.list' which is a list of groups. In the latter case, groups are removed
##  from the list as long as they are not needed any longer to save space.
##  if all is true, the full orbits are kept, otherwise only representatives.
##
DeclareOperation( "SubgroupsOrbitsAndNormalizers",[IsGroup,IsObject,IsBool]);

#############################################################################
##
#O  GroupOnSubgroupsOrbit(G,H) . . . . . . . . . . . . . . orbit of H under G
##
DeclareGlobalFunction("GroupOnSubgroupsOrbit");

#############################################################################
##
#O  MinimumGroupOnSubgroupsOrbit(G,H [,N_G(H)]) minimum of orbit of H under G
##
DeclareGlobalFunction("MinimumGroupOnSubgroupsOrbit");

#############################################################################
##
#E  oprtglat.gd . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
##
