/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SBIIndexWriter;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.compress.utils.CountingOutputStream;

public class BAMStreamWriter {
    private final CountingOutputStream countingOut;
    private final BlockCompressedOutputStream compressedOut;
    private final BAMRecordCodec bamRecordCodec;
    private final BAMIndexer bamIndexer;
    private final SBIIndexWriter sbiIndexWriter;
    private SAMRecord previousSamRecord;
    private Chunk previousSamRecordChunk;

    public BAMStreamWriter(OutputStream outputStream, OutputStream indexStream, OutputStream sbiStream, long sbiGranularity, SAMFileHeader header) {
        this.countingOut = new CountingOutputStream(outputStream);
        this.compressedOut = new BlockCompressedOutputStream((OutputStream)this.countingOut, (Path)null);
        this.bamRecordCodec = new BAMRecordCodec(header);
        this.bamRecordCodec.setOutputStream(this.compressedOut);
        this.bamIndexer = indexStream != null ? new BAMIndexer(indexStream, header, false) : null;
        this.sbiIndexWriter = sbiStream != null ? new SBIIndexWriter(sbiStream, sbiGranularity) : null;
    }

    public void writeHeader(SAMFileHeader header) {
        BinaryCodec outputBinaryCodec = new BinaryCodec(this.compressedOut);
        BAMFileWriter.writeHeader(outputBinaryCodec, header);
        try {
            this.compressedOut.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public void writeAlignment(SAMRecord alignment) {
        if (this.bamIndexer != null && this.previousSamRecord != null) {
            this.previousSamRecord.setFileSource(new SAMFileSource(null, new BAMFileSpan(this.previousSamRecordChunk)));
            this.bamIndexer.processAlignment(this.previousSamRecord);
        }
        long startOffset = this.compressedOut.getFilePointer();
        if (this.sbiIndexWriter != null) {
            this.sbiIndexWriter.processRecord(startOffset);
        }
        this.bamRecordCodec.encode(alignment);
        long stopOffset = this.compressedOut.getFilePointer();
        this.previousSamRecord = alignment;
        this.previousSamRecordChunk = new Chunk(startOffset, stopOffset);
    }

    public void finish(boolean writeTerminatorBlock) {
        try {
            this.compressedOut.close(writeTerminatorBlock);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        long finalVirtualOffset = this.compressedOut.getFilePointer();
        long dataFileLength = this.countingOut.getBytesWritten();
        if (this.sbiIndexWriter != null) {
            this.sbiIndexWriter.finish(finalVirtualOffset, dataFileLength);
        }
        if (this.bamIndexer != null && this.previousSamRecord != null) {
            this.previousSamRecordChunk = new Chunk(this.previousSamRecordChunk.getChunkStart(), finalVirtualOffset);
            this.previousSamRecord.setFileSource(new SAMFileSource(null, new BAMFileSpan(this.previousSamRecordChunk)));
            this.bamIndexer.processAlignment(this.previousSamRecord);
        }
        if (this.bamIndexer != null) {
            this.bamIndexer.finish();
        }
    }
}

