/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.swing.JideButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.broad.igv.ui.TrackFilterPane;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;

public abstract class FilterComponent
extends JPanel {
    private FilterElement filterElement;
    private TrackFilterPane filterPane;
    private ButtonGroup booleanButtonGroup;
    private JComboBox comparisonOperatorComboBox;
    private JComboBox itemComboBox;
    private JPanel jPanel1;
    private JButton moreButton;
    private JButton removeButton;
    private JTextField valueTextField;

    public FilterComponent(TrackFilterPane filterPane, String text, List<String> items, FilterElement element) {
        this.initComponents();
        this.filterPane = filterPane;
        this.itemComboBox.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        ArrayList<String> textForOperators = new ArrayList<String>();
        FilterElement.Operator[] operators = FilterElement.Operator.values();
        for (int i = 0; i < operators.length; ++i) {
            if (operators[i].equals(FilterElement.Operator.GREATER_THAN_OR_EQUAL) || operators[i].equals(FilterElement.Operator.LESS_THAN_OR_EQUAL)) continue;
            textForOperators.add(operators[i].getValue());
        }
        Collections.sort(textForOperators);
        this.comparisonOperatorComboBox.setModel(new DefaultComboBoxModel<Object>(textForOperators.toArray()));
        if (element != null) {
            this.filterElement = element;
            this.itemComboBox.setSelectedItem(this.filterElement.getSelectedItem());
            this.valueTextField.setText(this.filterElement.getValue());
        } else {
            String selectedItem = (String)this.itemComboBox.getSelectedItem();
            FilterElement.Operator selectedOperator = this.getOperatorForText((String)this.comparisonOperatorComboBox.getSelectedItem());
            this.filterElement = this.createFilterElement(filterPane.getFilter(), selectedItem, selectedOperator, null, null);
        }
        filterPane.getFilter().add(this.filterElement);
    }

    public abstract FilterElement createFilterElement(Filter var1, String var2, FilterElement.Operator var3, String var4, FilterElement.BooleanOperator var5);

    private FilterElement.Operator getOperatorForText(String operatorText) {
        FilterElement.Operator[] operators;
        FilterElement.Operator selected = null;
        for (FilterElement.Operator operator : operators = FilterElement.Operator.values()) {
            if (!operatorText.equals(operator.getValue())) continue;
            selected = operator;
            break;
        }
        return selected;
    }

    public FilterElement getFilterElement() {
        return this.filterElement;
    }

    public String getItem() {
        return (String)this.itemComboBox.getSelectedItem();
    }

    public String getComparisonOperator() {
        return (String)this.comparisonOperatorComboBox.getSelectedItem();
    }

    public String getExpectedValue() {
        return this.valueTextField.getText();
    }

    public void save() {
        this.filterElement.setSelectedItem(this.getItem());
        FilterElement.Operator operator = this.getOperatorForText(this.getComparisonOperator());
        this.filterElement.setComparisonOperator(operator);
        this.filterElement.setExpectedValue(this.getExpectedValue());
    }

    public void displayMoreButton(boolean value) {
        this.moreButton.setVisible(value);
    }

    protected void remove() {
        if (this.filterPane != null) {
            Component[] components = this.filterPane.getComponents();
            if (components.length < 2) {
                return;
            }
            this.filterPane.remove(this);
            this.filterPane.getFilter().remove(this.getFilterElement());
            this.filterPane.adjustMoreAndBooleanButtonVisibility();
            this.filterPane.repaint();
            SwingUtilities.getWindowAncestor(this.filterPane).pack();
        }
    }

    private void initComponents() {
        this.booleanButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.itemComboBox = new JComboBox();
        this.comparisonOperatorComboBox = new JComboBox();
        this.valueTextField = new JTextField();
        this.moreButton = new JideButton();
        this.removeButton = new JideButton();
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(530, 40));
        this.setPreferredSize(new Dimension(700, 40));
        this.setRequestFocusEnabled(false);
        this.setLayout(new FlowLayout(0, 2, 5));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setMinimumSize(new Dimension(470, 31));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.itemComboBox.setMinimumSize(new Dimension(50, 27));
        this.itemComboBox.setPreferredSize(new Dimension(150, 27));
        this.itemComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterComponent.this.itemComboBoxActionPerformed(evt);
            }
        });
        this.itemComboBox.addHierarchyBoundsListener(new HierarchyBoundsListener(){

            @Override
            public void ancestorMoved(HierarchyEvent evt) {
                FilterComponent.this.itemComboBoxAncestorMoved(evt);
            }

            @Override
            public void ancestorResized(HierarchyEvent evt) {
            }
        });
        this.jPanel1.add(this.itemComboBox);
        this.comparisonOperatorComboBox.setActionCommand("comparisonOperatorComboBoxChanged");
        this.comparisonOperatorComboBox.setMinimumSize(new Dimension(50, 27));
        this.comparisonOperatorComboBox.setPreferredSize(new Dimension(150, 27));
        this.comparisonOperatorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterComponent.this.comparisonOperatorComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.comparisonOperatorComboBox);
        this.valueTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.valueTextField.setMinimumSize(new Dimension(50, 27));
        this.valueTextField.setPreferredSize(new Dimension(150, 27));
        this.valueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterComponent.this.valueTextFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.valueTextField);
        this.add(this.jPanel1);
        this.moreButton.setFont(new Font("Arial", 0, 14));
        this.moreButton.setText("+");
        this.moreButton.setContentAreaFilled(false);
        this.moreButton.setHorizontalTextPosition(0);
        this.moreButton.setPreferredSize(new Dimension(45, 27));
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterComponent.this.moreButtonActionPerformed(evt);
            }
        });
        this.add(this.moreButton);
        this.removeButton.setFont(new Font("Arial", 0, 14));
        this.removeButton.setText("-");
        this.removeButton.setContentAreaFilled(false);
        this.removeButton.setHorizontalTextPosition(0);
        this.removeButton.setPreferredSize(new Dimension(45, 27));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterComponent.this.removeButtonActionPerformed(evt);
            }
        });
        this.add(this.removeButton);
    }

    private void valueTextFieldActionPerformed(ActionEvent evt) {
    }

    private void comparisonOperatorComboBoxActionPerformed(ActionEvent evt) {
    }

    private void itemComboBoxActionPerformed(ActionEvent evt) {
    }

    private void itemComboBoxAncestorMoved(HierarchyEvent evt) {
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        if (this.filterPane.more()) {
            this.displayMoreButton(false);
            this.invalidate();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.remove();
    }
}

