/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.CRLFInputStream;
import gnu.java.net.CRLFOutputStream;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.ftp.ActiveModeDTP;
import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.FTPException;
import gnu.java.net.protocol.ftp.FTPResponse;
import gnu.java.net.protocol.ftp.PassiveModeDTP;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.TrustManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FTPConnection {
    public static final int FTP_PORT = 21;
    public static final int FTP_DATA_PORT = 20;
    protected static final String USER = "USER";
    protected static final String PASS = "PASS";
    protected static final String ACCT = "ACCT";
    protected static final String CWD = "CWD";
    protected static final String CDUP = "CDUP";
    protected static final String SMNT = "SMNT";
    protected static final String REIN = "REIN";
    protected static final String QUIT = "QUIT";
    protected static final String PORT = "PORT";
    protected static final String PASV = "PASV";
    protected static final String TYPE = "TYPE";
    protected static final String STRU = "STRU";
    protected static final String MODE = "MODE";
    protected static final String RETR = "RETR";
    protected static final String STOR = "STOR";
    protected static final String STOU = "STOU";
    protected static final String APPE = "APPE";
    protected static final String ALLO = "ALLO";
    protected static final String REST = "REST";
    protected static final String RNFR = "RNFR";
    protected static final String RNTO = "RNTO";
    protected static final String ABOR = "ABOR";
    protected static final String DELE = "DELE";
    protected static final String RMD = "RMD";
    protected static final String MKD = "MKD";
    protected static final String PWD = "PWD";
    protected static final String LIST = "LIST";
    protected static final String NLST = "NLST";
    protected static final String SITE = "SITE";
    protected static final String SYST = "SYST";
    protected static final String STAT = "STAT";
    protected static final String HELP = "HELP";
    protected static final String NOOP = "NOOP";
    protected static final String AUTH = "AUTH";
    protected static final String PBSZ = "PBSZ";
    protected static final String PROT = "PROT";
    protected static final String CCC = "CCC";
    protected static final String TLS = "TLS";
    public static final int TYPE_ASCII = 1;
    public static final int TYPE_EBCDIC = 2;
    public static final int TYPE_BINARY = 3;
    public static final int STRUCTURE_FILE = 1;
    public static final int STRUCTURE_RECORD = 2;
    public static final int STRUCTURE_PAGE = 3;
    public static final int MODE_STREAM = 1;
    public static final int MODE_BLOCK = 2;
    public static final int MODE_COMPRESSED = 3;
    private static final String US_ASCII = "US-ASCII";
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected int connectionTimeout;
    protected int timeout;
    protected boolean debug;
    protected DTP dtp;
    protected int representationType;
    protected int fileStructure;
    protected int transferMode;
    protected boolean passive;

    public boolean authenticate(String username, String password) throws IOException {
        String cmd = "USER " + username;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 230: {
                return true;
            }
            case 331: {
                break;
            }
            case 332: 
            case 530: {
                return false;
            }
            default: {
                throw new FTPException(response);
            }
        }
        cmd = "PASS " + password;
        this.send(cmd);
        response = this.getResponse();
        switch (response.getCode()) {
            case 202: 
            case 230: {
                return true;
            }
            case 332: 
            case 530: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public boolean starttls(boolean confidential) throws IOException {
        return this.starttls(confidential, new EmptyX509TrustManager());
    }

    /*
     * Exception decompiling
     */
    public boolean starttls(boolean confidential, TrustManager tm) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean changeWorkingDirectory(String path) throws IOException {
        String cmd = "CWD " + path;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public boolean changeToParentDirectory() throws IOException {
        this.send(CDUP);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public void reinitialize() throws IOException {
        this.send(REIN);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 220: {
                if (this.dtp == null) break;
                this.dtp.complete();
                this.dtp = null;
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    public void logout() throws IOException {
        this.send(QUIT);
        try {
            this.getResponse();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.dtp != null) {
            this.dtp.complete();
            this.dtp = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void initialiseDTP() throws IOException {
        if (this.dtp != null) {
            this.dtp.complete();
            this.dtp = null;
        }
        InetAddress localhost = this.socket.getLocalAddress();
        if (this.passive) {
            this.send(PASV);
            FTPResponse response = this.getResponse();
            switch (response.getCode()) {
                case 227: {
                    String message = response.getMessage();
                    try {
                        int start = message.indexOf(44);
                        char c = message.charAt(start - 1);
                        while (c >= '0' && c <= '9') {
                            c = message.charAt(--start - 1);
                        }
                        int mid1 = start;
                        int i = 0;
                        while (i < 4) {
                            mid1 = message.indexOf(44, mid1 + 1);
                            ++i;
                        }
                        int mid2 = message.indexOf(44, mid1 + 1);
                        if (mid1 == -1 || mid2 < mid1) {
                            throw new ProtocolException("Malformed 227: " + message);
                        }
                        int end = mid2;
                        c = message.charAt(end + 1);
                        while (c >= '0' && c <= '9') {
                            c = message.charAt(++end + 1);
                        }
                        String address = message.substring(start, mid1).replace(',', '.');
                        int port_hi = Integer.parseInt(message.substring(mid1 + 1, mid2));
                        int port_lo = Integer.parseInt(message.substring(mid2 + 1, end + 1));
                        int port = port_hi << 8 | port_lo;
                        this.dtp = new PassiveModeDTP(address, port, localhost, this.connectionTimeout, this.timeout);
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new ProtocolException(e.getMessage() + ": " + message);
                    }
                    catch (NumberFormatException e) {
                        throw new ProtocolException(e.getMessage() + ": " + message);
                    }
                }
                default: {
                    throw new FTPException(response);
                }
            }
        } else {
            int port = this.socket.getLocalPort() + 1;
            int tries = 0;
            while (this.dtp == null) {
                try {
                    this.dtp = new ActiveModeDTP(localhost, port, this.connectionTimeout, this.timeout);
                }
                catch (BindException e) {
                    ++port;
                    if (++tries <= 9) continue;
                    throw e;
                }
            }
            StringBuffer buf = new StringBuffer(PORT);
            buf.append(' ');
            byte[] address = localhost.getAddress();
            int i = 0;
            while (i < address.length) {
                int a = address[i];
                if (a < 0) {
                    a += 256;
                }
                buf.append(a);
                buf.append(',');
                ++i;
            }
            int port_hi = (port & 0xFF00) >> 8;
            int port_lo = port & 0xFF;
            buf.append(port_hi);
            buf.append(',');
            buf.append(port_lo);
            this.send(buf.toString());
            FTPResponse response = this.getResponse();
            switch (response.getCode()) {
                case 200: {
                    break;
                }
                default: {
                    this.dtp.abort();
                    this.dtp = null;
                    throw new FTPException(response);
                }
            }
        }
        this.dtp.setTransferMode(this.transferMode);
    }

    public void setPassive(boolean flag) throws IOException {
        if (this.passive != flag) {
            this.passive = flag;
            this.initialiseDTP();
        }
    }

    public int getRepresentationType() {
        return this.representationType;
    }

    public void setRepresentationType(int type) throws IOException {
        StringBuffer buf = new StringBuffer(TYPE);
        buf.append(' ');
        switch (type) {
            case 1: {
                buf.append('A');
                break;
            }
            case 2: {
                buf.append('E');
                break;
            }
            case 3: {
                buf.append('I');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(type));
            }
        }
        this.send(buf.toString());
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 200: {
                this.representationType = type;
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    public int getFileStructure() {
        return this.fileStructure;
    }

    public void setFileStructure(int structure) throws IOException {
        StringBuffer buf = new StringBuffer(STRU);
        buf.append(' ');
        switch (structure) {
            case 1: {
                buf.append('F');
                break;
            }
            case 2: {
                buf.append('R');
                break;
            }
            case 3: {
                buf.append('P');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(structure));
            }
        }
        this.send(buf.toString());
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 200: {
                this.fileStructure = structure;
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(int mode) throws IOException {
        StringBuffer buf = new StringBuffer(MODE);
        buf.append(' ');
        switch (mode) {
            case 1: {
                buf.append('S');
                break;
            }
            case 2: {
                buf.append('B');
                break;
            }
            case 3: {
                buf.append('C');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(mode));
            }
        }
        this.send(buf.toString());
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 200: {
                this.transferMode = mode;
                if (this.dtp == null) break;
                this.dtp.setTransferMode(mode);
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    public InputStream retrieve(String filename) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String cmd = "RETR " + filename;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getInputStream();
            }
        }
        throw new FTPException(response);
    }

    public OutputStream store(String filename) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String cmd = "STOR " + filename;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getOutputStream();
            }
        }
        throw new FTPException(response);
    }

    public OutputStream append(String filename) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String cmd = "APPE " + filename;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getOutputStream();
            }
        }
        throw new FTPException(response);
    }

    public void allocate(long size) throws IOException {
        String cmd = "ALLO " + size;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 200: 
            case 202: {
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        String cmd = "RNFR " + oldName;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 450: 
            case 550: {
                return false;
            }
            case 350: {
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
        cmd = "RNTO " + newName;
        this.send(cmd);
        response = this.getResponse();
        switch (response.getCode()) {
            case 250: {
                return true;
            }
            case 450: 
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public boolean abort() throws IOException {
        this.send(ABOR);
        FTPResponse response = this.getResponse();
        if (this.dtp != null) {
            this.dtp.abort();
        }
        switch (response.getCode()) {
            case 226: {
                return false;
            }
            case 426: {
                response = this.getResponse();
                if (response.getCode() != 226) break;
                return true;
            }
        }
        throw new FTPException(response);
    }

    public boolean delete(String filename) throws IOException {
        String cmd = "DELE " + filename;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 250: {
                return true;
            }
            case 450: 
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public boolean removeDirectory(String pathname) throws IOException {
        String cmd = "RMD " + pathname;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public boolean makeDirectory(String pathname) throws IOException {
        String cmd = "MKD " + pathname;
        this.send(cmd);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 257: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(response);
    }

    public String getWorkingDirectory() throws IOException {
        this.send(PWD);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 257: {
                String message = response.getMessage();
                if (message.charAt(0) == '\"') {
                    int end = message.indexOf(34, 1);
                    if (end == -1) {
                        throw new ProtocolException(message);
                    }
                    return message.substring(1, end);
                }
                int end = message.indexOf(32);
                if (end == -1) {
                    return message;
                }
                return message.substring(0, end);
            }
        }
        throw new FTPException(response);
    }

    public InputStream list(String pathname) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        if (pathname == null) {
            this.send(LIST);
        } else {
            String cmd = "LIST " + pathname;
            this.send(cmd);
        }
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getInputStream();
            }
        }
        throw new FTPException(response);
    }

    public List nameList(String pathname) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        if (pathname == null) {
            this.send(NLST);
        } else {
            String cmd = "NLST " + pathname;
            this.send(cmd);
        }
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 125: 
            case 150: {
                InputStream in = this.dtp.getInputStream();
                in = new BufferedInputStream(in);
                in = new CRLFInputStream(in);
                LineInputStream li = new LineInputStream(in);
                ArrayList ret = new ArrayList();
                String line = li.readLine();
                while (line != null) {
                    ret.add(line);
                    line = li.readLine();
                }
                li.close();
                return ret;
            }
        }
        throw new FTPException(response);
    }

    public String system() throws IOException {
        this.send(SYST);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 215: {
                String message = response.getMessage();
                int end = message.indexOf(32);
                if (end == -1) {
                    return message;
                }
                return message.substring(0, end);
            }
        }
        throw new FTPException(response);
    }

    public void noop() throws IOException {
        this.send(NOOP);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 200: {
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }

    protected void send(String cmd) throws IOException {
        byte[] data = cmd.getBytes(US_ASCII);
        this.out.write(data);
        this.out.writeln();
        this.out.flush();
    }

    protected FTPResponse getResponse() throws IOException {
        FTPResponse response = this.readResponse();
        if (response.getCode() == 226) {
            if (this.dtp != null) {
                this.dtp.transferComplete();
            }
            response = this.readResponse();
        }
        return response;
    }

    protected FTPResponse readResponse() throws IOException {
        String line = this.in.readLine();
        if (line == null) {
            throw new ProtocolException("EOF");
        }
        if (line.length() < 4) {
            throw new ProtocolException(line);
        }
        int code = FTPConnection.parseCode(line);
        if (code == -1) {
            throw new ProtocolException(line);
        }
        char c = line.charAt(3);
        if (c == ' ') {
            return new FTPResponse(code, line.substring(4));
        }
        if (c == '-') {
            StringBuffer buf = new StringBuffer(line.substring(4));
            buf.append('\n');
            while (true) {
                if ((line = this.in.readLine()) == null) {
                    throw new ProtocolException("EOF");
                }
                if (line.length() >= 4 && line.charAt(3) == ' ' && FTPConnection.parseCode(line) == code) {
                    return new FTPResponse(code, line.substring(4), buf.toString());
                }
                buf.append(line);
                buf.append('\n');
            }
        }
        throw new ProtocolException(line);
    }

    static final int parseCode(String line) {
        char[] c = new char[]{line.charAt(0), line.charAt(1), line.charAt(2)};
        int ret = 0;
        int i = 0;
        while (i < 3) {
            int digit = c[i] - 48;
            if (digit < 0 || digit > 9) {
                return -1;
            }
            switch (i) {
                case 0: {
                    ret += 100 * digit;
                    break;
                }
                case 1: {
                    ret += 10 * digit;
                    break;
                }
                case 2: {
                    ret += digit;
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    private final /* synthetic */ void this() {
        this.representationType = 1;
        this.fileStructure = 1;
        this.transferMode = 1;
        this.passive = false;
    }

    public FTPConnection(String hostname) throws UnknownHostException, IOException {
        this(hostname, -1, 0, 0, false);
    }

    public FTPConnection(String hostname, int port) throws UnknownHostException, IOException {
        this(hostname, port, 0, 0, false);
    }

    public FTPConnection(String hostname, int port, int connectionTimeout, int timeout, boolean debug) throws UnknownHostException, IOException {
        this.this();
        this.connectionTimeout = connectionTimeout;
        this.timeout = timeout;
        this.debug = debug;
        if (port <= 0) {
            port = 21;
        }
        this.socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(hostname, port);
        if (connectionTimeout > 0) {
            this.socket.connect(address, connectionTimeout);
        } else {
            this.socket.connect(address);
        }
        if (timeout > 0) {
            this.socket.setSoTimeout(timeout);
        }
        InputStream in = this.socket.getInputStream();
        in = new BufferedInputStream(in);
        in = new CRLFInputStream(in);
        this.in = new LineInputStream(in);
        OutputStream out = this.socket.getOutputStream();
        out = new BufferedOutputStream(out);
        this.out = new CRLFOutputStream(out);
        FTPResponse response = this.getResponse();
        switch (response.getCode()) {
            case 220: {
                break;
            }
            default: {
                throw new FTPException(response);
            }
        }
    }
}

