/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.processor.PacketProcessor;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.TransportException;
import gnu.classpath.jdwp.transport.TransportFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;

public class Jdwp
extends Thread {
    private static Jdwp _instance = null;
    public static boolean isDebugging = false;
    private static final String _PROPERTY_SUSPEND = "suspend";
    private PacketProcessor _packetProcessor;
    private Thread _ppThread;
    private HashMap _properties;
    private Thread _mainThread;
    private JdwpConnection _connection;
    private boolean _shutdown = false;
    private ThreadGroup _group;

    public static Jdwp getDefault() {
        return _instance;
    }

    public static boolean suspendOnStartup() {
        String suspend;
        Jdwp jdwp = Jdwp.getDefault();
        return jdwp != null && (suspend = (String)jdwp._properties.get(_PROPERTY_SUSPEND)) != null && suspend.equals("y");
    }

    public void configure(String configArgs, Thread mainThread) {
        this._mainThread = mainThread;
        this._processConfigury(configArgs);
    }

    private final void _doInitialization() throws TransportException {
        this._group = new ThreadGroup("JDWP threads");
        ITransport transport = TransportFactory.newInstance(this._properties);
        this._connection = new JdwpConnection(this._group, transport);
        this._connection.initialize();
        this._connection.start();
        this._packetProcessor = new PacketProcessor(this._connection);
        this._ppThread = new Thread(this._group, new Runnable(){

            public final void run() {
                AccessController.doPrivileged(Jdwp.this._packetProcessor);
            }
        });
        this._ppThread.start();
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._packetProcessor.shutdown();
            this._ppThread.interrupt();
            this._connection.shutdown();
            this._shutdown = true;
            isDebugging = false;
            this.interrupt();
        }
    }

    public static void notify(Event event) {
        EventManager em;
        EventRequest request;
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null && (request = (em = EventManager.getDefault()).getEventRequest(event)) != null) {
            Jdwp.sendEvent(request, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendEvent(EventRequest request, Event event) {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp == null) return;
        try {
            JdwpConnection jdwpConnection = jdwp._connection;
            synchronized (jdwpConnection) {
                jdwp._connection.sendEvent(request, event);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                jdwp._enforceSuspendPolicy(request.getSuspendPolicy());
                return;
            }
        }
        catch (IOException ie) {
            System.out.println("Jdwp.notify: caught exception: " + ie);
        }
    }

    private final void _enforceSuspendPolicy(byte suspendPolicy) {
        switch (suspendPolicy) {
            case 0: {
                break;
            }
            case 1: {
                VMVirtualMachine.suspendThread(this);
                break;
            }
            case 2: {
                VMVirtualMachine.suspendAllThreads();
                break;
            }
        }
    }

    public void run() {
        try {
            this._doInitialization();
            this._mainThread.start();
            this._mainThread.join();
        }
        catch (InterruptedException ie) {
        }
        catch (Throwable t) {
            System.out.println("Exception in JDWP back-end: " + t);
            System.exit(1);
        }
    }

    private final void _processConfigury(String configString) {
        this._properties = new HashMap();
        String[] options = configString.split(",");
        int i = 0;
        while (i < options.length) {
            String[] property = options[i].split("=");
            if (property.length == 2) {
                this._properties.put(property[0], property[1]);
            }
            ++i;
        }
    }

    public Jdwp() {
        isDebugging = true;
        _instance = this;
    }
}

