/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.build.CompressionHeaderFactory;
import htsjdk.samtools.cram.build.SliceFactory;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;

public final class ContainerFactory {
    private final CRAMEncodingStrategy encodingStrategy;
    private final CompressionHeaderFactory compressionHeaderFactory;
    private final SliceFactory sliceFactory;
    private final SAMFileHeader samFileHeader;
    private final boolean coordinateSorted;
    private final List<SAMRecord> sliceSAMRecords;
    private long globalRecordCounter = 0L;
    private int currentReferenceContextID = -3;

    public ContainerFactory(SAMFileHeader samFileHeader, CRAMEncodingStrategy encodingStrategy, CRAMReferenceSource referenceSource) {
        this.encodingStrategy = encodingStrategy;
        this.samFileHeader = samFileHeader;
        this.coordinateSorted = samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate;
        this.compressionHeaderFactory = new CompressionHeaderFactory(encodingStrategy);
        this.sliceFactory = new SliceFactory(encodingStrategy, referenceSource, samFileHeader, this.globalRecordCounter);
        this.sliceSAMRecords = new ArrayList<SAMRecord>(this.encodingStrategy.getReadsPerSlice());
    }

    public final Container getNextContainer(SAMRecord samRecord, long containerByteOffset) {
        int nextRecordIndex;
        int updatedReferenceContextID;
        Container container = null;
        if (samRecord.getHeader() == null) {
            samRecord.setHeaderStrict(this.samFileHeader);
        }
        if (this.shouldEmitSlice(updatedReferenceContextID = this.sliceFactory.getUpdatedReferenceContext(this.currentReferenceContextID, nextRecordIndex = samRecord.getReferenceIndex().intValue(), this.sliceSAMRecords.size()))) {
            this.sliceFactory.createNewSliceEntry(this.currentReferenceContextID, this.sliceSAMRecords);
            this.sliceSAMRecords.clear();
            if (this.shouldEmitContainer(this.currentReferenceContextID, nextRecordIndex, this.sliceFactory.getNumberOfSliceEntries())) {
                container = this.makeContainer(containerByteOffset);
            }
            this.currentReferenceContextID = nextRecordIndex;
        } else {
            this.currentReferenceContextID = updatedReferenceContextID;
        }
        this.sliceSAMRecords.add(samRecord);
        return container;
    }

    public Container getFinalContainer(long containerByteOffset) {
        if (this.sliceSAMRecords.size() > 0) {
            this.sliceFactory.createNewSliceEntry(this.currentReferenceContextID, this.sliceSAMRecords);
            this.sliceSAMRecords.clear();
        }
        if (this.sliceFactory.getNumberOfSliceEntries() != 0) {
            Container container = this.makeContainer(containerByteOffset);
            this.currentReferenceContextID = -3;
            return container;
        }
        this.currentReferenceContextID = -3;
        return null;
    }

    public boolean shouldEmitContainer(int currentReferenceContextID, int nextRecordIndex, int numberOfSliceEntries) {
        return numberOfSliceEntries >= this.encodingStrategy.getSlicesPerContainer() || currentReferenceContextID == -2 || currentReferenceContextID != nextRecordIndex;
    }

    private boolean shouldEmitSlice(int updatedReferenceContextID) {
        return updatedReferenceContextID == -3;
    }

    private final Container makeContainer(long containerByteOffset) {
        ValidationUtils.validateArg(this.sliceFactory.getNumberOfSliceEntries() != 0, "must have slice entries to create a container");
        CompressionHeader compressionHeader = this.compressionHeaderFactory.createCompressionHeader(this.sliceFactory.getCRAMRecordsForAllSlices(), this.coordinateSorted);
        Container container = new Container(compressionHeader, this.sliceFactory.createSlices(compressionHeader, containerByteOffset), containerByteOffset, this.globalRecordCounter);
        this.globalRecordCounter += (long)container.getContainerHeader().getNumberOfRecords();
        return container;
    }
}

