/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.ftp.FTPClient;
import htsjdk.samtools.util.ftp.FTPReply;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.ftp.FTPUtils;

public class IGVSeekableFTPStream
extends SeekableStream {
    private static Logger log = Logger.getLogger(IGVSeekableFTPStream.class);
    private long position = 0L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;
    private String source;
    private long length = -1L;

    public IGVSeekableFTPStream(URL url) throws IOException {
        this.source = url.toExternalForm();
        this.userInfo = url.getUserInfo();
        this.host = url.getHost();
        this.path = url.getPath();
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public boolean eof() throws IOException {
        return this.position() >= this.length();
    }

    public String getSource() {
        return this.source;
    }

    public long length() {
        if (this.length < 0L) {
            this.length = this.getLength();
        }
        return this.length;
    }

    private long getLength() {
        try {
            FTPReply reply = this.ftp.size(this.path);
            if (reply.isSuccess()) {
                return Long.parseLong(reply.getReplyString());
            }
        }
        catch (IOException e) {
            log.error((Object)("Error getting length. " + e.getMessage()), (Throwable)e);
        }
        return -1L;
    }

    public long skip(long n) throws IOException {
        long bytesToSkip = n;
        this.position += bytesToSkip;
        this.ftp.setRestPosition(this.position);
        return bytesToSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        try {
            FTPReply reply = this.ftp.pasv();
            assert (reply.isSuccess());
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            reply = this.ftp.retr(this.path);
            InputStream is = this.ftp.getDataStream();
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n2 = -1;
                    return n2;
                }
                n += count;
            }
            this.position += (long)n;
            int n3 = n;
            return n3;
        }
        catch (EOFException e) {
            if (n < 0) {
                int n4 = -1;
                return n4;
            }
            this.position += (long)n;
            int n5 = n;
            return n5;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    public void close() throws IOException {
        log.debug((Object)"close");
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

