/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.IntervalList;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.Log;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.readers.LineIterator;

public class IntervalListCodec
extends AsciiFeatureCodec<Interval> {
    private final Log log = Log.getInstance(IntervalListCodec.class);
    private SAMSequenceDictionary dictionary;
    String lastSeq = null;

    public IntervalListCodec() {
        this((SAMSequenceDictionary)null);
    }

    public IntervalListCodec(SAMSequenceDictionary dict) {
        super(Interval.class);
        this.dictionary = dict;
    }

    private Interval parseIntervalString(String line, SAMSequenceDictionary dict) {
        boolean SEQUENCE_POS = false;
        boolean START_POS = true;
        int END_POS = 2;
        int STRAND_POS = 3;
        int NAME_POS = 4;
        FormatUtil format = new FormatUtil();
        String[] fields = line.split("\t");
        if (fields.length != 5) {
            throw new TribbleException("Invalid interval record contains " + fields.length + " fields: " + line);
        }
        String seq = fields[0];
        if (seq.equals(this.lastSeq)) {
            seq = this.lastSeq;
        }
        this.lastSeq = seq;
        int start = format.parseInt(fields[1]);
        int end = format.parseInt(fields[2]);
        if (start < 1) {
            throw new IllegalArgumentException("Coordinate less than 1: start value of " + start + " is less than 1 and thus illegal");
        }
        if (start > end + 1) {
            throw new IllegalArgumentException("Start value of " + start + " is greater than end + 1 for end of value: " + end + ". I'm afraid I cannot let you do that.");
        }
        Strand strand = Strand.decode(fields[3]);
        if (strand == Strand.NONE) {
            throw new IllegalArgumentException("Invalid strand field: " + fields[3]);
        }
        String name = fields[4];
        Interval interval = new Interval(seq, start, end, strand == Strand.NEGATIVE, name);
        SAMSequenceRecord sequence = dict.getSequence(seq);
        if (sequence == null) {
            this.log.warn("Ignoring interval for unknown reference: " + interval);
            return null;
        }
        int sequenceLength = sequence.getSequenceLength();
        if (sequenceLength > 0 && sequenceLength < end) {
            throw new IllegalArgumentException("interval with end: " + end + " extends beyond end of sequence with length: " + sequenceLength);
        }
        return interval;
    }

    @Override
    public Interval decode(String line) {
        if (line.startsWith("@")) {
            return null;
        }
        if (line.trim().isEmpty()) {
            return null;
        }
        if (this.dictionary == null) {
            throw new TribbleException("IntervalList dictionary cannot be null when decoding a record");
        }
        return this.parseIntervalString(line, this.dictionary);
    }

    @Override
    public Object readActualHeader(final LineIterator lineIterator) {
        SAMTextHeaderCodec headerCodec = new SAMTextHeaderCodec();
        SAMFileHeader header = headerCodec.decode(new LineReader(){
            int lineNo = 0;

            @Override
            public String readLine() {
                ++this.lineNo;
                return (String)lineIterator.next();
            }

            @Override
            public int getLineNumber() {
                return this.lineNo;
            }

            @Override
            public int peek() {
                return lineIterator.hasNext() ? (int)lineIterator.peek().charAt(0) : -1;
            }

            @Override
            public void close() {
            }
        }, "IntervalListCodec");
        this.dictionary = header.getSequenceDictionary();
        return header;
    }

    @Override
    public boolean canDecode(String s) {
        return s.endsWith(".interval_list") || s.endsWith(".interval_list.gz");
    }
}

