/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;
import java.math.BigDecimal;

public class BigDecimalRange
extends AbstractRange<BigDecimal> {
    protected BigDecimal _min;
    protected BigDecimal _max;
    private static final BigDecimal TWO = new BigDecimal(2);

    public BigDecimalRange() {
        this(BigDecimal.ZERO, BigDecimal.ONE);
    }

    public BigDecimalRange(BigDecimal min, BigDecimal max) {
        boolean inOrder = min.compareTo(max) < 0;
        this._min = inOrder ? min : max;
        this._max = inOrder ? max : min;
    }

    public BigDecimalRange(BigDecimalRange BigDecimalRange2) {
        this(BigDecimalRange2.getMin(), BigDecimalRange2.getMax());
    }

    @Override
    public Range<BigDecimal> copy() {
        return new BigDecimalRange(this);
    }

    @Override
    public double minimum() {
        return this._min.doubleValue();
    }

    @Override
    public double maximum() {
        return this._max.doubleValue();
    }

    public BigDecimal getMin() {
        return this._min;
    }

    public void setMin(BigDecimal min) {
        BigDecimal old = this._min;
        if (old != null && old.equals(min)) {
            return;
        }
        assert (min.compareTo(this._max) <= 0);
        this._min = min;
        this.firePropertyChange("min", old, min);
    }

    public BigDecimal getMax() {
        return this._max;
    }

    public void setMax(BigDecimal max) {
        BigDecimal old = this._max;
        if (old != null && old.equals(max)) {
            return;
        }
        assert (max.compareTo(this._min) >= 0);
        this._max = max;
        this.firePropertyChange("max", old, max);
    }

    @Override
    public double size() {
        return this._max.subtract(this._min).doubleValue();
    }

    @Override
    public BigDecimal lower() {
        return this.getMin();
    }

    @Override
    public void adjust(BigDecimal lower, BigDecimal upper) {
        double size = this.size();
        if (lower != null) {
            this.setMin(lower);
        } else if (upper != null) {
            this.setMin(upper.add(new BigDecimal(size)));
        }
        if (upper != null) {
            this.setMax(upper);
        } else if (lower != null) {
            this.setMin(lower.add(new BigDecimal(size)));
        }
    }

    @Override
    public BigDecimal upper() {
        return this.getMax();
    }

    @Override
    public boolean contains(BigDecimal x) {
        return x != null && x.compareTo(this._min) >= 0 && x.compareTo(this._max) <= 0;
    }

    public BigDecimalRange stretch(double stretchFactor) {
        return this.stretch(stretchFactor, stretchFactor);
    }

    public BigDecimalRange stretch(double stretchFactorForLower, double stretchFactorForUpper) {
        BigDecimal mid = this._max.add(this._min).divide(TWO);
        BigDecimal halfSize = this._max.subtract(this._min).divide(TWO);
        return new BigDecimalRange(mid.subtract(halfSize.multiply(new BigDecimal(stretchFactorForLower))), mid.add(halfSize.multiply(new BigDecimal(stretchFactorForUpper))));
    }

    @Override
    public Range<BigDecimal> createIntermediate(Range<BigDecimal> target, double position) {
        throw new UnsupportedOperationException("createIntermediate method is not currently support in BigDecimalRange");
    }

    public boolean equals(Object other) {
        if (other instanceof BigDecimalRange) {
            BigDecimalRange otherRange = (BigDecimalRange)other;
            return this._min.equals(otherRange._min) && this._max.equals(otherRange._max);
        }
        return false;
    }

    public int hashCode() {
        return this._max.multiply(new BigDecimal(29)).add(this._min).intValue();
    }

    public String toString() {
        return String.format("#<BigDecimalRange min=%f max=%f>", this._min, this._max);
    }
}

