/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.reference.FastaReferenceWriter;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import htsjdk.utils.ValidationUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FastaReferenceWriterBuilder {
    private Path fastaFile;
    private boolean gzippedFastaFile;
    private boolean makeGziOutput = true;
    private boolean makeFaiOutput = true;
    private boolean makeDictOutput = true;
    private boolean emitMd5 = true;
    private int basesPerLine = 60;
    private Path gziIndexFile;
    private Path faiIndexFile;
    private Path dictFile;
    private OutputStream fastaOutput;
    private OutputStream faiIndexOutput;
    private OutputStream gziIndexOutput;
    private OutputStream dictOutput;

    private static Path defaultGziFile(boolean makeGziFile, Path fastaFile) {
        return makeGziFile ? GZIIndex.resolveIndexNameForBgzipFile(fastaFile) : null;
    }

    private static Path defaultFaiFile(boolean makeFaiFile, Path fastaFile) {
        return makeFaiFile ? ReferenceSequenceFileFactory.getFastaIndexFileName(fastaFile) : null;
    }

    private static Path defaultDictFile(boolean makeDictFile, Path fastaFile) {
        return makeDictFile ? ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(fastaFile) : null;
    }

    protected static int checkBasesPerLine(int value) {
        ValidationUtils.validateArg(value > 0, "bases per line must be 1 or greater");
        return value;
    }

    public FastaReferenceWriterBuilder setFastaFile(Path fastaFile) {
        this.fastaFile = fastaFile;
        this.fastaOutput = null;
        if (IOUtil.hasGzipFileExtension(fastaFile)) {
            this.gzippedFastaFile = true;
            this.makeGziOutput = true;
        }
        return this;
    }

    public FastaReferenceWriterBuilder setMakeFaiOutput(boolean makeFaiOutput) {
        this.makeFaiOutput = makeFaiOutput;
        return this;
    }

    public FastaReferenceWriterBuilder setMakeDictOutput(boolean makeDictOutput) {
        this.makeDictOutput = makeDictOutput;
        return this;
    }

    public FastaReferenceWriterBuilder setMakeGziOutput(boolean makeGziOutput) {
        this.makeGziOutput = makeGziOutput;
        return this;
    }

    public FastaReferenceWriterBuilder setBasesPerLine(int basesPerLine) {
        this.basesPerLine = basesPerLine;
        return this;
    }

    public FastaReferenceWriterBuilder setIndexFile(Path faiIndexFile) {
        this.faiIndexFile = faiIndexFile;
        this.faiIndexOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setGziIndexFile(Path gziIndexFile) {
        this.gziIndexFile = gziIndexFile;
        this.gziIndexOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setDictFile(Path dictFile) {
        this.dictFile = dictFile;
        this.dictOutput = null;
        return this;
    }

    public FastaReferenceWriterBuilder setFastaOutput(OutputStream fastaOutput) {
        this.fastaOutput = fastaOutput;
        this.fastaFile = null;
        this.gzippedFastaFile = false;
        this.makeGziOutput = false;
        return this;
    }

    public FastaReferenceWriterBuilder setIndexOutput(OutputStream faiIndexOutput) {
        this.faiIndexOutput = faiIndexOutput;
        this.faiIndexFile = null;
        return this;
    }

    public FastaReferenceWriterBuilder setGziIndexOutput(OutputStream gziIndexOutput) {
        this.gziIndexOutput = gziIndexOutput;
        this.gziIndexFile = null;
        return this;
    }

    public FastaReferenceWriterBuilder setDictOutput(OutputStream dictOutput) {
        this.dictOutput = dictOutput;
        this.dictFile = null;
        return this;
    }

    public FastaReferenceWriter build() throws IOException {
        if (this.fastaFile == null && this.fastaOutput == null) {
            throw new IllegalArgumentException("Both fastaFile and fastaOutput were null. Please set one of them to be non-null.");
        }
        if (this.fastaFile != null) {
            if (this.faiIndexFile == null && this.faiIndexOutput == null) {
                this.faiIndexFile = FastaReferenceWriterBuilder.defaultFaiFile(this.makeFaiOutput, this.fastaFile);
            } else if (this.faiIndexFile != null && this.faiIndexOutput != null) {
                throw new IllegalArgumentException("Both faiIndexFile and faiIndexOutput were non-null. Please set one of them to be null.");
            }
            if (this.dictFile == null && this.dictOutput == null) {
                this.dictFile = FastaReferenceWriterBuilder.defaultDictFile(this.makeDictOutput, this.fastaFile);
            } else if (this.dictFile != null && this.dictOutput != null) {
                throw new IllegalArgumentException("Both dictFile and dictOutput were non-null. Please set one of them to be null.");
            }
            if (this.gzippedFastaFile && this.gziIndexFile == null && this.gziIndexOutput == null) {
                this.gziIndexFile = FastaReferenceWriterBuilder.defaultGziFile(this.makeGziOutput, this.fastaFile);
            } else if (!(this.gzippedFastaFile || this.gziIndexFile == null && this.gziIndexOutput == null)) {
                throw new IllegalArgumentException("Requested a gzi index but the output format fasta file was not a block compressed gzip file");
            }
            if (this.gziIndexFile != null && this.gziIndexOutput != null) {
                throw new IllegalArgumentException("Both dictFile and dictOutput were non-null. Please set one of them to be null.");
            }
            if (!(this.faiIndexFile == null && this.faiIndexOutput == null || !this.gzippedFastaFile || this.gziIndexFile != null && this.gziIndexOutput == null)) {
                throw new IllegalArgumentException("Requested a fai index file for a block compressed output file. This index is unusable without a gzi index file as well");
            }
        }
        FastaReferenceWriterBuilder.checkBasesPerLine(this.basesPerLine);
        if (this.gziIndexFile != null) {
            this.gziIndexOutput = new BufferedOutputStream(Files.newOutputStream(this.gziIndexFile, new OpenOption[0]));
        }
        if (this.fastaFile != null) {
            if (this.gzippedFastaFile) {
                this.fastaOutput = new BlockCompressedOutputStream(Files.newOutputStream(this.fastaFile, new OpenOption[0]), this.fastaFile);
                ((BlockCompressedOutputStream)this.fastaOutput).addIndexer(this.gziIndexOutput);
            } else {
                this.fastaOutput = new BufferedOutputStream(Files.newOutputStream(this.fastaFile, new OpenOption[0]));
            }
        }
        if (this.faiIndexFile != null) {
            this.faiIndexOutput = new BufferedOutputStream(Files.newOutputStream(this.faiIndexFile, new OpenOption[0]));
        }
        if (this.dictFile != null) {
            this.dictOutput = new BufferedOutputStream(Files.newOutputStream(this.dictFile, new OpenOption[0]));
        }
        return new FastaReferenceWriter(this.basesPerLine, this.emitMd5, this.fastaOutput, this.faiIndexOutput, this.dictOutput);
    }

    public boolean getEmitMd5() {
        return this.emitMd5;
    }

    public FastaReferenceWriterBuilder setEmitMd5(boolean emitMd5) {
        this.emitMd5 = emitMd5;
        return this;
    }
}

