/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.fastutil.objects.Object2LongFunction;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.StringMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiterallySignedStringMap
extends AbstractObject2LongFunction<CharSequence>
implements StringMap<MutableString>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected final Object2LongFunction<? extends CharSequence> function;
    protected final ObjectList<? extends MutableString> list;
    protected final int size;

    public LiterallySignedStringMap(Object2LongFunction<? extends CharSequence> function, ObjectList<? extends MutableString> list) {
        this.function = function;
        this.list = list;
        this.size = list.size();
        for (int i = 0; i < this.size; ++i) {
            if (function.getLong(list.get(i)) == (long)i) continue;
            throw new IllegalArgumentException("Function and list do not agree");
        }
        this.defRetValue = -1L;
    }

    public long getLong(Object o) {
        CharSequence s = (CharSequence)o;
        long index = this.function.getLong((Object)s);
        return index >= 0L && index < (long)this.size && ((MutableString)this.list.get((int)index)).equals(s) ? index : this.defRetValue;
    }

    public Long get(Object o) {
        CharSequence s = (CharSequence)o;
        long index = this.function.getLong((Object)s);
        return index >= 0L && index < (long)this.size && ((MutableString)this.list.get((int)index)).equals(s) ? Long.valueOf(index) : null;
    }

    public int size() {
        return this.function.size();
    }

    public boolean containsKey(Object o) {
        return this.getLong(o) != -1L;
    }

    @Override
    public ObjectList<? extends MutableString> list() {
        return this.list;
    }

    public static void main(String[] arg) throws IOException, JSAPException, ClassNotFoundException, SecurityException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(LiterallySignedStringMap.class.getName(), "Builds a shift-add-xor signed string map by reading a newline-separated list of strings and a function built on the same list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new Switch("text", 't', "text", "The string list actually a text file, with one string per line."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the function to be signed."), new UnflaggedOption("list", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the serialised list of strings, or of a text file containing a list of strings, if -t is specified."), new UnflaggedOption("map", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename of the resulting map.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String listName = jsapResult.getString("list");
        String mapName = jsapResult.getString("map");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean text = jsapResult.getBoolean("text");
        ObjectList<MutableString> list = text ? new FileLinesCollection(listName, encoding.toString(), zipped).allLines() : (ObjectList<MutableString>)BinIO.loadObject((CharSequence)listName);
        Logger logger = LoggerFactory.getLogger(LiterallySignedStringMap.class);
        logger.info("Signing...");
        BinIO.storeObject((Object)new LiterallySignedStringMap((Object2LongFunction<? extends CharSequence>)((Object2LongFunction)BinIO.loadObject((CharSequence)functionName)), list), (CharSequence)mapName);
        logger.info("Completed.");
    }
}

