/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.StringParser;

public final class QualifiedSwitch
extends FlaggedOption {
    public QualifiedSwitch(String id, StringParser stringParser, String defaultValue, boolean required, char shortFlag, String longFlag, String help) {
        super(id, stringParser, defaultValue, required, shortFlag, longFlag, help);
    }

    public QualifiedSwitch(String id, StringParser stringParser, String defaultValue, boolean required, char shortFlag, String longFlag) {
        super(id, stringParser, defaultValue, required, shortFlag, longFlag);
    }

    public QualifiedSwitch(String id) {
        super(id);
    }

    @Override
    public String getSyntax() {
        StringBuffer result = new StringBuffer();
        if (!this.required()) {
            result.append("[");
        }
        if (this.getLongFlag() != JSAP.NO_LONGFLAG || this.getShortFlag() != '\u0000') {
            if (this.getLongFlag() == JSAP.NO_LONGFLAG) {
                result.append("-" + this.getShortFlag());
            } else if (this.getShortFlag() == '\u0000') {
                result.append("--" + this.getLongFlag());
            } else {
                result.append("(-" + this.getShortFlag() + "|--" + this.getLongFlag() + ")");
            }
        }
        result.append("[:");
        String un = this.getUsageName();
        char sep = this.getListSeparator();
        if (this.isList()) {
            result.append(un + "1" + sep + un + "2" + sep + "..." + sep + un + "N ");
        } else {
            result.append("<" + un + ">");
        }
        if (!this.required()) {
            result.append("]");
        }
        result.append("]");
        return result.toString();
    }
}

