/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011\u0011%\u00112tiJ\f7\r\u001e'pO\u000ecW-\u00198fe&sG/Z4sCRLwN\u001c+fgRD\u0001\"\u0004\u0001\u0003\u0002\u0003\u0006IAD\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\"a\u0004\r\u000f\u0005A1\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\u0007\u0003\u0019a$o\\8u})\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\u00051\u0001K]3eK\u001aL!!\u0007\u000e\u0003\rM#(/\u001b8h\u0015\t9B\u0003C\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0003=}\u0001\"!\u0003\u0001\t\u000b5Y\u0002\u0019\u0001\b\t\u000f\u0005\u0002!\u0019!C\u0001E\u0005)1m\u001c3fGV\t1\u0005\u0005\u0002%]5\tQE\u0003\u0002'O\u00051!/Z2pe\u0012T!\u0001K\u0015\u0002\r\r|W.\\8o\u0015\t)!F\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018&\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007BB\u0019\u0001A\u0003%1%\u0001\u0004d_\u0012,7\r\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003\u0011!\u0018.\\3\u0016\u0003U\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005i:$\u0001C'pG.$\u0016.\\3\t\rq\u0002\u0001\u0015!\u00036\u0003\u0015!\u0018.\\3!\u0011\u001dq\u0004\u00011A\u0005\u0002}\nqaY8v]R,'/F\u0001A!\t\t%)D\u0001\u0015\u0013\t\u0019ECA\u0002J]RDq!\u0012\u0001A\u0002\u0013\u0005a)A\u0006d_VtG/\u001a:`I\u0015\fHCA$K!\t\t\u0005*\u0003\u0002J)\t!QK\\5u\u0011\u001dYE)!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0011\u0019i\u0005\u0001)Q\u0005\u0001\u0006A1m\\;oi\u0016\u0014\b\u0005C\u0004P\u0001\t\u0007I\u0011\u0001)\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012!\u0015\t\u0004\u0003J#\u0016BA*\u0015\u0005\u0015\t%O]1z!\t)f+D\u0001(\u0013\t9vE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\re\u0003\u0001\u0015!\u0003R\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0003\\\u0001\u0011\u0005A,A\u0006dY\u0016\fg.\u001a:UKN$H#A$)\u0005is\u0006CA0c\u001b\u0005\u0001'BA1-\u0003\u0015QWO\\5u\u0013\t\u0019\u0007M\u0001\u0003UKN$\b\"B3\u0001\t\u0003a\u0016a\n;fgR\u001cE.Z1og\u000e{WNY5oK\u0012\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\rV8qS\u000eD#\u0001\u001a0\t\u000b!\u0004A\u0011B5\u00027\r\u0014X-\u0019;f\u0019\u0006\u0014x-Z*j]\u001edW-T3tg\u0006<WmU3u)\rQ\u0007O\u001d\t\u0005\u0003.tQ.\u0003\u0002m)\t1A+\u001e9mKJ\u0002\"\u0001\n8\n\u0005=,#!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0003rO\u0002\u0007\u0001)A\u0002lKfDQa]4A\u0002Q\fA#\\3tg\u0006<WMR8s[\u0006$h+\u001a:tS>t\u0007CA!v\u0013\t1HC\u0001\u0003CsR,\u0007\"\u0002=\u0001\t\u0003a\u0016A\b;fgR\u001cE.Z1oKJ<\u0016\u000e\u001e5NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,1Q\t9h\fC\u0003|\u0001\u0011\u0005A,\u0001\u0018uKN$8\t\\3b]&twMT3ti\u0016$W*Z:tC\u001e,7oV5uQ6+H\u000e^5qY\u00164VM]:j_:\u001c\bF\u0001>_\u0011\u0015q\b\u0001\"\u0001]\u0003]\u0019G.Z1oKJ\u001cuN\u001c4jOV\u0003H-\u0019;f)\u0016\u001cH\u000f\u000b\u0002~=\"9\u00111\u0001\u0001\u0005\n\u0005\u0015\u0011\u0001E2iK\u000e\\G*Y:u\u00072,\u0017M\\3e)\u001d9\u0015qAA\u0006\u0003\u001fAq!!\u0003\u0002\u0002\u0001\u0007a\"A\u0003u_BL7\rC\u0004\u0002\u000e\u0005\u0005\u0001\u0019\u0001!\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\t\u0003#\t\t\u00011\u0001\u0002\u0014\u0005Qa-\u001b:ti\u0012K'\u000f^=\u0011\u0007\u0005\u000b)\"C\u0002\u0002\u0018Q\u0011A\u0001T8oO\"9\u00111\u0004\u0001\u0005\n\u0005u\u0011AG2iK\u000e\\Gj\\4BMR,'/\u00119qK:$\u0017N\\4EkB\u001cHcB$\u0002 \u0005\u001d\u00121\u0006\u0005\b\u0007\u0005e\u0001\u0019AA\u0011!\rI\u00111E\u0005\u0004\u0003K\u0011!a\u0001'pO\"A\u0011\u0011FA\r\u0001\u0004\t\u0019\"A\u0005ti\u0006\u0014HoU5{K\"A\u0011QFA\r\u0001\u0004\ty#A\u0004baB,g\u000eZ:\u0011\r\u0005E\u00121HA!\u001d\u0011\t\u0019$a\u000e\u000f\u0007E\t)$C\u0001\u0016\u0013\r\tI\u0004F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0007M+\u0017OC\u0002\u0002:Q\u0001r!QA\"\u0001:\t\u0019\"C\u0002\u0002FQ\u0011a\u0001V;qY\u0016\u001c\u0004bBA%\u0001\u0011%\u00111J\u0001\u0006i>l\u0015\r\u001d\u000b\u0005\u0003\u001b\nY\u0006E\u0004\u0002P\u0005U\u0003)!\u0017\u000e\u0005\u0005E#bAA*)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0013\u0011\u000b\u0002\u0004\u001b\u0006\u0004\b#B!l\u001d\u0005M\u0001\u0002CA/\u0003\u000f\u0002\r!a\u0018\u0002\u00115,7o]1hKN\u0004b!a\u0014\u0002b\u0005\u0005\u0013\u0002BA2\u0003#\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0003O\u0002A\u0011BA5\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\t\u0005}\u00131\u000e\u0005\b\u0007\u0005\u0015\u0004\u0019AA\u0011\u0011\u001d\ty\u0007\u0001C\u0005\u0003c\n\u0011b\u001e:ji\u0016$U\u000f]:\u0015\u001d\u0005=\u00121OA<\u0003w\ni(a \u0002\u0004\"9\u0011QOA7\u0001\u0004\u0001\u0015a\u00028v[.+\u0017p\u001d\u0005\b\u0003s\ni\u00071\u0001A\u0003\u001dqW/\u001c#vaNDqaAA7\u0001\u0004\t\t\u0003\u0003\u0004\"\u0003[\u0002\ra\t\u0005\n\u0003\u0003\u000bi\u0007%AA\u0002\u0001\u000b\u0001b\u001d;beR\\U-\u001f\u0005\n\u0003\u000b\u000bi\u0007%AA\u0002Q\f!\"\\1hS\u000e4\u0016\r\\;f\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017\u000b\u0011d\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fiRq\u0011qFAG\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0005bBA;\u0003\u000f\u0003\r\u0001\u0011\u0005\b\u0003s\n9\t1\u0001A\u0011\u001d\u0019\u0011q\u0011a\u0001\u0003CAa!IAD\u0001\u0004\u0019\u0003\"CAA\u0003\u000f\u0003\n\u00111\u0001A\u0011\u001d\t))a\"A\u0002QD\u0011\"a'\u0001#\u0003%I!!(\u0002']\u0014\u0018\u000e^3EkB\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005}%f\u0001!\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.R\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00026\u0002\t\n\u0011\"\u0003\u00028\u0006\u0019rO]5uK\u0012+\bo\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011\u0011\u0018\u0016\u0004i\u0006\u0005\u0006\"CA_\u0001E\u0005I\u0011BAO\u0003\r:(/\u001b;f\tV\u00048oU5oO2,W*Z:tC\u001e,7+\u001a;%I\u00164\u0017-\u001e7uIUBs\u0001AAa\u0003\u001b\fy\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9\rY\u0001\u0007eVtg.\u001a:\n\t\u0005-\u0017Q\u0019\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\t\t\t\u000e\u0005\u0003\u0002T\u0006eWBAAk\u0015\r\t9\u000eY\u0001\beVtg.\u001a:t\u0013\u0011\tY.!6\u0003\u001bA\u000b'/Y7fi\u0016\u0014\u0018N_3e\u000f\u001d\tyN\u0001E\u0001\u0003C\f\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3tiB\u0019\u0011\"a9\u0007\r\u0005\u0011\u0001\u0012AAs'\u0011\t\u0019/a:\u0011\u0007\u0005\u000bI/C\u0002\u0002lR\u0011a!\u00118z%\u00164\u0007b\u0002\u000f\u0002d\u0012\u0005\u0011q\u001e\u000b\u0003\u0003CD\u0001\"a=\u0002d\u0012\u0005\u0011Q_\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cXCAA|!\u0019\tIPa\u0001\u0003\b5\u0011\u00111 \u0006\u0005\u0003{\fy0\u0001\u0003vi&d'B\u0001B\u0001\u0003\u0011Q\u0017M^1\n\t\t\u0015\u00111 \u0002\u000b\u0007>dG.Z2uS>t\u0007cA!S\u001d!\"\u0011\u0011\u001fB\u0006!\u0011\u0011iAa\b\u000f\t\t=!1\u0004\b\u0005\u0005#\u0011IB\u0004\u0003\u0003\u0014\t]abA\t\u0003\u0016%\tQ&\u0003\u0002bY%\u0019\u0011q\u001b1\n\t\tu\u0011Q[\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\n\t\t\u0005\"1\u0005\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\u0002B\u000f\u0003+\u0004")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec;
    private final MockTime time;
    private int counter;
    private final TopicPartition[] topicPartitions;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerIntegrationTest$.MODULE$.parameters();
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void cleanerTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$12 = maxMessageSize;
        float x$13 = this.makeCleaner$default$2();
        int x$14 = this.makeCleaner$default$3();
        long x$15 = this.makeCleaner$default$4();
        long x$16 = this.makeCleaner$default$6();
        int x$17 = this.makeCleaner$default$7();
        int x$18 = this.makeCleaner$default$8();
        Option<Object> x$19 = this.makeCleaner$default$9();
        Properties x$20 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$11, x$13, x$14, x$15, x$12, x$16, x$17, x$18, x$19, x$20));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3());
        long largeMessageOffset = appendInfo.firstOffset();
        int x$21 = largeMessageKey + 1;
        int x$22 = 100;
        int x$23 = 3;
        Log x$24 = log;
        CompressionType x$25 = this.codec();
        byte x$26 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$22, x$23, x$24, x$25, x$21, x$26);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        Assert.assertFalse((boolean)checkpoints.contains((Object)this.topicPartitions()[0]));
    }

    @Test
    public void testCleansCombinedCompactAndDeleteTopic() {
        Log log;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log2 = log = (Log)tuple2._1();
        Log log3 = log2;
        log3.logSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> log3.numberOfSegments() == 1, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There should only be 1 segment remaining", 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1L, (long)log3.numberOfSegments());
        this.cleaner().shutdown();
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps);
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Log log22 = (Log)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)log22, (Object)messages);
        Tuple2 tuple24 = tuple23;
        Log log23 = (Log)tuple24._1();
        Seq messages2 = (Seq)tuple24._2();
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log23);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read));
    }

    private Tuple2<String, MemoryRecords> createLargeSingleMessageSet(int key, byte messageFormatVersion) {
        String value = LogCleanerIntegrationTest.messageValue$1(128);
        byte[] x$37 = value.getBytes();
        CompressionType x$38 = this.codec();
        byte[] x$39 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$40 = messageFormatVersion;
        long x$41 = TestUtils$.MODULE$.singletonRecords$default$4();
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords(x$37, x$39, x$38, x$41, x$40);
        return new Tuple2((Object)value, (Object)messageSet);
    }

    @Test
    public void testCleanerWithMessageFormatV0() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        CompressionType compressionType = this.codec();
        int n = CompressionType.NONE.equals(compressionType) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
        int maxMessageSize = n;
        WrappedArray x$42 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$43 = maxMessageSize;
        float x$44 = this.makeCleaner$default$2();
        int x$45 = this.makeCleaner$default$3();
        long x$46 = this.makeCleaner$default$4();
        long x$47 = this.makeCleaner$default$6();
        int x$48 = this.makeCleaner$default$7();
        int x$49 = this.makeCleaner$default$8();
        Option<Object> x$50 = this.makeCleaner$default$9();
        Properties x$51 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$42, x$44, x$45, x$46, x$43, x$47, x$48, x$49, x$50, x$51));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$52 = maxMessageSize;
        Properties x$53 = this.logConfigProperties$default$1();
        float x$54 = this.logConfigProperties$default$3();
        long x$55 = this.logConfigProperties$default$4();
        int x$56 = this.logConfigProperties$default$5();
        int x$57 = this.logConfigProperties$default$6();
        Properties props = this.logConfigProperties(x$53, x$52, x$54, x$55, x$56, x$57);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$58 = 100;
        int x$59 = 3;
        Log x$60 = log;
        CompressionType x$61 = this.codec();
        byte x$62 = 0;
        int x$63 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$58, x$59, x$60, x$61, x$63, x$62);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$64 = 40;
        int x$65 = 3;
        Log x$66 = log;
        CompressionType x$67 = this.codec();
        byte x$68 = 0;
        int x$69 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$64, x$65, x$66, x$67, x$69, x$68);
        LogAppendInfo appendInfo = log.appendAsLeader(largeMessageSet2, 0, log.appendAsLeader$default$3());
        long largeMessageOffset = appendInfo.firstOffset();
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$70 = 30;
        int x$71 = 40;
        int x$72 = 3;
        Log x$73 = log;
        CompressionType x$74 = this.codec();
        byte x$75 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$71, x$72, x$73, x$74, x$70, x$75);
        int x$76 = 15;
        int x$77 = 5;
        int x$78 = 3;
        Log x$79 = log;
        CompressionType x$80 = this.codec();
        byte x$81 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$77, x$78, x$79, x$80, x$76, x$81);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset))})), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @Test
    public void testCleaningNestedMessagesWithMultipleVersions() {
        int maxMessageSize = 192;
        WrappedArray x$82 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$83 = maxMessageSize;
        float x$84 = this.makeCleaner$default$2();
        int x$85 = this.makeCleaner$default$3();
        long x$86 = this.makeCleaner$default$4();
        long x$87 = this.makeCleaner$default$6();
        int x$88 = this.makeCleaner$default$7();
        int x$89 = this.makeCleaner$default$8();
        Option<Object> x$90 = this.makeCleaner$default$9();
        Properties x$91 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$82, x$84, x$85, x$86, x$83, x$87, x$88, x$89, x$90, x$91));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$92 = maxMessageSize;
        Properties x$93 = this.logConfigProperties$default$1();
        float x$94 = this.logConfigProperties$default$3();
        long x$95 = this.logConfigProperties$default$4();
        int x$96 = this.logConfigProperties$default$5();
        int x$97 = this.logConfigProperties$default$6();
        Properties props = this.logConfigProperties(x$93, x$92, x$94, x$95, x$96, x$97);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$98 = 2;
        int x$99 = 3;
        Log x$100 = log;
        CompressionType x$101 = this.codec();
        byte x$102 = 0;
        int x$103 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$98, x$99, x$100, x$101, x$103, x$102);
        int x$104 = 2;
        int x$105 = 3;
        int x$106 = 2;
        Log x$107 = log;
        CompressionType x$108 = this.codec();
        byte x$109 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$104, x$106, x$107, x$108, x$105, x$109), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.config_$eq(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$110 = 4;
        int x$111 = 2;
        int x$112 = 2;
        Log x$113 = log;
        CompressionType x$114 = this.codec();
        byte x$115 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$111, x$112, x$113, x$114, x$110, x$115);
        int x$116 = 4;
        int x$117 = 2;
        int x$118 = 2;
        Log x$119 = log;
        CompressionType x$120 = this.codec();
        byte x$121 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$117, x$118, x$119, x$120, x$116, x$121), Seq$.MODULE$.canBuildFrom());
        int x$122 = 6;
        int x$123 = 2;
        int x$124 = 2;
        Log x$125 = log;
        CompressionType x$126 = this.codec();
        byte x$127 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$123, x$124, x$125, x$126, x$122, x$127), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assert.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    @Test
    public void cleanerConfigUpdateTest() {
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)largeMessageValue, (Object)largeMessageSet);
        Tuple2 tuple23 = tuple22;
        String largeMessageValue2 = (String)tuple23._1();
        MemoryRecords largeMessageSet2 = (MemoryRecords)tuple23._2();
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$128 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$129 = 1L;
        int x$130 = maxMessageSize;
        Some x$131 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$132 = this.makeCleaner$default$2();
        int x$133 = this.makeCleaner$default$3();
        long x$134 = this.makeCleaner$default$6();
        int x$135 = this.makeCleaner$default$7();
        int x$136 = this.makeCleaner$default$8();
        Properties x$137 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$128, x$132, x$133, x$129, x$130, x$134, x$135, x$136, (Option<Object>)x$131, x$137));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assert.assertEquals((long)1L, (long)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assert.assertTrue((String)"Should not have cleaned", (boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty());
        KafkaConfig oldConfig = LogCleanerIntegrationTest.kafkaConfigWithCleanerConfig$1(this.cleaner().currentConfig());
        KafkaConfig newConfig = LogCleanerIntegrationTest.kafkaConfigWithCleanerConfig$1(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9()));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assert.assertEquals((long)2L, (long)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$138 = topicPartition;
        long x$139 = firstDirty;
        long x$140 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$138, x$139, x$140);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstDirty), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstDirty ? 1 : 0) != 0);
    }

    private void checkLogAfterAppendingDups(Log log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change", this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read));
        Assert.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int key = BoxesRunTime.unboxToInt((Object)tuple3._1());
            String value = (String)tuple3._2();
            long offset = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeDups$1(this, numKeys, log, codec, startKey, magicValue, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDups$default$5() {
        return 0;
    }

    private byte writeDups$default$6() {
        return 2;
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, Log log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, numKeys, startKey, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int key = tuple2._1$mcI$sp();
            String payload = (String)tuple2._2();
            SimpleRecord simpleRecord = new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), payload.toString().getBytes());
            return simpleRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(appendInfo.firstOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 kv = (Tuple2)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            return tuple3;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1) {
        WrappedArray x$27 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        Properties x$28 = logProps$1;
        long x$29 = 100L;
        float x$30 = this.makeCleaner$default$2();
        int x$31 = this.makeCleaner$default$3();
        int x$32 = this.makeCleaner$default$5();
        long x$33 = this.makeCleaner$default$6();
        int x$34 = this.makeCleaner$default$7();
        int x$35 = this.makeCleaner$default$8();
        Option<Object> x$36 = this.makeCleaner$default$9();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$27, x$30, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$28));
        Log log = (Log)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.onHighWatermarkIncremented(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: startSize=", " compactedSize=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startSize), BoxesRunTime.boxToInteger((int)compactedSize)})), (startSize > (long)compactedSize ? 1 : 0) != 0);
        return new Tuple2((Object)log, messages);
    }

    private static final String messageValue$1(int length) {
        Random random = new Random(0);
        return new String((char[])random.alphanumeric().take(length).toArray(ClassTag$.MODULE$.Char()));
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.numThreads())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.dedupeBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.dedupeBufferLoadFactor())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.ioBufferSize())).toString());
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)cleanerConfig.maxMessageSize())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), ((Object)BoxesRunTime.boxToLong((long)cleanerConfig.backOffMs())).toString());
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), ((Object)BoxesRunTime.boxToDouble((double)cleanerConfig.maxIoBytesPerSecond())).toString());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ Tuple3 $anonfun$writeDups$2(LogCleanerIntegrationTest $this, Log log$1, CompressionType codec$1, byte magicValue$1, int key) {
        String value = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString();
        byte[] x$141 = value.toString().getBytes();
        CompressionType x$142 = codec$1;
        byte[] x$143 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte x$144 = magicValue$1;
        long x$145 = TestUtils$.MODULE$.singletonRecords$default$4();
        LogAppendInfo appendInfo = log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$141, x$143, x$142, x$145, x$144), 0, log$1.appendAsLeader$default$3());
        $this.counter_$eq($this.counter() + 1);
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)appendInfo.firstOffset()));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(LogCleanerIntegrationTest $this, int numKeys$1, Log log$1, CompressionType codec$1, int startKey$1, byte magicValue$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeDups$2($this, log$1, codec$1, magicValue$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerIntegrationTest $this, int key) {
        String payload = ((Object)BoxesRunTime.boxToInteger((int)$this.counter())).toString();
        $this.counter_$eq($this.counter() + 1);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerIntegrationTest $this, int numKeys$2, int startKey$2, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$2), startKey$2 + numKeys$2).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public LogCleanerIntegrationTest(String compressionCodec) {
        this.codec = CompressionType.forName((String)compressionCodec);
        this.time = new MockTime();
        this.counter = 0;
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

