/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;

public class MaxLineNumberVisitor {
    public static int visit(Instruction instruction) {
        int maxLineNumber = instruction.lineNumber;
        switch (instruction.opcode) {
            case 271: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ArrayLoadInstruction)instruction).indexref);
                break;
            }
            case 83: 
            case 272: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ArrayStoreInstruction)instruction).valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                maxLineNumber = MaxLineNumberVisitor.visit(ai.msg == null ? ai.test : ai.msg);
                break;
            }
            case 191: {
                maxLineNumber = MaxLineNumberVisitor.visit(((AThrow)instruction).value);
                break;
            }
            case 266: {
                maxLineNumber = MaxLineNumberVisitor.visit(((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 265: 
            case 267: {
                maxLineNumber = MaxLineNumberVisitor.visit(((BinaryOperatorInstruction)instruction).value2);
                break;
            }
            case 192: {
                maxLineNumber = MaxLineNumberVisitor.visit(((CheckCast)instruction).objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                maxLineNumber = MaxLineNumberVisitor.visit(((StoreInstruction)instruction).valueref);
                break;
            }
            case 264: {
                maxLineNumber = MaxLineNumberVisitor.visit(((DupStore)instruction).objectref);
                break;
            }
            case 275: 
            case 276: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ConvertInstruction)instruction).value);
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.instruction == null) break;
                maxLineNumber = MaxLineNumberVisitor.visit(fd.instruction);
                break;
            }
            case 261: {
                maxLineNumber = MaxLineNumberVisitor.visit(((IfCmp)instruction).value2);
                break;
            }
            case 260: 
            case 262: {
                maxLineNumber = MaxLineNumberVisitor.visit(((IfInstruction)instruction).value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                maxLineNumber = MaxLineNumberVisitor.visit(branchList.get(branchList.size() - 1));
                break;
            }
            case 193: {
                maxLineNumber = MaxLineNumberVisitor.visit(((InstanceOf)instruction).objectref);
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int length = list.size();
                if (length == 0) {
                    maxLineNumber = instruction.lineNumber;
                    break;
                }
                maxLineNumber = MaxLineNumberVisitor.visit(list.get(0));
                int i = length - 1;
                while (i > 0) {
                    int lineNumber = MaxLineNumberVisitor.visit(list.get(i));
                    if (maxLineNumber < lineNumber) {
                        maxLineNumber = lineNumber;
                    }
                    --i;
                }
                break;
            }
            case 274: 
            case 321: {
                List list = ((InvokeNew)instruction).args;
                int length = list.size();
                if (length == 0) {
                    maxLineNumber = instruction.lineNumber;
                    break;
                }
                maxLineNumber = MaxLineNumberVisitor.visit((Instruction)list.get(0));
                int i = length - 1;
                while (i > 0) {
                    int lineNumber = MaxLineNumberVisitor.visit((Instruction)list.get(i));
                    if (maxLineNumber < lineNumber) {
                        maxLineNumber = lineNumber;
                    }
                    --i;
                }
                break;
            }
            case 171: {
                maxLineNumber = MaxLineNumberVisitor.visit(((LookupSwitch)instruction).key);
                break;
            }
            case 194: {
                maxLineNumber = MaxLineNumberVisitor.visit(((MonitorEnter)instruction).objectref);
                break;
            }
            case 195: {
                maxLineNumber = MaxLineNumberVisitor.visit(((MonitorExit)instruction).objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int length = dimensions.length;
                if (length <= 0) break;
                maxLineNumber = MaxLineNumberVisitor.visit(dimensions[length - 1]);
                break;
            }
            case 188: {
                maxLineNumber = MaxLineNumberVisitor.visit(((NewArray)instruction).dimension);
                break;
            }
            case 189: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ANewArray)instruction).dimension);
                break;
            }
            case 87: {
                maxLineNumber = MaxLineNumberVisitor.visit(((Pop)instruction).objectref);
                break;
            }
            case 181: {
                maxLineNumber = MaxLineNumberVisitor.visit(((PutField)instruction).valueref);
                break;
            }
            case 179: {
                maxLineNumber = MaxLineNumberVisitor.visit(((PutStatic)instruction).valueref);
                break;
            }
            case 273: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ReturnInstruction)instruction).valueref);
                break;
            }
            case 170: {
                maxLineNumber = MaxLineNumberVisitor.visit(((TableSwitch)instruction).key);
                break;
            }
            case 280: {
                maxLineNumber = MaxLineNumberVisitor.visit(((TernaryOpStore)instruction).objectref);
                break;
            }
            case 277: {
                IncInstruction ii = (IncInstruction)instruction;
                switch (ii.count) {
                    case -1: 
                    case 1: {
                        maxLineNumber = MaxLineNumberVisitor.visit(ii.value);
                    }
                }
                break;
            }
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                switch (ii.count) {
                    case -1: 
                    case 1: {
                        maxLineNumber = instruction.lineNumber;
                    }
                }
                maxLineNumber = MaxLineNumberVisitor.visit(ii.value);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                int length = iai.values.size();
                if (length <= 0) break;
                maxLineNumber = MaxLineNumberVisitor.visit(iai.values.get(length - 1));
                break;
            }
            case 281: {
                maxLineNumber = MaxLineNumberVisitor.visit(((TernaryOperator)instruction).value2);
            }
        }
        if (maxLineNumber < instruction.lineNumber) {
            return instruction.lineNumber;
        }
        return maxLineNumber;
    }
}

