/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import org.apache.tomcat.util.collections.ConcurrentCache;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.MediaType;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int size) {
        this.cache = new ConcurrentCache(size);
    }

    public String[] parse(String input) {
        String[] result = this.cache.get(input);
        if (result != null) {
            return result;
        }
        MediaType m = null;
        try {
            m = HttpParser.parseMediaType(new StringReader(input));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (m != null) {
            result = new String[]{m.toStringNoCharset(), m.getCharset()};
            this.cache.put(input, result);
        }
        return result;
    }
}

