/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.config.SchemaConstants;
import org.apache.cassandra.cql3.statements.KeyspaceAttributes;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;

public class AlterKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KeyspaceAttributes attrs;

    public AlterKeyspaceStatement(String name, KeyspaceAttributes attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.name, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name);
        if (ksm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        if (SchemaConstants.isLocalSystemKeyspace(ksm.name)) {
            throw new InvalidRequestException("Cannot alter system keyspace");
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null && !this.attrs.getReplicationOptions().isEmpty()) {
            throw new ConfigurationException("Missing replication strategy class");
        }
        if (this.attrs.getReplicationStrategyClass() != null) {
            KeyspaceParams params = this.attrs.asAlteredKeyspaceParams(ksm.params);
            params.validate(this.name);
            if (params.replication.klass.equals(LocalStrategy.class)) {
                throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
            }
        }
    }

    @Override
    public Event.SchemaChange announceMigration(QueryState queryState, boolean isLocalOnly) throws RequestValidationException {
        KeyspaceMetadata oldKsm = Schema.instance.getKSMetaData(this.name);
        if (oldKsm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        KeyspaceMetadata newKsm = oldKsm.withSwapped(this.attrs.asAlteredKeyspaceParams(oldKsm.params));
        MigrationManager.announceKeyspaceUpdate(newKsm, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, this.keyspace());
    }
}

