/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.Utilities;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCircleST;
import com.xerox.VTM.glyphs.VEllipseST;
import com.xerox.VTM.glyphs.VPolygonST;
import com.xerox.VTM.glyphs.VRectangleOrST;
import com.xerox.VTM.glyphs.VRoundRectST;
import com.xerox.VTM.glyphs.VSegmentST;
import com.xerox.VTM.svg.Context;
import com.xerox.VTM.svg.Metadata;
import com.xerox.VTM.svg.SVGStyle;
import com.xerox.VTM.svg.SVGWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.claribole.zvtm.glyphs.DPathST;
import net.claribole.zvtm.glyphs.VImageST;
import net.claribole.zvtm.glyphs.VTextST;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SVGReader {
    public static final String _polyline = "polyline";
    public static final String _line = "line";
    public static final String _rect = "rect";
    public static final String _image = "image";
    public static final String _ellipse = "ellipse";
    public static final String _circle = "circle";
    public static final String _path = "path";
    public static final String _text = "text";
    public static final String _polygon = "polygon";
    public static final String _g = "g";
    public static final String _a = "a";
    public static final String _title = "title";
    public static final String _fill = "fill";
    public static final String _stroke = "stroke";
    public static final String _strokewidth = "stroke-width";
    public static final String _strokedasharray = "stroke-dasharray";
    public static final String _fillopacity = "fill-opacity";
    public static final String _fontfamily = "font-family";
    public static final String _fontsize = "font-size";
    public static final String _fontweight = "font-weight";
    public static final String _fontstyle = "font-style";
    public static final String _fillCSS = "fill:";
    public static final String _strokeCSS = "stroke:";
    public static final String _strokewidthCSS = "stroke-width:";
    public static final String _strokedasharrayCSS = "stroke-dasharray:";
    public static final String _fillopacityCSS = "fill-opacity:";
    public static final String _fontfamilyCSS = "font-family:";
    public static final String _fontsizeCSS = "font-size:";
    public static final String _fontweightCSS = "font-weight:";
    public static final String _fontstyleCSS = "font-style:";
    public static final String _style = "style";
    public static final String _class = "class";
    public static final String _cx = "cx";
    public static final String _cy = "cy";
    public static final String _rx = "rx";
    public static final String _ry = "ry";
    public static final String _r = "r";
    public static final String _d = "d";
    public static final String _x = "x";
    public static final String _y = "y";
    public static final String _x1 = "x1";
    public static final String _y1 = "y1";
    public static final String _x2 = "x2";
    public static final String _y2 = "y2";
    public static final String _width = "width";
    public static final String _height = "height";
    public static final String _points = "points";
    public static final String _textanchor = "text-anchor";
    public static final String _start = "start";
    public static final String _middle = "middle";
    public static final String _end = "end";
    public static final String _inherit = "inherit";
    public static final String _pt = "pt";
    public static final String _id = "id";
    public static final String _transform = "transform";
    public static final String _viewBox = "viewBox";
    public static final String xlinkURI = "http://www.w3.org/1999/xlink";
    public static final String _href = "href";
    public static final String HTTP_SCHEME = "http://";
    public static final String FILE_SCHEME = "file:/";
    public static final String FILE_PROTOCOL = "file";
    public static final String EMPTY_STRING = "";
    public static final String COMMA_SEP = ",";
    public static final String SPACE_SEP = " ";
    public static final String LINE_SEP = "\n";
    static final String STYLING_INSTRUCTION_SEP = ";";
    static Hashtable fontCache = new Hashtable();
    static long xoffset = 0L;
    static long yoffset = 0L;
    static double scale = 1.0;
    public static float RRARCR = 0.4f;
    protected static Hashtable strokes = new Hashtable();
    protected static String SOLID_DASH_PATTERN = "solid";
    static final short fill_INDEX = 0;
    static final short stroke_INDEX = 1;
    static final short strokewidth_INDEX = 2;
    static final short strokedasharray_INDEX = 3;
    static final short fillopacity_INDEX = 4;
    static final short fontfamily_INDEX = 5;
    static final short fontsize_INDEX = 6;
    static final short fontweight_INDEX = 7;
    static final short fontstyle_INDEX = 8;
    static final String LOAD_EXTERNAL_DTD_URL = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static void setPositionOffset(long dx, long dy) {
        xoffset = dx;
        yoffset = dy;
    }

    public static LongPoint getPositionOffset() {
        return new LongPoint(xoffset, yoffset);
    }

    public static boolean checkSVGPath(String svg) {
        boolean res = true;
        byte[] chrs = svg.getBytes();
        for (int i = 0; i < chrs.length; ++i) {
            if (chrs[i] == 32 || chrs[i] == 45 || chrs[i] >= 48 && chrs[i] <= 57 || chrs[i] == 67 || chrs[i] == 72 || chrs[i] == 76 || chrs[i] == 77 || chrs[i] == 81 || chrs[i] == 86 || chrs[i] == 99 || chrs[i] == 104 || chrs[i] == 108 || chrs[i] == 109 || chrs[i] == 113 || chrs[i] == 118 || chrs[i] == 101 || chrs[i] == 69 || chrs[i] == 44 || chrs[i] == 46) continue;
            res = false;
            System.err.println("SVG Path: char '" + svg.substring(i, i + 1) + "' not supported");
            break;
        }
        return res;
    }

    public static long getLong(String s) {
        return Math.round(Double.parseDouble(s));
    }

    private static void processNextSVGPathCommand(StringBuffer svg, DPathST ph, StringBuffer lastCommand) {
        if (svg.length() > 0) {
            block0 : switch (svg.charAt(0)) {
                case 'M': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.jump(x, -y, true);
                    lastCommand.setCharAt(0, 'M');
                    break;
                }
                case 'm': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.jump(x, -y, false);
                    lastCommand.setCharAt(0, 'm');
                    break;
                }
                case 'L': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(x, -y, true);
                    lastCommand.setCharAt(0, 'L');
                    break;
                }
                case 'l': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(x, -y, false);
                    lastCommand.setCharAt(0, 'l');
                    break;
                }
                case 'H': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    ph.addSegment(x, 0L, true);
                    lastCommand.setCharAt(0, 'H');
                    break;
                }
                case 'h': {
                    svg.deleteCharAt(0);
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    ph.addSegment(x, 0L, false);
                    lastCommand.setCharAt(0, 'h');
                    break;
                }
                case 'V': {
                    svg.deleteCharAt(0);
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(0L, -y, true);
                    lastCommand.setCharAt(0, 'V');
                    break;
                }
                case 'v': {
                    svg.deleteCharAt(0);
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addSegment(0L, -y, false);
                    lastCommand.setCharAt(0, 'v');
                    break;
                }
                case 'C': {
                    svg.deleteCharAt(0);
                    long x1 = SVGReader.getNextNumber(svg) + xoffset;
                    long y1 = SVGReader.getNextNumber(svg) + yoffset;
                    long x2 = SVGReader.getNextNumber(svg) + xoffset;
                    long y2 = SVGReader.getNextNumber(svg) + yoffset;
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addCbCurve(x, -y, x1, -y1, x2, -y2, true);
                    lastCommand.setCharAt(0, 'C');
                    break;
                }
                case 'c': {
                    svg.deleteCharAt(0);
                    long x1 = SVGReader.getNextNumber(svg) + xoffset;
                    long y1 = SVGReader.getNextNumber(svg) + yoffset;
                    long x2 = SVGReader.getNextNumber(svg) + xoffset;
                    long y2 = SVGReader.getNextNumber(svg) + yoffset;
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addCbCurve(x, -y, x1, -y1, x2, -y2, false);
                    lastCommand.setCharAt(0, 'c');
                    break;
                }
                case 'Q': {
                    svg.deleteCharAt(0);
                    long x1 = SVGReader.getNextNumber(svg) + xoffset;
                    long y1 = SVGReader.getNextNumber(svg) + yoffset;
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addQdCurve(x, -y, x1, -y1, true);
                    lastCommand.setCharAt(0, 'Q');
                    break;
                }
                case 'q': {
                    svg.deleteCharAt(0);
                    long x1 = SVGReader.getNextNumber(svg) + xoffset;
                    long y1 = SVGReader.getNextNumber(svg) + yoffset;
                    long x = SVGReader.getNextNumber(svg) + xoffset;
                    long y = SVGReader.getNextNumber(svg) + yoffset;
                    ph.addQdCurve(x, -y, x1, -y1, false);
                    lastCommand.setCharAt(0, 'q');
                    break;
                }
                default: {
                    switch (lastCommand.charAt(0)) {
                        case 'M': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.jump(x, -y, true);
                            break block0;
                        }
                        case 'm': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.jump(x, -y, false);
                            break block0;
                        }
                        case 'L': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(x, -y, true);
                            break block0;
                        }
                        case 'l': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(x, -y, false);
                            break block0;
                        }
                        case 'H': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            ph.addSegment(x, 0L, true);
                            break block0;
                        }
                        case 'h': {
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            ph.addSegment(x, 0L, false);
                            break block0;
                        }
                        case 'V': {
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(0L, -y, true);
                            break block0;
                        }
                        case 'v': {
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addSegment(0L, -y, false);
                            break block0;
                        }
                        case 'C': {
                            long x1 = SVGReader.getNextNumber(svg) + xoffset;
                            long y1 = SVGReader.getNextNumber(svg) + yoffset;
                            long x2 = SVGReader.getNextNumber(svg) + xoffset;
                            long y2 = SVGReader.getNextNumber(svg) + yoffset;
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addCbCurve(x, -y, x1, -y1, x2, -y2, true);
                            break block0;
                        }
                        case 'c': {
                            long x1 = SVGReader.getNextNumber(svg) + xoffset;
                            long y1 = SVGReader.getNextNumber(svg) + yoffset;
                            long x2 = SVGReader.getNextNumber(svg) + xoffset;
                            long y2 = SVGReader.getNextNumber(svg) + yoffset;
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addCbCurve(x, -y, x1, -y1, x2, -y2, false);
                            break block0;
                        }
                        case 'Q': {
                            long x1 = SVGReader.getNextNumber(svg) + xoffset;
                            long y1 = SVGReader.getNextNumber(svg) + yoffset;
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addQdCurve(x, -y, x1, -y1, true);
                            break block0;
                        }
                        case 'q': {
                            long x1 = SVGReader.getNextNumber(svg) + xoffset;
                            long y1 = SVGReader.getNextNumber(svg) + yoffset;
                            long x = SVGReader.getNextNumber(svg) + xoffset;
                            long y = SVGReader.getNextNumber(svg) + yoffset;
                            ph.addQdCurve(x, -y, x1, -y1, false);
                            break block0;
                        }
                    }
                }
            }
        }
    }

    public static Color getColor(String s) {
        if (s == null) {
            return null;
        }
        try {
            if (s.startsWith("rgb(")) {
                StringTokenizer st = new StringTokenizer(s.substring(4, s.length() - 1), COMMA_SEP);
                String[] ar = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    ar[i++] = st.nextToken();
                }
                if (ar[0].endsWith("%")) {
                    float r = new Float(ar[0].substring(0, ar[0].length() - 1)).floatValue() / 100.0f;
                    float g = new Float(ar[1].substring(0, ar[1].length() - 1)).floatValue() / 100.0f;
                    float b = new Float(ar[2].substring(0, ar[2].length() - 1)).floatValue() / 100.0f;
                    return new Color(r, g, b);
                }
                int r = new Float(ar[0]).intValue();
                int g = new Float(ar[1]).intValue();
                int b = new Float(ar[2]).intValue();
                return new Color(r, g, b);
            }
            if (s.startsWith("#")) {
                String s2 = s.length() == 4 ? s.substring(1, 2) + s.substring(1, 2) + s.substring(2, 3) + s.substring(2, 3) + s.substring(3, 4) + s.substring(3, 4) : s.substring(1, s.length());
                int r = Integer.parseInt(s2.substring(0, 2), 16);
                int g = Integer.parseInt(s2.substring(2, 4), 16);
                int b = Integer.parseInt(s2.substring(4, 6), 16);
                return new Color(r, g, b);
            }
            if (s.startsWith("none")) {
                return null;
            }
            Color c = Utilities.getColorByKeyword(s);
            if (c != null) {
                return c;
            }
            return null;
        }
        catch (Exception ex) {
            System.err.println("Error: SVGReader.getColor(): " + ex);
            return Color.WHITE;
        }
    }

    public static SVGStyle getStyle(String s, Element e) {
        SVGStyle ss = new SVGStyle();
        boolean[] attributesSet = new boolean[9];
        if (s != null) {
            s = s.replaceAll(LINE_SEP, EMPTY_STRING);
            s = s.replaceAll(SPACE_SEP, EMPTY_STRING);
            StringTokenizer st = new StringTokenizer(s, STYLING_INSTRUCTION_SEP);
            while (st.hasMoreTokens()) {
                String instr = st.nextToken();
                if (instr.startsWith(_fillCSS)) {
                    ss.setFillColor(SVGReader.getColor(instr.substring(5, instr.length())));
                    attributesSet[0] = true;
                    continue;
                }
                if (instr.startsWith(_strokeCSS)) {
                    ss.setStrokeColor(SVGReader.getColor(instr.substring(7, instr.length())));
                    attributesSet[1] = true;
                    continue;
                }
                if (instr.startsWith(_strokewidthCSS)) {
                    ss.setStrokeWidth(instr.substring(13, instr.length()));
                    attributesSet[2] = true;
                    continue;
                }
                if (instr.startsWith(_strokedasharrayCSS)) {
                    ss.setStrokeDashArray(instr.substring(17, instr.length()));
                    attributesSet[3] = true;
                    continue;
                }
                if (instr.startsWith(_fillopacityCSS)) {
                    ss.setAlphaTransparencyValue(new Float(instr.substring(13, instr.length())));
                    attributesSet[4] = true;
                    continue;
                }
                if (instr.startsWith(_fontfamilyCSS)) {
                    ss.setFontFamily(instr.substring(12, instr.length()));
                    attributesSet[5] = true;
                    continue;
                }
                if (instr.startsWith(_fontsizeCSS)) {
                    ss.setFontSize(instr.substring(10, instr.length()));
                    attributesSet[6] = true;
                    continue;
                }
                if (instr.startsWith(_fontweightCSS)) {
                    ss.setFontWeight(instr.substring(12, instr.length()));
                    attributesSet[7] = true;
                    continue;
                }
                if (!instr.startsWith(_fontstyleCSS)) continue;
                ss.setFontStyle(instr.substring(11, instr.length()));
                attributesSet[8] = true;
            }
        }
        if (e != null) {
            if (!attributesSet[0] && e.hasAttribute(_fill)) {
                ss.setFillColor(SVGReader.getColor(e.getAttribute(_fill)));
            }
            if (!attributesSet[1] && e.hasAttribute(_stroke)) {
                ss.setStrokeColor(SVGReader.getColor(e.getAttribute(_stroke)));
            }
            if (!attributesSet[2] && e.hasAttribute(_strokewidth)) {
                ss.setStrokeWidth(e.getAttribute(_strokewidth));
            }
            if (!attributesSet[3] && e.hasAttribute(_strokedasharray)) {
                ss.setStrokeDashArray(e.getAttribute(_strokedasharray));
            }
            if (!attributesSet[4] && e.hasAttribute(_fillopacity)) {
                ss.setAlphaTransparencyValue(new Float(e.getAttribute(_fillopacity)));
            }
            if (!attributesSet[5] && e.hasAttribute(_fontfamily)) {
                ss.setFontFamily(e.getAttribute(_fontfamily));
            }
            if (!attributesSet[6] && e.hasAttribute(_fontsize)) {
                ss.setFontSize(e.getAttribute(_fontsize));
            }
            if (!attributesSet[7] && e.hasAttribute(_fontweight)) {
                ss.setFontWeight(e.getAttribute(_fontweight));
            }
            if (!attributesSet[8] && e.hasAttribute(_fontstyle)) {
                ss.setFontStyle(e.getAttribute(_fontstyle));
            }
        }
        return ss.hasStylingInformation() ? ss : null;
    }

    public static void translateSVGPolygon(String s, Vector res) {
        StringBuffer svg = new StringBuffer(s);
        while (svg.length() > 0) {
            Utilities.delLeadingSpaces(svg);
            SVGReader.processNextSVGCoords(svg, res);
        }
    }

    private static void processNextSVGCoords(StringBuffer svg, Vector res) {
        if (svg.length() > 0) {
            long x = SVGReader.getNextNumber(svg);
            long y = SVGReader.getNextNumber(svg);
            if (scale != 1.0) {
                x = (long)Math.floor((double)x * scale);
                y = (long)Math.floor((double)y * scale);
            }
            res.add(new LongPoint(x += xoffset, y += yoffset));
        }
    }

    private static void seekSecondCoord(StringBuffer sb) {
        Utilities.delLeadingSpaces(sb);
        while (sb.length() > 0 && (Character.isWhitespace(sb.charAt(0)) || sb.charAt(0) == ',')) {
            sb.deleteCharAt(0);
        }
    }

    static long getNextNumber(StringBuffer sb) {
        long res = 0L;
        SVGReader.seekSecondCoord(sb);
        StringBuffer dgb = new StringBuffer();
        while (sb.length() > 0 && (Character.isDigit(sb.charAt(0)) || sb.charAt(0) == '-' || sb.charAt(0) == '.' || sb.charAt(0) == 'e' || sb.charAt(0) == 'E' || sb.charAt(0) == '+')) {
            dgb.append(sb.charAt(0));
            sb.deleteCharAt(0);
        }
        if (dgb.length() > 0) {
            res = SVGReader.getLong(dgb.toString());
        }
        return res;
    }

    public static void assignStroke(Glyph g, SVGStyle ss) {
        BasicStroke bs;
        float[] sda;
        Float sw = ss.getStrokeWidth();
        if (sw == null) {
            sw = new Float(1.0f);
        }
        if ((sda = ss.getStrokeDashArray()) != null) {
            String dashPattern = Utilities.arrayOffloatAsCSStrings(sda);
            if (strokes.containsKey(sw)) {
                Hashtable h1 = (Hashtable)strokes.get(sw);
                if (h1.containsKey(dashPattern)) {
                    bs = (BasicStroke)h1.get(dashPattern);
                } else {
                    bs = new BasicStroke(sw.floatValue(), 0, 0, SVGWriter.DEFAULT_MITER_LIMIT, sda, SVGWriter.DEFAULT_DASH_OFFSET);
                    h1.put(dashPattern, bs);
                }
            } else {
                bs = new BasicStroke(sw.floatValue(), 0, 0, SVGWriter.DEFAULT_MITER_LIMIT, sda, SVGWriter.DEFAULT_DASH_OFFSET);
                Hashtable<String, BasicStroke> h1 = new Hashtable<String, BasicStroke>();
                h1.put(dashPattern, bs);
                strokes.put(sw, h1);
            }
        } else if (strokes.containsKey(sw)) {
            Hashtable h1 = (Hashtable)strokes.get(sw);
            if (h1.containsKey(SOLID_DASH_PATTERN)) {
                bs = (BasicStroke)h1.get(SOLID_DASH_PATTERN);
            } else {
                bs = new BasicStroke(sw.floatValue());
                h1.put(SOLID_DASH_PATTERN, bs);
            }
        } else {
            bs = new BasicStroke(sw.floatValue());
            Hashtable<String, BasicStroke> h1 = new Hashtable<String, BasicStroke>();
            h1.put(SOLID_DASH_PATTERN, bs);
            strokes.put(sw, h1);
        }
        g.setStroke(bs);
    }

    public static boolean isRectangle(Vector v) {
        if (v.size() == 4 || v.size() == 5) {
            LongPoint p1 = (LongPoint)v.elementAt(0);
            LongPoint p2 = (LongPoint)v.elementAt(1);
            LongPoint p3 = (LongPoint)v.elementAt(2);
            LongPoint p4 = (LongPoint)v.elementAt(3);
            return p2.x == p3.x && p1.y == p2.y && p3.y == p4.y && p1.x == p4.x || p2.y == p3.y && p1.x == p2.x && p3.x == p4.x && p1.y == p4.y;
        }
        return false;
    }

    public static VEllipseST createEllipse(Element e) {
        return SVGReader.createEllipse(e, null, false);
    }

    public static VEllipseST createEllipse(Element e, Context ctx) {
        return SVGReader.createEllipse(e, ctx, false);
    }

    public static VEllipseST createEllipse(Element e, Context ctx, boolean meta) {
        VEllipseST res;
        long x = SVGReader.getLong(e.getAttribute(_cx));
        long y = SVGReader.getLong(e.getAttribute(_cy));
        long w = SVGReader.getLong(e.getAttribute(_rx));
        long h = SVGReader.getLong(e.getAttribute(_ry));
        if (scale != 1.0) {
            x = (long)Math.floor((double)x * scale);
            y = (long)Math.floor((double)y * scale);
            w = (long)Math.floor((double)w * scale);
            h = (long)Math.floor((double)h * scale);
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VEllipseST(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VEllipseST(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f);
                }
                res.setTranslucencyValue(ss.getAlphaTransparencyValue());
            } else if (ss.getFillColor() == null) {
                res = new VEllipseST(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VEllipseST(x, -y, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke(res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VEllipseST(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VEllipseST(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f);
                }
                res.setTranslucencyValue(ctx.getAlphaTransparencyValue());
            } else if (ctx.getFillColor() == null) {
                res = new VEllipseST(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VEllipseST(x, -y, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            }
        } else {
            res = new VEllipseST(x, -y, 0, w, h, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VCircleST createCircle(Element e) {
        return SVGReader.createCircle(e, null, false);
    }

    public static VCircleST createCircle(Element e, Context ctx) {
        return SVGReader.createCircle(e, ctx, false);
    }

    public static VCircleST createCircle(Element e, Context ctx, boolean meta) {
        VCircleST res;
        long x = SVGReader.getLong(e.getAttribute(_cx));
        long y = SVGReader.getLong(e.getAttribute(_cy));
        long r = SVGReader.getLong(e.getAttribute(_r));
        if (scale != 1.0) {
            x = (long)Math.floor((double)x * scale);
            y = (long)Math.floor((double)y * scale);
            r = (long)Math.floor((double)r * scale);
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VCircleST(x, -y, 0, r, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VCircleST(x, -y, 0, r, ss.getFillColor(), Color.BLACK, 1.0f);
                }
                res.setTranslucencyValue(ss.getAlphaTransparencyValue());
            } else if (ss.getFillColor() == null) {
                res = new VCircleST(x, -y, 0, r, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VCircleST(x, -y, 0, r, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke(res, ss);
            }
        } else {
            res = new VCircleST(x, -y, 0, r, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VTextST createText(Element e, VirtualSpaceManager vsm) {
        return SVGReader.createText(e, null, vsm, false);
    }

    public static VTextST createText(Element e, Context ctx, VirtualSpaceManager vsm) {
        return SVGReader.createText(e, ctx, vsm, false);
    }

    public static VTextST createText(Element e, Context ctx, VirtualSpaceManager vsm, boolean meta) {
        VTextST res;
        String tx = e.getFirstChild() == null ? EMPTY_STRING : e.getFirstChild().getNodeValue();
        long x = SVGReader.getLong(e.getAttribute(_x));
        long y = SVGReader.getLong(e.getAttribute(_y));
        if (scale != 1.0) {
            x = (long)Math.floor((double)x * scale);
            y = (long)Math.floor((double)y * scale);
        }
        x += xoffset;
        y += yoffset;
        short ta = 0;
        if (e.hasAttribute(_textanchor)) {
            String tas = e.getAttribute(_textanchor);
            if (tas.equals(_middle)) {
                ta = 1;
            } else if (tas.equals(_end)) {
                ta = 2;
            } else if (tas.equals(_inherit)) {
                System.err.println("SVGReader::'inherit' value for text-anchor attribute not supported yet");
            }
        }
        Color tc = Color.BLACK;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.getStrokeColor() == null) {
                if (ss.getFillColor() != null) {
                    tc = ss.getFillColor();
                }
            } else {
                tc = ss.getStrokeColor();
            }
            res = ss.hasTransparencyInformation() ? new VTextST(x, -y, 0, tc, tx, ta, ss.getAlphaTransparencyValue()) : new VTextST(x, -y, 0, tc, tx, ta, 1.0f);
            Font f = ss.getDefinedFont(ctx);
            if (SVGReader.specialFont(f, vsm.getMainFont())) {
                res.setSpecialFont(f);
            }
        } else if (ctx != null) {
            res = ctx.hasTransparencyInformation() ? new VTextST(x, -y, 0, tc, tx, ta, ctx.getAlphaTransparencyValue()) : new VTextST(x, -y, 0, tc, tx, ta, 1.0f);
            Font f = ctx.getDefinedFont();
            if (SVGReader.specialFont(f, vsm.getMainFont())) {
                res.setSpecialFont(f);
            }
        } else {
            res = new VTextST(x, -y, 0, tc, tx, ta, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VRectangleOrST createRectangleFromPolygon(Element e) {
        return SVGReader.createRectangleFromPolygon(e, null, false);
    }

    public static VRectangleOrST createRectangleFromPolygon(Element e, Context ctx) {
        return SVGReader.createRectangleFromPolygon(e, ctx, false);
    }

    public static VRectangleOrST createRectangleFromPolygon(Element e, Context ctx, boolean meta) {
        Vector coords = new Vector();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        if (SVGReader.isRectangle(coords)) {
            VRectangleOrST res;
            LongPoint p1 = (LongPoint)coords.elementAt(0);
            LongPoint p2 = (LongPoint)coords.elementAt(1);
            LongPoint p3 = (LongPoint)coords.elementAt(2);
            LongPoint p4 = (LongPoint)coords.elementAt(3);
            long l = Math.min(p1.x, Math.min(p2.x, Math.min(p3.x, p4.x)));
            long u = Math.max(p1.y, Math.max(p2.y, Math.max(p3.y, p4.y)));
            long r = Math.max(p1.x, Math.max(p2.x, Math.max(p3.x, p4.x)));
            long d = Math.min(p1.y, Math.min(p2.y, Math.min(p3.y, p4.y)));
            LongPoint pNW = new LongPoint(l, u);
            LongPoint pNE = new LongPoint(r, u);
            LongPoint pSE = new LongPoint(r, d);
            LongPoint pSW = new LongPoint(l, d);
            long h = Math.abs(pSE.y - pNE.y);
            long w = Math.abs(pNW.x - pNE.x);
            long x = pNE.x - w / 2L;
            long y = pNE.y - h / 2L;
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null) {
                if (ss.hasTransparencyInformation()) {
                    if (ss.getFillColor() == null) {
                        res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                        res.setFilled(false);
                    } else {
                        res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, ss.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                    }
                    res.setTranslucencyValue(ss.getAlphaTransparencyValue());
                } else if (ss.getFillColor() == null) {
                    res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, ss.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                }
                Color border = ss.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ss.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke(res, ss);
                }
            } else if (ctx != null) {
                if (ctx.hasTransparencyInformation()) {
                    if (ctx.getFillColor() == null) {
                        res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                        res.setFilled(false);
                    } else {
                        res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, ctx.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                    }
                    res.setTranslucencyValue(ctx.getAlphaTransparencyValue());
                } else if (ctx.getFillColor() == null) {
                    res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, ctx.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                }
                Color border = ctx.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ctx.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
            } else {
                res = new VRectangleOrST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
            }
            if (meta) {
                SVGReader.setMetadata(res, ctx);
            }
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            return res;
        }
        return null;
    }

    public static VRoundRectST createRoundRectFromPolygon(Element e) {
        return SVGReader.createRoundRectFromPolygon(e, null, false);
    }

    public static VRoundRectST createRoundRectFromPolygon(Element e, Context ctx) {
        return SVGReader.createRoundRectFromPolygon(e, ctx, false);
    }

    public static VRoundRectST createRoundRectFromPolygon(Element e, Context ctx, boolean meta) {
        Vector coords = new Vector();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        if (SVGReader.isRectangle(coords)) {
            VRoundRectST res;
            LongPoint p1 = (LongPoint)coords.elementAt(0);
            LongPoint p2 = (LongPoint)coords.elementAt(1);
            LongPoint p3 = (LongPoint)coords.elementAt(2);
            LongPoint p4 = (LongPoint)coords.elementAt(3);
            long l = Math.min(p1.x, Math.min(p2.x, Math.min(p3.x, p4.x)));
            long u = Math.max(p1.y, Math.max(p2.y, Math.max(p3.y, p4.y)));
            long r = Math.max(p1.x, Math.max(p2.x, Math.max(p3.x, p4.x)));
            long d = Math.min(p1.y, Math.min(p2.y, Math.min(p3.y, p4.y)));
            LongPoint pNW = new LongPoint(l, u);
            LongPoint pNE = new LongPoint(r, u);
            LongPoint pSE = new LongPoint(r, d);
            LongPoint pSW = new LongPoint(l, d);
            long h = Math.abs(pSE.y - pNE.y);
            long w = Math.abs(pNW.x - pNE.x);
            long x = pNE.x - w / 2L;
            long y = pNE.y - h / 2L;
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null) {
                if (ss.hasTransparencyInformation()) {
                    if (ss.getFillColor() == null) {
                        res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                        res.setFilled(false);
                    } else {
                        res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, ss.getFillColor(), Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                    }
                    res.setTranslucencyValue(ss.getAlphaTransparencyValue());
                } else if (ss.getFillColor() == null) {
                    res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                    res.setFilled(false);
                } else {
                    res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, ss.getFillColor(), Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                }
                Color border = ss.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ss.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke(res, ss);
                }
            } else if (ctx != null) {
                if (ctx.hasTransparencyInformation()) {
                    if (ctx.getFillColor() == null) {
                        res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                        res.setFilled(false);
                    } else {
                        res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, ctx.getFillColor(), Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                    }
                    res.setTranslucencyValue(ctx.getAlphaTransparencyValue());
                } else if (ctx.getFillColor() == null) {
                    res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                    res.setFilled(false);
                } else {
                    res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, ctx.getFillColor(), Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
                }
                Color border = ctx.getStrokeColor();
                if (border != null) {
                    float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                    res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
                } else if (ctx.hasStrokeColorInformation()) {
                    res.setDrawBorder(false);
                }
            } else {
                res = new VRoundRectST(x, -y, 0, w / 2L, h / 2L, Color.WHITE, Color.BLACK, 1.0f, Math.round(RRARCR * (float)Math.min(w, h)), Math.round(RRARCR * (float)Math.min(w, h)));
            }
            if (meta) {
                SVGReader.setMetadata(res, ctx);
            }
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            return res;
        }
        return null;
    }

    public static VRectangleOrST createRectangle(Element e) {
        return SVGReader.createRectangle(e, null, false);
    }

    public static VRectangleOrST createRectangle(Element e, Context ctx) {
        return SVGReader.createRectangle(e, ctx, false);
    }

    public static VRectangleOrST createRectangle(Element e, Context ctx, boolean meta) {
        VRectangleOrST res;
        long x = SVGReader.getLong(e.getAttribute(_x));
        long y = SVGReader.getLong(e.getAttribute(_y));
        long w = SVGReader.getLong(e.getAttribute(_width)) / 2L;
        long h = SVGReader.getLong(e.getAttribute(_height)) / 2L;
        if (scale != 1.0) {
            x = (long)Math.floor((double)x * scale);
            y = (long)Math.floor((double)y * scale);
            w = (long)Math.floor((double)w * scale);
            h = (long)Math.floor((double)h * scale);
        }
        x += xoffset;
        y += yoffset;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VRectangleOrST(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOrST(x + w, -y - h, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                }
                res.setTranslucencyValue(ss.getAlphaTransparencyValue());
            } else if (ss.getFillColor() == null) {
                res = new VRectangleOrST(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                res.setFilled(false);
            } else {
                res = new VRectangleOrST(x + w, -y - h, 0, w, h, ss.getFillColor(), Color.BLACK, 1.0f, 0.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke(res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VRectangleOrST(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                    res.setFilled(false);
                } else {
                    res = new VRectangleOrST(x + w, -y - h, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f, 0.0f);
                }
                res.setTranslucencyValue(ctx.getAlphaTransparencyValue());
            } else if (ctx.getFillColor() == null) {
                res = new VRectangleOrST(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
                res.setFilled(false);
            } else {
                res = new VRectangleOrST(x + w, -y - h, 0, w, h, ctx.getFillColor(), Color.BLACK, 1.0f, 0.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ctx.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
        } else {
            res = new VRectangleOrST(x + w, -y - h, 0, w, h, Color.WHITE, Color.BLACK, 1.0f, 0.0f);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static Glyph createImage(Element e, Context ctx, boolean meta, Hashtable imageStore, String documentParentURL) {
        return SVGReader.createImage(e, ctx, meta, imageStore, documentParentURL, null);
    }

    public static VImageST createImage(Element e, Context ctx, boolean meta, Hashtable imageStore, String documentParentURL, String fallbackParentURL) {
        ImageIcon ii;
        String imagePath;
        String height;
        long x = SVGReader.getLong(e.getAttribute(_x)) + xoffset;
        long y = SVGReader.getLong(e.getAttribute(_y)) + yoffset;
        String width = e.getAttribute(_width);
        if (width.endsWith("px")) {
            width = width.substring(0, width.length() - 2);
        }
        if ((height = e.getAttribute(_height)).endsWith("px")) {
            height = height.substring(0, height.length() - 2);
        }
        long w = SVGReader.getLong(width);
        long h = SVGReader.getLong(height);
        long hw = w / 2L;
        long hh = h / 2L;
        Glyph res = null;
        if (e.hasAttributeNS(xlinkURI, _href) && (imagePath = e.getAttributeNS(xlinkURI, _href)).length() > 0 && (ii = SVGReader.getImage(imagePath, documentParentURL, fallbackParentURL, imageStore)) != null) {
            int aw = ii.getIconWidth();
            int ah = ii.getIconHeight();
            double wr = (double)w / (double)aw;
            double hr = (double)h / (double)ah;
            res = wr != 1.0 || hr != 1.0 ? new VImageST(x + hw, -y - hh, 0, ii.getImage(), Math.min(wr, hr), 1.0f) : new VImageST(x + hw, -y - hh, 0, ii.getImage(), 1.0f);
        }
        if (res != null) {
            if (e.hasAttribute(_class)) {
                res.setType(e.getAttribute(_class));
            }
            if (meta) {
                SVGReader.setMetadata(res, ctx);
            }
        }
        return res;
    }

    public static VPolygonST createPolygon(Element e) {
        return SVGReader.createPolygon(e, null, false);
    }

    public static VPolygonST createPolygon(Element e, Context ctx) {
        return SVGReader.createPolygon(e, ctx, false);
    }

    public static VPolygonST createPolygon(Element e, Context ctx, boolean meta) {
        VPolygonST res;
        Vector coords = new Vector();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        LongPoint[] coords2 = new LongPoint[coords.size()];
        for (int i = 0; i < coords2.length; ++i) {
            LongPoint lp = (LongPoint)coords.elementAt(i);
            coords2[i] = new LongPoint(lp.x, -lp.y);
        }
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            if (ss.hasTransparencyInformation()) {
                if (ss.getFillColor() == null) {
                    res = new VPolygonST(coords2, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VPolygonST(coords2, ss.getFillColor(), Color.BLACK, 1.0f);
                }
                res.setTranslucencyValue(ss.getAlphaTransparencyValue());
            } else if (ss.getFillColor() == null) {
                res = new VPolygonST(coords2, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VPolygonST(coords2, ss.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ss.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ss.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
            if (ss.requiresSpecialStroke()) {
                SVGReader.assignStroke(res, ss);
            }
        } else if (ctx != null) {
            if (ctx.hasTransparencyInformation()) {
                if (ctx.getFillColor() == null) {
                    res = new VPolygonST(coords2, Color.WHITE, Color.BLACK, 1.0f);
                    res.setFilled(false);
                } else {
                    res = new VPolygonST(coords2, ctx.getFillColor(), Color.BLACK, 1.0f);
                }
                res.setTranslucencyValue(ctx.getAlphaTransparencyValue());
            } else if (ctx.getFillColor() == null) {
                res = new VPolygonST(coords2, Color.WHITE, Color.BLACK, 1.0f);
                res.setFilled(false);
            } else {
                res = new VPolygonST(coords2, ctx.getFillColor(), Color.BLACK, 1.0f);
            }
            Color border = ctx.getStrokeColor();
            if (border != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                res.setHSVbColor(hsv[0], hsv[1], hsv[2]);
            } else if (ctx.hasStrokeColorInformation()) {
                res.setDrawBorder(false);
            }
        } else {
            res = new VPolygonST(coords2, Color.WHITE, Color.BLACK, 1.0f);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VSegmentST[] createPolyline(Element e) {
        return SVGReader.createPolyline(e, null, false);
    }

    public static VSegmentST[] createPolyline(Element e, Context ctx) {
        return SVGReader.createPolyline(e, ctx, false);
    }

    public static VSegmentST[] createPolyline(Element e, Context ctx, boolean meta) {
        Vector coords = new Vector();
        SVGReader.translateSVGPolygon(e.getAttribute(_points), coords);
        VSegmentST[] res = new VSegmentST[coords.size() - 1];
        Color border = Color.black;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            border = ss.getStrokeColor();
            if (border == null) {
                border = ss.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
        } else if (ctx != null) {
            border = ctx.getStrokeColor() != null ? ctx.getStrokeColor() : (ctx.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK);
        }
        for (int i = 0; i < coords.size() - 1; ++i) {
            LongPoint lp1 = (LongPoint)coords.elementAt(i);
            LongPoint lp2 = (LongPoint)coords.elementAt(i + 1);
            res[i] = new VSegmentST(lp1.x, -lp1.y, 0, border, lp2.x, -lp2.y, 1.0f);
            if (ss != null && ss.requiresSpecialStroke()) {
                SVGReader.assignStroke(res[i], ss);
            }
            if (meta) {
                SVGReader.setMetadata(res[i], ctx);
            }
            if (!e.hasAttribute(_class)) continue;
            res[i].setType(e.getAttribute(_class));
        }
        return res;
    }

    public static VSegmentST createLine(Element e) {
        return SVGReader.createLine(e, null, false);
    }

    public static VSegmentST createLine(Element e, Context ctx) {
        return SVGReader.createLine(e, ctx, false);
    }

    public static VSegmentST createLine(Element e, Context ctx, boolean meta) {
        VSegmentST res;
        long x1 = SVGReader.getLong(e.getAttribute(_x1));
        long y1 = SVGReader.getLong(e.getAttribute(_y1));
        long x2 = SVGReader.getLong(e.getAttribute(_x2));
        long y2 = SVGReader.getLong(e.getAttribute(_y2));
        if (scale != 1.0) {
            x1 = (long)Math.floor((double)x1 * scale);
            y1 = (long)Math.floor((double)y1 * scale);
            x2 = (long)Math.floor((double)x2 * scale);
            y2 = (long)Math.floor((double)y2 * scale);
        }
        x1 += xoffset;
        y1 += yoffset;
        x2 += xoffset;
        y2 += yoffset;
        Color border = Color.black;
        SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
        if (ss != null) {
            border = ss.getStrokeColor();
            if (border == null) {
                Color color = border = ss.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
            res = ss.hasTransparencyInformation() ? new VSegmentST(x1, -y1, 0, border, x2, -y2, ss.getAlphaTransparencyValue()) : new VSegmentST(x1, -y1, 0, border, x2, -y2, 1.0f);
        } else if (ctx != null) {
            if (ctx.getStrokeColor() != null) {
                border = ctx.getStrokeColor();
            } else {
                Color color = border = ctx.hasStrokeColorInformation() ? Color.WHITE : Color.BLACK;
            }
            res = ctx.hasTransparencyInformation() ? new VSegmentST(x1, -y1, 0, border, x2, -y2, ctx.getAlphaTransparencyValue()) : new VSegmentST(x1, -y1, 0, border, x2, -y2, 1.0f);
        } else {
            res = new VSegmentST(x1, -y1, 0, border, x2, -y2, 1.0f);
        }
        if (ss != null && ss.requiresSpecialStroke()) {
            SVGReader.assignStroke(res, ss);
        }
        if (meta) {
            SVGReader.setMetadata(res, ctx);
        }
        if (e.hasAttribute(_class)) {
            res.setType(e.getAttribute(_class));
        }
        return res;
    }

    public static DPathST createPath(Element e, DPathST ph) {
        return SVGReader.createPath(e, ph, null, false);
    }

    public static DPathST createPath(Element e, DPathST ph, Context ctx) {
        return SVGReader.createPath(e, ph, ctx, false);
    }

    public static DPathST createPath(Element e, DPathST ph, Context ctx, boolean meta) {
        StringBuffer svg = new StringBuffer(e.getAttribute(_d));
        if (SVGReader.checkSVGPath(svg.toString())) {
            Color border;
            StringBuffer lastCommand = new StringBuffer("M");
            while (svg.length() > 0) {
                Utilities.delLeadingSpaces(svg);
                SVGReader.processNextSVGPathCommand(svg, ph, lastCommand);
            }
            SVGStyle ss = SVGReader.getStyle(e.getAttribute(_style), e);
            if (ss != null && ss.hasStrokeColorInformation()) {
                Color border2 = ss.getStrokeColor();
                float[] hsv = Color.RGBtoHSB(border2.getRed(), border2.getGreen(), border2.getBlue(), new float[3]);
                ph.setHSVColor(hsv[0], hsv[1], hsv[2]);
                if (ss.requiresSpecialStroke()) {
                    SVGReader.assignStroke(ph, ss);
                }
            } else if (ctx != null && (border = ctx.getStrokeColor()) != null) {
                float[] hsv = Color.RGBtoHSB(border.getRed(), border.getGreen(), border.getBlue(), new float[3]);
                ph.setHSVColor(hsv[0], hsv[1], hsv[2]);
            }
            if (meta) {
                SVGReader.setMetadata(ph, ctx);
            }
            if (e.hasAttribute(_class)) {
                ph.setType(e.getAttribute(_class));
            }
            return ph;
        }
        return null;
    }

    public static DPathST createPath(String d, DPathST ph) {
        return SVGReader.createPath(d, ph, null, false);
    }

    public static DPathST createPath(String d, DPathST ph, Context ctx) {
        return SVGReader.createPath(d, ph, ctx, false);
    }

    public static DPathST createPath(String d, DPathST ph, Context ctx, boolean meta) {
        StringBuffer svg = new StringBuffer(d);
        if (SVGReader.checkSVGPath(svg.toString())) {
            StringBuffer lastCommand = new StringBuffer("M");
            while (svg.length() > 0) {
                Utilities.delLeadingSpaces(svg);
                SVGReader.processNextSVGPathCommand(svg, ph, lastCommand);
            }
            if (meta) {
                SVGReader.setMetadata(ph, ctx);
            }
            return ph;
        }
        return null;
    }

    public static void load(Document d, VirtualSpaceManager vsm, String vs) {
        SVGReader.load(d, vsm, vs, false, EMPTY_STRING);
    }

    public static void load(Document d, VirtualSpaceManager vsm, String vs, boolean meta) {
        SVGReader.load(d, vsm, vs, meta, EMPTY_STRING);
    }

    public static void load(Document d, VirtualSpaceManager vsm, String vs, boolean meta, String documentURL) {
        SVGReader.load(d, vsm, vs, meta, documentURL, null);
    }

    public static void load(Document d, VirtualSpaceManager vsm, String vs, boolean meta, String documentURL, String fallbackParentURL) {
        String documentParentURL = documentURL.substring(0, documentURL.lastIndexOf("/") + 1);
        Element svgRoot = d.getDocumentElement();
        NodeList objects = svgRoot.getChildNodes();
        Hashtable imageStore = new Hashtable();
        for (int i = 0; i < objects.getLength(); ++i) {
            Node obj = objects.item(i);
            if (obj.getNodeType() != 1) continue;
            SVGReader.processNode((Element)obj, vsm, vs, null, false, meta, documentParentURL, fallbackParentURL, imageStore);
        }
    }

    private static void processNode(Element e, VirtualSpaceManager vsm, String vs, Context ctx, boolean mainFontSet, boolean meta, String documentParentURL, String fallbackParentURL, Hashtable imageStore) {
        String tagName = e.getTagName();
        if (tagName.equals(_rect)) {
            vsm.addGlyph((Glyph)SVGReader.createRectangle(e, ctx, meta), vs);
        } else if (tagName.equals(_ellipse)) {
            vsm.addGlyph((Glyph)SVGReader.createEllipse(e, ctx, meta), vs);
        } else if (tagName.equals(_circle)) {
            vsm.addGlyph((Glyph)SVGReader.createCircle(e, ctx, meta), vs);
        } else if (tagName.equals(_path)) {
            vsm.addGlyph((Glyph)SVGReader.createPath(e, new DPathST(1.0f), ctx, meta), vs);
        } else if (tagName.equals(_text)) {
            vsm.addGlyph((Glyph)SVGReader.createText(e, ctx, vsm, meta), vs);
        } else if (tagName.equals(_polygon)) {
            VRectangleOrST g = SVGReader.createRectangleFromPolygon(e, ctx, meta);
            if (g != null) {
                vsm.addGlyph((Glyph)g, vs);
            } else {
                vsm.addGlyph((Glyph)SVGReader.createPolygon(e, ctx, meta), vs);
            }
        } else if (tagName.equals(_polyline)) {
            VSegmentST[] segments = SVGReader.createPolyline(e, ctx, meta);
            for (int i = 0; i < segments.length; ++i) {
                vsm.addGlyph((Glyph)segments[i], vs);
            }
        } else if (tagName.equals(_line)) {
            vsm.addGlyph((Glyph)SVGReader.createLine(e, ctx, meta), vs);
        } else if (tagName.equals(_image)) {
            if (SVGReader.isSVGImage(e)) {
                String height;
                String imagePath = e.getAttributeNS(xlinkURI, _href);
                URL imageURL = SVGReader.getImageURL(imagePath, documentParentURL, fallbackParentURL);
                String width = e.getAttribute(_width);
                if (width.endsWith("px")) {
                    width = width.substring(0, width.length() - 2);
                }
                if ((height = e.getAttribute(_height)).endsWith("px")) {
                    height = height.substring(0, height.length() - 2);
                }
                long w = SVGReader.getLong(width);
                long h = SVGReader.getLong(height);
                long x = SVGReader.getLong(e.getAttribute(_x));
                long y = SVGReader.getLong(e.getAttribute(_y));
                long xos = xoffset;
                long yos = yoffset;
                xoffset += x;
                yoffset += y;
                String imPath = imageURL.toString();
                Document imageDoc = SVGReader.parseSVG(imPath, false);
                Element svgRoot = imageDoc.getDocumentElement();
                String viewBox = svgRoot.getAttribute(_viewBox);
                String[] vbs = viewBox.split(SPACE_SEP);
                String xorigin = vbs[0];
                String yorigin = vbs[1];
                String iwidth = vbs[2];
                String iheight = vbs[3];
                long xor = SVGReader.getLong(xorigin);
                long yor = SVGReader.getLong(yorigin);
                long iw = SVGReader.getLong(iwidth);
                long ih = SVGReader.getLong(iheight);
                scale = (double)w / (double)iw;
                xoffset -= (long)Math.floor((double)xor * scale);
                yoffset -= (long)Math.floor((double)yor * scale);
                SVGReader.load(imageDoc, vsm, vs, meta, imPath);
                scale = 1.0;
                xoffset = xos;
                yoffset = yos;
            } else {
                VImageST g = SVGReader.createImage(e, ctx, meta, imageStore, documentParentURL, fallbackParentURL);
                if (g != null) {
                    vsm.addGlyph((Glyph)g, vs);
                }
            }
        } else if (tagName.equals(_g)) {
            NodeList titles;
            if (ctx == null) {
                ctx = new Context();
            }
            long xos = xoffset;
            long yos = yoffset;
            if (e.hasAttribute(_transform)) {
                String ty;
                String tx;
                int rp;
                int transl;
                String transform = e.getAttribute(_transform);
                String tlate = transform.substring((transl = transform.indexOf("translate")) + 10, rp = transform.indexOf(")", transl));
                String[] split = tlate.split(COMMA_SEP);
                if (split.length >= 2) {
                    tx = split[0].trim();
                    ty = split[1].trim();
                } else {
                    split = tlate.split(SPACE_SEP);
                    tx = split[0].trim();
                    ty = split[1].trim();
                }
                xoffset += (long)Math.floor((double)SVGReader.getLong(tx) * scale);
                yoffset += (long)Math.floor((double)SVGReader.getLong(ty) * scale);
            }
            NodeList objects = e.getChildNodes();
            boolean setAFont = false;
            if (e.hasAttribute(_style)) {
                ctx.add(e.getAttribute(_style));
                if (!mainFontSet) {
                    Font f = ctx.getDefinedFont();
                    if (f != null) {
                        vsm.setMainFont(f);
                        setAFont = true;
                    }
                } else {
                    setAFont = true;
                }
            }
            if ((titles = e.getElementsByTagName(_title)).getLength() > 0) {
                try {
                    ctx.setTitle(((Element)titles.item(0)).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (e.hasAttribute(_id)) {
                try {
                    ctx.setClosestAncestorGroupID(e.getAttribute(_id));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            for (int i = 0; i < objects.getLength(); ++i) {
                Node obj = objects.item(i);
                if (obj.getNodeType() != 1) continue;
                SVGReader.processNode((Element)obj, vsm, vs, ctx.duplicate(), setAFont, meta, documentParentURL, fallbackParentURL, imageStore);
            }
            xoffset = xos;
            yoffset = yos;
        } else if (tagName.equals(_a)) {
            NodeList objects = e.getChildNodes();
            boolean setAFont = false;
            if (e.hasAttribute(_style)) {
                if (ctx != null) {
                    ctx.add(e.getAttribute(_style));
                } else {
                    ctx = new Context(e.getAttribute(_style));
                }
                if (!mainFontSet) {
                    Font f = ctx.getDefinedFont();
                    if (f != null) {
                        vsm.setMainFont(f);
                        setAFont = true;
                    }
                } else {
                    setAFont = true;
                }
            }
            if (e.hasAttributeNS(xlinkURI, _href)) {
                if (ctx == null) {
                    ctx = new Context();
                }
                ctx.setURL(e.getAttributeNS(xlinkURI, _href));
            }
            for (int i = 0; i < objects.getLength(); ++i) {
                Node obj = objects.item(i);
                if (obj.getNodeType() != 1) continue;
                SVGReader.processNode((Element)obj, vsm, vs, ctx != null ? ctx.duplicate() : null, setAFont, meta, documentParentURL, fallbackParentURL, imageStore);
            }
        } else if (!tagName.equals(_title)) {
            System.err.println("SVGReader: unsupported element: " + tagName);
        }
    }

    public static Font getFont(String fontFamily, int fontStyle, int fontSize) {
        Font res;
        if (fontCache.containsKey(fontFamily)) {
            Vector fontData;
            Vector v = (Vector)fontCache.get(fontFamily);
            for (int i = 0; i < v.size(); ++i) {
                fontData = (Vector)v.elementAt(i);
                if ((Integer)fontData.elementAt(0) != fontStyle || (Integer)fontData.elementAt(1) != fontSize) continue;
                return (Font)fontData.elementAt(2);
            }
            fontData = new Vector();
            fontData.addElement(new Integer(fontStyle));
            fontData.addElement(new Integer(fontSize));
            res = new Font(fontFamily, fontStyle, fontSize);
            fontData.addElement(res);
            v.addElement(fontData);
            fontCache.put(fontFamily, v);
        } else {
            Vector<Serializable> fontData = new Vector<Serializable>();
            fontData.addElement(new Integer(fontStyle));
            fontData.addElement(new Integer(fontSize));
            res = new Font(fontFamily, fontStyle, fontSize);
            fontData.addElement(res);
            Vector<Vector<Serializable>> v = new Vector<Vector<Serializable>>();
            v.addElement(fontData);
            fontCache.put(fontFamily, v);
        }
        return res;
    }

    private static void setMetadata(Glyph g, Context ctx) {
        if (ctx != null && (ctx.getURL() != null || ctx.getTitle() != null || ctx.getClosestAncestorGroupID() != null)) {
            g.setOwner(new Metadata(ctx.getURL(), ctx.getTitle(), ctx.getClosestAncestorGroupID()));
        }
    }

    private static boolean specialFont(Font cFont, Font mFont) {
        if (cFont == null) {
            return false;
        }
        return !cFont.getFamily().equals(mFont.getFamily()) || cFont.getSize() != mFont.getSize() || cFont.getStyle() != mFont.getStyle();
    }

    static URL getImageURL(String imagePath, String documentParentURL, String fallbackParentURL) {
        URL imageURL = null;
        if (imagePath.startsWith(FILE_SCHEME) || imagePath.startsWith(HTTP_SCHEME)) {
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else if (imagePath.charAt(0) == '/') {
            imagePath = "file://" + imagePath;
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else if (imagePath.substring(1, 3).equals(":\\")) {
            imagePath = "file:///" + imagePath.replace('\\', '/').replace(':', '|');
            try {
                imageURL = new URL(imagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
        } else {
            String absImagePath = documentParentURL + imagePath;
            try {
                imageURL = new URL(absImagePath);
            }
            catch (MalformedURLException ex) {
                System.err.println("Failed to identify image location: " + imagePath);
            }
            if (imageURL.getProtocol().equals(FILE_PROTOCOL) && fallbackParentURL != null) {
                try {
                    if (!new File(new URI(imageURL.toString())).exists()) {
                        absImagePath = fallbackParentURL + imagePath;
                        try {
                            imageURL = new URL(absImagePath);
                        }
                        catch (MalformedURLException ex) {}
                    }
                }
                catch (Exception ex) {
                    System.err.println("Image icon was found neither at\n" + documentParentURL + imagePath + "nor at\n" + fallbackParentURL + imagePath);
                }
            }
        }
        return imageURL;
    }

    static ImageIcon getImage(String imagePath, String documentParentURL, String fallbackParentURL, Hashtable imageStore) {
        URL imageURL = SVGReader.getImageURL(imagePath, documentParentURL, fallbackParentURL);
        ImageIcon res = null;
        if (imageStore.containsKey(imageURL)) {
            res = (ImageIcon)imageStore.get(imageURL);
        } else {
            try {
                res = new ImageIcon(imageURL);
                imageStore.put(imageURL, res);
            }
            catch (Exception ex) {
                System.err.println("Failed to load image from: " + imageURL.toString());
                res = null;
            }
        }
        return res;
    }

    static boolean isSVGImage(Element e) {
        String imagePath;
        return e.hasAttributeNS(xlinkURI, _href) && (imagePath = e.getAttributeNS(xlinkURI, _href)).endsWith(".svg");
    }

    static Document parseSVG(String uri, boolean validation) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validation);
            if (!validation) {
                factory.setAttribute(LOAD_EXTERNAL_DTD_URL, Boolean.FALSE);
            }
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document res = builder.parse(uri);
            return res;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

