/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.LogAndContinueExceptionHandler;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateManager;
import org.apache.kafka.streams.processor.internals.GlobalStateManagerImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateUpdateTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManager;
import org.apache.kafka.streams.processor.internals.StoreChangelogReader;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.ThreadCache;

@InterfaceStability.Evolving
public class TopologyTestDriver {
    private final Time mockTime;
    private final InternalTopologyBuilder internalTopologyBuilder;
    private static final int PARTITION_ID = 0;
    private static final TaskId TASK_ID = new TaskId(0, 0);
    private StreamTask task;
    private GlobalStateUpdateTask globalStateTask;
    private final StateDirectory stateDirectory;
    private final ProcessorTopology processorTopology;
    private final MockProducer<byte[], byte[]> producer;
    private final Set<String> internalTopics = new HashSet<String>();
    private final Map<String, TopicPartition> partitionsByTopic = new HashMap<String, TopicPartition>();
    private final Map<String, TopicPartition> globalPartitionsByTopic = new HashMap<String, TopicPartition>();
    private final Map<TopicPartition, AtomicLong> offsetsByTopicPartition = new HashMap<TopicPartition, AtomicLong>();
    private final Map<String, Queue<ProducerRecord<byte[], byte[]>>> outputRecordsByTopic = new HashMap<String, Queue<ProducerRecord<byte[], byte[]>>>();

    public TopologyTestDriver(Topology topology, Properties config) {
        this(topology, config, System.currentTimeMillis());
    }

    public TopologyTestDriver(Topology topology, Properties config, long initialWallClockTimeMs) {
        StreamsConfig streamsConfig = new StreamsConfig((Map)config);
        this.mockTime = new MockTime(initialWallClockTimeMs);
        this.internalTopologyBuilder = topology.internalTopologyBuilder;
        this.internalTopologyBuilder.setApplicationId(streamsConfig.getString("application.id"));
        this.processorTopology = this.internalTopologyBuilder.build(null);
        ProcessorTopology globalTopology = this.internalTopologyBuilder.buildGlobalStateTopology();
        ByteArraySerializer bytesSerializer = new ByteArraySerializer();
        this.producer = new MockProducer<byte[], byte[]>(true, (Serializer)bytesSerializer, (Serializer)bytesSerializer){

            public List<PartitionInfo> partitionsFor(String topic) {
                return Collections.singletonList(new PartitionInfo(topic, 0, null, null, null));
            }
        };
        MockConsumer consumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        this.stateDirectory = new StateDirectory(streamsConfig, this.mockTime);
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(new Metrics(), "topology-test-driver-stream-metrics", Collections.emptyMap());
        ThreadCache cache = new ThreadCache(new LogContext("topology-test-driver "), Math.max(0L, streamsConfig.getLong("cache.max.bytes.buffering")), (StreamsMetrics)streamsMetrics);
        StateRestoreListener stateRestoreListener = new StateRestoreListener(){

            public void onRestoreStart(TopicPartition topicPartition, String storeName, long startingOffset, long endingOffset) {
            }

            public void onBatchRestored(TopicPartition topicPartition, String storeName, long batchEndOffset, long numRestored) {
            }

            public void onRestoreEnd(TopicPartition topicPartition, String storeName, long totalRestored) {
            }
        };
        for (InternalTopologyBuilder.TopicsInfo topicsInfo : this.internalTopologyBuilder.topicGroups().values()) {
            this.internalTopics.addAll(topicsInfo.repartitionSourceTopics.keySet());
        }
        for (String topic : this.processorTopology.sourceTopics()) {
            TopicPartition tp = new TopicPartition(topic, 0);
            this.partitionsByTopic.put(topic, tp);
            this.offsetsByTopicPartition.put(tp, new AtomicLong());
        }
        consumer.assign(this.partitionsByTopic.values());
        if (globalTopology != null) {
            for (String topicName : globalTopology.sourceTopics()) {
                TopicPartition partition = new TopicPartition(topicName, 0);
                this.globalPartitionsByTopic.put(topicName, partition);
                this.offsetsByTopicPartition.put(partition, new AtomicLong());
                consumer.updatePartitions(topicName, Collections.singletonList(new PartitionInfo(topicName, 0, null, null, null)));
                consumer.updateBeginningOffsets(Collections.singletonMap(partition, 0L));
                consumer.updateEndOffsets(Collections.singletonMap(partition, 0L));
            }
            GlobalStateManagerImpl stateManager = new GlobalStateManagerImpl(new LogContext("mock "), globalTopology, (Consumer)consumer, this.stateDirectory, stateRestoreListener, streamsConfig);
            GlobalProcessorContextImpl globalProcessorContext = new GlobalProcessorContextImpl(streamsConfig, (StateManager)stateManager, (StreamsMetrics)streamsMetrics, cache);
            stateManager.setGlobalProcessorContext((InternalProcessorContext)globalProcessorContext);
            this.globalStateTask = new GlobalStateUpdateTask(globalTopology, (InternalProcessorContext)globalProcessorContext, (GlobalStateManager)stateManager, (DeserializationExceptionHandler)new LogAndContinueExceptionHandler(), new LogContext());
            this.globalStateTask.initialize();
        }
        if (!this.partitionsByTopic.isEmpty()) {
            this.task = new StreamTask(TASK_ID, this.partitionsByTopic.values(), this.processorTopology, (Consumer)consumer, (ChangelogReader)new StoreChangelogReader(this.createRestoreConsumer(this.processorTopology.storeToChangelogTopic()), stateRestoreListener, new LogContext("topology-test-driver ")), streamsConfig, (StreamsMetrics)streamsMetrics, this.stateDirectory, cache, this.mockTime, this.producer);
            this.task.initializeStateStores();
            this.task.initializeTopology();
        }
    }

    public void pipeInput(ConsumerRecord<byte[], byte[]> consumerRecord) {
        String topicName = consumerRecord.topic();
        TopicPartition topicPartition = this.partitionsByTopic.get(topicName);
        if (topicPartition != null) {
            long offset = this.offsetsByTopicPartition.get(topicPartition).incrementAndGet() - 1L;
            this.task.addRecords(topicPartition, Collections.singleton(new ConsumerRecord(topicName, topicPartition.partition(), offset, consumerRecord.timestamp(), consumerRecord.timestampType(), -1L, consumerRecord.serializedKeySize(), consumerRecord.serializedValueSize(), consumerRecord.key(), consumerRecord.value())));
            ((InternalProcessorContext)this.task.context()).setRecordContext((RecordContext)new ProcessorRecordContext(consumerRecord.timestamp(), offset, topicPartition.partition(), topicName));
            this.task.process();
            this.task.maybePunctuateStreamTime();
            this.task.commit();
            this.captureOutputRecords();
        } else {
            TopicPartition globalTopicPartition = this.globalPartitionsByTopic.get(topicName);
            if (globalTopicPartition == null) {
                throw new IllegalArgumentException("Unknown topic: " + topicName);
            }
            long offset = this.offsetsByTopicPartition.get(globalTopicPartition).incrementAndGet() - 1L;
            this.globalStateTask.update(new ConsumerRecord(globalTopicPartition.topic(), globalTopicPartition.partition(), offset, consumerRecord.timestamp(), consumerRecord.timestampType(), -1L, consumerRecord.serializedKeySize(), consumerRecord.serializedValueSize(), consumerRecord.key(), consumerRecord.value()));
            this.globalStateTask.flushState();
        }
    }

    private void captureOutputRecords() {
        List output = this.producer.history();
        this.producer.clear();
        for (ProducerRecord record : output) {
            Queue<ProducerRecord<byte[], byte[]>> outputRecords = this.outputRecordsByTopic.get(record.topic());
            if (outputRecords == null) {
                outputRecords = new LinkedList<ProducerRecord<byte[], byte[]>>();
                this.outputRecordsByTopic.put(record.topic(), outputRecords);
            }
            outputRecords.add((ProducerRecord<byte[], byte[]>)record);
            String outputTopicName = record.topic();
            if (!this.internalTopics.contains(outputTopicName) && !this.processorTopology.sourceTopics().contains(outputTopicName)) continue;
            byte[] serializedKey = (byte[])record.key();
            byte[] serializedValue = (byte[])record.value();
            this.pipeInput((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(outputTopicName, -1, -1L, record.timestamp().longValue(), TimestampType.CREATE_TIME, 0L, serializedKey == null ? 0 : serializedKey.length, serializedValue == null ? 0 : serializedValue.length, (Object)serializedKey, (Object)serializedValue));
        }
    }

    public void pipeInput(List<ConsumerRecord<byte[], byte[]>> records) {
        for (ConsumerRecord<byte[], byte[]> record : records) {
            this.pipeInput(record);
        }
    }

    public void advanceWallClockTime(long advanceMs) {
        this.mockTime.sleep(advanceMs);
        this.task.maybePunctuateSystemTime();
        this.task.commit();
        this.captureOutputRecords();
    }

    public ProducerRecord<byte[], byte[]> readOutput(String topic) {
        Queue<ProducerRecord<byte[], byte[]>> outputRecords = this.outputRecordsByTopic.get(topic);
        if (outputRecords == null) {
            return null;
        }
        return outputRecords.poll();
    }

    public <K, V> ProducerRecord<K, V> readOutput(String topic, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        ProducerRecord<byte[], byte[]> record = this.readOutput(topic);
        if (record == null) {
            return null;
        }
        Object key = keyDeserializer.deserialize(record.topic(), (byte[])record.key());
        Object value = valueDeserializer.deserialize(record.topic(), (byte[])record.value());
        return new ProducerRecord(record.topic(), record.partition(), record.timestamp(), key, value);
    }

    public Map<String, StateStore> getAllStateStores() {
        HashMap<String, StateStore> allStores = new HashMap<String, StateStore>();
        for (String storeName : this.internalTopologyBuilder.allStateStoreName()) {
            allStores.put(storeName, ((ProcessorContextImpl)this.task.context()).getStateMgr().getStore(storeName));
        }
        return allStores;
    }

    public StateStore getStateStore(String name) {
        return ((ProcessorContextImpl)this.task.context()).getStateMgr().getStore(name);
    }

    public <K, V> KeyValueStore<K, V> getKeyValueStore(String name) {
        StateStore store = this.getStateStore(name);
        return store instanceof KeyValueStore ? (KeyValueStore)store : null;
    }

    public <K, V> WindowStore<K, V> getWindowStore(String name) {
        StateStore store = this.getStateStore(name);
        return store instanceof WindowStore ? (WindowStore)store : null;
    }

    public <K, V> SessionStore<K, V> getSessionStore(String name) {
        StateStore store = this.getStateStore(name);
        return store instanceof SessionStore ? (SessionStore)store : null;
    }

    public void close() {
        if (this.task != null) {
            this.task.close(true, false);
        }
        if (this.globalStateTask != null) {
            try {
                this.globalStateTask.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.captureOutputRecords();
        this.stateDirectory.clean();
    }

    private MockConsumer<byte[], byte[]> createRestoreConsumer(Map<String, String> storeToChangelogTopic) {
        MockConsumer<byte[], byte[]> consumer = new MockConsumer<byte[], byte[]>(OffsetResetStrategy.LATEST){

            public synchronized void seekToEnd(Collection<TopicPartition> partitions) {
            }

            public synchronized void seekToBeginning(Collection<TopicPartition> partitions) {
            }

            public synchronized long position(TopicPartition partition) {
                return 0L;
            }
        };
        for (Map.Entry<String, String> storeAndTopic : storeToChangelogTopic.entrySet()) {
            String topicName = storeAndTopic.getValue();
            ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
            partitionInfos.add(new PartitionInfo(topicName, 0, null, null, null));
            consumer.updatePartitions(topicName, partitionInfos);
            consumer.updateEndOffsets(Collections.singletonMap(new TopicPartition(topicName, 0), 0L));
        }
        return consumer;
    }

    static class MockTime
    implements Time {
        private final AtomicLong timeMs;
        private final AtomicLong highResTimeNs;

        MockTime(long startTimestampMs) {
            this.timeMs = new AtomicLong(startTimestampMs);
            this.highResTimeNs = new AtomicLong(startTimestampMs * 1000L * 1000L);
        }

        public long milliseconds() {
            return this.timeMs.get();
        }

        public long nanoseconds() {
            return this.highResTimeNs.get();
        }

        public long hiResClockMs() {
            return TimeUnit.NANOSECONDS.toMillis(this.nanoseconds());
        }

        public void sleep(long ms) {
            if (ms < 0L) {
                throw new IllegalArgumentException("Sleep ms cannot be negative.");
            }
            this.timeMs.addAndGet(ms);
            this.highResTimeNs.addAndGet(TimeUnit.MILLISECONDS.toNanos(ms));
        }
    }
}

