/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001\u001d\u0011!CU3qY&\u001c\u0017-T1oC\u001e,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005)Ao\u001c9jGV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!A.\u00198h\u0015\u0005Y\u0012\u0001\u00026bm\u0006L!!\b\r\u0003\rM#(/\u001b8h\u0011\u0019y\u0002\u0001)A\u0005-\u00051Ao\u001c9jG\u0002Bq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0003uS6,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!B;uS2\u001c\u0018B\u0001\u0015&\u0005!iunY6US6,\u0007B\u0002\u0016\u0001A\u0003%1%A\u0003uS6,\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\u000f5,GO]5dgV\ta\u0006\u0005\u00020q5\t\u0001G\u0003\u0002-c)\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0019\u0003\u000f5+GO]5dg\"11\b\u0001Q\u0001\n9\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002y\n\u0001B_6DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\tu.\u001cG.[3oi*\u0011AIN\u0001\u0007\u0013BJE/Z2\n\u0005\u0019\u000b%\u0001\u0003.l\u00072LWM\u001c;\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003I\u0015\u0001\u0004>l\u00072LWM\u001c;`I\u0015\fHC\u0001&N!\tI1*\u0003\u0002M\u0015\t!QK\\5u\u0011\u001dqu)!AA\u0002}\n1\u0001\u001f\u00132\u0011%\u0001\u0006\u00011A\u0001B\u0003&q(A\u0005{W\u000ec\u0017.\u001a8uA!I!\u000b\u0001a\u0001\u0002\u0004%\taU\u0001\u000eW\u000647.\u0019.l\u00072LWM\u001c;\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!a\u0016\u0003\u0002\u0005i\\\u0017BA-W\u00055Y\u0015MZ6b5.\u001cE.[3oi\"I1\f\u0001a\u0001\u0002\u0004%\t\u0001X\u0001\u0012W\u000647.\u0019.l\u00072LWM\u001c;`I\u0015\fHC\u0001&^\u0011\u001dq%,!AA\u0002QC\u0011b\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002+\u0002\u001d-\fgm[1[W\u000ec\u0017.\u001a8uA!)\u0011\r\u0001C\u0001E\u0006)1/\u001a;VaR\t!\n\u000b\u0002aIB\u0011Q\r[\u0007\u0002M*\u0011qMN\u0001\u0006UVt\u0017\u000e^\u0005\u0003S\u001a\u0014aAQ3g_J,\u0007\"B6\u0001\t\u0003\u0011\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)l\u0007CA3o\u0013\tygMA\u0003BMR,'\u000fC\u0003r\u0001\u0011\u0005!-A\u0011uKN$\b*[4i/\u0006$XM]'be.$\u0015N]3di>\u0014\u00180T1qa&tw\r\u000b\u0002qgB\u0011Q\r^\u0005\u0003k\u001a\u0014A\u0001V3ti\")q\u000f\u0001C\u0001E\u0006IC/Z:u\u0011&<\u0007n^1uKJl\u0015M]6SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD#A^:\t\u000bi\u0004A\u0011\u00012\u0002/Q,7\u000f^%mY\u0016<\u0017\r\u001c*fcVL'/\u001a3BG.\u001c\bFA=t\u0011\u0015i\b\u0001\"\u0001c\u0003\u0011\"Xm\u001d;DY\u0016\f'\u000fU;sO\u0006$xN]=P]\n+7m\\7j]\u001e4u\u000e\u001c7po\u0016\u0014\bF\u0001?t\u0011\u0019\t\t\u0001\u0001C\u0001E\u0006AD/Z:u%\u0016\u001cW-\u001b<f\u001fV$xJZ(sI\u0016\u00148+Z9vK:\u001cW-\u0012=dKB$\u0018n\u001c8XSRDGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bFA@t\u0011\u0019\t9\u0001\u0001C\u0001E\u0006\u0011C/Z:u%\u0016\fGmQ8n[&$H/\u001a3GKR\u001c\u0007\u000eT5nSR,G-\u0011;M'>C3!!\u0002t\u0011\u0019\ti\u0001\u0001C\u0001E\u0006YC/Z:u\t\u0016d\u0017-_3e\r\u0016$8\r[%oG2,H-Z:BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000fK\u0002\u0002\fMDa!a\u0005\u0001\t\u0003\u0011\u0017a\f;fgR4U\r^2i\u0005\u0016LxN\u001c3IS\u001eDw+\u0019;fe6\f'o\u001b*fiV\u0014h.R7qif\u0014Vm\u001d9p]N,\u0007fAA\tg\"1\u0011\u0011\u0004\u0001\u0005\u0002\t\fq\u0006^3ti\u001a+Go\u00195NKN\u001c\u0018mZ3t/\",gNT8u\r>dGn\\<fe\u001a{'o\u00148f!\u0006\u0014H/\u001b;j_:D3!a\u0006t\r\u0019\ty\u0002\u0001\u0003\u0002\"\tq1)\u00197mE\u0006\u001c7NU3tk2$X\u0003BA\u0012\u0003c\u00192!!\b\t\u0011\u001dy\u0011Q\u0004C\u0001\u0003O!\"!!\u000b\u0011\r\u0005-\u0012QDA\u0017\u001b\u0005\u0001\u0001\u0003BA\u0018\u0003ca\u0001\u0001\u0002\u0005\u00024\u0005u!\u0019AA\u001b\u0005\u0005!\u0016\u0003BA\u001c\u0003{\u00012!CA\u001d\u0013\r\tYD\u0003\u0002\b\u001d>$\b.\u001b8h!\rI\u0011qH\u0005\u0004\u0003\u0003R!aA!os\"Q\u0011QIA\u000f\u0001\u0004%I!a\u0012\u0002\u000bY\fG.^3\u0016\u0005\u0005%\u0003#B\u0005\u0002L\u00055\u0012bAA'\u0015\t1q\n\u001d;j_:D!\"!\u0015\u0002\u001e\u0001\u0007I\u0011BA*\u0003%1\u0018\r\\;f?\u0012*\u0017\u000fF\u0002K\u0003+B\u0011BTA(\u0003\u0003\u0005\r!!\u0013\t\u0013\u0005e\u0013Q\u0004Q!\n\u0005%\u0013A\u0002<bYV,\u0007\u0005\u0003\u0006\u0002^\u0005u\u0001\u0019!C\u0005\u0003?\n1AZ;o+\t\t\t\u0007E\u0003\n\u0003\u0017\n\u0019\u0007\u0005\u0004\n\u0003K\niCS\u0005\u0004\u0003OR!!\u0003$v]\u000e$\u0018n\u001c82\u0011)\tY'!\bA\u0002\u0013%\u0011QN\u0001\bMVtw\fJ3r)\rQ\u0015q\u000e\u0005\n\u001d\u0006%\u0014\u0011!a\u0001\u0003CB\u0011\"a\u001d\u0002\u001e\u0001\u0006K!!\u0019\u0002\t\u0019,h\u000e\t\u0005\t\u0003o\ni\u0002\"\u0001\u0002z\u0005Y\u0011m]:feR4\u0015N]3e+\t\ti\u0003\u0003\u0005\u0002~\u0005uA\u0011AA@\u0003\u001dI7OR5sK\u0012,\"!!!\u0011\u0007%\t\u0019)C\u0002\u0002\u0006*\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\n\u0006uA\u0011AAF\u0003\u00111\u0017N]3\u0015\u0007)\u000bi\t\u0003\u0005\u0002F\u0005\u001d\u0005\u0019AA\u0017\u0011!\t\t*!\b\u0005\u0002\u0005M\u0015AB8o\r&\u0014X\r\u0006\u0003\u0002*\u0005U\u0005\u0002CA/\u0003\u001f\u0003\r!a\u0019\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\u001c\u0006i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$\"\"!(\u0002L\u0006U\u0017\u0011]Ay!\u0019\tY#!\b\u0002 B!\u0011\u0011UAc\u001d\u0011\t\u0019+a0\u000f\t\u0005\u0015\u00161\u0018\b\u0005\u0003O\u000bIL\u0004\u0003\u0002*\u0006]f\u0002BAV\u0003ksA!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003c3\u0011A\u0002\u001fs_>$h(C\u00018\u0013\t)d'\u0003\u0002\u0006i%\u0011!gM\u0005\u0004\u0003{\u000b\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005\u0005\u00171Y\u0001\u0010!J|G-^2f%\u0016\u001c\bo\u001c8tK*\u0019\u0011QX\u0019\n\t\u0005\u001d\u0017\u0011\u001a\u0002\u0012!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'\u0002BAa\u0003\u0007D\u0001\"!4\u0002\u0018\u0002\u0007\u0011qZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\r\u0011\u0012\u0011[\u0005\u0004\u0003'\u0014!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\t\u0003/\f9\n1\u0001\u0002Z\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0005\u00037\fi.D\u00012\u0013\r\ty.\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t\u0019/a&A\u0002\u0005\u0015\u0018a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111^\u0019\u0002\rI,7m\u001c:e\u0013\u0011\ty/!;\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011)\t\u00190a&\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\rSN4%o\\7DY&,g\u000e\u001e\u0005\b\u0003o\u0004A\u0011BA}\u0003=1W\r^2i\u0003N\u001cuN\\:v[\u0016\u0014H\u0003DA~\u0005\u0007\u0011)Aa\u0002\u0003\u001a\t\r\u0002CBA\u0016\u0003;\ti\u0010E\u0002\u0013\u0003\u007fL1A!\u0001\u0003\u0005I1U\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u0011\u00055\u0017Q\u001fa\u0001\u0003\u001fD\u0001\"a6\u0002v\u0002\u0007\u0011\u0011\u001c\u0005\t\u0005\u0013\t)\u00101\u0001\u0003\f\u0005i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004BA!\u0004\u0003\u00149!\u00111\u0015B\b\u0013\u0011\u0011\t\"a1\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\tU!q\u0003\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\tE\u00111\u0019\u0005\u000b\u00057\t)\u0010%AA\u0002\tu\u0011\u0001C7j]\nKH/Z:\u0011\u0007%\u0011y\"C\u0002\u0003\")\u00111!\u00138u\u0011)\u0011)#!>\u0011\u0002\u0003\u0007!qE\u0001\u000fSN|G.\u0019;j_:dUM^3m!\u0011\u0011ICa\u000b\u000e\u0005\u0005\r\u0017\u0002\u0002B\u0017\u0003\u0007\u0014a\"S:pY\u0006$\u0018n\u001c8MKZ,G\u000eC\u0004\u00032\u0001!IAa\r\u0002\u001f\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$B\"a?\u00036\t]\"\u0011\bB\u001e\u0005{A\u0001\"!4\u00030\u0001\u0007\u0011q\u001a\u0005\t\u0003/\u0014y\u00031\u0001\u0002Z\"A!\u0011\u0002B\u0018\u0001\u0004\u0011Y\u0001\u0003\u0006\u0003\u001c\t=\u0002\u0013!a\u0001\u0005;A!B!\n\u00030A\u0005\t\u0019\u0001B\u0014\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007\nQBZ3uG\"lUm]:bO\u0016\u001cHCDA~\u0005\u000b\u00129Ea\u0013\u0003N\t=#\u0011\u000b\u0005\t\u0003\u001b\u0014y\u00041\u0001\u0002P\"A!\u0011\nB \u0001\u0004\u0011i\"A\u0005sKBd\u0017nY1JI\"A\u0011q\u001bB \u0001\u0004\tI\u000e\u0003\u0005\u0003\n\t}\u0002\u0019\u0001B\u0006\u0011!\u0011YBa\u0010A\u0002\tu\u0001\u0002\u0003B\u0013\u0005\u007f\u0001\rAa\n\t\u000f\tU\u0003\u0001\"\u0003\u0003X\u0005A3/\u001a;vaJ+\u0007\u000f\\5dC6\u000bg.Y4fe^KG\u000f['pG.,G\rU;sO\u0006$xN]5fgR1\u0011q\u001aB-\u0005OB\u0001Ba\u0017\u0003T\u0001\u0007!QL\u0001\u0006i&lWM\u001d\t\u0005\u0005?\u0012\u0019'\u0004\u0002\u0003b)\u0019!1L\u0013\n\t\t\u0015$\u0011\r\u0002\n\u001b>\u001c7\u000eV5nKJD!B!\u001b\u0003TA\u0005\t\u0019\u0001B6\u00039\tG.\u001b<f\u0005J|7.\u001a:JIN\u0004bA!\u001c\u0003x\tua\u0002\u0002B8\u0005grA!!,\u0003r%\t1\"C\u0002\u0003v)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003z\tm$aA*fc*\u0019!Q\u000f\u0006\t\u0013\t}\u0004!%A\u0005\n\t\u0005\u0015aF1qa\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019I\u000b\u0003\u0002\u0002\n\u00155F\u0001BD!\u0011\u0011IIa%\u000e\u0005\t-%\u0002\u0002BG\u0005\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE%\"\u0001\u0006b]:|G/\u0019;j_:LAA!&\u0003\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\te\u0005!%A\u0005\n\tm\u0015!\u00074fi\u000eD\u0017i]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!(+\t\tu!Q\u0011\u0005\n\u0005C\u0003\u0011\u0013!C\u0005\u0005G\u000b\u0011DZ3uG\"\f5oQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!Q\u0015\u0016\u0005\u0005O\u0011)\tC\u0005\u0003*\u0002\t\n\u0011\"\u0003\u0003,\u0006\u00114/\u001a;vaJ+\u0007\u000f\\5dC6\u000bg.Y4fe^KG\u000f['pG.,G\rU;sO\u0006$xN]5fg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003.*\"!1\u000eBC\u0011%\u0011\t\fAI\u0001\n\u0013\u0011Y*A\rgKR\u001c\u0007.Q:G_2dwn^3sI\u0011,g-Y;mi\u0012\"\u0004\"\u0003B[\u0001E\u0005I\u0011\u0002BR\u0003e1W\r^2i\u0003N4u\u000e\u001c7po\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private KafkaZkClient kafkaZkClient;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfRangeSequence)})).getBytes())});
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(response);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$11, x$12);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            ReplicaManager x$21 = replicaManager;
            TopicPartition x$22 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$23 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000);
            IsolationLevel x$24 = IsolationLevel.READ_UNCOMMITTED;
            int x$25 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$21, x$22, x$23, x$25, x$24);
            ReplicaManager x$26 = replicaManager;
            TopicPartition x$27 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$28 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$29 = IsolationLevel.READ_COMMITTED;
            int x$30 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$26, x$27, x$28, x$30, x$29);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$31 = replicaManager;
            TopicPartition x$32 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$33 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$34 = IsolationLevel.READ_COMMITTED;
            int x$35 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$31, x$32, x$33, x$35, x$34);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$36 = replicaManager;
            TopicPartition x$37 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$38 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$39 = IsolationLevel.READ_COMMITTED;
            int x$40 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$36, x$37, x$38, x$40, x$39);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$41 = replicaManager;
            TopicPartition x$42 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$43 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$44 = IsolationLevel.READ_UNCOMMITTED;
            int x$45 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$41, x$42, x$43, x$45, x$44);
            ReplicaManager x$46 = replicaManager;
            TopicPartition x$47 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$48 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$49 = IsolationLevel.READ_COMMITTED;
            int x$50 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$46, x$47, x$48, x$50, x$49);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$13, x$14);
                return BoxedUnit.UNIT;
            });
            replicaManager.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, replicaManager, producerId, epoch, BoxesRunTime.unboxToInt((Object)sequence)));
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$51 = replicaManager;
            TopicPartition x$52 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$53 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000);
            IsolationLevel x$54 = IsolationLevel.READ_UNCOMMITTED;
            int x$55 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$51, x$52, x$53, x$55, x$54);
            ReplicaManager x$56 = replicaManager;
            TopicPartition x$57 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$58 = new FetchRequest.PartitionData(0L, 0L, 100000);
            IsolationLevel x$59 = IsolationLevel.READ_COMMITTED;
            int x$60 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$56, x$57, x$58, x$60, x$59);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(x$15, x$16);
                return BoxedUnit.UNIT;
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(this, rm, BoxesRunTime.unboxToInt((Object)i)));
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$61 = 0;
            boolean x$62 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$61, x$62);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$63 = 0;
            boolean x$64 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$63, x$64);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> {
                ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(x$17, x$18);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(this, replicaManager, tp0, tp1, BoxesRunTime.unboxToInt((Object)i)));
            long x$65 = 1000L;
            int x$66 = 1;
            int x$67 = 0;
            int x$68 = Integer.MAX_VALUE;
            boolean x$69 = false;
            Seq x$70 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000))}));
            Function1 & Serializable & scala.Serializable x$71 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.fetchCallback$1(responseStatus, tp0, tp1);
                return BoxedUnit.UNIT;
            };
            IsolationLevel x$72 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$73 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$65, x$66, x$67, x$68, x$69, x$70, x$73, (Function1)x$71, x$72);
            Option tp0Replica = replicaManager.getReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.getReplica(tp1);
            Option tp1Replica = replicaManager.getReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, boolean isFromClient) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, (short)-1, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    private boolean appendRecords$default$4() {
        return true;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$74 = 1000L;
        int x$75 = replicaId;
        int x$76 = minBytes;
        int x$77 = Integer.MAX_VALUE;
        boolean x$78 = false;
        Seq x$79 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Function1 & Serializable & scala.Serializable x$80 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$2(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        };
        IsolationLevel x$81 = isolationLevel;
        ReplicaQuota x$82 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$74, x$75, x$76, x$77, x$78, x$79, x$82, (Function1)x$80, x$81);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$20 -> new File((String)x$20), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)brokerId), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)brokerId))})), BoxesRunTime.unboxToInt((Object)brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReplicaManagerTest.$anonfun$setupReplicaManagerWithMockedPurgatories$3(metadataCache, BoxesRunTime.unboxToInt((Object)brokerId)));
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$83 = "Produce";
        MockTimer x$84 = timer;
        boolean x$85 = false;
        int x$86 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$87 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$88 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$83, (Timer)x$84, x$86, x$87, x$85, x$88);
        String x$89 = "Fetch";
        MockTimer x$90 = timer;
        boolean x$91 = false;
        int x$92 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$93 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$94 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$89, (Timer)x$90, x$92, x$93, x$91, x$94);
        String x$95 = "DeleteRecords";
        MockTimer x$96 = timer;
        boolean x$97 = false;
        int x$98 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$99 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$100 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$95, (Timer)x$96, x$98, x$99, x$97, x$100);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(ReplicaManagerTest $this, ReplicaManager replicaManager$1, long producerId$1, short epoch$1, int sequence) {
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
        Assert.assertEquals((long)0L, (long)response.logStartOffset);
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, ReplicaManager replicaManager$2, long producerId$2, short epoch$2, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, ReplicaManager replicaManager$3, long producerId$3, short epoch$3, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$3, (short)epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sequence)})).getBytes())});
        return $this.appendRecords(replicaManager$3, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(Iterable x$15, Iterable x$16) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(Iterable x$17, Iterable x$18) {
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(ReplicaManagerTest $this, ReplicaManager replicaManager$4, TopicPartition tp0$1, TopicPartition tp1$1, int i) {
        $this.appendRecords(replicaManager$4, tp0$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(response);
            return BoxedUnit.UNIT;
        });
        return $this.appendRecords(replicaManager$4, tp1$1, TestUtils$.MODULE$.singletonRecords(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)1L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    private static final void fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
        Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$setupReplicaManagerWithMockedPurgatories$3(MetadataCache metadataCache$1, int brokerId) {
        return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$1.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable & scala.Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            block0: {
                this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
                if (!this.isFired()) break block0;
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

