/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.LastChunk;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.PacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.ReceivedPacketReport;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtp.RtpSequenceNumber;
import org.jitsi.rtp.rtp.RtpSequenceNumberKt;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020 J\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020 J\u0006\u0010+\u001a\u00020 J\u0019\u0010,\u001a\u00020(2\n\u0010-\u001a\u00060\u0007j\u0002`.H\u0002\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020$2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0007J\u0006\u00106\u001a\u00020$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacketBuilder;", "", "rtcpHeader", "Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "mediaSourceSsrc", "", "feedbackPacketSeqNum", "", "<init>", "(Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;JI)V", "getRtcpHeader", "()Lorg/jitsi/rtp/rtcp/RtcpHeaderBuilder;", "getMediaSourceSsrc", "()J", "setMediaSourceSsrc", "(J)V", "getFeedbackPacketSeqNum", "()I", "value", "Lorg/jitsi/rtp/rtp/RtpSequenceNumber;", "base_seq_no_", "getBase_seq_no_-Y2GOy3c", "I", "base_time_ticks_", "num_seq_no_", "getNum_seq_no_", "last_chunk_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/LastChunk;", "encoded_chunks_", "", "size_bytes_", "last_timestamp_", "Ljava/time/Instant;", "packets_", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/PacketReport;", "SetBase", "", "base_sequence", "ref_timestamp", "AddReceivedPacket", "", "seqNum", "timestampIn", "BaseTime", "AddDeltaSize", "deltaSize", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/DeltaSize;", "(I)Z", "build", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "writeTo", "buf", "", "offset", "clear", "rtp"})
@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="This class is a port and use the original names.")
@SourceDebugExtension(value={"SMAP\nRtcpFbTccPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpFbTccPacket.kt\norg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacketBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,508:1\n1863#2,2:509\n1863#2,2:511\n*S KotlinDebug\n*F\n+ 1 RtcpFbTccPacket.kt\norg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacketBuilder\n*L\n213#1:509,2\n222#1:511,2\n*E\n"})
public final class RtcpFbTccPacketBuilder {
    @NotNull
    private final RtcpHeaderBuilder rtcpHeader;
    private long mediaSourceSsrc;
    private final int feedbackPacketSeqNum;
    private int base_seq_no_;
    private long base_time_ticks_;
    private int num_seq_no_;
    @NotNull
    private LastChunk last_chunk_;
    @NotNull
    private final List<Integer> encoded_chunks_;
    private int size_bytes_;
    @NotNull
    private Instant last_timestamp_;
    @NotNull
    private final List<PacketReport> packets_;

    public RtcpFbTccPacketBuilder(@NotNull RtcpHeaderBuilder rtcpHeader, long mediaSourceSsrc, int feedbackPacketSeqNum) {
        Intrinsics.checkNotNullParameter(rtcpHeader, "rtcpHeader");
        this.rtcpHeader = rtcpHeader;
        this.mediaSourceSsrc = mediaSourceSsrc;
        this.feedbackPacketSeqNum = feedbackPacketSeqNum;
        this.base_seq_no_ = RtpSequenceNumber.Companion.getINVALID-Y2GOy3c();
        this.base_time_ticks_ = -1L;
        this.last_chunk_ = new LastChunk();
        this.encoded_chunks_ = new ArrayList();
        this.size_bytes_ = 20;
        Instant instant = Instant.EPOCH;
        Intrinsics.checkNotNullExpressionValue(instant, "EPOCH");
        this.last_timestamp_ = instant;
        this.packets_ = new ArrayList();
    }

    public /* synthetic */ RtcpFbTccPacketBuilder(RtcpHeaderBuilder rtcpHeaderBuilder, long l, int n, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 1) != 0) {
            rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, 0L, 63, null);
        }
        if ((n2 & 2) != 0) {
            l = -1L;
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        this(rtcpHeaderBuilder, l, n);
    }

    @NotNull
    public final RtcpHeaderBuilder getRtcpHeader() {
        return this.rtcpHeader;
    }

    public final long getMediaSourceSsrc() {
        return this.mediaSourceSsrc;
    }

    public final void setMediaSourceSsrc(long l) {
        this.mediaSourceSsrc = l;
    }

    public final int getFeedbackPacketSeqNum() {
        return this.feedbackPacketSeqNum;
    }

    public final int getBase_seq_no_-Y2GOy3c() {
        return this.base_seq_no_;
    }

    public final int getNum_seq_no_() {
        return this.num_seq_no_;
    }

    public final void SetBase(int base_sequence, @NotNull Instant ref_timestamp) {
        Intrinsics.checkNotNullParameter(ref_timestamp, "ref_timestamp");
        this.base_seq_no_ = RtpSequenceNumberKt.toRtpSequenceNumber(base_sequence);
        this.base_time_ticks_ = InstantKt.toEpochMicro(ref_timestamp) % DurationKt.toMicros(RtcpFbTccPacket.Companion.getKTimeWrapPeriod()) / DurationKt.toMicros(RtcpFbTccPacket.Companion.getKBaseScaleFactor());
        this.last_timestamp_ = this.BaseTime();
    }

    public final boolean AddReceivedPacket(int seqNum, @NotNull Instant timestampIn) {
        int delta_size;
        Intrinsics.checkNotNullParameter(timestampIn, "timestampIn");
        int sequence_number = RtpSequenceNumberKt.toRtpSequenceNumber(seqNum);
        Instant timestamp = timestampIn;
        if (this.last_timestamp_.compareTo(timestamp) > 0) {
            Duration duration = Duration.between(timestamp, this.last_timestamp_);
            Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
            timestamp = timestamp.plus(DurationKt.roundUpTo(duration, RtcpFbTccPacket.Companion.getKTimeWrapPeriod()));
        }
        Duration duration = Duration.between(this.last_timestamp_, timestamp);
        Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
        long delta_full = DurationKt.toMicros(duration) % DurationKt.toMicros(RtcpFbTccPacket.Companion.getKTimeWrapPeriod());
        if (delta_full > DurationKt.toMicros(RtcpFbTccPacket.Companion.getKTimeWrapPeriod()) / (long)2) {
            delta_full -= DurationKt.toMicros(RtcpFbTccPacket.Companion.getKTimeWrapPeriod());
            delta_full -= DurationKt.toMicros(RtcpFbTccPacket.Companion.getKDeltaScaleFactor()) / (long)2;
        } else {
            delta_full += DurationKt.toMicros(RtcpFbTccPacket.Companion.getKDeltaScaleFactor()) / (long)2;
        }
        short delta = (short)(delta_full /= DurationKt.toMicros(RtcpFbTccPacket.Companion.getKDeltaScaleFactor()));
        if ((long)delta != delta_full) {
            return false;
        }
        int next_seq_no = RtpSequenceNumber.plus-MMyMW7M(this.base_seq_no_, this.num_seq_no_);
        if (!RtpSequenceNumber.equals-impl0(sequence_number, next_seq_no)) {
            int lastSeqNo = RtpSequenceNumber.minus-MMyMW7M(next_seq_no, 1);
            if (RtpSequenceNumber.compareTo-m4k8pQA(sequence_number, lastSeqNo) <= 0) {
                return false;
            }
            while (!RtpSequenceNumber.equals-impl0(next_seq_no, sequence_number)) {
                if (!this.AddDeltaSize(0)) {
                    return false;
                }
                next_seq_no = RtpSequenceNumber.plus-MMyMW7M(next_seq_no, 1);
            }
        }
        int n = delta_size = delta >= 0 && delta <= 255 ? 1 : 2;
        if (!this.AddDeltaSize(delta_size)) {
            return false;
        }
        this.packets_.add(new ReceivedPacketReport(sequence_number, delta));
        this.last_timestamp_ = this.last_timestamp_.plus(DurationKt.times(delta, RtcpFbTccPacket.Companion.getKDeltaScaleFactor()));
        this.size_bytes_ += delta_size;
        return true;
    }

    @NotNull
    public final Instant BaseTime() {
        Instant instant = Instant.EPOCH.plus(DurationKt.times(this.base_time_ticks_, RtcpFbTccPacket.Companion.getKBaseScaleFactor()));
        Intrinsics.checkNotNullExpressionValue(instant, "plus(...)");
        return instant;
    }

    private final boolean AddDeltaSize(int deltaSize) {
        int add_chunk_size;
        if (this.num_seq_no_ == 65535) {
            return false;
        }
        int n = add_chunk_size = this.last_chunk_.Empty() ? 2 : 0;
        if (this.size_bytes_ + deltaSize + add_chunk_size > 1200) {
            return false;
        }
        if (this.last_chunk_.CanAdd(deltaSize)) {
            this.size_bytes_ += add_chunk_size;
            this.last_chunk_.Add(deltaSize);
            ++this.num_seq_no_;
            return true;
        }
        if (this.size_bytes_ + deltaSize + 2 > 1200) {
            return false;
        }
        this.encoded_chunks_.add(this.last_chunk_.Emit());
        this.size_bytes_ += 2;
        this.last_chunk_.Add(deltaSize);
        ++this.num_seq_no_;
        return true;
    }

    @NotNull
    public final RtcpFbTccPacket build() {
        int packetSize = this.size_bytes_ + RtpUtils.Companion.getNumPaddingBytes(this.size_bytes_);
        byte[] buf = BufferPool.Companion.getGetArray().invoke(packetSize);
        this.writeTo(buf, 0);
        return new RtcpFbTccPacket(buf, 0, packetSize);
    }

    public final void writeTo(@NotNull byte[] buf, int offset) {
        RtcpHeaderBuilder rtcpHeaderBuilder;
        Intrinsics.checkNotNullParameter(buf, "buf");
        int paddingBytes = RtpUtils.Companion.getNumPaddingBytes(this.size_bytes_);
        RtcpHeaderBuilder $this$writeTo_u24lambda_u240 = rtcpHeaderBuilder = this.rtcpHeader;
        boolean bl = false;
        $this$writeTo_u24lambda_u240.setPacketType(205);
        $this$writeTo_u24lambda_u240.setReportCount(15);
        $this$writeTo_u24lambda_u240.setLength(RtpUtils.Companion.calculateRtcpLengthFieldValue(this.size_bytes_ + paddingBytes));
        rtcpHeaderBuilder.writeTo(buf, offset);
        RtcpFbPacket.Companion.setMediaSourceSsrc(buf, offset, this.mediaSourceSsrc);
        RtcpFbTccPacket.Companion.setBaseSeqNum(buf, offset, this.base_seq_no_);
        RtcpFbTccPacket.Companion.setPacketStatusCount(buf, offset, this.num_seq_no_);
        RtcpFbTccPacket.Companion.setReferenceTimeTicks(buf, offset, (int)this.base_time_ticks_);
        RtcpFbTccPacket.Companion.setFeedbackPacketCount(buf, offset, this.feedbackPacketSeqNum);
        int currOffset = 0;
        currOffset = 20;
        Iterable $this$forEach$iv = this.encoded_chunks_;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            ByteArrayExtensionsKt.putShort(buf, currOffset, (short)it);
            currOffset += 2;
        }
        if (!this.last_chunk_.Empty()) {
            int chunk = this.last_chunk_.EncodeLast();
            ByteArrayExtensionsKt.putShort(buf, currOffset, (short)chunk);
            currOffset += 2;
        }
        $this$forEach$iv = this.packets_;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketReport it = (PacketReport)element$iv;
            boolean bl3 = false;
            if (!(it instanceof ReceivedPacketReport)) continue;
            int n = ((ReceivedPacketReport)it).getDeltaTicks();
            boolean bl4 = 0 <= n ? n < 256 : false;
            if (bl4) {
                n = currOffset;
                currOffset = n + 1;
                buf[n] = (byte)((ReceivedPacketReport)it).getDeltaTicks();
                continue;
            }
            ByteArrayExtensionsKt.putShort(buf, currOffset, ((ReceivedPacketReport)it).getDeltaTicks());
            currOffset += 2;
        }
        int n = 0;
        while (n < paddingBytes) {
            int it = n++;
            boolean bl5 = false;
            int n2 = currOffset;
            currOffset = n2 + 1;
            buf[n2] = 0;
        }
    }

    public final void clear() {
        this.num_seq_no_ = 0;
        this.size_bytes_ = 20;
    }

    public RtcpFbTccPacketBuilder() {
        this(null, 0L, 0, 7, null);
    }
}

