/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportInstanceConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeConversionTasks
extends BaseCmd {
    public static final String SHOW_TRANSFER_DETAILS = "show-transfer-details";
    public static final String[] SHOW_TRANSFER_DETAILS_DESC = new String[]{"Display additional details for uploading the disk image.", "This information will be retrieved by ec2-upload-disk-image automatically", "and is not required for normal use."};

    public DescribeConversionTasks(String[] args) {
        super("ec2dct", "ec2-describe-conversion-tasks");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)SHOW_TRANSFER_DETAILS);
        OptionBuilder.withDescription((String)DescribeConversionTasks.joinDescription(SHOW_TRANSFER_DETAILS_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected String getOptionString() {
        return "[TASK-ID [TASK-ID [...]]]";
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption(SHOW_TRANSFER_DETAILS);
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your conversion tasks.  If the TASK-ID parameter is");
        System.out.println("     not specified, all of your conversion tasks will be returned.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] taskIds = this.getNonOptions();
        boolean printDetails = this.isOptionSet(SHOW_TRANSFER_DETAILS);
        List rsp = jec2.describeConversionTasks(taskIds);
        if (rsp == null) {
            return true;
        }
        ArrayList<ConversionTaskDescription> imp_i = new ArrayList<ConversionTaskDescription>();
        ArrayList<ConversionTaskDescription> imp_vol = new ArrayList<ConversionTaskDescription>();
        for (ConversionTaskDescription task : rsp) {
            if (task.getTaskType().equals("ImportInstance")) {
                imp_i.add(task);
                continue;
            }
            if (!task.getTaskType().equals("ImportVolume")) continue;
            imp_vol.add(task);
        }
        for (ConversionTaskDescription task : imp_i) {
            ImportInstanceConversionTask impi_task = task.getImportInstanceConversionTask();
            out.output(System.out, task, impi_task, printDetails);
        }
        for (ConversionTaskDescription task : imp_vol) {
            out.output(System.out, task, task.getImportVolumeConversionTask(), printDetails);
        }
        return true;
    }

    public static void main(String[] args) {
        new DescribeConversionTasks(args).invoke();
    }
}

