/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.balancer.rules;

import javax.servlet.http.HttpServletRequest;
import org.apache.webapp.balancer.rules.BaseRule;

public class RemoteAddressRule
extends BaseRule {
    private String remoteAddress;

    public void setRemoteAddress(String theAddress) {
        if (theAddress == null) {
            throw new IllegalArgumentException("The address cannot be null.");
        }
        this.remoteAddress = theAddress;
    }

    protected String getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean matches(HttpServletRequest request) {
        String requestAddr = request.getRemoteAddr();
        return requestAddr.compareTo(this.getRemoteAddress()) == 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        buffer.append("Target remote address: ");
        buffer.append(this.getRemoteAddress());
        buffer.append(" / ");
        buffer.append("Redirect URL: ");
        buffer.append(this.getRedirectUrl());
        buffer.append("]");
        return buffer.toString();
    }
}

