/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.thrift.ITransportFactory;
import org.apache.cassandra.thrift.TFramedTransportFactory;

public class SettingsTransport
implements Serializable {
    private final String fqFactoryClass;
    private final TOptions options;
    private ITransportFactory factory;

    public SettingsTransport(TOptions options) {
        this.options = options;
        this.fqFactoryClass = options.factory.value();
        try {
            Class<?> clazz = Class.forName(this.fqFactoryClass);
            if (!ITransportFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz + " is not a valid transport factory");
            }
            clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid transport factory class: " + options.factory.value(), e);
        }
    }

    private void configureTransportFactory(ITransportFactory transportFactory, TOptions options) {
        HashMap<String, String> factoryOptions = new HashMap<String, String>();
        if (transportFactory.supportedOptions().contains("enc.truststore")) {
            factoryOptions.put("enc.truststore", options.trustStore.value());
        }
        if (transportFactory.supportedOptions().contains("enc.truststore.password")) {
            factoryOptions.put("enc.truststore.password", options.trustStorePw.value());
        }
        if (transportFactory.supportedOptions().contains("enc.keystore")) {
            factoryOptions.put("enc.keystore", options.keyStore.value());
        }
        if (transportFactory.supportedOptions().contains("enc.keystore.password")) {
            factoryOptions.put("enc.keystore.password", options.keyStorePw.value());
        }
        if (transportFactory.supportedOptions().contains("enc.protocol")) {
            factoryOptions.put("enc.protocol", options.protocol.value());
        }
        if (transportFactory.supportedOptions().contains("enc.cipher.suites")) {
            factoryOptions.put("enc.cipher.suites", options.ciphers.value());
        }
        for (String optionKey : transportFactory.supportedOptions()) {
            if (System.getProperty(optionKey) == null) continue;
            factoryOptions.put(optionKey, System.getProperty(optionKey));
        }
        transportFactory.setOptions(factoryOptions);
    }

    public synchronized ITransportFactory getFactory() {
        if (this.factory == null) {
            try {
                this.factory = (ITransportFactory)Class.forName(this.fqFactoryClass).newInstance();
                this.configureTransportFactory(this.factory, this.options);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.factory;
    }

    public EncryptionOptions.ClientEncryptionOptions getEncryptionOptions() {
        EncryptionOptions.ClientEncryptionOptions encOptions = new EncryptionOptions.ClientEncryptionOptions();
        if (this.options.trustStore.present()) {
            encOptions.enabled = true;
            encOptions.truststore = this.options.trustStore.value();
            encOptions.truststore_password = this.options.trustStorePw.value();
            if (this.options.keyStore.present()) {
                encOptions.keystore = this.options.keyStore.value();
                encOptions.keystore_password = this.options.keyStorePw.value();
            } else {
                encOptions.keystore = encOptions.truststore;
                encOptions.keystore_password = encOptions.truststore_password;
            }
            encOptions.algorithm = this.options.alg.value();
            encOptions.protocol = this.options.protocol.value();
            encOptions.cipher_suites = this.options.ciphers.value().split(",");
        }
        return encOptions;
    }

    public static SettingsTransport get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-transport");
        if (params == null) {
            return new SettingsTransport(new TOptions());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new TOptions[]{new TOptions()});
        if (options == null) {
            SettingsTransport.printHelp();
            System.out.println("Invalid -transport options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsTransport((TOptions)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-transport", new TOptions());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsTransport.printHelp();
            }
        };
    }

    static class TOptions
    extends GroupedOptions
    implements Serializable {
        final OptionSimple factory = new OptionSimple("factory=", ".*", TFramedTransportFactory.class.getName(), "Fully-qualified ITransportFactory class name for creating a connection. Note: For Thrift over SSL, use org.apache.cassandra.thrift.SSLTransportFactory.", false);
        final OptionSimple trustStore = new OptionSimple("truststore=", ".*", null, "SSL: full path to truststore", false);
        final OptionSimple trustStorePw = new OptionSimple("truststore-password=", ".*", null, "SSL: truststore password", false);
        final OptionSimple keyStore = new OptionSimple("keystore=", ".*", null, "SSL: full path to keystore", false);
        final OptionSimple keyStorePw = new OptionSimple("keystore-password=", ".*", null, "SSL: keystore password", false);
        final OptionSimple protocol = new OptionSimple("ssl-protocol=", ".*", "TLS", "SSL: connection protocol to use", false);
        final OptionSimple alg = new OptionSimple("ssl-alg=", ".*", "SunX509", "SSL: algorithm", false);
        final OptionSimple storeType = new OptionSimple("store-type=", ".*", "JKS", "SSL: keystore format", false);
        final OptionSimple ciphers = new OptionSimple("ssl-ciphers=", ".*", "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA", "SSL: comma delimited list of encryption suites to use", false);

        TOptions() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.factory, this.trustStore, this.trustStorePw, this.keyStore, this.keyStorePw, this.protocol, this.alg, this.storeType, this.ciphers);
        }
    }
}

