/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
* Portions Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.awt.Component;
import java.io.*;
import javax.swing.*; // JFileChooser, ConfirmDialog, MessageDialog, ...
//import javax.swing.filechooser.FileFilter;

import GoGrinder.Main;

// is it better to split this up? e.g.: FileSelect (J...)
//                                      FileTest (exist, allowed, exec,...)
//                                      FileName (also folder, allowedChar, path length, slashes, quotation marks)
//                               DONE   FileReadWrite (only read write and, as this is also write: copy)
//                                      FileException (IO, Security,...)
//                                      FileFilters


/**
 *
 * @author  Ruediger Klehn
 * @author  tkington
 */
// the old File tasks class beside T.K.'s older FileUtils class
public class FileWorks{ // ###### METHODS FOLLOWING ABC ########

  private static String CurrentDirectory = "";
  private static boolean warnUser = true; // we get handed over, if the user gets warnings from this class
  static final String NL = Main.NEW_LINE;

  public FileWorks(){/*NOTHING*/}
  
  // as we are not sure, if a path from a system variable or Java variable has 
  //   no slash/backslash at the end, we remove this explicitely by getting the 
  //   canonical path of our path
  public static String cleanPath(String cleanThis){
    String cleanedPath = null;
    try { 
      cleanedPath = new File(cleanThis).getCanonicalFile().toString();
    }
    catch(Exception e) { // IOException or SecurityException
      String stackTop = "\n Happened where (~): " + e.getStackTrace()[0];
      String msg = "Error while trying to clean a path string: "
                  + ">" + cleanThis + "<" + NL
                  + "We are going to give back: " + NL
                  + ">" + cleanedPath + "<" + NL
                  + e.getMessage();
      if (Main.DEBUG6) msg = msg + stackTop;
      JOptionPane.showMessageDialog(null, msg); // showOptionDialog  "Continue inspite of this error?" [Yes]/[Exit] (no default)
      ExceptionHandler.logCommonProblem(e, msg);
    }
    if (cleanedPath == null) cleanedPath = cleanThis; // how can this happen? - Oh, when getCanonicalFile fails ...
    return cleanedPath;
  }
  
  public static boolean createFolder(File createThisFolderF){ 
    return createFolder(createThisFolderF.getPath()) ;
  } 
  
  public static boolean createFolder(String createThisFolder){
    File createThisF = new File(createThisFolder);
    boolean success = createThisF.mkdirs(); 
      // here needn't be a msg: if NAME already exists and is folder - no problem; but if NAME is file...
    if (!success){
      JOptionPane.showMessageDialog(null, "There was a problem creating that folder: \n"
                                        + "\"" + createThisFolder + "\""
                                        + "Please check the folder!");
    }
    return success;
  }
  
  // at the moment this is only used for calling the editor
  public static void execute(String[] executeThis, File workingDir){
    try{
      Runtime.getRuntime().exec(executeThis, null, workingDir); 
      // we should have an alternative way here for debugging: capture console/error output (switch: -debug)
    }
    catch(IOException e) {
      String execStrings = "";
      for (int i=0;i<executeThis.length;i++) execStrings = execStrings + executeThis[i] + "\n";
      String msg = Messages.getString("ProbFrame.ErrorLaunchingEditor") + NL
                  + "Command and arguments were (the first line should name the executable): " + NL 
                  + execStrings
                  + "in folder " + NL
                  + workingDir.toString();
      JOptionPane.showMessageDialog(null, msg);
      Main.logEditorProblem(e, msg);
    }
    return;
  }
 
  public static long getFileSize(String ofThisFileStr){
    File ofThisFileF = new File(ofThisFileStr);
    return ofThisFileF.length();
  }
  
  public static String[] listFiles(String listThisPath){
    return new File(listThisPath).list(); // null, if normalFile or ioerror; not ./..; array length = 0, if folder empty
  }

   // THIS IS THE OLD CHOOSER FROM THE MAIN CLASS - there is a redirection to here 
  public static String selectFile(Component owner, FileFilters.GGFileFilter filter, String title, // 5 parameters
                                  boolean save, String buttonText) { // owner: parent frame for setting the chooser 
                                                                     // to the center of the previous window
    // return null; when no file choosen or any other error 
    JFileChooser chooser = new JFileChooser();
    chooser.setDialogTitle(title);
    chooser.setMultiSelectionEnabled(false);
    chooser.setAcceptAllFileFilterUsed(false);
    chooser.setCurrentDirectory(GS.getSaveDir());
    chooser.resetChoosableFileFilters(); // chooser is static, so the filter must be reset
    chooser.setFileFilter(filter);
    chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); // when one file only, then ok
    chooser.setApproveButtonText(buttonText);
    
    int ret;
    if(save) // true = save // false  = load/open
      ret = chooser.showSaveDialog(owner);
    else ret = chooser.showOpenDialog(owner);
    if(ret != JFileChooser.APPROVE_OPTION)
      return null;
    
    File f = chooser.getSelectedFile();
    if (save && f.exists() && !f.canWrite()){
      JOptionPane.showMessageDialog(owner, "Cannot write to file: \n" + f.getPath() + "\n"
                                             + " Write protected? Folder rights? Please select another name or folder");
      return null;
    }
    String fExt;
    if ( !f.getName().endsWith(filter.getExt()) )
      fExt = f.getName() + filter.getExt();
    else fExt = f.getName();
    File fExtFile = new File(fExt);
    if(save) {
      if(f.exists() || fExtFile.exists()) { // the overwrite dialog thing doesn't work correct: 
                                            // if you enter xy as file name, xy.ext is written;
                                            // but not checked correctly for exists (from SelectionDialog, save gxp)
        int choice = JOptionPane.showConfirmDialog(owner,
                            f.getName() + " " + Messages.getString("already_exists_overwrite"),
                            null, JOptionPane.YES_NO_OPTION);
        if(choice == JOptionPane.NO_OPTION || choice == JOptionPane.CLOSED_OPTION)return null;
      }
    } 
    // we need to clear here, if the file is valid for the named purpose (exists, isFile, canRead)
    // so test; when error: ask, if again (see folder)
    else if(!f.exists()) {
      JOptionPane.showMessageDialog(owner, f.getName() + " " + Messages.getString("does_not_exist"));
      return null;
    }
    GS.setSaveDir(chooser.getCurrentDirectory());
    if(!f.getName().toLowerCase().endsWith(filter.getExt()))
      return f.getPath() + filter.getExt();
    return f.getPath();
  }
     
   // 7 parameters // oh! - I don't use this?
  public static File[] selectFiles(Component owner, byte toSelect, FileFilters.GGFileFilter filter, 
                                  String preDefined, boolean save, String caption, String buttonText){
    int chooserResponse = 1; // 1=CANCEL_OPTION - as default
    File[] selectionListMultiF = null;
    File selectionListSingleF;
    JFileChooser myChooser = new JFileChooser();
    myChooser.setDialogTitle(caption);
    myChooser.setCurrentDirectory(GS.getSaveDir());
    myChooser.setFileHidingEnabled(true); // don't show hidden files
    myChooser.setFileFilter(filter);   // folders are not filtered
    myChooser.setAcceptAllFileFilterUsed(false); // true = allow not to filter / show all files ; false = filtered only 
                                                 // (but you can enter a filter in the text field, e.g. * )
      // byte toSelect  // 0=oneFile, 1=oneFolder, 2=oneFileOrFolder, 3=onePlusFiles,
      // 4=onePlusFolders,  5=onePlusFilesOrFolders (mixed allowed)
    
    if (toSelect == 0 || toSelect == 2 || toSelect == 3 || toSelect == 5){
      myChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); // this allows selection!!
       // Java finals: .FILES_ONLY (=0) .DIRECTORIES_ONLY (=1) .FILES_AND_DIRECTORIES (=2)
    }   // these allow display and selection; folders are always shown
    else if (toSelect == 1 || toSelect == 4) myChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY); 
      // else if (toSelect == 0 || toSelect == 3) myChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    if (toSelect == 3 || toSelect == 4 ||  toSelect == 5) myChooser.setMultiSelectionEnabled(true); 
    // then also e.g. combined files + folders
    else myChooser.setMultiSelectionEnabled(false);    
    if (save) chooserResponse = myChooser.showSaveDialog( owner );
    else chooserResponse = myChooser.showOpenDialog( owner );
    
    if ( chooserResponse == JFileChooser.APPROVE_OPTION ){  // -1=ERROR_OPTION, 0=APPROVE_OPTION, 1=CANCEL_OPTION
      if (toSelect == 3 || toSelect == 4 ||  toSelect == 5){
        selectionListMultiF = myChooser.getSelectedFiles(); 
        GS.setSaveDir(myChooser.getCurrentDirectory());
      }
      else{
        selectionListSingleF = myChooser.getSelectedFile();
        selectionListMultiF = new File[1];
        selectionListMultiF[0] = selectionListSingleF;
        GS.setSaveDir(myChooser.getCurrentDirectory());
      }
    }
    else if (chooserResponse == JFileChooser.CANCEL_OPTION){ /*MESSAGE ABORTED*/ }
    else { // -1=ERROR_OPTION
      JOptionPane.showMessageDialog(owner, "There was an error while selecting. \n"
                                         + "Please check the folder.");
    } 

    return selectionListMultiF; // File[]
  }

  // irritating: one time I give back File, another time String (SHOULD BE CONSISTENT!)
  public static File[] selectFolder(int toSelect, String caption, String approveButtTxt, String beginHere, boolean needWrite){
      // 1=oneFolder, 4=onePlusFolders
    if (!beginHere.equals("")) CurrentDirectory = beginHere;
    else CurrentDirectory = Main.USER_HOME; // this happens, when we use the command line switch -validate
    // settings dir would be nicer, but with command line switch -validate (lets 
    // select a folder) the settings folder is still unknown
    int chooserResponse = 1;
    File[] selectedFoldersF = null;
    File selectedFolder;
    JFileChooser selectFolder = new JFileChooser();
    boolean folderGood = false;
    while (!folderGood){ // after the test or abort a continuation "try again"  ("exit" on abort is not good)
      chooserResponse = 1; // -1=ERROR_OPTION, 0=APPROVE_OPTION, 1=CANCEL_OPTION
      selectFolder.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
      if (!CurrentDirectory.equals("")){
        selectFolder.setCurrentDirectory(new File(CurrentDirectory));
        CurrentDirectory = "";
      }
      else{
        selectFolder.setCurrentDirectory(GS.getSaveDir());
      }
      selectFolder.setDialogTitle(caption);
      selectFolder.setApproveButtonText(approveButtTxt); // Use folder // Import folders

      if (toSelect == 4)selectFolder.setMultiSelectionEnabled(true);
      else selectFolder.setMultiSelectionEnabled(false);
      chooserResponse = selectFolder.showOpenDialog(null); 
      if (chooserResponse == JFileChooser.APPROVE_OPTION){
        if (toSelect == 4)
          selectedFoldersF = selectFolder.getSelectedFiles();
        else {
          selectedFolder = selectFolder.getSelectedFile();
          selectedFoldersF = new File[1];
          selectedFoldersF[0] = selectedFolder;
          }
        folderGood = true;
      }
      else {
        selectedFoldersF = new File[1];
        selectedFoldersF[0] = new File("");
        return selectedFoldersF;
      }

      if (toSelect == 1) folderGood = testFolder(selectedFoldersF[0], needWrite); // true: needWrite
    }//while
    GS.setSaveDir(selectFolder.getCurrentDirectory());
    return selectedFoldersF;//File[]
  }//selectFolder
  
  public static boolean testExecutable(){d.b.g("NOT YET");return true;}

  public static boolean testFile(File testThisPathWithFileF, boolean needWrite){
    return testFile(testThisPathWithFileF.getPath(), needWrite);
  }
  
  //public static boolean testFile(String testThisPathWithFile, boolean needWrite, boolean locWarnUser){ // + boolean giveMsg
  //  return testFile(testThisPathWithFile, needWrite, true);
  //}
  
  // testFile is a bit krauty 
  public static boolean testFile(String testThisPathWithFile, boolean needWrite){ // + boolean giveMsg
    // .exists(), .isDirectory(), [.isRegularFile()], .canRead(), .canWrite(), ... 
    // the test for a link file is possible in Java 7   // but you can compare path/file <--> canonical path/file
    File testThis = new File (testThisPathWithFile);
      if (!testThis.exists()) { 
        if (Main.warningsStartup){
          JOptionPane.showMessageDialog(null, testThisPathWithFile + ": \n"
                                       + "File doesn't exist.");
        }
        return false;
      }
      if (testThis.isDirectory()) { 
        JOptionPane.showMessageDialog(null, testThisPathWithFile + ": \n"
                                         + "File is actually a directory.");
        return false;
      }
      if (!testThis.canRead()) { 
        if (Main.warningsStartup){
          JOptionPane.showMessageDialog(null, testThisPathWithFile + ": \n"
                                           + "I cannot read the file.");
        }
        return false;
      }
      if (!testThis.canWrite() && needWrite) { // (needWrite && !path.canWrite())  // this test is irrelevant for import
        JOptionPane.showMessageDialog(null, testThisPathWithFile + ": \n"
                                         + "I need write access to the file.");
        return false;
      }
    return true;
  }
  
  public static boolean testFolder(String path, boolean needWrite){
  return testFolder(new File(path), needWrite);
  }
  
  public static boolean testFolder(String path, boolean needWrite, boolean warnU){
    warnUser = warnU;
  return testFolder(new File(path), needWrite);
  }
  
  public static boolean testFolder(File pathF, boolean needWrite){ // warnUser = false/true
   // exists, isDirectory, read, write, ... // + boolean giveMsg ?
      if (!pathF.exists()) {
//d.b.g("not exist");
        if (warnUser)
          JOptionPane.showMessageDialog(null, pathF.toString() + ": \n"
                                       + "Folder doesn't exist. You need to create it!");
        return false;
      }
      if (!pathF.isDirectory()) {
//d.b.g("not dir");
        if (warnUser)
          JOptionPane.showMessageDialog(null, pathF.toString() + ": \n"
                                         + "That isn't a folder. Please select a valid folder");
        return false;
      }
      if (!pathF.canRead()) {
//d.b.g("not read");
        if (warnUser)
          JOptionPane.showMessageDialog(null, pathF.toString() + ": \n"
                                         + "Cannot read folder. Please select another folder");
        return false;
      }
      if (needWrite && !pathF.canWrite()) {
//d.b.g("not write");
        if (warnUser)
          JOptionPane.showMessageDialog(null, pathF.toString() + ": \n"
                                         + "Cannot write to folder. Please select another folder");
        return false;
      }
      return true;
  }
  
  public static boolean testPortable(){
    File portF = new File (Main.thisProgsFolder + Main.SLASH + "PORTABLE");
      if (portF.exists() && portF.isFile() && new File(Main.thisProgsFolder).canWrite()){ 
      // program's folder is already marked as portable install AND is writable
        Main.PORTABLE = true;
        return true;
      }
    return false;
  }
  
  public static boolean testRunString(){d.b.g("NOT YET");return true;}

}
