/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.TimeWindowedKStream;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KStreamReduce;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamWindowAggregate;
import org.apache.kafka.streams.kstream.internals.KStreamWindowReduce;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.SessionWindowedKStreamImpl;
import org.apache.kafka.streams.kstream.internals.TimeWindowedKStreamImpl;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.WindowStore;

class KGroupedStreamImpl<K, V>
extends AbstractStream<K>
implements KGroupedStream<K, V> {
    static final String REDUCE_NAME = "KSTREAM-REDUCE-";
    static final String AGGREGATE_NAME = "KSTREAM-AGGREGATE-";
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;
    private final boolean repartitionRequired;
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private boolean isQueryable = true;

    KGroupedStreamImpl(InternalStreamsBuilder builder, String name, Set<String> sourceNodes, Serde<K> keySerde, Serde<V> valSerde, boolean repartitionRequired) {
        super(builder, name, sourceNodes);
        this.aggregateBuilder = new GroupedStreamAggregateBuilder<K, V>(builder, keySerde, valSerde, repartitionRequired, sourceNodes, name);
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.repartitionRequired = repartitionRequired;
        this.isQueryable = true;
    }

    private void determineIsQueryable(String queryableStoreName) {
        if (queryableStoreName == null) {
            this.isQueryable = false;
        }
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.reduce(reducer, KGroupedStreamImpl.keyValueStore(this.keySerde, this.valSerde, this.getOrCreateName(queryableStoreName, REDUCE_NAME)));
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer) {
        this.determineIsQueryable(null);
        return this.reduce(reducer, (String)null);
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doAggregate(new KStreamReduce(storeSupplier.name(), reducer), REDUCE_NAME, storeSupplier);
    }

    @Override
    public KTable<K, V> reduce(Reducer<V> reducer, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, V, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, REDUCE_NAME);
        return this.doAggregate(new KStreamReduce(materializedInternal.storeName(), reducer), REDUCE_NAME, materializedInternal);
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Windows<W> windows, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.reduce(reducer, windows, KGroupedStreamImpl.windowedStore(this.keySerde, this.valSerde, windows, this.getOrCreateName(queryableStoreName, REDUCE_NAME)));
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Windows<W> windows) {
        return this.windowedBy(windows).reduce(reducer);
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Windows<W> windows, StateStoreSupplier<WindowStore> storeSupplier) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(windows, "windows can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doAggregate(new KStreamWindowReduce(windows, storeSupplier.name(), reducer), REDUCE_NAME, storeSupplier);
    }

    @Override
    public <T> KTable<K, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Serde<T> aggValueSerde, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.aggregate(initializer, aggregator, KGroupedStreamImpl.keyValueStore(this.keySerde, aggValueSerde, this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)));
    }

    @Override
    public <VR> KTable<K, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        return this.aggregateMaterialized(initializer, aggregator, materialized);
    }

    private <VR> KTable<K, VR> aggregateMaterialized(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Materialized<K, VR, KeyValueStore<Bytes, byte[]>> materialized) {
        MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, AGGREGATE_NAME);
        return this.doAggregate(new KStreamAggregate<K, V, VR>(materializedInternal.storeName(), initializer, aggregator), AGGREGATE_NAME, materializedInternal);
    }

    @Override
    public <VR> KTable<K, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        MaterializedInternal materializedInternal = new MaterializedInternal(Materialized.with(this.keySerde, null), this.builder, AGGREGATE_NAME);
        return this.doAggregate(new KStreamAggregate<K, V, VR>(materializedInternal.storeName(), initializer, aggregator), AGGREGATE_NAME, materializedInternal);
    }

    @Override
    public <T> KTable<K, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Serde<T> aggValueSerde) {
        return this.aggregate(initializer, aggregator, aggValueSerde, (String)null);
    }

    @Override
    public <T> KTable<K, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, StateStoreSupplier<KeyValueStore> storeSupplier) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doAggregate(new KStreamAggregate<K, V, T>(storeSupplier.name(), initializer, aggregator), AGGREGATE_NAME, storeSupplier);
    }

    @Override
    public <W extends Window, T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Windows<W> windows, Serde<T> aggValueSerde, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.aggregate(initializer, aggregator, windows, KGroupedStreamImpl.windowedStore(this.keySerde, aggValueSerde, windows, this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)));
    }

    @Override
    public <W extends Window, T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Windows<W> windows, Serde<T> aggValueSerde) {
        return this.windowedBy(windows).aggregate(initializer, aggregator, Materialized.as(this.builder.newStoreName(AGGREGATE_NAME)).withKeySerde(this.keySerde).withValueSerde(aggValueSerde));
    }

    @Override
    public <W extends Window, T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Windows<W> windows, StateStoreSupplier<WindowStore> storeSupplier) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(windows, "windows can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doAggregate(new KStreamWindowAggregate<K, V, T, W>(windows, storeSupplier.name(), initializer, aggregator), AGGREGATE_NAME, storeSupplier);
    }

    @Override
    public KTable<K, Long> count(String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.count(KGroupedStreamImpl.keyValueStore(this.keySerde, Serdes.Long(), this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)));
    }

    @Override
    public KTable<K, Long> count() {
        return this.count((String)null);
    }

    @Override
    public KTable<K, Long> count(StateStoreSupplier<KeyValueStore> storeSupplier) {
        return this.aggregate((Initializer<T>)this.aggregateBuilder.countInitializer, (Aggregator<? super K, ? super V, T>)this.aggregateBuilder.countAggregator, storeSupplier);
    }

    @Override
    public KTable<K, Long> count(Materialized<K, Long, KeyValueStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, Long, KeyValueStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, KeyValueStore<Bytes, byte[]>>(materialized, this.builder, AGGREGATE_NAME);
        if (materializedInternal.valueSerde() == null) {
            materialized.withValueSerde((Serde<Long>)Serdes.Long());
        }
        return this.aggregate(this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, materialized);
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, Long> count(Windows<W> windows, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.count(windows, KGroupedStreamImpl.windowedStore(this.keySerde, Serdes.Long(), windows, this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)));
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, Long> count(Windows<W> windows) {
        return this.windowedBy(windows).count();
    }

    @Override
    public <W extends Window> KTable<Windowed<K>, Long> count(Windows<W> windows, StateStoreSupplier<WindowStore> storeSupplier) {
        return this.aggregate((Initializer<T>)this.aggregateBuilder.countInitializer, (Aggregator<? super K, ? super V, T>)this.aggregateBuilder.countAggregator, windows, storeSupplier);
    }

    @Override
    public <T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger, SessionWindows sessionWindows, Serde<T> aggValueSerde, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.aggregate(initializer, aggregator, sessionMerger, sessionWindows, aggValueSerde, KGroupedStreamImpl.storeFactory(this.keySerde, aggValueSerde, this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)).sessionWindowed(sessionWindows.maintainMs()).build());
    }

    @Override
    public <T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger, SessionWindows sessionWindows, Serde<T> aggValueSerde) {
        return this.windowedBy(sessionWindows).aggregate(initializer, aggregator, sessionMerger, Materialized.as(this.builder.newStoreName(AGGREGATE_NAME)).withKeySerde(this.keySerde).withValueSerde(aggValueSerde));
    }

    @Override
    public <T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger, SessionWindows sessionWindows, Serde<T> aggValueSerde, StateStoreSupplier<SessionStore> storeSupplier) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(sessionWindows, "sessionWindows can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        return this.doAggregate(new KStreamSessionWindowAggregate<K, V, T>(sessionWindows, storeSupplier.name(), initializer, aggregator, sessionMerger), AGGREGATE_NAME, storeSupplier);
    }

    @Override
    public <W extends Window> TimeWindowedKStream<K, V> windowedBy(Windows<W> windows) {
        return new TimeWindowedKStreamImpl<K, V, W>(windows, this.builder, this.sourceNodes, this.name, this.keySerde, this.valSerde, this.repartitionRequired);
    }

    @Override
    public SessionWindowedKStream<K, V> windowedBy(SessionWindows windows) {
        return new SessionWindowedKStreamImpl<K, V>(windows, this.builder, this.sourceNodes, this.name, this.keySerde, this.valSerde, this.aggregateBuilder);
    }

    @Override
    public KTable<Windowed<K>, Long> count(SessionWindows sessionWindows, String queryableStoreName) {
        Materialized materialized = Materialized.as(this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)).withKeySerde(this.keySerde).withValueSerde(Serdes.Long());
        return this.windowedBy(sessionWindows).count(materialized);
    }

    @Override
    public KTable<Windowed<K>, Long> count(SessionWindows sessionWindows) {
        return this.windowedBy(sessionWindows).count();
    }

    @Override
    public KTable<Windowed<K>, Long> count(SessionWindows sessionWindows, StateStoreSupplier<SessionStore> storeSupplier) {
        Objects.requireNonNull(sessionWindows, "sessionWindows can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Merger sessionMerger = new Merger<K, Long>(){

            @Override
            public Long apply(K aggKey, Long aggOne, Long aggTwo) {
                return aggOne + aggTwo;
            }
        };
        return this.aggregate(this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, sessionMerger, sessionWindows, Serdes.Long(), storeSupplier);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, SessionWindows sessionWindows, String queryableStoreName) {
        this.determineIsQueryable(queryableStoreName);
        return this.reduce(reducer, sessionWindows, KGroupedStreamImpl.storeFactory(this.keySerde, this.valSerde, this.getOrCreateName(queryableStoreName, AGGREGATE_NAME)).sessionWindowed(sessionWindows.maintainMs()).build());
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, SessionWindows sessionWindows) {
        return this.windowedBy(sessionWindows).reduce(reducer);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(final Reducer<V> reducer, SessionWindows sessionWindows, StateStoreSupplier<SessionStore> storeSupplier) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(sessionWindows, "sessionWindows can't be null");
        Objects.requireNonNull(storeSupplier, "storeSupplier can't be null");
        Initializer initializer = new Initializer<V>(){

            @Override
            public V apply() {
                return null;
            }
        };
        final Aggregator aggregator = new Aggregator<K, V, V>(){

            @Override
            public V apply(K aggKey, V value, V aggregate) {
                if (aggregate == null) {
                    return value;
                }
                return reducer.apply(aggregate, value);
            }
        };
        Merger sessionMerger = new Merger<K, V>(){

            @Override
            public V apply(K aggKey, V aggOne, V aggTwo) {
                return aggregator.apply(aggKey, aggTwo, aggOne);
            }
        };
        return this.aggregate(initializer, aggregator, sessionMerger, sessionWindows, this.valSerde, storeSupplier);
    }

    private <T> KTable<K, T> doAggregate(KStreamAggProcessorSupplier<K, ?, V, T> aggregateSupplier, String functionName, MaterializedInternal<K, T, KeyValueStore<Bytes, byte[]>> materializedInternal) {
        StoreBuilder<KeyValueStore<K, T>> storeBuilder = new KeyValueStoreMaterializer<K, T>(materializedInternal).materialize();
        return this.aggregateBuilder.build(aggregateSupplier, functionName, storeBuilder, materializedInternal.isQueryable());
    }

    private <T> KTable<K, T> doAggregate(KStreamAggProcessorSupplier<K, ?, V, T> aggregateSupplier, String functionName, StateStoreSupplier storeSupplier) {
        String aggFunctionName = this.builder.newProcessorName(functionName);
        String sourceName = this.repartitionIfRequired(storeSupplier.name());
        this.builder.internalTopologyBuilder.addProcessor(aggFunctionName, aggregateSupplier, sourceName);
        this.builder.internalTopologyBuilder.addStateStore(storeSupplier, aggFunctionName);
        return new KTableImpl(this.builder, aggFunctionName, aggregateSupplier, sourceName.equals(this.name) ? this.sourceNodes : Collections.singleton(sourceName), storeSupplier.name(), this.isQueryable);
    }

    private String repartitionIfRequired(String queryableStoreName) {
        if (!this.repartitionRequired) {
            return this.name;
        }
        return KStreamImpl.createReparitionedSource(this.builder, this.keySerde, this.valSerde, queryableStoreName, this.name);
    }
}

