/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.admin.RackAwareMode;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004R3tGJL'-Z\"p]N,X.\u001a:He>,\b\u000fV3ti*\u00111\u0001B\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\rD_:\u001cX/\\3s\u000fJ|W\u000f]\"p[6\fg\u000e\u001a+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001bB\t\u0001\u0005\u0004%IAE\u0001\u0014I\u0016\u001c8M]5cKRK\b/Z(gMN,Go]\u000b\u0002'A\u0019AcF\r\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011Q!\u0011:sCf\u00042\u0001F\f\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u0015;sS:<\u0007BB\u0012\u0001A\u0003%1#\u0001\u000beKN\u001c'/\u001b2f)f\u0004Xm\u00144gg\u0016$8\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0003\u0013\u0003M!Wm]2sS\n,G+\u001f9f\u001b\u0016l'-\u001a:t\u0011\u00199\u0003\u0001)A\u0005'\u0005!B-Z:de&\u0014W\rV=qK6+WNY3sg\u0002Bq!\u000b\u0001C\u0002\u0013%!#A\teKN\u001c'/\u001b2f)f\u0004Xm\u0015;bi\u0016Daa\u000b\u0001!\u0002\u0013\u0019\u0012A\u00053fg\u000e\u0014\u0018NY3UsB,7\u000b^1uK\u0002Bq!\f\u0001C\u0002\u0013%!#A\u0007eKN\u001c'/\u001b2f)f\u0004Xm\u001d\u0005\u0007_\u0001\u0001\u000b\u0011B\n\u0002\u001d\u0011,7o\u0019:jE\u0016$\u0016\u0010]3tA!)\u0011\u0007\u0001C\u0001e\u0005YC/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgnZ$s_V\u0004x+\u001b;i\u001f2$7i\u001c8tk6,'\u000fF\u00014!\t!B'\u0003\u00026+\t!QK\\5uQ\u0011\u0001tG\u000f\u001f\u0011\u0005QA\u0014BA\u001d\u0016\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002w\u00051E\u000b[5tAQ,7\u000f\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0013%A\u001f\u0002\u0011Ar\u0013'\r\u00181]AB#\u0001M \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!\u00026v]&$(\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G\u0003\n!A+Z:u\u0011\u0015A\u0005\u0001\"\u00013\u0003!\"Xm\u001d;EKN\u001c'/\u001b2f\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9XSRDw\n\u001c3D_:\u001cX/\\3sQ\u00119uG\u000f\u001f)\u0005\u001d{\u0004\"\u0002'\u0001\t\u0003\u0011\u0014!\u000e;fgR$Um]2sS\n,W\t_5ti&twm\u0012:pkB<\u0016\u000e\u001e5O_6+WNY3sg^KG\u000f[(mI\u000e{gn];nKJDCaS\u001c;y!\u00121j\u0010\u0005\u0006!\u0002!\tAM\u0001=i\u0016\u001cH\u000fR3tGJL'-Z\"p]N,X.\u001a:t/&$\bNT8BgNLwM\\3e!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001f2$7i\u001c8tk6,'\u000f\u000b\u0003Poib\u0004FA(@\u0011\u0015!\u0006\u0001\"\u00013\u0003q!Xm\u001d;EKN\u001c'/\u001b2f\u001d>tW\t_5ti&twm\u0012:pkBD#aU \t\u000b]\u0003A\u0011\u0001\u001a\u0002EQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3XSRDW*\u001e7uSBdWmU;c\u0003\u000e$\u0018n\u001c8tQ\u00111v(\u0017.\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u0005\u0001l&aD(qi&|g.\u0012=dKB$\u0018n\u001c8\t\u000b\t\u0004A\u0011\u0001\u001a\u0002KQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3PM\u001a\u001cX\r^:PM:{g.\u0012=jgRLgnZ$s_V\u0004\bFA1@\u0011\u0015)\u0007\u0001\"\u00013\u0003\u0015\"Xm\u001d;EKN\u001c'/\u001b2f\u001b\u0016l'-\u001a:t\u001f\u001atuN\\#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002e\u007f!)\u0001\u000e\u0001C\u0001e\u0005\u0019C/Z:u\t\u0016\u001c8M]5cKN#\u0018\r^3PM:{g.\u0012=jgRLgnZ$s_V\u0004\bFA4@\u0011\u0015Y\u0007\u0001\"\u00013\u0003e!Xm\u001d;EKN\u001c'/\u001b2f\u000bbL7\u000f^5oO\u001e\u0013x.\u001e9)\u0005)|\u0004\"\u00028\u0001\t\u0003\u0011\u0014A\t;fgR$Um]2sS\n,wJ\u001a4tKR\u001cxJZ#ySN$\u0018N\\4He>,\b\u000f\u000b\u0002n\u007f!)\u0011\u000f\u0001C\u0001e\u0005\u0011C/Z:u\t\u0016\u001c8M]5cK6+WNY3sg>3W\t_5ti&twm\u0012:pkBD#\u0001] \t\u000bQ\u0004A\u0011\u0001\u001a\u0002AQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Ti\u0006$Xm\u00144Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003g~BQa\u001e\u0001\u0005\u0002I\na\u0007^3ti\u0012+7o\u0019:jE\u0016\u001cF/\u0019;f\u001f\u001a,\u00050[:uS:<wI]8va^KG\u000f\u001b*pk:$'k\u001c2j]\u0006\u001b8/[4o_JD#A^ \t\u000bi\u0004A\u0011\u0001\u001a\u0002MQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Fq&\u001cH/\u001b8h\u000fJ|W\u000f],ji\"tu.T3nE\u0016\u00148\u000f\u000b\u0002z\u007f!)Q\u0010\u0001C\u0001e\u0005yC/Z:u\t\u0016\u001c8M]5cK>3gm]3ug>3W\t_5ti&twm\u0012:pkB<\u0016\u000e\u001e5O_6+WNY3sg\"\u0012Ap\u0010\u0005\u0007\u0003\u0003\u0001A\u0011\u0001\u001a\u0002_Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3NK6\u0014WM]:PM\u0016C\u0018n\u001d;j]\u001e<%o\\;q/&$\bNT8NK6\u0014WM]:)\u0005}|\u0004BBA\u0004\u0001\u0011\u0005!'A\u0017uKN$H)Z:de&\u0014Wm\u0015;bi\u0016|e-\u0012=jgRLgnZ$s_V\u0004x+\u001b;i\u001d>lU-\u001c2feND3!!\u0002@\u0011\u0019\ti\u0001\u0001C\u0001e\u0005\u0011D/Z:u\t\u0016\u001c8M]5cK^KG\u000f[\"p]N,X.\u001a:t/&$\bn\\;u\u0003N\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>t7\u000fK\u0002\u0002\f}Ba!a\u0005\u0001\t\u0003\u0011\u0014!\u000f;fgR$Um]2sS\n,wJ\u001a4tKR\u001cx+\u001b;i\u0007>t7/^7feN<\u0016\u000e\u001e5pkR\f5o]5h]\u0016$\u0007+\u0019:uSRLwN\\:)\u0007\u0005Eq\b\u0003\u0004\u0002\u001a\u0001!\tAM\u0001:i\u0016\u001cH\u000fR3tGJL'-Z'f[\n,'o],ji\"\u001cuN\\:v[\u0016\u00148oV5uQ>,H/Q:tS\u001etW\r\u001a)beRLG/[8og\"\u001a\u0011qC \t\r\u0005}\u0001\u0001\"\u00013\u0003]\"Xm\u001d;EKN\u001c'/\u001b2f'R\fG/Z,ji\"\u001cuN\\:v[\u0016\u00148oV5uQ>,H/Q:tS\u001etW\r\u001a)beRLG/[8og\"\u001a\u0011QD \t\r\u0005\u0015\u0002\u0001\"\u00013\u0003]\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.T;mi&\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e\fe\u000eZ'vYRL\u0007\u000f\\3D_:\u001cX/\\3sg\"\u001a\u00111E \t\r\u0005-\u0002\u0001\"\u00013\u0003y\"Xm\u001d;EKN\u001c'/\u001b2f\u001f\u001a47/\u001a;t/&$\b.T;mi&\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e\fe\u000eZ'vYRL\u0007\u000f\\3D_:\u001cX/\\3sg\"\u001a\u0011\u0011F \t\r\u0005E\u0002\u0001\"\u00013\u0003y\"Xm\u001d;EKN\u001c'/\u001b2f\u001b\u0016l'-\u001a:t/&$\b.T;mi&\u0004\u0016M\u001d;ji&|g\u000eV8qS\u000e\fe\u000eZ'vYRL\u0007\u000f\\3D_:\u001cX/\\3sg\"\u001a\u0011qF \t\r\u0005]\u0002\u0001\"\u00013\u0003q\"Xm\u001d;EKN\u001c'/\u001b2f'R\fG/Z,ji\"lU\u000f\u001c;j!\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0003:$W*\u001e7uSBdWmQ8ogVlWM]:)\u0007\u0005Ur\b\u0003\u0004\u0002>\u0001!\tAM\u0001 i\u0016\u001cH\u000fR3tGJL'-Z*j[BdWmQ8ogVlWM]$s_V\u0004\bfAA\u001e\u007f!1\u00111\t\u0001\u0005\u0002I\nq\u0006^3ti\u0012+7o\u0019:jE\u0016<%o\\;q/&$\bn\u00155peRLe.\u001b;jC2L'0\u0019;j_:$\u0016.\\3pkRD3!!\u0011@\u0011\u0019\tI\u0005\u0001C\u0001e\u00051D/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:XSRD7\u000b[8si&s\u0017\u000e^5bY&T\u0018\r^5p]RKW.Z8vi\"\u001a\u0011qI \t\r\u0005=\u0003\u0001\"\u00013\u0003Y\"Xm\u001d;EKN\u001c'/\u001b2f\u000fJ|W\u000f]'f[\n,'o],ji\"\u001c\u0006n\u001c:u\u0013:LG/[1mSj\fG/[8o)&lWm\\;uQ\r\tie\u0010\u0005\u0007\u0003+\u0002A\u0011\u0001\u001a\u0002iQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3He>,\bo\u0015;bi\u0016<\u0016\u000e\u001e5TQ>\u0014H/\u00138ji&\fG.\u001b>bi&|g\u000eV5nK>,H\u000fK\u0002\u0002T}\u0002")
public class DescribeConsumerGroupTest
extends ConsumerGroupCommandTest {
    private final String[][] describeTypeOffsets = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{""}), (String[])((Object[])new String[]{"--offsets"})});
    private final String[][] describeTypeMembers = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"--members"}), (String[])((Object[])new String[]{"--members", "--verbose"})});
    private final String[][] describeTypeState = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"--state"})});
    private final String[][] describeTypes = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeOffsets())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeMembers())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypeState())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));

    private String[][] describeTypeOffsets() {
        return this.describeTypeOffsets;
    }

    private String[][] describeTypeMembers() {
        return this.describeTypeMembers;
    }

    private String[][] describeTypeState() {
        return this.describeTypeState;
    }

    private String[][] describeTypes() {
        return this.describeTypes;
    }

    @Test
    public void testDescribeNonExistingGroupWithOldConsumer() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.createOldConsumer();
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", "missing.group"}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Option)service.collectGroupOffsets()._2()).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected no rows in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeExistingGroupWithOldConsumer() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.createOldConsumer();
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option assignments;
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignments = (Option)tuple2._2();
            Option assignments2 = option;
            return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithOldConsumer$3(this, x$1))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithOldConsumer$4(this, x$2)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithOldConsumer$5(x$3)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rows and a consumer id column in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeExistingGroupWithNoMembersWithOldConsumer() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.createOldConsumer();
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option assignments;
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignments = (Option)tuple2._2();
            Option assignments2 = option;
            return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$3(this, x$4))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$4(this, x$5)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$5(x$6)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rows and a consumer id column in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.stopRandomOldConsumer();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option assignments;
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignments = (Option)tuple2._2();
            Option assignments2 = option;
            return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$8(this, x$7))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$9(this, x$8)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$10(x$9)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected no active member in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.createOldConsumer();
        this.createOldConsumer();
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--describe", "--group", this.group()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option assignments;
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignments = (Option)tuple2._2();
            Option assignments2 = option;
            return assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$3(this, x$10))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$4(this, x))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$5(this, x))) == 1;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rows for consumers with no assigned partitions in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeNonExistingGroup$1(this, missingGroup, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=OptionException.class)
    public void testDescribeWithMultipleSubActions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--members", "--state"});
        this.getConsumerGroupService(cgcArgs);
        throw this.fail("Expected an error due to presence of mutually exclusive options", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    @Test
    public void testDescribeOffsetsOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Tuple2 tuple2 = service.collectGroupOffsets();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the state to be 'Dead', with no members in the group '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), (state2.contains((Object)"Dead") && assignments2.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeMembersOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Tuple2 tuple2 = service.collectGroupMembers(false);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the state to be 'Dead', with no members in the group '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), (state2.contains((Object)"Dead") && assignments2.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
        Tuple2 tuple24 = service.collectGroupMembers(true);
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option state22 = (Option)tuple24._1();
        Option assignments22 = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)state22, (Object)assignments22);
        Tuple2 tuple26 = tuple25;
        Option state23 = (Option)tuple26._1();
        Option assignments23 = (Option)tuple26._2();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the state to be 'Dead', with no members in the group '", "' (verbose option)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), (state23.contains((Object)"Dead") && assignments23.contains((Object)Nil$.MODULE$) ? 1 : 0) != 0);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDescribeStateOfNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "missing.group"});
        service = this.getConsumerGroupService(cgcArgs);
        state = service.collectGroupState();
        v0 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the state to be 'Dead', with no members in the group '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()}));
        v1 = state.state();
        var4_4 = "Dead";
        if (v1 != null ? v1.equals(var4_4) == false : var4_4 != null) ** GOTO lbl-1000
        if (state.numMembers() == 0 && state.coordinator() != null && ((TraversableOnce)this.servers().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDescribeStateOfNonExistingGroup$1$adapted(kafka.server.KafkaServer ), (Lkafka/server/KafkaServer;)Ljava/lang/Object;)(), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Assert.assertTrue((String)v0, (boolean)v2);
    }

    @Test
    public void testDescribeExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroup$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$3(this, x$17))) == 1 && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$4(this, x$18)))).head()).consumerId().exists((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$5(x$19))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$6(this, x$20)))).head()).clientId().exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$7(x$21))) && ((ConsumerGroupCommand.PartitionAssignmentState)((IterableLike)((TraversableLike)assignments2.get()).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$8(this, x$22)))).head()).host().exists((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroup$9(x$23)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a 'Stable' group status, rows and valid values for consumer id / client id / host columns in describe results for group ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeMembersOfExistingGroup() {
        Option assignments;
        Option assignments2;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            if (!state2.contains((Object)"Stable")) return false;
            Option option = assignments2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq memberAssignments = (Seq)some.value();
                if (memberAssignments.count((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$3(this, x$25))) != 1) return false;
                String string = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$4(this, x$26)))).head()).consumerId();
                String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$5(this, x$27)))).head()).clientId();
                String string4 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string3 == null) {
                    if (string4 == null) return false;
                } else if (string3.equals(string4)) return false;
                String string5 = ((ConsumerGroupCommand.MemberAssignmentState)((IterableLike)memberAssignments.filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroup$6(this, x$28)))).head()).host();
                String string6 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
                if (string5 == null) {
                    if (string6 == null) return false;
                    return true;
                } else if (string5.equals(string6)) return false;
                return true;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a 'Stable' group status, rows and valid member information for group ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option option = assignments2 = (Option)tuple2._2();
        Option option2 = assignments = option;
        if (None$.MODULE$.equals(option2)) {
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected partition assignments for members of group ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }
        if (!(option2 instanceof Some)) {
            throw new MatchError((Object)option2);
        }
        Some some = (Some)option2;
        Seq memberAssignments = (Seq)some.value();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a topic partition assigned to the single group member for group ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), (memberAssignments.size() == 1 && ((ConsumerGroupCommand.MemberAssignmentState)memberAssignments.head()).assignment().size() == 1 ? 1 : 0) != 0);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Test
    public void testDescribeStateOfExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "range";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroup$3(x$29)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a 'Stable' group status, with one member and round robin assignment strategy for group ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeStateOfExistingGroupWithRoundRobinAssignor() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        int x$68 = 1;
        String x$69 = RoundRobinAssignor.class.getName();
        String x$70 = this.addConsumerGroupExecutor$default$2();
        String x$71 = this.addConsumerGroupExecutor$default$3();
        this.addConsumerGroupExecutor(x$68, x$70, x$71, x$69);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "roundrobin";
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$3(x$30)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a 'Stable' group status, with one member and round robin assignment strategy for group ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeExistingGroupWithNoMembers$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.exists((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)x$33.exists((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$4($this, x$34)))));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the group to initially become stable, and to find group in assignments after initial offset commit.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        Tuple2 tuple2 = TestUtils$.MODULE$.computeUntilTrue((Function0 & Serializable & scala.Serializable)() -> service.collectGroupOffsets(), TestUtils$.MODULE$.computeUntilTrue$default$2(), TestUtils$.MODULE$.computeUntilTrue$default$3(), (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(this, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 result = (Tuple2)tuple2._1();
        boolean succeeded = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToBoolean((boolean)succeeded));
        Tuple2 tuple23 = tuple22;
        Tuple2 result2 = (Tuple2)tuple23._1();
        boolean succeeded2 = tuple23._2$mcZ$sp();
        Tuple2 tuple24 = result2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Option state = (Option)tuple24._1();
        Option assignments = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple26 = tuple25;
        Option state2 = (Option)tuple26._1();
        Option assignments2 = (Option)tuple26._2();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected no active member in describe group results, state: ", ", assignments: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state2, assignments2})), (boolean)succeeded2);
    }

    @Test
    public void testDescribeMembersOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.exists((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.exists((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersOfExistingGroupWithNoMembers$4($this, x$44)))));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the group to initially become stable, and to find group in assignments after initial offset commit.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Empty") && assignments2.isDefined() && ((SeqLike)assignments2.get()).isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected no member in describe group members results for group '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeStateOfExistingGroupWithNoMembers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 1) return false;
            if (state.coordinator() == null) return false;
            if (!((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfExistingGroupWithNoMembers$3(x$46)), Buffer$.MODULE$.canBuildFrom())).toList().contains((Object)BoxesRunTime.boxToInteger((int)state.coordinator().id()))) return false;
            return true;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the group '", "' to initially become stable, and have a single member."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Empty";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (state.numMembers() != 0) return false;
            String string3 = state.assignmentStrategy();
            String string4 = "";
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected the group '", "' to become empty after the only member leaving."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.group()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(this, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3(this, x$49))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$4(this, x))) == 1;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rows for consumers with no assigned partitions in describe group results", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeMembersWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3(this, x$51))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4(this, x))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(this, x))) == 1 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$6(x$52))) == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected rows for consumers with no assigned partitions in describe group results", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)"Expected additional columns in verbose version of describe members", (state2.contains((Object)"Stable") && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(x$54))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeStateWithConsumersWithoutAssignedPartitions() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(2, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            return !(string != null ? !string.equals(string2) : string2 != null) && state.numMembers() == 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected two consumers in describe group results", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        AdminZkClient qual$1 = this.adminZkClient();
        String x$80 = topic2;
        int x$81 = 2;
        int x$82 = 1;
        Properties x$83 = qual$1.createTopic$default$4();
        RackAwareMode x$84 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$80, x$81, x$82, x$83, x$84);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.describeTypes())).foreach((Function1 & Serializable & scala.Serializable)describeType -> {
            DescribeConsumerGroupTest.$anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(this, topic2, describeType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        AdminZkClient qual$2 = this.adminZkClient();
        String x$85 = topic2;
        int x$86 = 2;
        int x$87 = 1;
        Properties x$88 = qual$2.createTopic$default$4();
        RackAwareMode x$89 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$85, x$86, x$87, x$88, x$89);
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3(this, x$57))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4(this, x))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$5(this, x))) == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected two rows (one row per consumer) in describe group results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        AdminZkClient qual$3 = this.adminZkClient();
        String x$90 = topic2;
        int x$91 = 2;
        int x$92 = 1;
        Properties x$93 = qual$3.createTopic$default$4();
        RackAwareMode x$94 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$90, x$91, x$92, x$93, x$94);
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupMembers(false);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Stable") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$59 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3(this, x$59))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4(this, x))) == 2 && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$5(this, x))) == 0;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected two rows (one row per consumer) in describe group members results.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Tuple2 tuple2 = service.collectGroupMembers(true);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
        Tuple2 tuple23 = tuple22;
        Option state2 = (Option)tuple23._1();
        Option assignments2 = (Option)tuple23._2();
        Assert.assertTrue((String)"Expected additional columns in verbose version of describe members", (state2.contains((Object)"Stable") && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(x$61))) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDescribeStateWithMultiPartitionTopicAndMultipleConsumers() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        AdminZkClient qual$4 = this.adminZkClient();
        String x$95 = topic2;
        int x$96 = 2;
        int x$97 = 1;
        Properties x$98 = qual$4.createTopic$default$4();
        RackAwareMode x$99 = qual$4.createTopic$default$5();
        qual$4.createTopic(x$95, x$96, x$97, x$98, x$99);
        this.addConsumerGroupExecutor(2, topic2, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ConsumerGroupCommand.GroupState state = service.collectGroupState();
            String string = state.state();
            String string2 = "Stable";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = state.group();
            String string4 = this.group();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (state.numMembers() != 2) return false;
            return true;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected a stable group with two members in describe group state result.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeSimpleConsumerGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String topic2 = "foo2";
        AdminZkClient qual$5 = this.adminZkClient();
        String x$100 = topic2;
        int x$101 = 2;
        int x$102 = 1;
        Properties x$103 = qual$5.createTopic$default$4();
        RackAwareMode x$104 = qual$5.createTopic$default$5();
        qual$5.createTopic(x$100, x$101, x$102, x$103, x$104);
        this.addSimpleGroupExecutor((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic2, 0), new TopicPartition(topic2, 1)}))), this.addSimpleGroupExecutor$default$2());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = service.collectGroupOffsets();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option state = (Option)tuple2._1();
            Option assignments = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)state, (Object)assignments);
            Tuple2 tuple23 = tuple22;
            Option state2 = (Option)tuple23._1();
            Option assignments2 = (Option)tuple23._2();
            return state2.contains((Object)"Empty") && assignments2.isDefined() && ((TraversableOnce)assignments2.get()).count((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeSimpleConsumerGroup$3(this, x$63))) == 2;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected a stable group with two members in describe group state result.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDescribeGroupWithShortInitializationTimeout() {
        String[] describeType = this.describeTypes()[Random$.MODULE$.nextInt(this.describeTypes().length)];
        String group = this.group() + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("");
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--timeout", "1", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The consumer group command should have failed due to low initialization timeout (describe type: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    @Test
    public void testDescribeGroupOffsetsWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupOffsets();
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    @Test
    public void testDescribeGroupMembersWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupMembers(false);
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
        }
        catch (TimeoutException timeoutException) {
            try {
                service.collectGroupMembers(true);
                throw this.fail("The consumer group command should fail due to low initialization timeout (verbose)", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            }
            catch (TimeoutException timeoutException2) {
                return;
            }
        }
    }

    @Test
    public void testDescribeGroupStateWithShortInitializationTimeout() {
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", this.group(), "--timeout", "1"});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        try {
            service.collectGroupState();
            throw this.fail("The consumer group command should fail due to low initialization timeout", new Position("DescribeConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        }
        catch (TimeoutException timeoutException) {
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithOldConsumer$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$1) {
        String string = x$1.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithOldConsumer$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$2) {
        String string = x$2.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithOldConsumer$5(String x$3) {
        String string = x$3.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$4) {
        String string = x$4.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$5) {
        String string = x$5.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$5(String x$6) {
        String string = x$6.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$7) {
        String string = x$7.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$9(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$8) {
        String string = x$8.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeExistingGroupWithNoMembersWithOldConsumer$10(String x$9) {
        String string = x$9.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$10) {
        String string = x$10.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeConsumersWithNoAssignedPartitionsWithOldConsumer$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$testDescribeNonExistingGroup$1(DescribeConsumerGroupTest $this, String missingGroup$1, String[] describeType) {
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", missingGroup$1})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected error was not detected for describe option '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), (boolean)output.contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer group '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingGroup$1}))));
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfNonExistingGroup$1(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroup$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = $this.group() + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("");
        int x$64 = 1;
        String x$65 = group;
        String x$66 = $this.addConsumerGroupExecutor$default$2();
        String x$67 = $this.addConsumerGroupExecutor$default$4();
        $this.addConsumerGroupExecutor(x$64, x$66, x$65, x$67);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            return output2.trim().split("\n").length == 2 && error2.isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a data row and no error in describe results with describe type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$17) {
        String string = x$17.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$18) {
        String string = x$18.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$5(String x$19) {
        String string = x$19.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$6(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$20) {
        String string = x$20.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$7(String x$21) {
        String string = x$21.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$22) {
        String string = x$22.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroup$9(String x$23) {
        String string = x$23.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$25) {
        String string = x$25.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$26) {
        String string = x$26.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$27) {
        String string = x$27.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroup$6(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$28) {
        String string = x$28.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroup$3(KafkaServer x$29) {
        return x$29.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithRoundRobinAssignor$3(KafkaServer x$30) {
        return x$30.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeExistingGroupWithNoMembers$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = $this.group() + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("");
        int x$72 = 1;
        String x$73 = group;
        String x$74 = $this.addConsumerGroupExecutor$default$2();
        String x$75 = $this.addConsumerGroupExecutor$default$4();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(x$72, x$74, x$73, x$75);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            return output2.trim().split("\n").length == 2 && error2.isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected describe group results with one data row for describe type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.grabConsoleError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup()).contains(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Consumer group '", "' has no active members."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{group}))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected no active member in describe group results with describe type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$34) {
        String string = x$34.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$36) {
        String string = x$36.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final ConsumerGroupCommand.PartitionAssignmentState assignment$1(Seq testGroupAssignments$1) {
        return (ConsumerGroupCommand.PartitionAssignmentState)testGroupAssignments$1.head();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(String x$37) {
        String string = x$37.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(String x$38) {
        String string = x$38.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(String x$39) {
        String string = x$39.trim();
        String string2 = ConsumerGroupCommand$.MODULE$.MISSING_COLUMN_VALUE();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$6(DescribeConsumerGroupTest $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option state = (Option)tuple2._1();
        Option assignments = (Option)tuple2._2();
        Seq testGroupAssignments = (Seq)Option$.MODULE$.option2Iterable(assignments).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$35 -> (Seq)x$35.filter((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$8($this, x$36))), Seq$.MODULE$.canBuildFrom());
        boolean bl = state.contains((Object)"Empty") && testGroupAssignments.size() == 1 && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).consumerId().exists((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$9(x$37))) && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).clientId().exists((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$10(x$38))) && DescribeConsumerGroupTest.assignment$1(testGroupAssignments).host().exists((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)DescribeConsumerGroupTest.$anonfun$testDescribeOffsetsOfExistingGroupWithNoMembers$11(x$39)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersOfExistingGroupWithNoMembers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$44) {
        String string = x$44.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$testDescribeStateOfExistingGroupWithNoMembers$3(KafkaServer x$46) {
        return x$46.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithConsumersWithoutAssignedPartitions$1(DescribeConsumerGroupTest $this, String[] describeType) {
        String group = $this.group() + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("");
        int x$76 = 2;
        String x$77 = group;
        String x$78 = $this.addConsumerGroupExecutor$default$2();
        String x$79 = $this.addConsumerGroupExecutor$default$4();
        $this.addConsumerGroupExecutor(x$76, x$78, x$77, x$79);
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            int expectedNumRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeMembers())).contains((Object)describeType) ? 3 : 2;
            return error2.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output2.trim().split("\n"))).size() == expectedNumRows;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single data row in describe group result with describe type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$49) {
        String string = x$49.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithConsumersWithoutAssignedPartitions$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$51) {
        String string = x$51.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$6(ConsumerGroupCommand.MemberAssignmentState x$52) {
        return x$52.assignment().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithConsumersWithoutAssignedPartitions$7(ConsumerGroupCommand.MemberAssignmentState x$54) {
        return x$54.assignment().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testDescribeWithMultiPartitionTopicAndMultipleConsumers$1(DescribeConsumerGroupTest $this, String topic2$1, String[] describeType) {
        String group = $this.group() + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString("");
        $this.addConsumerGroupExecutor(2, topic2$1, group, $this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.brokerList(), "--describe", "--group", group})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ConsumerGroupCommand.ConsumerGroupService service = $this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2<String, String> tuple2 = TestUtils$.MODULE$.grabConsoleOutputAndError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.describeGroup());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String output = (String)tuple2._1();
            String error = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)output, (Object)error);
            Tuple2 tuple23 = tuple22;
            String output2 = (String)tuple23._1();
            String error2 = (String)tuple23._2();
            int expectedNumRows = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.describeTypeState())).contains((Object)describeType) ? 2 : 3;
            return error2.isEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output2.trim().split("\n"))).size() == expectedNumRows;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single data row in describe group result with describe type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])describeType)).mkString(" ")})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$57) {
        String string = x$57.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeOffsetsWithMultiPartitionTopicAndMultipleConsumers$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.partition().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x$59) {
        String string = x$59.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$4(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$5(DescribeConsumerGroupTest $this, ConsumerGroupCommand.MemberAssignmentState x) {
        String string = x.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null) && x.numPartitions() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeMembersWithMultiPartitionTopicAndMultipleConsumers$6(ConsumerGroupCommand.MemberAssignmentState x$61) {
        return x$61.assignment().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeSimpleConsumerGroup$3(DescribeConsumerGroupTest $this, ConsumerGroupCommand.PartitionAssignmentState x$63) {
        String string = x$63.group();
        String string2 = $this.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Object $anonfun$testDescribeStateOfNonExistingGroup$1$adapted(KafkaServer x$14) {
        return BoxesRunTime.boxToInteger((int)DescribeConsumerGroupTest.$anonfun$testDescribeStateOfNonExistingGroup$1(x$14));
    }
}

