/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.jitsi.srtp.SrtpPolicy;
import org.jitsi.srtp.crypto.Aes;
import org.jitsi.srtp.crypto.SrtpCipherCtr;

class SrtpKdf {
    static final byte LABEL_RTP_ENCRYPTION = 0;
    static final byte LABEL_RTP_MSG_AUTH = 1;
    static final byte LABEL_RTP_SALT = 2;
    static final byte LABEL_RTCP_ENCRYPTION = 3;
    static final byte LABEL_RTCP_MSG_AUTH = 4;
    static final byte LABEL_RTCP_SALT = 5;
    private final SrtpCipherCtr cipherCtr;
    private final byte[] masterSalt;
    private final byte[] ivStore = new byte[16];

    SrtpKdf(byte[] masterK, byte[] masterS, SrtpPolicy policy) throws GeneralSecurityException {
        int encKeyLength = policy.getEncKeyLength();
        switch (policy.getEncType()) {
            case 1: 
            case 2: 
            case 5: {
                this.cipherCtr = new SrtpCipherCtr(Aes.createCipher("AES/CTR/NoPadding"));
                break;
            }
            case 3: 
            case 4: {
                this.cipherCtr = new SrtpCipherCtr(Cipher.getInstance("Twofish/CTR/NoPadding"));
                break;
            }
            default: {
                this.cipherCtr = null;
            }
        }
        if (this.cipherCtr != null) {
            this.cipherCtr.init(masterK, null);
        }
        int saltKeyLength = policy.getSaltKeyLength();
        this.masterSalt = new byte[saltKeyLength];
        if (saltKeyLength != 0) {
            System.arraycopy(masterS, 0, this.masterSalt, 0, saltKeyLength);
        }
    }

    void deriveSessionKey(byte[] sessKey, byte label) throws GeneralSecurityException {
        if (sessKey == null || sessKey.length == 0) {
            return;
        }
        assert (this.masterSalt.length < this.ivStore.length);
        System.arraycopy(this.masterSalt, 0, this.ivStore, 0, this.masterSalt.length);
        this.ivStore[7] = (byte)(this.ivStore[7] ^ label);
        for (int i = this.masterSalt.length; i < this.ivStore.length; ++i) {
            this.ivStore[i] = 0;
            this.ivStore[i] = 0;
        }
        Arrays.fill(sessKey, (byte)0);
        this.cipherCtr.setIV(this.ivStore, 1);
        this.cipherCtr.process(sessKey, 0, sessKey.length);
    }
}

