/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.twogtp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.twogtp.Compare;
import net.sf.gogui.twogtp.Openings;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public class TwoGtp
extends GtpEngine {
    private final boolean m_alternate;
    private boolean m_gameSaved;
    private boolean m_inconsistentState;
    private final boolean m_isKomiFixed;
    private final boolean m_loadsgf;
    private boolean m_observerIsDisabled;
    private boolean m_refereeIsDisabled;
    private boolean m_resigned;
    private final boolean m_verbose;
    private int m_gameIndex;
    private final int m_numberGames;
    private int m_openingMovesIndex;
    private final int m_size;
    private double m_komi;
    private double m_cpuTimeBlack;
    private double m_cpuTimeWhite;
    private Board m_board;
    private GoColor m_resignColor;
    private GameTree m_gameTree;
    private Node m_currentNode;
    private final Openings m_openings;
    private final String m_blackName;
    private final String m_blackVersion;
    private String m_openingFile;
    private final String m_refereeCommand;
    private final String m_refereeName;
    private final String m_refereeVersion;
    private final String m_sgfFile;
    private final String m_whiteName;
    private final String m_whiteVersion;
    private final ArrayList m_games = new ArrayList(100);
    private ArrayList m_openingMoves;
    private final GtpClient m_black;
    private final GtpClient m_observer;
    private final GtpClient m_referee;
    private final GtpClient m_white;
    private final TimeSettings m_timeSettings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TwoGtp(String string, String string2, String string3, String string4, int n, double d, boolean bl, int n2, boolean bl2, String string5, boolean bl3, boolean bl4, Openings openings, boolean bl5, TimeSettings timeSettings) throws Exception {
        super(null);
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > 25) {
            throw new AssertionError();
        }
        if (string.equals("")) {
            throw new ErrorMessage("No black program set");
        }
        if (string2.equals("")) {
            throw new ErrorMessage("No white program set");
        }
        this.m_sgfFile = string5;
        if (bl3) {
            this.getResultFile().delete();
        }
        this.findInitialGameIndex();
        this.readGames();
        this.m_black = new GtpClient(string, bl4, null);
        this.m_black.setLogPrefix("B");
        this.m_white = new GtpClient(string2, bl4, null);
        this.m_white.setLogPrefix("W");
        this.m_refereeCommand = string3;
        if (!string3.equals("")) {
            this.m_referee = new GtpClient(string3, bl4, null);
            this.m_referee.setLogPrefix("R");
        } else {
            this.m_referee = null;
        }
        if (!string4.equals("")) {
            this.m_observer = new GtpClient(string4, bl4, null);
            this.m_observer.setLogPrefix("O");
        } else {
            this.m_observer = null;
        }
        this.m_inconsistentState = false;
        this.m_black.queryProtocolVersion();
        this.m_white.queryProtocolVersion();
        this.m_blackName = TwoGtp.getName(this.m_black);
        this.m_whiteName = TwoGtp.getName(this.m_white);
        this.m_blackVersion = TwoGtp.getVersion(this.m_black);
        this.m_whiteVersion = TwoGtp.getVersion(this.m_white);
        this.m_black.querySupportedCommands();
        this.m_white.querySupportedCommands();
        this.m_black.queryInterruptSupport();
        this.m_white.queryInterruptSupport();
        if (this.m_referee != null) {
            this.m_referee.queryProtocolVersion();
            this.m_refereeName = TwoGtp.getName(this.m_referee);
            this.m_refereeVersion = TwoGtp.getVersion(this.m_referee);
            this.m_referee.querySupportedCommands();
            this.m_referee.queryInterruptSupport();
        } else {
            this.m_refereeName = null;
            this.m_refereeVersion = null;
        }
        if (this.m_observer != null) {
            this.m_observer.queryProtocolVersion();
            this.m_observer.querySupportedCommands();
            this.m_observer.queryInterruptSupport();
        }
        this.m_size = n;
        this.m_komi = d;
        this.m_isKomiFixed = bl;
        this.m_alternate = bl2;
        this.m_numberGames = n2;
        this.m_openings = openings;
        this.m_verbose = bl4;
        this.m_loadsgf = bl5;
        this.m_timeSettings = timeSettings;
        this.initGame(n);
    }

    public void autoPlay() throws Exception {
        System.in.close();
        StringBuffer stringBuffer = new StringBuffer(256);
        while (this.m_gameIndex < this.m_numberGames) {
            try {
                this.newGame(this.m_size);
                while (!this.gameOver()) {
                    stringBuffer.setLength(0);
                    this.sendGenmove(this.m_board.getToMove(), stringBuffer);
                }
            }
            catch (GtpError gtpError) {
                this.handleEndOfGame(true, gtpError.getMessage());
            }
            if (this.m_black.isProgramDead()) {
                throw new ErrorMessage("Black program died");
            }
            if (!this.m_white.isProgramDead()) continue;
            throw new ErrorMessage("White program died");
        }
        this.m_black.send("quit");
        this.m_white.send("quit");
        this.close();
    }

    public void close() {
        this.m_black.close();
        this.m_white.close();
        if (this.m_referee != null) {
            this.m_referee.close();
        }
        if (this.m_observer != null) {
            this.m_observer.close();
        }
        this.m_black.waitForExit();
        this.m_white.waitForExit();
        if (this.m_referee != null) {
            this.m_referee.waitForExit();
        }
        if (this.m_observer != null) {
            this.m_observer.waitForExit();
        }
    }

    public int gamesLeft() {
        if (this.m_numberGames <= 0) {
            return -1;
        }
        return this.m_numberGames - this.m_gameIndex;
    }

    public void handleCommand(GtpCommand gtpCommand) throws GtpError {
        String string = gtpCommand.getCommand();
        if (string.equals("boardsize")) {
            this.cmdBoardSize(gtpCommand);
        } else if (string.equals("clear_board")) {
            this.cmdClearBoard(gtpCommand);
        } else if (string.equals("final_score")) {
            this.finalStatusCommand(gtpCommand);
        } else if (string.equals("final_status")) {
            this.finalStatusCommand(gtpCommand);
        } else if (string.equals("final_status_list")) {
            this.finalStatusCommand(gtpCommand);
        } else if (!string.equals("gogui_interrupt")) {
            if (string.equals("gogui_title")) {
                gtpCommand.setResponse(this.getTitle());
            } else if (string.equals("loadsgf")) {
                this.sendBoth(gtpCommand.getLine(), true);
            } else if (string.equals("twogtp_black")) {
                this.twogtpColor(this.m_black, gtpCommand);
            } else if (string.equals("twogtp_white")) {
                this.twogtpColor(this.m_white, gtpCommand);
            } else if (string.equals("twogtp_referee")) {
                this.twogtpReferee(gtpCommand);
            } else if (string.equals("twogtp_observer")) {
                this.twogtpObserver(gtpCommand);
            } else if (string.equals("quit")) {
                this.sendBoth("quit", false);
            } else if (string.equals("play")) {
                this.cmdPlay(gtpCommand);
            } else if (string.equals("undo")) {
                this.cmdUndo(gtpCommand);
            } else if (string.equals("genmove")) {
                this.cmdGenmove(gtpCommand);
            } else if (string.equals("komi")) {
                this.komi(gtpCommand);
            } else if (string.equals("scoring_system")) {
                this.sendIfSupported(string, gtpCommand.getLine());
            } else if (string.equals("name")) {
                gtpCommand.setResponse("TwoGtp");
            } else if (string.equals("version")) {
                gtpCommand.setResponse(Version.get());
            } else if (string.equals("protocol_version")) {
                gtpCommand.setResponse("2");
            } else if (string.equals("list_commands")) {
                gtpCommand.setResponse("boardsize\nclear_board\nfinal_score\nfinal_status\nfinal_status_list\ngenmove\ngogui_interrupt\ngogui_title\nkomi\nlist_commands\nloadsgf\nname\nplay\nquit\nscoring_system\ntime_settings\ntwogtp_black\ntwogtp_observer\ntwogtp_referee\ntwogtp_white\nundo\nversion\n");
            } else {
                if (string.equals("genmove_black") || string.equals("genmove_white") || string.equals("black") || string.equals("white") || string.equals("kgs-genmove_cleanup") || string.equals("genmove_cleanup")) {
                    throw new GtpError("unknown command");
                }
                if (string.equals("time_settings")) {
                    this.sendIfSupported(string, gtpCommand.getLine());
                } else {
                    boolean bl = this.m_black.isCommandSupported(string);
                    boolean bl2 = this.m_white.isCommandSupported(string);
                    boolean bl3 = false;
                    if (this.m_referee != null && !this.m_refereeIsDisabled) {
                        bl3 = this.m_referee.isCommandSupported(string);
                    }
                    boolean bl4 = false;
                    if (this.m_observer != null && !this.m_observerIsDisabled) {
                        bl4 = this.m_observer.isCommandSupported(string);
                    }
                    if (bl && !bl4 && !bl2 && !bl3) {
                        this.forward(this.m_black, gtpCommand);
                    }
                    if (bl2 && !bl4 && !bl && !bl3) {
                        this.forward(this.m_white, gtpCommand);
                    }
                    if (bl3 && !bl4 && !bl && !bl2) {
                        this.forward(this.m_referee, gtpCommand);
                    }
                    if (bl4 && !bl3 && !bl && !bl2) {
                        this.forward(this.m_observer, gtpCommand);
                    }
                    if (!(bl3 || bl || bl4 || bl2)) {
                        throw new GtpError("unknown command");
                    }
                    throw new GtpError("use twogtp_black/white/referee/observer");
                }
            }
        }
    }

    public void interruptProgram(GtpClient gtpClient) {
        try {
            if (gtpClient.isInterruptSupported()) {
                gtpClient.sendInterrupt();
            }
        }
        catch (GtpError gtpError) {
            System.err.println(gtpError);
        }
    }

    public void interruptCommand() {
        this.interruptProgram(this.m_black);
        this.interruptProgram(this.m_white);
        if (this.m_referee != null && !this.m_refereeIsDisabled) {
            this.interruptProgram(this.m_referee);
        }
        if (this.m_observer != null && !this.m_observerIsDisabled) {
            this.interruptProgram(this.m_observer);
        }
    }

    private void checkInconsistentState() throws GtpError {
        if (this.m_inconsistentState) {
            throw new GtpError("Inconsistent state");
        }
    }

    private void cmdBoardSize(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(1);
        int n = gtpCommand.getIntArg(0, 1, 25);
        if (n != this.m_size) {
            throw new GtpError("Size must be " + this.m_size);
        }
    }

    private void cmdClearBoard(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        if (this.gamesLeft() == 0) {
            throw new GtpError("Maximum number of " + this.m_numberGames + " games reached");
        }
        this.newGame(this.m_size);
    }

    private void cmdGenmove(GtpCommand gtpCommand) throws GtpError {
        this.sendGenmove(gtpCommand.getColorArg(), gtpCommand.getResponse());
    }

    private void cmdPlay(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkNuArg(2);
        this.checkInconsistentState();
        GoColor goColor = gtpCommand.getColorArg(0);
        GoPoint goPoint = gtpCommand.getPointArg(1, this.m_size);
        Move move = Move.get(goPoint, goColor);
        if (this.m_openings != null && this.m_openingMovesIndex < this.m_openingMoves.size() && !move.equals(this.getOpeningMove(this.m_openingMovesIndex))) {
            throw new GtpError("Move not allowed if openings are used");
        }
        this.sendMove(move);
    }

    private void cmdUndo(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        this.checkInconsistentState();
        this.sendBoth("undo", true);
        this.m_board.undo();
        if (this.m_openings == null || this.m_openingMovesIndex > this.m_openingMoves.size()) {
            this.m_currentNode = this.m_currentNode.getFather();
        }
        if (this.m_openings != null) {
            --this.m_openingMovesIndex;
            if (this.m_openingMovesIndex < 0) {
                this.m_openingMovesIndex = 0;
            }
        }
    }

    private void finalStatusCommand(GtpCommand gtpCommand) throws GtpError {
        if (this.m_referee != null && !this.m_refereeIsDisabled) {
            this.forward(this.m_referee, gtpCommand);
        } else if (this.m_black.isCommandSupported("final_status")) {
            this.forward(this.m_black, gtpCommand);
        } else if (this.m_white.isCommandSupported("final_status")) {
            this.forward(this.m_white, gtpCommand);
        } else {
            throw new GtpError("neither player supports final_status");
        }
    }

    private void findInitialGameIndex() {
        this.m_gameIndex = 0;
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(this.getResultFile());
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                int n;
                if (string.trim().startsWith("#") || (n = Integer.parseInt((stringArray = string.split("\\t"))[0])) + 1 <= this.m_gameIndex) continue;
                this.m_gameIndex = n + 1;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void forward(GtpClient gtpClient, GtpCommand gtpCommand) throws GtpError {
        gtpCommand.setResponse(gtpClient.send(gtpCommand.getLine()));
    }

    private boolean gameOver() {
        return this.m_board.bothPassed() || this.m_resigned;
    }

    private double getCpuTime(GtpClient gtpClient) {
        double d = 0.0;
        try {
            if (gtpClient.isCpuTimeSupported()) {
                d = gtpClient.getCpuTime();
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        return d;
    }

    private File getFile(int n) {
        return new File(this.m_sgfFile + "-" + n + ".sgf");
    }

    private static String getName(GtpClient gtpClient) {
        try {
            String string = gtpClient.send("name");
            if (!string.trim().equals("")) {
                return string;
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        return "Unknown";
    }

    private Move getOpeningMove(int n) {
        return (Move)this.m_openingMoves.get(n);
    }

    private static String getVersion(GtpClient gtpClient) {
        try {
            String string = gtpClient.send("version");
            if (!string.trim().equals("")) {
                return string;
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
        return "";
    }

    private static String getResult(GtpClient gtpClient) {
        try {
            return gtpClient.send("final_score");
        }
        catch (GtpError gtpError) {
            return "?";
        }
    }

    private File getResultFile() {
        return new File(this.m_sgfFile + ".dat");
    }

    private String getTitle() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_blackName;
        String string2 = this.m_whiteName;
        if (string.equals(string2)) {
            if (!this.m_blackVersion.equals("")) {
                string = this.m_blackName + ":" + this.m_blackVersion;
            }
            if (!this.m_whiteVersion.equals("")) {
                string2 = this.m_whiteName + ":" + this.m_whiteVersion;
            }
        }
        if (this.isAlternated()) {
            String string3 = string;
            string = string2;
            string2 = string3;
        }
        string = StringUtils.capitalize(string);
        string2 = StringUtils.capitalize(string2);
        stringBuffer.append(string2);
        stringBuffer.append(" vs ");
        stringBuffer.append(string);
        stringBuffer.append(" (B)");
        if (!this.m_sgfFile.equals("")) {
            stringBuffer.append(" (");
            stringBuffer.append(this.m_gameIndex + 1);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private void handleEndOfGame(boolean bl, String string) {
        try {
            String string2;
            ArrayList arrayList;
            double d;
            double d2;
            String string3;
            String string4;
            String string5;
            block9: {
                if (this.m_resigned) {
                    String string6 = this.m_resignColor == GoColor.BLACK ? "W" : "B";
                    string5 = string6 = string6 + "+R";
                    string4 = string6;
                    string3 = string6;
                } else {
                    string5 = TwoGtp.getResult(this.m_black);
                    string4 = TwoGtp.getResult(this.m_white);
                    string3 = "?";
                    if (this.m_referee != null && !this.m_refereeIsDisabled) {
                        string3 = TwoGtp.getResult(this.m_referee);
                    }
                }
                d2 = Math.max(0.0, this.getCpuTime(this.m_black) - this.m_cpuTimeBlack);
                d = Math.max(0.0, this.getCpuTime(this.m_white) - this.m_cpuTimeWhite);
                this.m_cpuTimeBlack = d2;
                this.m_cpuTimeWhite = d;
                if (this.isAlternated()) {
                    string5 = this.inverseResult(string5);
                    string4 = this.inverseResult(string4);
                    string3 = this.inverseResult(string3);
                }
                arrayList = Compare.getAllAsMoves(this.m_gameTree.getRoot());
                string2 = Compare.checkDuplicate(this.m_board, arrayList, this.m_games, this.m_alternate, this.isAlternated());
                if (this.m_black.isProgramDead() || this.m_white.isProgramDead()) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
            }
            int n = NodeUtils.getMoveNumber(this.m_currentNode);
            this.saveResult(string5, string4, string3, this.isAlternated(), string2, n, bl, string, d2, d);
            this.saveGame(string5, string4, string3);
            ++this.m_gameIndex;
            this.m_games.add(arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Could not save game: " + fileNotFoundException.getMessage());
        }
    }

    private void initGame(int n) throws GtpError {
        this.m_board = new Board(n);
        this.m_gameTree = new GameTree(n, this.m_komi, null, null, null);
        this.m_currentNode = this.m_gameTree.getRoot();
        this.m_resigned = false;
        if (this.m_openings != null) {
            int n2 = this.m_alternate ? this.m_gameIndex / 2 % this.m_openings.getNumber() : this.m_gameIndex % this.m_openings.getNumber();
            try {
                this.m_openings.loadFile(n2);
            }
            catch (Exception exception) {
                throw new GtpError(exception.getMessage());
            }
            this.m_openingFile = this.m_openings.getFilename();
            if (this.m_verbose) {
                System.err.println("Loaded opening " + this.m_openingFile);
            }
            if (this.m_openings.getGameInformation().m_boardSize != n) {
                throw new GtpError("Wrong board size: " + this.m_openingFile);
            }
            this.m_gameTree = this.m_openings.getGameTree();
            if (this.m_isKomiFixed) {
                this.m_gameTree.getGameInformation().m_komi = this.m_komi;
            }
            this.m_openingMoves = Compare.getAllAsMoves(this.m_gameTree.getRoot());
            this.m_openingMovesIndex = 0;
            Node node = this.m_gameTree.getRoot();
            this.m_currentNode = NodeUtils.getLast(node);
            if (this.m_loadsgf) {
                String string = "loadsgf " + this.m_openingFile;
                this.send(this.m_black, this.m_white, string, string, string, string, true);
                this.m_openingMovesIndex = this.m_openingMoves.size();
            }
        }
    }

    private String inverseResult(String string) {
        if (string.indexOf(66) >= 0) {
            return string.replaceAll("B", "W");
        }
        if (string.indexOf(87) >= 0) {
            return string.replaceAll("W", "B");
        }
        return string;
    }

    private boolean isAlternated() {
        return this.m_alternate && this.m_gameIndex % 2 != 0;
    }

    private void komi(GtpCommand gtpCommand) throws GtpError {
        double d;
        if (this.m_isKomiFixed) {
            throw new GtpError("Komi " + this.m_komi + " is fixed by command line option");
        }
        this.m_gameTree.getGameInformation().m_komi = this.m_komi = (d = gtpCommand.getDoubleArg());
        this.sendIfSupported("komi", "komi " + this.m_komi);
    }

    private void mergeResponse(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        boolean bl;
        boolean bl2;
        boolean bl3 = string == null || string.equals("");
        boolean bl4 = bl2 = string2 == null || string2.equals("");
        if (bl3 && bl2) {
            return;
        }
        boolean bl5 = bl = string != null && string.indexOf(10) >= 0 || string2 != null && string2.indexOf(10) >= 0;
        if (!bl3) {
            stringBuffer.append(string3);
            if (bl) {
                stringBuffer.append(":\n");
            } else {
                stringBuffer.append(": ");
            }
            stringBuffer.append(string);
            if (!bl2) {
                if (bl) {
                    stringBuffer.append('\n');
                } else {
                    stringBuffer.append("  ");
                }
            }
        }
        if (!bl2) {
            stringBuffer.append(string4);
            if (bl) {
                stringBuffer.append(":\n");
            } else {
                stringBuffer.append(": ");
            }
            stringBuffer.append(string2);
        }
        if (!$assertionsDisabled && stringBuffer.indexOf("\n\n") >= 0) {
            throw new AssertionError();
        }
    }

    private void newGame(int n) throws GtpError {
        String string;
        this.m_cpuTimeBlack = this.getCpuTime(this.m_black);
        this.m_cpuTimeWhite = this.getCpuTime(this.m_white);
        this.m_black.sendBoardsize(n);
        this.m_black.sendClearBoard(n);
        try {
            this.m_white.sendBoardsize(n);
            this.m_white.sendClearBoard(n);
        }
        catch (GtpError gtpError) {
            this.m_inconsistentState = true;
            throw gtpError;
        }
        if (this.m_referee != null) {
            string = this.m_referee.getCommandBoardsize(n);
            if (string != null) {
                this.sendToReferee(string);
            }
            this.sendToReferee(this.m_referee.getCommandClearBoard(n));
            this.m_refereeIsDisabled = false;
        }
        if (this.m_observer != null) {
            string = this.m_observer.getCommandBoardsize(n);
            if (string != null) {
                this.sendToObserver(string);
            }
            this.sendToObserver(this.m_observer.getCommandClearBoard(n));
            this.m_observerIsDisabled = false;
        }
        this.m_inconsistentState = false;
        this.initGame(n);
        this.m_gameSaved = false;
        this.sendIfSupported("komi", "komi " + this.m_komi);
        if (this.m_timeSettings != null) {
            this.sendIfSupported("time_settings", GtpUtils.getTimeSettingsCommand(this.m_timeSettings));
        }
    }

    private void play(Move move) {
        this.m_board.play(move);
        if (this.m_openings != null) {
            ++this.m_openingMovesIndex;
        }
        if (this.m_openings == null || this.m_openingMovesIndex > this.m_openingMoves.size()) {
            Node node = new Node(move);
            this.m_currentNode.append(node);
            this.m_currentNode = node;
        }
    }

    private void readGames() {
        for (int i = 0; i < this.m_gameIndex; ++i) {
            File file = this.getFile(i);
            if (!file.exists()) {
                System.err.println("Game " + file + " not found");
                continue;
            }
            if (!file.exists()) {
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                SgfReader sgfReader = new SgfReader(fileInputStream, file.toString(), null, 0L);
                Node node = sgfReader.getGameTree().getRoot();
                this.m_games.add(Compare.getAllAsMoves(node));
                continue;
            }
            catch (SgfReader.SgfError sgfError) {
                System.err.println("Error reading " + file + ": " + sgfError.getMessage());
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error reading " + file + ": " + exception.getMessage());
            }
        }
    }

    private void saveGame(String object, String string, String string2) throws FileNotFoundException {
        Object object2;
        if (this.m_sgfFile.equals("")) {
            return;
        }
        String string3 = this.m_blackName;
        if (!this.m_blackVersion.equals("")) {
            string3 = string3 + ":" + this.m_blackVersion;
        }
        String string4 = this.m_whiteName;
        if (!this.m_whiteVersion.equals("")) {
            string4 = string4 + ":" + this.m_whiteVersion;
        }
        String string5 = this.m_black.getProgramCommand();
        String string6 = this.m_white.getProgramCommand();
        if (this.isAlternated()) {
            string3 = this.m_whiteName;
            if (!this.m_whiteVersion.equals("")) {
                string3 = string3 + ":" + this.m_whiteVersion;
            }
            string4 = this.m_blackName;
            if (!this.m_blackVersion.equals("")) {
                string4 = string4 + ":" + this.m_blackVersion;
            }
            string5 = this.m_white.getProgramCommand();
            string6 = this.m_black.getProgramCommand();
            object2 = this.inverseResult(string);
            string = this.inverseResult((String)object);
            object = object2;
            string2 = this.inverseResult(string2);
        }
        object2 = this.m_gameTree.getGameInformation();
        ((GameInformation)object2).m_playerBlack = string3;
        ((GameInformation)object2).m_playerWhite = string4;
        if (this.m_referee != null) {
            ((GameInformation)object2).m_result = string2;
        } else if (((String)object).equals(string) && !((String)object).equals("?")) {
            ((GameInformation)object2).m_result = object;
        }
        String string7 = Platform.getHostInfo();
        String string8 = "Black: " + string5 + "\nWhite: " + string6;
        if (this.m_openings != null) {
            string8 = string8 + "\nOpening: " + this.m_openingFile;
        }
        string8 = string8 + "\nResult[Black]: " + (String)object + "\nResult[White]: " + string;
        if (this.m_referee != null) {
            string8 = string8 + "\nReferee: " + this.m_refereeCommand + "\nResult[Referee]: " + string2;
        }
        string8 = string8 + "\nHost: " + string7 + "\nDate: " + StringUtils.getDate();
        this.m_gameTree.getRoot().setComment(string8);
        File file = this.getFile(this.m_gameIndex);
        if (this.m_verbose) {
            System.err.println("Saving " + file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        new SgfWriter((OutputStream)fileOutputStream, this.m_gameTree, "TwoGtp", Version.get());
    }

    private void saveResult(String string, String string2, String string3, boolean bl, String string4, int n, boolean bl2, String string5, double d, double d2) throws FileNotFoundException {
        Object object;
        OutputStream outputStream;
        Object object2;
        if (this.m_sgfFile.equals("")) {
            return;
        }
        File file = this.getResultFile();
        if (!file.exists()) {
            object2 = new FileOutputStream(file);
            outputStream = new PrintStream((OutputStream)object2);
            object = this.m_blackName;
            String string6 = this.m_whiteName;
            if (!this.m_blackVersion.equals("")) {
                object = this.m_blackName + ":" + this.m_blackVersion;
            }
            if (!this.m_whiteVersion.equals("")) {
                string6 = this.m_whiteName + ":" + this.m_whiteVersion;
            }
            String string7 = "-";
            if (this.m_referee != null) {
                string7 = this.m_refereeName + ":" + this.m_refereeVersion;
            }
            ((PrintStream)outputStream).println("# Black: " + (String)object);
            ((PrintStream)outputStream).println("# White: " + string6);
            ((PrintStream)outputStream).println("# Referee: " + string7);
            ((PrintStream)outputStream).println("# BlackCommand: " + this.m_black.getProgramCommand());
            ((PrintStream)outputStream).println("# WhiteCommand: " + this.m_white.getProgramCommand());
            ((PrintStream)outputStream).println("# RefereeCommand: " + this.m_refereeCommand);
            ((PrintStream)outputStream).println("# Size: " + this.m_size);
            ((PrintStream)outputStream).println("# Komi: " + this.m_komi);
            if (this.m_openings != null) {
                ((PrintStream)outputStream).println("# Openings: " + this.m_openings.getDirectory() + " (" + this.m_openings.getNumber() + " files)");
            }
            ((PrintStream)outputStream).println("# Date: " + StringUtils.getDate());
            ((PrintStream)outputStream).println("# Host: " + Platform.getHostInfo());
            ((PrintStream)outputStream).println("#GAME\tRES_B\tRES_W\tRES_R\tALT\tDUP\tLEN\tCPU_B\tCPU_W\tERR\tERR_MSG");
            ((PrintStream)outputStream).close();
        }
        object2 = StringUtils.getNumberFormat(1);
        outputStream = new FileOutputStream(file, true);
        object = new PrintStream(outputStream);
        ((PrintStream)object).println(Integer.toString(this.m_gameIndex) + "\t" + string + "\t" + string2 + "\t" + string3 + "\t" + (bl ? "1" : "0") + "\t" + string4 + "\t" + n + "\t" + ((NumberFormat)object2).format(d) + "\t" + ((NumberFormat)object2).format(d2) + "\t" + (bl2 ? "1" : "0") + "\t" + string5);
        ((PrintStream)object).close();
    }

    private void send(GtpClient gtpClient, GtpClient gtpClient2, String string, String string2, String string3, String string4, boolean bl) throws GtpError {
        block7: {
            if (!($assertionsDisabled || gtpClient == this.m_black && gtpClient2 == this.m_white || gtpClient == this.m_white && gtpClient2 == this.m_black)) {
                throw new AssertionError();
            }
            if (bl) {
                this.checkInconsistentState();
            }
            try {
                gtpClient.send(string);
            }
            catch (GtpError gtpError) {
                if (!bl) break block7;
                throw gtpError;
            }
        }
        try {
            gtpClient2.send(string2);
        }
        catch (GtpError gtpError) {
            if (bl) {
                this.m_inconsistentState = true;
            }
            throw gtpError;
        }
        this.sendToReferee(string3);
        this.sendToObserver(string4);
    }

    private void sendBoth(String string, boolean bl) throws GtpError {
        this.send(this.m_black, this.m_white, string, string, string, string, bl);
    }

    private void sendGenmove(GoColor goColor, StringBuffer stringBuffer) throws GtpError {
        String string;
        String string2;
        String string3;
        GtpClient gtpClient;
        GtpClient gtpClient2;
        boolean bl;
        this.checkInconsistentState();
        if (this.m_openings != null && this.m_openingMovesIndex < this.m_openingMoves.size() && !this.m_loadsgf) {
            Move move = this.getOpeningMove(this.m_openingMovesIndex);
            if (move.getColor() != goColor) {
                throw new GtpError("Not allowed if openings are used");
            }
            this.sendMove(move);
            stringBuffer.append(GoPoint.toString(move.getPoint()));
            return;
        }
        boolean bl2 = bl = goColor == GoColor.BLACK && this.isAlternated() || goColor == GoColor.WHITE && !this.isAlternated();
        if (bl) {
            gtpClient2 = this.m_white;
            gtpClient = this.m_black;
            string3 = "W";
            string2 = "B";
            string = this.m_white.getCommandGenmove(goColor);
        } else {
            gtpClient2 = this.m_black;
            gtpClient = this.m_white;
            string3 = "B";
            string2 = "W";
            string = this.m_black.getCommandGenmove(goColor);
        }
        String string4 = null;
        String string5 = null;
        string4 = gtpClient2.send(string);
        if (string4.equalsIgnoreCase("resign")) {
            stringBuffer.append("resign");
            this.m_resigned = true;
            this.m_resignColor = goColor;
        } else {
            GoPoint goPoint = null;
            try {
                goPoint = GtpUtils.parsePoint(string4, this.m_board.getSize());
            }
            catch (GtpError gtpError) {
                this.m_inconsistentState = true;
                throw new GtpError(string3 + " played invalid move");
            }
            Move move = Move.get(goPoint, goColor);
            String string6 = gtpClient.getCommandPlay(move);
            try {
                gtpClient.send(string6);
            }
            catch (GtpError gtpError) {
                string5 = gtpError.getMessage();
                try {
                    gtpClient2.send("undo");
                }
                catch (GtpError gtpError2) {
                    this.m_inconsistentState = true;
                }
                this.mergeResponse(stringBuffer, string4, string5, string3, string2);
                throw new GtpError(stringBuffer.toString());
            }
            stringBuffer.append(string4);
            if (this.m_referee != null && !this.m_refereeIsDisabled) {
                this.sendToReferee(this.m_referee.getCommandPlay(move));
            }
            if (this.m_observer != null && !this.m_observerIsDisabled) {
                this.sendToObserver(this.m_observer.getCommandPlay(move));
            }
            this.play(move);
        }
        if (this.gameOver() && !this.m_gameSaved) {
            this.handleEndOfGame(false, "");
            this.m_gameSaved = true;
        }
    }

    private void sendIfSupported(String string, String string2) {
        this.sendIfSupported(this.m_black, string, string2);
        this.sendIfSupported(this.m_white, string, string2);
        if (this.m_referee != null && !this.m_refereeIsDisabled) {
            this.sendIfSupported(this.m_referee, string, string2);
        }
        if (this.m_observer != null && !this.m_observerIsDisabled) {
            this.sendIfSupported(this.m_observer, string, string2);
        }
    }

    private void sendIfSupported(GtpClient gtpClient, String string, String string2) {
        if (!gtpClient.isCommandSupported(string)) {
            return;
        }
        try {
            gtpClient.send(string2);
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    private void sendMove(Move move) throws GtpError {
        String string = this.m_black.getCommandPlay(move);
        String string2 = this.m_white.getCommandPlay(move);
        String string3 = null;
        if (this.m_referee != null) {
            string3 = this.m_referee.getCommandPlay(move);
        }
        String string4 = null;
        if (this.m_observer != null) {
            string4 = this.m_observer.getCommandPlay(move);
        }
        this.send(this.m_black, this.m_white, string, string2, string3, string4, true);
        this.play(move);
    }

    private void sendToObserver(String string) {
        if (this.m_observer == null || this.m_observerIsDisabled) {
            return;
        }
        try {
            this.m_observer.send(string);
        }
        catch (GtpError gtpError) {
            System.err.println("Observer denied " + string + " command: " + gtpError.getMessage() + "\n" + "Disabling observer for this game.");
            this.m_observerIsDisabled = true;
        }
    }

    private void sendToReferee(String string) {
        if (this.m_referee == null || this.m_refereeIsDisabled) {
            return;
        }
        try {
            this.m_referee.send(string);
        }
        catch (GtpError gtpError) {
            System.err.println("Referee denied " + string + " command: " + gtpError.getMessage() + "\n" + "Disabling referee for this game.");
            this.m_refereeIsDisabled = true;
        }
    }

    private void twogtpColor(GtpClient gtpClient, GtpCommand gtpCommand) throws GtpError {
        gtpCommand.setResponse(gtpClient.send(gtpCommand.getArgLine()));
    }

    private void twogtpObserver(GtpCommand gtpCommand) throws GtpError {
        if (this.m_observer == null) {
            throw new GtpError("No observer enabled");
        }
        if (this.m_observerIsDisabled) {
            throw new GtpError("Observer disabled for this game");
        }
        this.twogtpColor(this.m_observer, gtpCommand);
    }

    private void twogtpReferee(GtpCommand gtpCommand) throws GtpError {
        if (this.m_referee == null) {
            throw new GtpError("No referee enabled");
        }
        if (this.m_refereeIsDisabled) {
            throw new GtpError("Referee disabled for this game");
        }
        this.twogtpColor(this.m_referee, gtpCommand);
    }

    static {
        $assertionsDisabled = !TwoGtp.class.desiredAssertionStatus();
    }
}

