/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.gallery.GalleryRemote.Log;
import java.lang.reflect.Method;
import javax.swing.JFrame;

public class MacOSXAdapter
extends ApplicationAdapter {
    private static MacOSXAdapter theAdapter;
    private static Application theApplication;
    private JFrame mainApplication;
    private static String quitMethod;
    private static String preferencesMethod;
    private static String aboutMethod;
    public static final String MODULE = "MacOSX";

    public static void registerMacOSXApplication(JFrame srcApp, String about, String quit, String pref) {
        if (theApplication == null) {
            theApplication = new Application();
        }
        if (theAdapter == null) {
            theAdapter = new MacOSXAdapter(srcApp);
        }
        theApplication.addApplicationListener((ApplicationListener)theAdapter);
        aboutMethod = about;
        quitMethod = quit;
        if (!pref.equalsIgnoreCase("")) {
            theApplication.setEnabledPreferencesMenu(true);
            preferencesMethod = pref;
        }
    }

    public void handleAbout(ApplicationEvent ae) {
        if (this.mainApplication != null) {
            try {
                ae.setHandled(true);
                Class<?> caller = Class.forName(this.mainApplication.getClass().getName());
                Method callMethod = caller.getDeclaredMethod(aboutMethod, null);
                if (callMethod != null) {
                    callMethod.invoke((Object)this.mainApplication, null);
                }
            }
            catch (NoClassDefFoundError e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (ClassNotFoundException e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (Exception e) {
                Log.log((int)1, (String)MODULE, (String)"Exception while loading the MacOSXAdapter:");
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("handleAbout: mainApplication instance detached");
        }
    }

    public void handleQuit(ApplicationEvent ae) {
        if (this.mainApplication != null) {
            try {
                ae.setHandled(false);
                Class<?> caller = Class.forName(this.mainApplication.getClass().getName());
                Method callMethod = caller.getDeclaredMethod(quitMethod, null);
                if (callMethod != null) {
                    callMethod.invoke((Object)this.mainApplication, null);
                }
            }
            catch (NoClassDefFoundError e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (ClassNotFoundException e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (Exception e) {
                Log.log((int)1, (String)MODULE, (String)"Exception while loading the MacOSXAdapter:");
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("handleQuit: mainApplication instance detached");
        }
    }

    public void handlePreferences(ApplicationEvent ae) {
        if (this.mainApplication != null) {
            try {
                Class<?> caller = Class.forName(this.mainApplication.getClass().getName());
                Method callMethod = caller.getDeclaredMethod(preferencesMethod, null);
                if (callMethod != null) {
                    callMethod.invoke((Object)this.mainApplication, null);
                }
                ae.setHandled(true);
            }
            catch (NoClassDefFoundError e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (ClassNotFoundException e) {
                Log.log((int)1, (String)MODULE, (String)("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")"));
            }
            catch (Exception e) {
                Log.log((int)1, (String)MODULE, (String)"Exception while loading the MacOSXAdapter:");
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("handlePreferences: mainApplication instance detached");
        }
    }

    private MacOSXAdapter(JFrame srcApp) {
        this.mainApplication = srcApp;
    }
}

