/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;

public enum LogChunkType {
    ZERO_TYPE(0),
    FULL(1),
    FIRST(2),
    MIDDLE(3),
    LAST(4),
    EOF,
    BAD_CHUNK,
    UNKNOWN;

    private final Integer persistentId;

    public static LogChunkType getLogChunkTypeByPersistentId(int persistentId) {
        for (LogChunkType logChunkType : LogChunkType.values()) {
            if (logChunkType.persistentId == null || logChunkType.persistentId != persistentId) continue;
            return logChunkType;
        }
        return UNKNOWN;
    }

    private LogChunkType() {
        this.persistentId = null;
    }

    private LogChunkType(int persistentId) {
        this.persistentId = persistentId;
    }

    public int getPersistentId() {
        Preconditions.checkArgument((this.persistentId != null ? 1 : 0) != 0, (String)"%s is not a persistent chunk type", (Object[])new Object[]{this.name()});
        return this.persistentId;
    }
}

