/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.util.ArrayList;
import java.util.List;
import jflex.Action;
import jflex.ErrorMessages;
import jflex.GeneratorException;
import jflex.Macros;
import jflex.Out;
import jflex.RegExp;
import jflex.SemCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExps {
    List<Integer> lines;
    List<List<Integer>> states = new ArrayList<List<Integer>>();
    List<RegExp> regExps = new ArrayList<RegExp>();
    List<Action> actions = new ArrayList<Action>();
    List<Boolean> BOL = new ArrayList<Boolean>();
    List<RegExp> look = new ArrayList<RegExp>();
    List<Integer> look_entry;
    int gen_look_count;

    public RegExps() {
        this.lines = new ArrayList<Integer>();
        this.look_entry = new ArrayList<Integer>();
    }

    public int insert(int line, List<Integer> stateList, RegExp regExp, Action action, Boolean isBOL, RegExp lookAhead) {
        this.states.add(stateList);
        this.regExps.add(regExp);
        this.actions.add(action);
        this.BOL.add(isBOL);
        this.look.add(lookAhead);
        this.lines.add(line);
        this.look_entry.add(null);
        return this.states.size() - 1;
    }

    public int insert(List<Integer> stateList, Action action) {
        this.states.add(stateList);
        this.regExps.add(null);
        this.actions.add(action);
        this.BOL.add(null);
        this.look.add(null);
        this.lines.add(null);
        this.look_entry.add(null);
        return this.states.size() - 1;
    }

    public void addStates(int regNum, List<Integer> newStates) {
        this.states.get(regNum).addAll(newStates);
    }

    public int getNum() {
        return this.states.size();
    }

    public boolean isBOL(int num) {
        return this.BOL.get(num);
    }

    public RegExp getLookAhead(int num) {
        return this.look.get(num);
    }

    public boolean isEOF(int num) {
        return this.BOL.get(num) == null;
    }

    public List<Integer> getStates(int num) {
        return this.states.get(num);
    }

    public RegExp getRegExp(int num) {
        return this.regExps.get(num);
    }

    public int getLine(int num) {
        return this.lines.get(num);
    }

    public int getLookEntry(int num) {
        return this.look_entry.get(num);
    }

    public void checkActions() {
        if (this.actions.get(this.actions.size() - 1) == null) {
            Out.error(ErrorMessages.NO_LAST_ACTION);
            throw new GeneratorException();
        }
    }

    public Action getAction(int num) {
        while (num < this.actions.size() && this.actions.get(num) == null) {
            ++num;
        }
        return this.actions.get(num);
    }

    public int NFASize(Macros macros) {
        int size = 0;
        for (RegExp r : this.regExps) {
            if (r == null) continue;
            size += r.size(macros);
        }
        for (RegExp r : this.look) {
            if (r == null) continue;
            size += r.size(macros);
        }
        return size;
    }

    public void checkLookAheads() {
        for (int i = 0; i < this.regExps.size(); ++i) {
            this.lookAheadCase(i);
        }
    }

    private void lookAheadCase(int regExpNum) {
        if (this.getLookAhead(regExpNum) != null) {
            RegExp r1 = this.getRegExp(regExpNum);
            RegExp r2 = this.getLookAhead(regExpNum);
            Action a = this.getAction(regExpNum);
            int len1 = SemCheck.length(r1);
            int len2 = SemCheck.length(r2);
            if (len1 >= 0) {
                a.setLookAction(1, len1);
            } else if (len2 >= 0) {
                a.setLookAction(2, len2);
            } else if (SemCheck.isFiniteChoice(r2)) {
                a.setLookAction(3, 0);
            } else {
                a.setLookAction(4, 0);
                this.look_entry.set(regExpNum, this.gen_look_count);
                ++this.gen_look_count;
            }
        }
    }
}

