/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.SyncUtil;

public class CompressedSegment
extends CommitLogSegment {
    private static final ThreadLocal<ByteBuffer> compressedBufferHolder = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(0);
        }
    };
    static Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    static final int MAX_BUFFERPOOL_SIZE = DatabaseDescriptor.getCommitLogMaxCompressionBuffersInPool();
    static final int COMPRESSED_MARKER_SIZE = 12;
    final ICompressor compressor;
    volatile long lastWrittenPos = 0L;
    static long startMillis = System.currentTimeMillis();

    CompressedSegment(CommitLog commitLog) {
        super(commitLog);
        this.compressor = commitLog.configuration.getCompressor();
        try {
            this.channel.write((ByteBuffer)this.buffer.duplicate().flip());
            this.lastWrittenPos = this.buffer.position();
            commitLog.allocator.addSize(this.lastWrittenPos);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    ByteBuffer allocate(int size) {
        return this.compressor.preferredBufferType().allocate(size);
    }

    @Override
    ByteBuffer createBuffer(CommitLog commitLog) {
        ByteBuffer buf = bufferPool.poll();
        if (buf == null) {
            buf = commitLog.configuration.getCompressor().preferredBufferType().allocate(DatabaseDescriptor.getCommitLogSegmentSize());
        } else {
            buf.clear();
        }
        return buf;
    }

    @Override
    void write(int startMarker, int nextMarker) {
        int contentStart = startMarker + 8;
        int length = nextMarker - contentStart;
        assert (length > 0 || length == 0 && !this.isStillAllocating());
        try {
            int neededBufferSize = this.compressor.initialCompressedBufferLength(length) + 12;
            ByteBuffer compressedBuffer = compressedBufferHolder.get();
            if (this.compressor.preferredBufferType() != BufferType.typeOf(compressedBuffer) || compressedBuffer.capacity() < neededBufferSize) {
                FileUtils.clean(compressedBuffer);
                compressedBuffer = this.allocate(neededBufferSize);
                compressedBufferHolder.set(compressedBuffer);
            }
            ByteBuffer inputBuffer = this.buffer.duplicate();
            inputBuffer.limit(contentStart + length).position(contentStart);
            compressedBuffer.limit(compressedBuffer.capacity()).position(12);
            this.compressor.compress(inputBuffer, compressedBuffer);
            compressedBuffer.flip();
            compressedBuffer.putInt(8, length);
            this.writeSyncMarker(compressedBuffer, 0, (int)this.channel.position(), (int)this.channel.position() + compressedBuffer.remaining());
            this.commitLog.allocator.addSize(compressedBuffer.limit());
            this.channel.write(compressedBuffer);
            assert (this.channel.position() - this.lastWrittenPos == (long)compressedBuffer.limit());
            this.lastWrittenPos = this.channel.position();
            SyncUtil.force(this.channel, true);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    protected void internalClose() {
        if (bufferPool.size() < MAX_BUFFERPOOL_SIZE) {
            bufferPool.add(this.buffer);
        } else {
            FileUtils.clean(this.buffer);
        }
        super.internalClose();
    }

    static void shutdown() {
        bufferPool.clear();
    }

    @Override
    public long onDiskSize() {
        return this.lastWrittenPos;
    }
}

