/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public enum Operator {
    EQ(0){

        @Override
        public String toString() {
            return "=";
        }
    }
    ,
    LT(4){

        @Override
        public String toString() {
            return "<";
        }

        @Override
        public Operator reverse() {
            return GT;
        }
    }
    ,
    LTE(3){

        @Override
        public String toString() {
            return "<=";
        }

        @Override
        public Operator reverse() {
            return GTE;
        }
    }
    ,
    GTE(1){

        @Override
        public String toString() {
            return ">=";
        }

        @Override
        public Operator reverse() {
            return LTE;
        }
    }
    ,
    GT(2){

        @Override
        public String toString() {
            return ">";
        }

        @Override
        public Operator reverse() {
            return LT;
        }
    }
    ,
    IN(7){}
    ,
    CONTAINS(5){}
    ,
    CONTAINS_KEY(6){

        @Override
        public String toString() {
            return "CONTAINS KEY";
        }
    }
    ,
    NEQ(8){

        @Override
        public String toString() {
            return "!=";
        }
    };

    private final int b;

    private Operator(int b) {
        this.b = b;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.b);
    }

    public static Operator readFrom(DataInput input) throws IOException {
        int b = input.readInt();
        for (Operator operator : Operator.values()) {
            if (operator.b != b) continue;
            return operator;
        }
        throw new IOException(String.format("Cannot resolve Relation.Type from binary representation: %s", b));
    }

    public String toString() {
        return this.name();
    }

    public Operator reverse() {
        return this;
    }
}

