/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.CompatibleAnalyser;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.search.QueryBuilder;
import org.opensolaris.opengrok.search.Summarizer;
import org.opensolaris.opengrok.search.context.Context;
import org.opensolaris.opengrok.search.context.HistoryContext;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.web.EftarFileReader;
import org.opensolaris.opengrok.web.Prefix;
import org.opensolaris.opengrok.web.SortOrder;
import org.opensolaris.opengrok.web.Suggestion;
import org.opensolaris.opengrok.web.Util;

public class SearchHelper {
    public int SPELLCHECK_SUGGEST_WORD_COUNT = 5;
    public File dataRoot;
    public String contextPath;
    public boolean compressed;
    public File sourceRoot;
    public EftarFileReader desc;
    public int start;
    public int maxItems;
    public QueryBuilder builder;
    public SortOrder order;
    public boolean parallel;
    public boolean isCrossRefSearch;
    public String redirect;
    public String errorMsg;
    public IndexSearcher searcher;
    public ScoreDoc[] hits;
    public int totalHits;
    public Query query;
    protected Sort sort;
    protected DirectSpellChecker checker;
    public SortedSet<String> projects;
    public Context sourceContext = null;
    public Summarizer summerizer = null;
    public HistoryContext historyContext;
    private static final Map<String, String> fileTypeDescription;
    public static final String PARSE_ERROR_MSG = "Unable to parse your query: ";
    private ExecutorService executor = null;
    private static final Logger log;
    File indexDir;
    private static final Pattern TABSPACE;

    public static Set<Map.Entry<String, String>> getFileTypeDescirptions() {
        return fileTypeDescription.entrySet();
    }

    public SearchHelper prepareExec(SortedSet<String> projects) {
        if (this.redirect != null || this.errorMsg != null) {
            return this;
        }
        try {
            this.indexDir = new File(this.dataRoot, "index");
            this.query = this.builder.build();
            if (projects == null) {
                this.errorMsg = "No project selected!";
                return this;
            }
            this.projects = projects;
            if (projects.isEmpty()) {
                FSDirectory dir = FSDirectory.open((File)this.indexDir);
                this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)dir));
            } else if (projects.size() == 1) {
                FSDirectory dir = FSDirectory.open((File)new File(this.indexDir, projects.first()));
                this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)dir));
            } else {
                IndexReader[] subreaders = new IndexReader[projects.size()];
                int ii = 0;
                for (String proj : projects) {
                    FSDirectory dir = FSDirectory.open((File)new File(this.indexDir, proj));
                    subreaders[ii++] = DirectoryReader.open((Directory)dir);
                }
                MultiReader searchables = new MultiReader(subreaders, true);
                if (this.parallel) {
                    int noThreads = 2 + 2 * Runtime.getRuntime().availableProcessors();
                    this.executor = Executors.newFixedThreadPool(noThreads);
                }
                this.searcher = this.parallel ? new IndexSearcher((IndexReader)searchables, this.executor) : new IndexSearcher((IndexReader)searchables);
            }
            switch (this.order) {
                case LASTMODIFIED: {
                    this.sort = new Sort(new SortField("date", SortField.Type.STRING, true));
                    break;
                }
                case BY_PATH: {
                    this.sort = new Sort(new SortField("fullpath", SortField.Type.STRING));
                    break;
                }
                default: {
                    this.sort = Sort.RELEVANCE;
                }
            }
            this.checker = new DirectSpellChecker();
        }
        catch (ParseException e) {
            this.errorMsg = PARSE_ERROR_MSG + e.getMessage();
        }
        catch (FileNotFoundException e) {
            this.errorMsg = "Index database(s) not found.";
        }
        catch (Exception e) {
            this.errorMsg = e.getMessage();
        }
        return this;
    }

    public SearchHelper executeQuery() {
        if (this.redirect != null || this.errorMsg != null) {
            return this;
        }
        try {
            String symbol;
            byte[] rawTags;
            Definitions tags;
            Document doc;
            TopFieldDocs fdocs = this.searcher.search(this.query, null, this.start + this.maxItems, this.sort);
            this.totalHits = fdocs.totalHits;
            this.hits = fdocs.scoreDocs;
            boolean isSingleDefinitionSearch = this.query instanceof TermQuery && this.builder.getDefs() != null;
            boolean uniqueDefinition = false;
            if (isSingleDefinitionSearch && this.hits != null && this.hits.length == 1 && (doc = this.searcher.doc(this.hits[0].doc)).getField("tags") != null && (tags = Definitions.deserialize(rawTags = doc.getField((String)"tags").binaryValue().bytes)).occurrences(symbol = ((TermQuery)this.query).getTerm().text()) == 1) {
                uniqueDefinition = true;
            }
            if (uniqueDefinition && this.hits != null && this.hits.length > 0 && this.isCrossRefSearch) {
                this.redirect = this.contextPath + (Object)((Object)Prefix.XREF_P) + Util.URIEncodePath(this.searcher.doc(this.hits[0].doc).get("path")) + '#' + Util.URIEncode(((TermQuery)this.query).getTerm().text());
            }
        }
        catch (BooleanQuery.TooManyClauses e) {
            this.errorMsg = "Too many results for wildcard!";
        }
        catch (Exception e) {
            this.errorMsg = e.getMessage();
        }
        return this;
    }

    private void getSuggestion(Term term, IndexReader ir, List<String> result) throws IOException {
        if (term == null) {
            return;
        }
        String[] toks = TABSPACE.split(term.text(), 0);
        for (int j = 0; j < toks.length; ++j) {
            SuggestWord[] words;
            for (SuggestWord w : words = this.checker.suggestSimilar(new Term(term.field(), toks[j]), this.SPELLCHECK_SUGGEST_WORD_COUNT, ir, SuggestMode.SUGGEST_ALWAYS)) {
                result.add(w.string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Suggestion> getSuggestions() {
        String[] name;
        if (this.projects == null) {
            return new ArrayList<Suggestion>(0);
        }
        if (this.projects.isEmpty()) {
            name = new String[]{"/"};
        } else if (this.projects.size() == 1) {
            name = new String[]{this.projects.first()};
        } else {
            name = new String[this.projects.size()];
            int ii = 0;
            for (String proj : this.projects) {
                name[ii++] = proj;
            }
        }
        ArrayList<Suggestion> res = new ArrayList<Suggestion>();
        ArrayList<String> dummy = new ArrayList<String>();
        DirectoryReader ir = null;
        for (int idx = 0; idx < name.length; ++idx) {
            Suggestion s = new Suggestion(name[idx]);
            try {
                Term t;
                FSDirectory dir = FSDirectory.open((File)new File(this.indexDir, name[idx]));
                ir = DirectoryReader.open((Directory)dir);
                if (this.builder.getFreetext() != null && !this.builder.getFreetext().isEmpty()) {
                    t = new Term("full", this.builder.getFreetext());
                    this.getSuggestion(t, (IndexReader)ir, dummy);
                    s.freetext = dummy.toArray(new String[dummy.size()]);
                    dummy.clear();
                }
                if (this.builder.getRefs() != null && !this.builder.getRefs().isEmpty()) {
                    t = new Term("refs", this.builder.getRefs());
                    this.getSuggestion(t, (IndexReader)ir, dummy);
                    s.refs = dummy.toArray(new String[dummy.size()]);
                    dummy.clear();
                }
                if (this.builder.getDefs() != null && !this.builder.getDefs().isEmpty()) {
                    t = new Term("defs", this.builder.getDefs());
                    this.getSuggestion(t, (IndexReader)ir, dummy);
                    s.defs = dummy.toArray(new String[dummy.size()]);
                    dummy.clear();
                }
                if (!(s.freetext != null && s.freetext.length > 0 || s.defs != null && s.defs.length > 0) && (s.refs == null || s.refs.length <= 0)) continue;
                res.add(s);
                continue;
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Got exception while getting spelling suggestions: ", e);
                continue;
            }
            finally {
                if (ir != null) {
                    try {
                        ir.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.WARNING, "Got exception while getting spelling suggestions: ", ex);
                    }
                }
            }
        }
        return res;
    }

    public SearchHelper prepareSummary() {
        if (this.redirect != null || this.errorMsg != null) {
            return this;
        }
        try {
            this.sourceContext = new Context(this.query, this.builder.getQueries());
            this.summerizer = new Summarizer(this.query, new CompatibleAnalyser());
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Summerizer: {0}", e.getMessage());
        }
        try {
            this.historyContext = new HistoryContext(this.query);
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "HistoryContext: {0}", e.getMessage());
        }
        return this;
    }

    public void destroy() {
        block4: {
            if (this.searcher != null) {
                IOUtils.close((Closeable)this.searcher.getIndexReader());
            }
            if (this.executor != null) {
                try {
                    this.executor.shutdown();
                }
                catch (SecurityException se) {
                    log.warning(se.getLocalizedMessage());
                    if (!log.isLoggable(Level.FINE)) break block4;
                    log.log(Level.FINE, "destroy", se);
                }
            }
        }
    }

    static {
        log = Logger.getLogger(SearchHelper.class.getName());
        fileTypeDescription = new TreeMap<String, String>();
        fileTypeDescription.put("xml", "XML");
        fileTypeDescription.put("troff", "Troff");
        fileTypeDescription.put("elf", "ELF");
        fileTypeDescription.put("javaclass", "Java class");
        fileTypeDescription.put("image", "Image file");
        fileTypeDescription.put("c", "C");
        fileTypeDescription.put("csharp", "C#");
        fileTypeDescription.put("vb", "Visual Basic");
        fileTypeDescription.put("cxx", "C++");
        fileTypeDescription.put("sh", "Shell script");
        fileTypeDescription.put("java", "Java");
        fileTypeDescription.put("javascript", "JavaScript");
        fileTypeDescription.put("python", "Python");
        fileTypeDescription.put("perl", "Perl");
        fileTypeDescription.put("php", "PHP");
        fileTypeDescription.put("lisp", "Lisp");
        fileTypeDescription.put("tcl", "Tcl");
        fileTypeDescription.put("scala", "Scala");
        fileTypeDescription.put("sql", "SQL");
        fileTypeDescription.put("plsql", "PL/SQL");
        fileTypeDescription.put("fortran", "Fortran");
        TABSPACE = Pattern.compile("[\t ]+");
    }
}

