/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.web.EftarFileReader;
import org.opensolaris.opengrok.web.Util;

public class DirectoryListing {
    private final EftarFileReader desc;
    private final long now;

    public DirectoryListing() {
        this.desc = null;
        this.now = System.currentTimeMillis();
    }

    public DirectoryListing(EftarFileReader desc) {
        this.desc = desc;
        this.now = System.currentTimeMillis();
    }

    private void PrintDateSize(Writer out, File child, Date modTime, Format dateFormatter) throws IOException {
        long lastm = modTime == null ? child.lastModified() : modTime.getTime();
        out.write("<td>");
        if (this.now - lastm < 86400000L) {
            out.write("Today");
        } else {
            out.write(dateFormatter.format(lastm));
        }
        out.write("</td><td>");
        out.write(Util.readableSize(child.length()));
        out.write("</td>");
    }

    public List<String> listTo(String contextPath, File dir, Writer out, String path, List<String> files) throws HistoryException, IOException {
        ArrayList<String> readMes = new ArrayList<String>();
        int offset = -1;
        EftarFileReader.FNode parentFNode = null;
        if (this.desc != null && (parentFNode = this.desc.getNode(path)) != null) {
            offset = parentFNode.childOffset;
        }
        out.write("<table id=\"dirlist\">\n");
        out.write("<thead>\n<tr><th/><th>Name</th><th></th><th>Date</th><th>Size</th>");
        if (offset > 0) {
            out.write("<th><tt>Description</tt></th>");
        }
        out.write("</tr>\n</thead>\n<tbody>\n");
        IgnoredNames ignoredNames = RuntimeEnvironment.getInstance().getIgnoredNames();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());
        if (path.length() != 0) {
            out.write("<tr><td><p class=\"'r'\"/></td><td>");
            out.write("<b><a href=\"..\">..</a></b></td><td></td>");
            this.PrintDateSize(out, dir.getParentFile(), null, dateFormatter);
            out.write("</tr>\n");
        }
        Map<String, Date> modTimes = HistoryGuru.getInstance().getLastModifiedTimes(dir);
        if (files != null) {
            for (String file : files) {
                File child;
                if (ignoredNames.ignore(file) || ignoredNames.ignore(child = new File(dir, file))) continue;
                if (file.startsWith("README") || file.endsWith("README") || file.startsWith("readme")) {
                    readMes.add(file);
                }
                boolean isDir = child.isDirectory();
                out.write("<tr><td>");
                out.write("<p class=\"");
                out.write(isDir ? 114 : 112);
                out.write("\"/>");
                out.write("</td><td><a href=\"");
                out.write(Util.URIEncodePath(file));
                if (isDir) {
                    out.write("/\"><b>");
                    out.write(file);
                    out.write("</b></a>/");
                } else {
                    out.write("\">");
                    out.write(file);
                    out.write("</a>");
                }
                out.write("</td>");
                Util.writeHAD(out, contextPath, path + file, isDir);
                this.PrintDateSize(out, child, modTimes.get(file), dateFormatter);
                if (offset > 0) {
                    String briefDesc = this.desc.getChildTag(parentFNode, file);
                    if (briefDesc == null) {
                        out.write("<td/>");
                    } else {
                        out.write("<td>");
                        out.write(briefDesc);
                        out.write("</td>");
                    }
                }
                out.write("</tr>\n");
            }
        }
        out.write("</tbody>\n</table>");
        return readMes;
    }
}

