/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.plain;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.opensolaris.opengrok.analysis.AnalyzerGuru;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.plain.PlainAnalyzer;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;

public final class PlainAnalyzerFactory
extends FileAnalyzerFactory {
    private static final FileAnalyzerFactory.Matcher MATCHER = new FileAnalyzerFactory.Matcher(){

        @Override
        public FileAnalyzerFactory isMagic(byte[] content, InputStream in) throws IOException {
            if (this.isPlainText(content)) {
                return DEFAULT_INSTANCE;
            }
            return null;
        }

        private boolean isPlainText(byte[] content) throws IOException {
            String ascii = new String(content, "US-ASCII");
            if (this.isPlainText(ascii)) {
                return true;
            }
            String noBOM = AnalyzerGuru.stripBOM(content);
            return noBOM != null && this.isPlainText(noBOM);
        }

        private boolean isPlainText(String str) {
            for (int i = 0; i < str.length(); ++i) {
                char b = str.charAt(i);
                if (b >= ' ' && b < '\u007f' || b == '\t' || b == '\n' || b == '\f' || b == '\r') continue;
                return false;
            }
            return true;
        }
    };
    public static final PlainAnalyzerFactory DEFAULT_INSTANCE = new PlainAnalyzerFactory();

    private PlainAnalyzerFactory() {
        super(null, null, null, null, MATCHER, "text/plain", FileAnalyzer.Genre.PLAIN);
    }

    @Override
    protected FileAnalyzer newAnalyzer() {
        return new PlainAnalyzer(this);
    }

    @Override
    public void writeXref(Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        PlainAnalyzer.writeXref(in, out, defs, annotation, project);
    }
}

