/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

public final class IteratorReader
extends Reader {
    private Iterator<String> iterator;
    private StringReader current;

    public IteratorReader(Iterable<String> iterable) {
        this(iterable.iterator());
    }

    public IteratorReader(Iterator<String> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret;
        if (this.current != null && ((ret = this.current.read(cbuf, off, len)) > 0 || len == 0)) {
            return ret;
        }
        if (this.iterator.hasNext()) {
            this.current = new StringReader(this.iterator.next() + '\n');
            return this.current.read(cbuf, off, len);
        }
        return -1;
    }

    @Override
    public void close() {
        this.iterator = null;
        this.current = null;
    }
}

