/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshot;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.snapshots.SimpleFileSnapshotProviderImpl;
import org.jetbrains.kotlin.incremental.storage.AbstractBasicMap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "Lorg/jetbrains/kotlin/incremental/storage/AbstractBasicMap;", "Ljava/io/File;", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "storageFile", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "compareAndUpdate", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "newFiles", "", "incremental-compilation-impl"})
public final class FileSnapshotMap
extends AbstractBasicMap<File, FileSnapshot> {
    public FileSnapshotMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(icContext, "icContext");
        super(storageFile, icContext.getFileDescriptorForSourceFiles(), FileSnapshotExternalizer.INSTANCE, icContext);
    }

    @NotNull
    public final synchronized ChangedFiles.Known compareAndUpdate(@NotNull Iterable<? extends File> newFiles) {
        Intrinsics.checkNotNullParameter(newFiles, "newFiles");
        SimpleFileSnapshotProviderImpl snapshotProvider = new SimpleFileSnapshotProviderImpl();
        ArrayList<File> newOrModified = new ArrayList<File>();
        ArrayList<File> removed = new ArrayList<File>();
        Set<? extends File> newFilesSet = CollectionsKt.toSet(newFiles);
        for (File file2 : this.getKeys()) {
            if (newFilesSet.contains(file2)) continue;
            this.remove(file2);
            removed.add(file2);
        }
        for (File file3 : newFilesSet) {
            FileSnapshot oldSnapshot = (FileSnapshot)this.get(file3);
            FileSnapshot newSnapshot = snapshotProvider.get(file3);
            if (oldSnapshot != null && Intrinsics.areEqual(oldSnapshot, newSnapshot)) continue;
            newOrModified.add(file3);
            this.set(file3, newSnapshot);
        }
        return new ChangedFiles.Known(newOrModified, removed, false, 4, null);
    }
}

