/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.RocksObject;

public class RateLimiter
extends RocksObject {
    private static final long DEFAULT_REFILL_PERIOD_MICROS = 100000L;
    private static final int DEFAULT_FAIRNESS = 10;

    public RateLimiter(long l, long l2, int n) {
        super(RateLimiter.newRateLimiterHandle(l, l2, n));
    }

    public RateLimiter(long l) {
        this(l, 100000L, 10);
    }

    public void setBytesPerSecond(long l) {
        assert (this.isOwningHandle());
        this.setBytesPerSecond(this.nativeHandle_, l);
    }

    public void request(long l) {
        assert (this.isOwningHandle());
        this.request(this.nativeHandle_, l);
    }

    public long getSingleBurstBytes() {
        assert (this.isOwningHandle());
        return this.getSingleBurstBytes(this.nativeHandle_);
    }

    public long getTotalBytesThrough() {
        assert (this.isOwningHandle());
        return this.getTotalBytesThrough(this.nativeHandle_);
    }

    public long getTotalRequests() {
        assert (this.isOwningHandle());
        return this.getTotalRequests(this.nativeHandle_);
    }

    private static native long newRateLimiterHandle(long var0, long var2, int var4);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setBytesPerSecond(long var1, long var3);

    private native void request(long var1, long var3);

    private native long getSingleBurstBytes(long var1);

    private native long getTotalBytesThrough(long var1);

    private native long getTotalRequests(long var1);
}

