/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.common.KafkaException;
import kafka.utils.CoreUtils$;
import kafka.utils.CoreUtilsTest;
import kafka.utils.CoreUtilsTest$TestException$4$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u000f\ti1i\u001c:f+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005\u001daunZ4j]\u001eDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0005\u0004%\t\u0001H\u0001\u0011G2,8\u000f^3s\u0013\u0012\u0004\u0016\r\u001e;fe:,\u0012!\b\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nQA]3hKbT!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1sDA\u0004QCR$XM\u001d8\t\r!\u0002\u0001\u0015!\u0003\u001e\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000e\t\u0005\u0006U\u0001!\taK\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0011)f.\u001b;)\u0005%\u001a\u0004C\u0001\u001b7\u001b\u0005)$BA\u0006\u000f\u0013\t9TG\u0001\u0003UKN$\b\"B\u001d\u0001\t\u0003Y\u0013A\u0003;fgR$&/_!mY\"\u0012\u0001h\r\u0005\u0006y\u0001!\taK\u0001\u0015i\u0016\u001cHoQ5sGVd\u0017M]%uKJ\fGo\u001c:)\u0005m\u001a\u0004\"B \u0001\t\u0003Y\u0013!\u0004;fgR\u0014V-\u00193CsR,7\u000f\u000b\u0002?g!)!\t\u0001C\u0001W\u00059A/Z:u\u0003\n\u001c\bFA!4\u0011\u0015)\u0005\u0001\"\u0001,\u0003E!Xm\u001d;SKBd\u0017mY3Tk\u001a4\u0017\u000e\u001f\u0015\u0003\tNBQ\u0001\u0013\u0001\u0005\u0002-\n1\u0002^3tiJ+\u0017\rZ%oi\"\u0012qi\r\u0005\u0006\u0017\u0002!\taK\u0001\fi\u0016\u001cHoQ:w\u0019&\u001cH\u000f\u000b\u0002Kg!)a\n\u0001C\u0001W\u0005QA/Z:u\u0007N4X*\u00199)\u00055\u001b\u0004\"B)\u0001\t\u0003Y\u0013A\u0003;fgRLe\u000eT8dW\"\u0012\u0001k\r\u0005\u0006)\u0002!\taK\u0001\u001ci\u0016\u001cH/\u0016:m'\u00064WMQ1tKZ\"TI\\2pI\u0016,V+\u0013#)\u0005M\u001b\u0004\"B,\u0001\t\u0003Y\u0013\u0001\u0007;fgR<UM\\3sCR,W+^5e\u0003N\u0014\u0015m]37i!\u0012ak\r\u0005\u00065\u0002!\taK\u0001\u0016i\u0016\u001cH/\u0011;p[&\u001cw)\u001a;PeV\u0003H-\u0019;fQ\tI6\u0007")
public class CoreUtilsTest
extends JUnitSuite
implements Logging {
    private final Pattern clusterIdPattern;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        CoreUtilsTest coreUtilsTest = this;
        synchronized (coreUtilsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException("test");
        }, (Logging)this, Level.INFO);
    }

    @Test
    public void testTryAll() {
        public class Kafka_utils_CoreUtilsTest$TestException$3
        extends Exception
        implements Product,
        scala.Serializable {
            private final String key;
            private final /* synthetic */ CoreUtilsTest $outer;

            public String key() {
                return this.key;
            }

            public Kafka_utils_CoreUtilsTest$TestException$3 copy(String key) {
                return new Kafka_utils_CoreUtilsTest$TestException$3(this.$outer, key);
            }

            public String copy$default$1() {
                return this.key();
            }

            public String productPrefix() {
                return "TestException";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return this.key();
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_utils_CoreUtilsTest$TestException$3;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_utils_CoreUtilsTest$TestException$3)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_utils_CoreUtilsTest$TestException$3 var4_4 = (Kafka_utils_CoreUtilsTest$TestException$3)x$1;
                String string = this.key();
                String string2 = var4_4.key();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Kafka_utils_CoreUtilsTest$TestException$3(CoreUtilsTest $outer, String key) {
                this.key = key;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        LazyRef TestException$module = new LazyRef();
        scala.collection.mutable.Map recorded = Map$.MODULE$.empty();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this, "exception-1")), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-2"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this, "exception-3")), recorded)})));
        scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-2"), (Object)package$.MODULE$.Right().apply((Object)"valid-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-3"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-3")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-1"), recorded)})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-1"), (Object)package$.MODULE$.Right().apply((Object)"valid-1"))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this, "exception-0")), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$3(this, "exception-1")), recorded)})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-0"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-0"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$2(TestException$module).apply("exception-1")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1 & Serializable & scala.Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(values)).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            buffer.putInt(i * 4, values[i]);
            Assert.assertEquals((String)"Written value should match read value.", (long)values[i], (long)CoreUtils$.MODULE$.readInt(buffer.array(), i * 4));
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6);
        ipv6Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Map singleMap = CoreUtils$.MODULE$.parseCsvMap(singleEntry);
        Object value = singleMap.getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Assert.assertTrue((boolean)value.equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4);
        ipv4Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces);
        spaceMap.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Assert.assertTrue((String)"Should be in lock", (boolean)lock.isHeldByCurrentThread());
            return 2;
        }));
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.urlEncoderNoPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.urlEncoderNoPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count), (Function1 & Serializable & scala.Serializable)i -> Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((AtomicInteger)CoreUtils$.MODULE$.atomicGetOrUpdate(map$1, (Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                createdCount$1.incrementAndGet();
                return new AtomicInteger();
            })).incrementAndGet(), (ExecutionContext)executionContext), IndexedSeq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assert.assertEquals((long)count, (long)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many creations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)created)})), (created > 0 && created <= nThreads ? 1 : 0) != 0);
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    private final /* synthetic */ CoreUtilsTest$TestException$4$ TestException$lzycompute$1(LazyRef TestException$module$1) {
        CoreUtilsTest$TestException$4$ coreUtilsTest$TestException$4$;
        LazyRef lazyRef = TestException$module$1;
        synchronized (lazyRef) {
            coreUtilsTest$TestException$4$ = TestException$module$1.initialized() ? (CoreUtilsTest$TestException$4$)((Object)TestException$module$1.value()) : (CoreUtilsTest$TestException$4$)((Object)TestException$module$1.initialize((Object)new CoreUtilsTest$TestException$4$(this)));
        }
        return coreUtilsTest$TestException$4$;
    }

    private final CoreUtilsTest$TestException$4$ TestException$2(LazyRef TestException$module$1) {
        return TestException$module$1.initialized() ? (CoreUtilsTest$TestException$4$)((Object)TestException$module$1.value()) : this.TestException$lzycompute$1(TestException$module$1);
    }

    private static final void recordingFunction$1(Either v, scala.collection.mutable.Map recorded$1) {
        String string;
        Either either = v;
        if (either instanceof Right) {
            String key;
            Right right = (Right)either;
            string = key = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Kafka_utils_CoreUtilsTest$TestException$3 e = (Kafka_utils_CoreUtilsTest$TestException$3)left.value();
            string = e.key();
        } else {
            throw new MatchError((Object)either);
        }
        String key = string;
        recorded$1.update((Object)key, (Object)v);
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assert.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("key"));
        Assert.assertTrue((boolean)((String)m._2()).equals("value"));
    }

    public CoreUtilsTest() {
        Logging.$init$((Logging)this);
        this.clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    }
}

