/*****
 NAME
	pstream.h - protocol definition for Object class group
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PSTREAM_H_INCLUDED)
#define	PSTREAM_H_INCLUDED

#include <coconut/pstring.h>

@protocol PDirFactory
  + (boolean) isDirExist: (const char *) name ;
@end

@protocol PFileFactory
  + (boolean) isLegalName: (const char *) name ;
  + (boolean) isFileExist: (const char *) name ;
    /* if you pass null pointer as "path", FALSE is returned. */
  + (boolean) isAbsolutePath: (const char *) path ;
  + (id <PConstStr>) getBaseName: (const char *) name ;
  + (id <PConstStr>) getDirName: (const char *) name ;
@end

@protocol PDir <PDebug>
    /* if the path is exist, return TRUE. */
  - (boolean) appendPath: (id <PBasicStr>) path ;
  - (id <PConstStr>) searchFile: (const char *) fname ;
  - (int) count ;
@end

@protocol PStream <PObject>

    /* get string which is ended by terminater character ('\n' or EOF) */
  - (id <PConstStr>) getLine ;

  - (io_status_t) putChar: (utf8_char) c ;
  - (io_status_t) putPtr: (const utf8_char *) ptr length: (u_int) len ;
  - (io_status_t) putPtr: (const utf8_char *) ptr ;
  - (io_status_t) putStr: (id <PBasicStr>) str ;
  - (io_status_t) putFormat: (const utf8_char *) form, ... ;

  - (open_t) accessMode ;
  - (boolean) isReadable ;
  - (boolean) isWritable ;

  - (io_status_t) flush ;
  - (io_status_t) rewind ;
@end

@protocol PFileAccess <PObject>
    /* Open the file "filename". The access mode is defined by mode.
       If the "filename" is NULL, standard input or output will be used. */
  - (id <PError>) open: (open_t) mode name: (const char *) filename ;

  - (id <PError>) close ;

    /* this method will return nil when the standard input/output are used */
  - (id <PConstStr>) fileName ;

    /* this method never return NULL because when standard input/output
       are used, this method returns "<stdin>" or "<stdout>" */
  - (id <PConstStr>) fileNameStr ;
@end

@protocol PFile <PFileAccess, PStream>
@end

/* see the protocol PAsyncNet in ./coconut/gnet/pnet.h */
@protocol PAsyncIO <PObject>
  - (io_status_t) flush ;

  - (boolean) asyncIOEvent: (io_condition_t) cond ;
  - (boolean) asyncInputEvent ;
  - (boolean) asyncOutputEvent ;
@end

@protocol PAsyncFileAccess
  - (id <PError>) openToRead: (const char *) filename output: (id <PStream>) 
      output;
  - (id <PError>) openToWrite: (const char *) filename input: (id <PStream>) 
      input ;
  - (id <PError>) close ;

    /* this method will return nil when the standard input/output are used */
  - (id <PConstStr>) fileName ;

    /* this method never return NULL because when standard input/output
       are used, this method returns "<stdin>" or "<stdout>" */
  - (id <PConstStr>) fileNameStr ;
@end

@protocol PAsyncFile <PAsyncFileAccess, PAsyncIO>
@end

@protocol PBuffer <PObject>
   /* return the input file name which is given by "load.." methods.
      the result never be nil. but it will be empty */
 - (id <PBasicStr>) inputFileName ;
   /* return the output file name which is given by "newDocument" methods. 
      the result never be nil. but it will be empty */
 - (id <PBasicStr>) outputFileName ;

   /* load the content of "fname" or "stream". The result value points
      the line number which load error occured. If the value is zero,
      it means there are no errors. 
      If the flag "dovalid" is set, the content of document is validated
      while loading. */
 - (u_int) loadFile: (const char *) fname validate: (boolean) dovalid ;
 - (u_int) loadStream: (id <PStream>) stream name: (const char *) fname 
     validate: (boolean) dovalid ;

   /* make the new document to add the content and save after building the
      object. if you give the "-" as name, the standard output is used when
      this document is saved. */
 - newDocument: (const char *) name ;

   /* save the data to the file. if the output file name is not given,
      the standard output is used to output. */
 - (id <PError>) saveFile ;
   /* if the output name is given, save the file */
 - (id <PError>) saveFileIfExist ;

   /* change output file name and save it. if you give the null as "fname",
      the standard output is used for target, but the file name is not
      changed. */
 - (id <PError>) saveFileAs: (const char *) fname ;
 - (id <PError>) saveStream: (id <PStream>) stream ;

 - clear ;
@end

#endif	/* !defined(PSTREAM_H_INCLUDED) */

