/*****
 NAME
 	papplication.h - prototype for default application main classes
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PAPPLICATION_H_INCLUDED)
#define PAPPLICATION_H_INCLUDED

#include <coconut/pobject.h>

@protocol PArgDecoder <PObject>
 - (id <PError>) setupOption: (id <POptParser>) parser ;
 - (id <PError>) decodeOption: (id <POptParser>) parser ;
 - (id <PError>) analyzeOption: (id <POptParser>) parser ;

 - (const utf8_char *) helpString ;

 - printUsage ;
   /* output version string to standard output */
 - printVersion ;
@end

@protocol PApplication <PObject>
 - (id <PError>) prologue: (int) argc argv: (const char **) argv ;
 - (id <PError>) main ;
 - (id <PError>) epilogue: (id <PError>) preerror ;
@end

#endif /* !defined(PAPPLICATION_H_INCLUDED) */

