/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class RestorableMeter {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private static final double NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final RestorableEWMA m15Rate;
    private final RestorableEWMA m120Rate;
    private final AtomicLong count = new AtomicLong();
    private final long startTime;
    private final AtomicLong lastTick;
    private final Clock clock = Clock.defaultClock();

    public RestorableMeter() {
        this.m15Rate = new RestorableEWMA(TimeUnit.MINUTES.toSeconds(15L));
        this.m120Rate = new RestorableEWMA(TimeUnit.MINUTES.toSeconds(120L));
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
    }

    public RestorableMeter(double lastM15Rate, double lastM120Rate) {
        this.m15Rate = new RestorableEWMA(lastM15Rate, TimeUnit.MINUTES.toSeconds(15L));
        this.m120Rate = new RestorableEWMA(lastM120Rate, TimeUnit.MINUTES.toSeconds(120L));
        this.startTime = this.clock.getTick();
        this.lastTick = new AtomicLong(this.startTime);
    }

    private void tickIfNecessary() {
        long newIntervalStartTick;
        long oldTick = this.lastTick.get();
        long newTick = this.clock.getTick();
        long age = newTick - oldTick;
        if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
            long requiredTicks = age / TICK_INTERVAL;
            for (long i = 0L; i < requiredTicks; ++i) {
                this.m15Rate.tick();
                this.m120Rate.tick();
            }
        }
    }

    public void mark() {
        this.mark(1L);
    }

    public void mark(long n) {
        this.tickIfNecessary();
        this.count.addAndGet(n);
        this.m15Rate.update(n);
        this.m120Rate.update(n);
    }

    public double fifteenMinuteRate() {
        this.tickIfNecessary();
        return this.m15Rate.rate();
    }

    public double twoHourRate() {
        this.tickIfNecessary();
        return this.m120Rate.rate();
    }

    public long count() {
        return this.count.get();
    }

    public double meanRate() {
        if (this.count() == 0L) {
            return 0.0;
        }
        long elapsed = this.clock.getTick() - this.startTime;
        return (double)this.count() / (double)elapsed * NANOS_PER_SECOND;
    }

    static class RestorableEWMA {
        private volatile boolean initialized = false;
        private volatile double rate = 0.0;
        private final AtomicLong uncounted = new AtomicLong();
        private final double alpha;
        private final double interval;

        public RestorableEWMA(long windowInSeconds) {
            this.alpha = 1.0 - Math.exp((double)(-TICK_INTERVAL) / NANOS_PER_SECOND / (double)windowInSeconds);
            this.interval = TICK_INTERVAL;
        }

        public RestorableEWMA(double lastRate, long intervalInSeconds) {
            this(intervalInSeconds);
            this.rate = lastRate / NANOS_PER_SECOND;
            this.initialized = true;
        }

        public void update(long n) {
            this.uncounted.addAndGet(n);
        }

        public void tick() {
            long count = this.uncounted.getAndSet(0L);
            double instantRate = (double)count / this.interval;
            if (this.initialized) {
                this.rate += this.alpha * (instantRate - this.rate);
            } else {
                this.rate = instantRate;
                this.initialized = true;
            }
        }

        public double rate() {
            return this.rate * NANOS_PER_SECOND;
        }
    }
}

