/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.index.composites.CompositesIndexIncludingCollectionKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;

public class CompositesIndexOnCollectionKeyAndValue
extends CompositesIndexIncludingCollectionKey {
    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        CollectionType colType = (CollectionType)this.columnDef.type;
        return CompositeType.getInstance(colType.nameComparator(), colType.valueComparator());
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        ByteBuffer key = cell.name().get(this.columnDef.position() + 1);
        ByteBuffer value = cell.value();
        return CompositeType.build(key, value);
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        Cell cell = this.extractTargetCell(entry, data);
        if (this.cellIsDead(cell, now)) {
            return true;
        }
        ByteBuffer indexCollectionValue = this.extractCollectionValue(entry);
        ByteBuffer targetCollectionValue = cell.value();
        AbstractType<?> valueComparator = ((CollectionType)this.columnDef.type).valueComparator();
        return valueComparator.compare(indexCollectionValue, targetCollectionValue) != 0;
    }

    private Cell extractTargetCell(CompositesIndex.IndexedEntry entry, ColumnFamily data) {
        ByteBuffer collectionKey = this.extractCollectionKey(entry);
        CellName name = data.getComparator().create(entry.indexedEntryPrefix, this.columnDef, collectionKey);
        return data.getColumn(name);
    }

    private ByteBuffer extractCollectionKey(CompositesIndex.IndexedEntry entry) {
        return this.extractIndexKeyComponent(entry, 0);
    }

    private ByteBuffer extractIndexKeyComponent(CompositesIndex.IndexedEntry entry, int component) {
        return CompositeType.extractComponent(entry.indexValue.getKey(), component);
    }

    private ByteBuffer extractCollectionValue(CompositesIndex.IndexedEntry entry) {
        return this.extractIndexKeyComponent(entry, 1);
    }

    private boolean cellIsDead(Cell cell, long now) {
        return cell == null || !cell.isLive(now);
    }
}

